/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.biocache.ObserverCallback;
import au.org.ala.biocache.Store;
import au.org.ala.biocache.web.UploadStatus;
import au.org.ala.biocache.web.UploaderThread;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.ala.layers.dao.IntersectCallback;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

class UploaderThread
implements Runnable {
    private static final Logger logger = Logger.getLogger(UploaderThread.class);
    public String status = "LOADING";
    protected Boolean reload;
    protected String[] headers;
    protected String datasetName = "";
    protected CSVReader csvData;
    protected int lineCount = 0;
    protected boolean firstLineIsData;
    protected String tempUid;
    protected String uploadStatusDir;
    protected Integer recordsToLoad = null;
    protected String[] customIndexFields = null;
    protected Integer threads = 4;
    protected String alaId = null;

    UploaderThread() {
    }

    @Override
    public void run() {
        File statusDir = null;
        File statusFile = null;
        ObjectMapper om = new ObjectMapper();
        ArrayList intList = new ArrayList();
        ArrayList floatList = new ArrayList();
        ArrayList stringList = new ArrayList();
        try {
            statusDir = new File(this.uploadStatusDir);
            if (!statusDir.exists()) {
                FileUtils.forceMkdir((File)statusDir);
            }
            statusFile = new File(this.uploadStatusDir + File.separator + this.tempUid);
            statusFile.createNewFile();
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            throw new RuntimeException(e1);
        }
        try {
            FileUtils.writeStringToFile((File)statusFile, (String)om.writeValueAsString((Object)new UploadStatus("STARTING", "Starting...", Integer.valueOf(0))));
            if (this.reload.booleanValue()) {
                FileUtils.writeStringToFile((File)statusFile, (String)om.writeValueAsString((Object)new UploadStatus("DELETING_EXISTING", "Deleting existing data...", Integer.valueOf(0))));
                Store.deleteRecords((String)this.tempUid, null, (boolean)true, (boolean)true);
            }
            FileUtils.writeStringToFile((File)statusFile, (String)om.writeValueAsString((Object)new UploadStatus("LOADING", "Loading...", Integer.valueOf(0))));
            Integer recordCount = this.lineCount;
            if (!this.firstLineIsData) {
                Integer n = recordCount;
                Integer n2 = recordCount = Integer.valueOf(recordCount - 1);
            }
            Integer counter = 0;
            try {
                String[] currentLine = this.csvData.readNext();
                CollectionUtils.addAll(intList, (Object[])this.customIndexFields);
                if (this.firstLineIsData) {
                    this.addRecord(this.tempUid, this.datasetName, currentLine, this.headers, intList, floatList, stringList);
                }
                Integer percentComplete = 0;
                while ((currentLine = this.csvData.readNext()) != null) {
                    Integer n = counter;
                    Integer n3 = counter = Integer.valueOf(counter + 1);
                    this.addRecord(this.tempUid, this.datasetName, currentLine, this.headers, intList, floatList, stringList);
                    if (counter % 100 != 0) continue;
                    Integer percentageComplete = 0;
                    if (counter != 0) {
                        percentageComplete = (int)((float)(counter + 1) / (float)recordCount.intValue() * 25.0f);
                    }
                    FileUtils.writeStringToFile((File)statusFile, (String)om.writeValueAsString((Object)new UploadStatus("LOADING", String.format("%d of %d records loaded.", counter, recordCount), percentageComplete)));
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            finally {
                this.csvData.close();
            }
            ArrayList<String> tmpCustIndexFields = new ArrayList<String>();
            for (String f : this.customIndexFields) {
                if (intList.contains(f)) {
                    tmpCustIndexFields.add(f + "_i");
                    continue;
                }
                if (floatList.contains(f)) {
                    tmpCustIndexFields.add(f + "_d");
                    continue;
                }
                tmpCustIndexFields.add(f);
            }
            this.status = "SAMPLING";
            UploadIntersectCallback u = new UploadIntersectCallback(this, statusFile);
            FileUtils.writeStringToFile((File)statusFile, (String)om.writeValueAsString((Object)new UploadStatus("SAMPLING", "Starting", Integer.valueOf(25))));
            Store.sample((String)this.tempUid, (IntersectCallback)u);
            this.status = "PROCESSING";
            logger.debug((Object)("Processing " + this.tempUid));
            FileUtils.writeStringToFile((File)statusFile, (String)om.writeValueAsString((Object)new UploadStatus("PROCESSING", "Starting", Integer.valueOf(50))));
            DefaultObserverCallback processingCallback = new DefaultObserverCallback(this, "PROCESSING", recordCount, statusFile, Integer.valueOf(50), "processed");
            Store.process((String)this.tempUid, (int)this.threads, (ObserverCallback)processingCallback);
            this.status = "INDEXING";
            logger.debug((Object)("Indexing " + this.tempUid + " " + tmpCustIndexFields));
            FileUtils.writeStringToFile((File)statusFile, (String)om.writeValueAsString((Object)new UploadStatus("INDEXING", "Starting", Integer.valueOf(75))));
            DefaultObserverCallback indexingCallback = new DefaultObserverCallback(this, "INDEXING", recordCount, statusFile, Integer.valueOf(75), "indexed");
            Store.index((String)this.tempUid, (String[])tmpCustIndexFields.toArray(new String[0]), (ObserverCallback)indexingCallback);
            this.status = "COMPLETE";
            FileUtils.writeStringToFile((File)statusFile, (String)om.writeValueAsString((Object)new UploadStatus(this.status, "Loading complete", Integer.valueOf(100))));
        }
        catch (Exception ex) {
            try {
                this.status = "FAILED";
                FileUtils.writeStringToFile((File)statusFile, (String)om.writeValueAsString((Object)new UploadStatus(this.status, "The system was unable to load this data.", Integer.valueOf(0))));
            }
            catch (IOException ioe) {
                logger.error((Object)("Loading failed and failed to update the status: " + ex.getMessage()), (Throwable)ex);
            }
            logger.error((Object)("Loading failed: " + ex.getMessage()), (Throwable)ex);
        }
    }

    private void addRecord(String tempUid, String datasetName, String[] currentLine, String[] headers, List<String> intList, List<String> floatList, List<String> stringList) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < headers.length && i < currentLine.length; ++i) {
            if (currentLine[i] == null || currentLine[i].trim().length() <= 0) continue;
            map.put(headers[i], currentLine[i].trim());
            if (intList.contains(headers[i])) {
                try {
                    Integer.parseInt(currentLine[i].trim());
                }
                catch (Exception e) {
                    intList.remove(headers[i]);
                    floatList.add(headers[i]);
                }
            }
            if (!floatList.contains(headers[i])) continue;
            try {
                Float.parseFloat(currentLine[i].trim());
                continue;
            }
            catch (Exception e) {
                floatList.remove(headers[i]);
                stringList.add(headers[i]);
            }
        }
        map.put("datasetName", datasetName);
        if (this.alaId != null) {
            map.put("userId", this.alaId);
        }
        if (!map.isEmpty()) {
            Store.loadRecord((String)tempUid, map, (boolean)false);
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

