/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.OccurrencePoint;
import au.org.ala.biocache.dto.PointType;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.heatmap.HeatMap;
import au.org.ala.biocache.util.ColorUtil;
import au.org.ala.biocache.util.SearchUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.ServletConfigAware;

@Controller(value="mapController")
public class MapController
implements ServletConfigAware {
    private static final Logger logger = Logger.getLogger(MapController.class);
    @Value(value="${heatmap.output.dir:/data/output/heatmap}")
    protected String heatmapOutputDir;
    @Inject
    protected SearchDAO searchDAO;
    @Inject
    protected SearchUtils searchUtils;
    private ServletConfig cfg;
    private static final int map_offset = 0x10000000;
    private static final double map_radius = 8.544565944705395E7;

    @Deprecated
    @RequestMapping(value={"/occurrences/wms"}, method={RequestMethod.GET})
    public void pointsWmsImage(SpatialSearchRequestParams requestParams, @RequestParam(value="colourby", required=false, defaultValue="0") Integer colourby, @RequestParam(value="width", required=false, defaultValue="256") Integer widthObj, @RequestParam(value="height", required=false, defaultValue="256") Integer heightObj, @RequestParam(value="zoom", required=false, defaultValue="0") Integer zoomLevel, @RequestParam(value="symsize", required=false, defaultValue="4") Integer symsize, @RequestParam(value="symbol", required=false, defaultValue="circle") String symbol, @RequestParam(value="bbox", required=false, defaultValue="110,-45,157,-9") String bboxString, @RequestParam(value="type", required=false, defaultValue="normal") String type, @RequestParam(value="outline", required=true, defaultValue="false") boolean outlinePoints, @RequestParam(value="outlineColour", required=true, defaultValue="0x000000") String outlineColour, HttpServletResponse response) throws Exception {
        int size = symsize;
        int width = widthObj;
        int height = heightObj;
        requestParams.setStart(Integer.valueOf(0));
        requestParams.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        String query = requestParams.getQ();
        String[] filterQuery = requestParams.getFq();
        if (StringUtils.isBlank((String)query) && StringUtils.isBlank((String)requestParams.getFormattedQuery())) {
            this.displayBlankImage(width, height, false, response);
            return;
        }
        response.setContentType("image/png");
        ArrayList<Object> fqList = null;
        fqList = filterQuery != null ? new ArrayList<String>(Arrays.asList(filterQuery)) : new ArrayList();
        double[] bbox = new double[4];
        int i = 0;
        for (String s : bboxString.split(",")) {
            try {
                bbox[i] = Double.parseDouble(s);
                ++i;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        double pixelWidth = (bbox[2] - bbox[0]) / (double)width;
        double pixelHeight = (bbox[3] - bbox[1]) / (double)height;
        bbox[0] = bbox[0] + pixelWidth / 2.0;
        bbox[2] = bbox[2] - pixelWidth / 2.0;
        bbox[1] = bbox[1] + pixelHeight / 2.0;
        bbox[3] = bbox[3] - pixelHeight / 2.0;
        double xoffset = (bbox[2] - bbox[0]) / (double)width * (double)(size * 2);
        double yoffset = (bbox[3] - bbox[1]) / (double)height * (double)(size * 2);
        double[] bbox2 = new double[]{this.convertMetersToLng(bbox[0] - (xoffset += pixelWidth)), this.convertMetersToLat(bbox[1] - (yoffset += pixelHeight)), this.convertMetersToLng(bbox[2] + xoffset), this.convertMetersToLat(bbox[3] + yoffset)};
        bbox[0] = this.convertMetersToLng(bbox[0]);
        bbox[1] = this.convertMetersToLat(bbox[1]);
        bbox[2] = this.convertMetersToLng(bbox[2]);
        bbox[3] = this.convertMetersToLat(bbox[3]);
        double[] pbbox = new double[]{this.convertLngToPixel(bbox[0]), this.convertLatToPixel(bbox[1]), this.convertLngToPixel(bbox[2]), this.convertLatToPixel(bbox[3])};
        String bboxString2 = bbox2[0] + "," + bbox2[1] + "," + bbox2[2] + "," + bbox2[3];
        this.bboxToQuery(bboxString2, fqList);
        PointType pointType = this.getPointTypeForZoomLevel(zoomLevel);
        String[] newFilterQuery = fqList.toArray(new String[fqList.size()]);
        requestParams.setFq(newFilterQuery);
        List points = this.searchDAO.getFacetPoints(requestParams, pointType);
        logger.debug((Object)("Points search for " + pointType.getLabel() + " - found: " + points.size()));
        if (points.size() == 0) {
            this.displayBlankImage(width, height, false, response);
            return;
        }
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setColor(Color.RED);
        int pointWidth = size * 2;
        double width_mult = (double)width / (pbbox[2] - pbbox[0]);
        double height_mult = (double)height / (pbbox[1] - pbbox[3]);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oColour = Color.decode(outlineColour);
        for (i = 0; i < points.size(); ++i) {
            OccurrencePoint pt = (OccurrencePoint)points.get(i);
            float lng = ((Float)pt.getCoordinates().get(0)).floatValue();
            float lat = ((Float)pt.getCoordinates().get(1)).floatValue();
            int x = (int)(((double)this.convertLngToPixel((double)lng) - pbbox[0]) * width_mult);
            int y = (int)(((double)this.convertLatToPixel((double)lat) - pbbox[3]) * height_mult);
            if (colourby != null) {
                int colour = 0xFF000000 | colourby;
                Color c = new Color(colour);
                g.setPaint(c);
            } else {
                g.setPaint(Color.blue);
            }
            Shape shp = this.getShape(symbol, x - size / 2, y - size / 2, pointWidth, pointWidth);
            g.draw(shp);
            g.fill(shp);
            if (!outlinePoints) continue;
            g.setPaint(oColour);
            g.drawOval(x - size / 2, y - size / 2, pointWidth, pointWidth);
        }
        g.dispose();
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "png", outputStream);
            ServletOutputStream outStream = response.getOutputStream();
            outStream.write(outputStream.toByteArray());
            outStream.flush();
            outStream.close();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to write image", (Throwable)e);
        }
    }

    @RequestMapping(value={"/occurrences/info"}, method={RequestMethod.GET})
    public String getOccurrencesInformation(SpatialSearchRequestParams requestParams, @RequestParam(value="zoom", required=false, defaultValue="0") Integer zoomLevel, @RequestParam(value="callback", required=false) String callback, Model model, HttpServletResponse response) throws Exception {
        if (callback != null && !callback.isEmpty()) {
            response.setContentType("text/javascript");
        } else {
            response.setContentType("application/json");
        }
        PointType pointType = this.getPointTypeForZoomLevel(zoomLevel);
        List points = this.searchDAO.getOccurrences(requestParams, pointType, "", 1);
        logger.info((Object)("Points search for " + pointType.getLabel() + " - found: " + points.size()));
        model.addAttribute("points", (Object)points);
        model.addAttribute("count", (Object)points.size());
        return "json/infoPointGeojson";
    }

    private void displayBlankImage(int width, int height, boolean useBase, HttpServletResponse response) {
        try {
            response.setContentType("image/png");
            BufferedImage baseImage = null;
            baseImage = useBase ? this.createBaseMapImage() : new BufferedImage(width, height, 2);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)baseImage, "png", outputStream);
            ServletOutputStream outStream = response.getOutputStream();
            outStream.write(outputStream.toByteArray());
            outStream.flush();
            outStream.close();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to write image", (Throwable)e);
        }
    }

    @RequestMapping(value={"/occurrences/legend"}, method={RequestMethod.GET})
    public void pointLegendImage(@RequestParam(value="colourby", required=false, defaultValue="0") Integer colourby, @RequestParam(value="width", required=false, defaultValue="50") Integer widthObj, @RequestParam(value="height", required=false, defaultValue="50") Integer heightObj, HttpServletResponse response) {
        try {
            int width = widthObj;
            int height = heightObj;
            BufferedImage img = new BufferedImage(width, height, 2);
            Graphics2D g = (Graphics2D)img.getGraphics();
            if (colourby != null) {
                int colour = 0xFF000000 | colourby;
                Color c = new Color(colour);
                g.setPaint(c);
            } else {
                g.setPaint(Color.blue);
            }
            g.fillOval(0, 0, width, width);
            g.dispose();
            response.setContentType("image/png");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "png", outputStream);
            ServletOutputStream outStream = response.getOutputStream();
            outStream.write(outputStream.toByteArray());
            outStream.flush();
            outStream.close();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to write image", (Throwable)e);
        }
    }

    private Shape getShape(String symbol, int x, int y, int width, int height) {
        RectangularShape shape = null;
        shape = (symbol = symbol.toLowerCase()).equals("square") ? new Rectangle2D.Float(x, y, width, height) : new Ellipse2D.Float(x, y, width, height);
        return shape;
    }

    public int convertLatToPixel(double lat) {
        return (int)Math.round(2.68435456E8 - 8.544565944705395E7 * Math.log((1.0 + Math.sin(lat * Math.PI / 180.0)) / (1.0 - Math.sin(lat * Math.PI / 180.0))) / 2.0);
    }

    public int convertLngToPixel(double lng) {
        return (int)Math.round(2.68435456E8 + 8.544565944705395E7 * lng * Math.PI / 180.0);
    }

    private double convertMetersToLng(double meters) {
        return meters / 2.0037508342789244E7 * 180.0;
    }

    private double convertMetersToLat(double meters) {
        return 57.29577951308232 * (2.0 * Math.atan(Math.exp(meters / 2.0037508342789244E7 * Math.PI)) - 1.5707963267948966);
    }

    protected void bboxToQuery(String bbox, ArrayList<String> fqList) {
        if (bbox != null && !bbox.isEmpty()) {
            String[] bounds = StringUtils.split((String)bbox, (String)",");
            if (bounds.length == 4) {
                String fq1 = "longitude:[" + bounds[0] + " TO " + bounds[2] + "]";
                fqList.add(fq1);
                String fq2 = "latitude:[" + bounds[1] + " TO " + bounds[3] + "]";
                fqList.add(fq2);
            } else {
                logger.warn((Object)("BBOX does not contain the expected number of coords (4). Found: " + bounds.length));
            }
        }
    }

    protected PointType getPointTypeForZoomLevel(Integer zoomLevel) {
        PointType pointType = null;
        if (zoomLevel != null) {
            pointType = zoomLevel >= 0 && zoomLevel <= 6 ? PointType.POINT_01 : (zoomLevel > 6 && zoomLevel <= 8 ? PointType.POINT_00001 : PointType.POINT_RAW);
        }
        return pointType;
    }

    private BufferedImage createBaseMapImage() throws IOException {
        InputStream in = this.cfg.getServletContext().getResourceAsStream("/images/");
        return ImageIO.read(in);
    }

    @RequestMapping(value={"/density/map", "/occurrences/static"}, method={RequestMethod.GET})
    @ResponseBody
    public void speciesDensityMap(SpatialSearchRequestParams requestParams, @RequestParam(value="forceRefresh", required=false, defaultValue="false") boolean forceRefresh, @RequestParam(value="forcePointsDisplay", required=false, defaultValue="false") boolean forcePointsDisplay, @RequestParam(value="pointColour", required=false, defaultValue="0000ff") String pointColour, @RequestParam(value="colourByFq", required=false, defaultValue="") String colourByFqCSV, @RequestParam(value="colours", required=false, defaultValue="") String coloursCSV, @RequestParam(value="pointHeatMapThreshold", required=false, defaultValue="500") Integer pointHeatMapThreshold, @RequestParam(value="opacity", required=false, defaultValue="1.0") Float opacity, HttpServletRequest request, HttpServletResponse response) throws Exception {
        File f;
        response.setContentType("image/png");
        File outputDir = new File(this.heatmapOutputDir);
        if (!outputDir.exists()) {
            FileUtils.forceMkdir((File)outputDir);
        }
        String outputHMFile = this.getOutputFile(request);
        String[] facetValues = null;
        String[] facetColours = null;
        if (StringUtils.trimToNull((String)colourByFqCSV) != null && StringUtils.trimToNull((String)coloursCSV) != null) {
            facetValues = colourByFqCSV.split(",");
            facetColours = coloursCSV.split(",");
            if (facetValues.length == 0 || facetValues.length != facetColours.length) {
                throw new IllegalArgumentException(String.format("Mismatch in facet values and colours. Values: %d, Colours: %d", facetValues.length, facetColours.length));
            }
        }
        if (!(f = new File(outputDir + "/" + outputHMFile)).isFile() || !f.exists() || forceRefresh) {
            logger.debug((Object)"Regenerating heatmap image");
            this.generateStaticHeatmapImages(requestParams, false, forcePointsDisplay, pointHeatMapThreshold, pointColour, facetValues, facetColours, opacity, request);
        } else {
            logger.debug((Object)"Heatmap file already exists on disk, sending file back to user");
        }
        try {
            File file = new File(outputDir + "/" + outputHMFile);
            BufferedImage img = ImageIO.read(file);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "png", outputStream);
            ServletOutputStream outStream = response.getOutputStream();
            outStream.write(outputStream.toByteArray());
            outStream.flush();
            outStream.close();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to write image.", (Throwable)e);
        }
    }

    private String getQueryHash(HttpServletRequest request) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(request.getQueryString().getBytes("UTF-8"));
        byte[] digest = md.digest();
        StringBuffer sb = new StringBuffer();
        for (byte b : digest) {
            sb.append(Integer.toHexString(b & 0xFF));
        }
        return sb.toString();
    }

    @RequestMapping(value={"/density/legend"}, method={RequestMethod.GET})
    @ResponseBody
    public void speciesDensityLegend(SpatialSearchRequestParams requestParams, @RequestParam(value="forceRefresh", required=false, defaultValue="false") boolean forceRefresh, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("image/png");
        File baseDir = new File(this.heatmapOutputDir);
        String outputHMFile = this.getOutputFile(request);
        File f = new File(baseDir + "/" + "legend_" + outputHMFile);
        if (!f.isFile() || !f.exists() || forceRefresh) {
            logger.debug((Object)"regenerating heatmap legend");
            this.generateStaticHeatmapImages(requestParams, true, false, Integer.valueOf(0), "0000ff", null, null, Float.valueOf(1.0f), request);
        } else {
            logger.debug((Object)"legend file already exists on disk, sending file back to user");
        }
        try {
            File file = new File(baseDir + "/" + "legend_" + outputHMFile);
            if (file.exists()) {
                BufferedImage img = ImageIO.read(file);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)img, "png", outputStream);
                ServletOutputStream outStream = response.getOutputStream();
                outStream.write(outputStream.toByteArray());
                outStream.flush();
                outStream.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to write image.", (Throwable)e);
        }
    }

    private String getOutputFile(HttpServletRequest request) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return this.getQueryHash(request) + "_hm.png";
    }

    public void generateStaticHeatmapImages(SpatialSearchRequestParams requestParams, boolean generateLegend, boolean forcePointsDisplay, Integer pointHeatMapThreshold, String defaultPointColour, String[] colourByFq, String[] colours, Float opacity, HttpServletRequest request) throws Exception {
        File baseDir = new File(this.heatmapOutputDir);
        logger.debug((Object)("Heatmap output directory is " + this.heatmapOutputDir));
        String outputHMFile = this.getOutputFile(request);
        PointType pointType = PointType.POINT_001;
        double[] points = this.retrievePoints(requestParams, pointType);
        HeatMap hm = new HeatMap();
        if (forcePointsDisplay || points.length == 0 || points.length / 2 < pointHeatMapThreshold) {
            if (!generateLegend) {
                if (colourByFq != null) {
                    Object[] originalFq = requestParams.getFq();
                    for (int k = 0; k < colourByFq.length; ++k) {
                        if (originalFq != null) {
                            requestParams.setFq((String[])ArrayUtils.add((Object[])originalFq, (Object)colourByFq[k]));
                        } else {
                            requestParams.setFq(new String[]{colourByFq[k]});
                        }
                        if (forcePointsDisplay && points.length > 0 && points.length / 2 < pointHeatMapThreshold) {
                            pointType = PointType.POINT_01;
                        }
                        double[] pointsForFacet = this.retrievePoints(requestParams, pointType);
                        Color pointColor = ColorUtil.getColor((String)colours[k], (Float)opacity);
                        hm.generatePoints(pointsForFacet, pointColor);
                    }
                } else {
                    Color pointColor = ColorUtil.getColor((String)defaultPointColour, (Float)opacity);
                    hm.generatePoints(points, pointColor);
                }
                hm.drawOutput(baseDir + "/" + outputHMFile, false);
            }
        } else {
            hm.generateClasses(points);
            if (generateLegend) {
                hm.drawLegend(baseDir + "/legend_" + outputHMFile);
            } else {
                hm.drawOutput(baseDir + "/" + outputHMFile, true);
            }
        }
    }

    private double[] retrievePoints(SpatialSearchRequestParams requestParams, PointType pointType) {
        double[] points = new double[]{};
        try {
            requestParams.setQ(requestParams.getQ());
            List occ_points = this.searchDAO.getFacetPoints(requestParams, pointType);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Points search for " + pointType.getLabel() + " - found: " + occ_points.size()));
            }
            int totalItems = 0;
            for (int i = 0; i < occ_points.size(); ++i) {
                OccurrencePoint pt = (OccurrencePoint)occ_points.get(i);
                totalItems = (int)((long)totalItems + pt.getCount());
            }
            logger.debug((Object)("total number of occurrence points is " + totalItems));
            points = new double[totalItems * 2];
            int j = 0;
            for (int i = 0; i < occ_points.size(); ++i) {
                OccurrencePoint pt = (OccurrencePoint)occ_points.get(i);
                pt.getCount();
                double lng = ((Float)pt.getCoordinates().get(0)).doubleValue();
                double lat = ((Float)pt.getCoordinates().get(1)).doubleValue();
                points[j] = lng;
                points[j + 1] = lat;
                j += 2;
            }
        }
        catch (Exception e) {
            logger.error((Object)"An error occurred getting heatmap points", (Throwable)e);
        }
        return points;
    }

    public void setSearchDAO(SearchDAO searchDAO) {
        this.searchDAO = searchDAO;
    }

    public void setSearchUtils(SearchUtils searchUtils) {
        this.searchUtils = searchUtils;
    }

    public void setServletConfig(ServletConfig cfg) {
        this.cfg = cfg;
    }
}

