/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.Store;
import au.org.ala.biocache.service.AuthService;
import au.org.ala.biocache.web.AbstractSecureController;
import au.org.ala.biocache.web.AdminController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AdminController
extends AbstractSecureController {
    private static final Logger logger = Logger.getLogger(AdminController.class);
    @Inject
    protected AuthService authService;
    @Value(value="${ingest.process.threads:4}")
    protected Integer ingestProcessingThreads;
    private Set<String> ingestingDrs = new HashSet();

    @RequestMapping(value={"/admin/ingest"}, method={RequestMethod.GET})
    public void ingestResources(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String ingest;
        String dataResources = request.getParameter("dr");
        String string = ingest = dataResources == null ? "all" : dataResources;
        if (this.shouldPerformOperation(request, response)) {
            logger.debug((Object)("Attempting to ingest " + ingest));
            if (this.ingestingDrs.contains(ingest)) {
                response.sendError(400, "Already ingesting " + ingest + ". Unable able to start a new ingestion.");
            } else {
                this.ingestingDrs.add(ingest);
                1 t = new /* Unavailable Anonymous Inner Class!! */;
                t.start();
            }
        }
    }

    @RequestMapping(value={"/admin/index/optimise"}, method={RequestMethod.POST})
    public void optimiseIndex(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.shouldPerformOperation(request, response)) {
            String message = Store.optimiseIndex();
            response.setStatus(200);
            response.getWriter().write(message);
        }
    }

    @RequestMapping(value={"/admin/modify*"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> modifyServer(@RequestParam(value="ro", required=false) Boolean readOnly, @RequestParam(value="reopenIndex", required=false, defaultValue="false") Boolean reopenIndex) throws Exception {
        ArrayList<String> actionsPerformed = new ArrayList<String>();
        if (readOnly != null) {
            Store.setReadOnly((boolean)readOnly);
            actionsPerformed.add("Set readonly = " + readOnly);
        }
        if (reopenIndex.booleanValue()) {
            Store.reopenIndex();
            actionsPerformed.add("Reopened the index");
        }
        return actionsPerformed;
    }

    @RequestMapping(value={"/admin/index/reindex"}, method={RequestMethod.POST})
    public void reindex(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.shouldPerformOperation(request, response)) {
            String dataResource = request.getParameter("dataResource");
            String startDate = request.getParameter("startDate");
            logger.info((Object)("Re-indexing data resource: " + dataResource + " starting at " + startDate));
            Store.reindex((String)dataResource, (String)startDate);
            response.setStatus(200);
        }
    }

    @RequestMapping(value={"/admin/isReadOnly"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean isReadOnly() {
        return Store.isReadOnly();
    }

    @RequestMapping(value={"/admin/refreshAuth"}, method={RequestMethod.GET})
    @ResponseBody
    public String refreshAuth() {
        this.authService.reloadCaches();
        return "Done";
    }

    static /* synthetic */ Set access$000(AdminController x0) {
        return x0.ingestingDrs;
    }
}

