/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.Store;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class AbstractSecureController {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSecureController.class);
    @Value(value="${api.check.url:https://auth.ala.org.au/apikey/ws/check?apikey=}")
    protected String apiCheckUrl;
    @Value(value="${api.check.enabled:true}")
    protected Boolean apiKeyCheckedEnabled = true;
    private static Set<String> apiKeys = new HashSet();

    public boolean shouldPerformOperation(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String apiKey = request.getParameter("apiKey");
        return this.shouldPerformOperation(apiKey, response, true);
    }

    public boolean shouldPerformOperation(String apiKey, HttpServletResponse response) throws Exception {
        return this.shouldPerformOperation(apiKey, response, true);
    }

    public boolean isValidKey(String keyToTest) {
        if (!this.apiKeyCheckedEnabled.booleanValue()) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)keyToTest)) {
            return false;
        }
        if (!apiKeys.contains(keyToTest)) {
            try {
                logger.debug("Checking api key: " + keyToTest);
                String url = this.apiCheckUrl + keyToTest;
                ObjectMapper om = new ObjectMapper();
                Map response = (Map)om.readValue(new URL(url), Map.class);
                logger.debug("Checking api key: " + keyToTest + ", valid: " + response.get("valid"));
                boolean isValid = (Boolean)response.get("valid");
                if (isValid) {
                    apiKeys.add(keyToTest);
                }
                return isValid;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            return true;
        }
        return false;
    }

    public boolean shouldPerformOperation(String apiKey, HttpServletResponse response, boolean checkReadOnly) throws Exception {
        if (checkReadOnly && Store.isReadOnly()) {
            response.sendError(409, "Server is in read only mode.  Try again later.");
        } else if (!this.isValidKey(apiKey)) {
            response.sendError(403, "An invalid API Key was provided.");
        }
        return !response.isCommitted();
    }
}

