/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.service.SpeciesLookupService;
import com.mockrunner.util.common.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.web.client.RestOperations;

public class SpeciesLookupRestService
implements SpeciesLookupService {
    private static final Logger logger = Logger.getLogger(SpeciesLookupRestService.class);
    private RestOperations restTemplate;
    protected String bieUriPrefix;
    protected Boolean enabled;
    @Inject
    private AbstractMessageSource messageSource;
    private String[] baseHeader;
    private String[] countBaseHeader;
    private String[] synonymHeader;
    private String[] countSynonymHeader;

    public String getGuidForName(String name) {
        String guid = null;
        if (this.enabled.booleanValue()) {
            try {
                Map jsonMap;
                String jsonUri = this.bieUriPrefix + "/guid/" + name;
                logger.info((Object)("Requesting: " + jsonUri));
                List jsonList = (List)this.restTemplate.getForObject(jsonUri, List.class, new Object[0]);
                if (!jsonList.isEmpty() && (jsonMap = (Map)jsonList.get(0)).containsKey("acceptedIdentifier")) {
                    guid = (String)jsonMap.get("acceptedIdentifier");
                }
            }
            catch (Exception ex) {
                logger.error((Object)("RestTemplate error: " + ex.getMessage()), (Throwable)ex);
            }
        }
        return guid;
    }

    public String getAcceptedNameForGuid(String guid) {
        String acceptedName = "";
        if (this.enabled.booleanValue()) {
            try {
                String jsonUri = this.bieUriPrefix + "/species/shortProfile/" + guid + ".json";
                logger.info((Object)("Requesting: " + jsonUri));
                Map jsonMap = (Map)this.restTemplate.getForObject(jsonUri, Map.class, new Object[0]);
                if (jsonMap.containsKey("scientificName")) {
                    acceptedName = (String)jsonMap.get("scientificName");
                }
            }
            catch (Exception ex) {
                logger.error((Object)("RestTemplate error: " + ex.getMessage()), (Throwable)ex);
            }
        }
        return acceptedName;
    }

    public List<String> getNamesForGuids(List<String> guids) {
        List names = null;
        if (this.enabled.booleanValue()) {
            try {
                String jsonUri = this.bieUriPrefix + "/species/namesFromGuids.json";
                String params = "?guid=" + StringUtils.join(guids, (String)"&guid=");
                names = (List)this.restTemplate.postForObject(jsonUri + params, null, List.class, new Object[0]);
            }
            catch (Exception ex) {
                logger.error((Object)("Requested URI: " + this.bieUriPrefix + "/species/namesFromGuids.json"));
                logger.error((Object)("With POST body: guid=" + StringUtils.join(guids, (String)"&guid=")));
                logger.error((Object)("RestTemplate error: " + ex.getMessage()), (Throwable)ex);
            }
        }
        return names;
    }

    private List<Map<String, String>> getNameDetailsForGuids(List<String> guids) {
        List results = null;
        if (this.enabled.booleanValue()) {
            String url = this.bieUriPrefix + "/species/guids/bulklookup.json";
            try {
                Map searchDTOList = (Map)this.restTemplate.postForObject(url, guids, Map.class, new Object[0]);
                results = (List)searchDTOList.get("searchDTOList");
            }
            catch (Exception ex) {
                logger.error((Object)("Requested URI: " + url));
                logger.error((Object)("With POST body: guid=" + StringUtils.join(guids, (String)"&guid=")));
                logger.error((Object)("RestTemplate error: " + ex.getMessage()), (Throwable)ex);
            }
        }
        return results;
    }

    private Map<String, List<Map<String, String>>> getSynonymDetailsForGuids(List<String> guids) {
        Map results = null;
        if (this.enabled.booleanValue()) {
            String url = this.bieUriPrefix + "/species/bulklookup/namesFromGuids.json";
            try {
                results = (Map)this.restTemplate.postForObject(url, guids, Map.class, new Object[0]);
            }
            catch (Exception ex) {
                logger.error((Object)("Requested URI: " + url));
                logger.error((Object)("With POST body: guid=" + StringUtils.join(guids, (String)"&guid=")));
                logger.error((Object)("RestTemplate error: " + ex.getMessage()), (Throwable)ex);
            }
        }
        return results;
    }

    public List<String[]> getSpeciesDetails(List<String> guids, List<Long> counts, boolean includeCounts, boolean includeSynonyms) {
        int size;
        Map synonyms;
        ArrayList<String[]> details = new ArrayList<String[]>(guids.size());
        List values = this.getNameDetailsForGuids(guids);
        Map map = synonyms = includeSynonyms ? this.getSynonymDetailsForGuids(guids) : new HashMap();
        int n = includeSynonyms && includeCounts ? 13 : (size = includeCounts && !includeSynonyms || includeSynonyms && !includeCounts ? 12 : 11);
        if (values != null && values.get(0) == null && guids.size() > 0 && StringUtil.countMatches((String)guids.get(0), (String)"|") == 4) {
            ArrayList<String> taxonConceptIds = new ArrayList<String>(guids.size());
            for (String s : guids) {
                String[] split;
                if (s == null) continue;
                if (s.startsWith("\"") && s.endsWith("\"") && s.length() > 2) {
                    s = s.substring(1, s.length() - 1);
                }
                if ((split = s.split("\\|", 6)).length == 5) {
                    taxonConceptIds.add(split[1]);
                    continue;
                }
                taxonConceptIds.add("");
            }
            values = this.getNameDetailsForGuids(taxonConceptIds);
        }
        for (int i = 0; i < guids.size(); ++i) {
            String guid;
            int countIdx = 11;
            String[] row = new String[size];
            row[0] = guid = guids.get(i);
            if (values != null && synonyms != null) {
                Map map2 = (Map)values.get(i);
                if (map2 != null) {
                    row[1] = (String)map2.get("nameComplete");
                    row[2] = (String)map2.get("author");
                    row[3] = (String)map2.get("rank");
                    row[4] = (String)map2.get("kingdom");
                    row[5] = (String)map2.get("phylum");
                    row[6] = (String)map2.get("classs");
                    row[7] = (String)map2.get("order");
                    row[8] = (String)map2.get("family");
                    row[9] = (String)map2.get("genus");
                    row[10] = (String)map2.get("commonNameSingle");
                } else if (StringUtil.countMatches((String)guid, (String)"|") == 4) {
                    if (guid.startsWith("\"") && guid.endsWith("\"") && guid.length() > 2) {
                        guid = guid.substring(1, guid.length() - 1);
                    }
                    String[] split = guid.split("\\|", 6);
                    row[0] = guid;
                    row[1] = split[0];
                    row[2] = "";
                    row[3] = "";
                    row[4] = split[3];
                    row[5] = "";
                    row[6] = "";
                    row[7] = "";
                    row[8] = split[4];
                    row[9] = "";
                    row[10] = split[2];
                }
                if (includeSynonyms) {
                    List names = (List)synonyms.get(row[0]);
                    StringBuilder sb = new StringBuilder();
                    for (Map n2 : names) {
                        if (guid.equals(n2.get("guid"))) continue;
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append((String)n2.get("name"));
                    }
                    row[11] = sb.toString();
                    countIdx = 12;
                }
            }
            if (includeCounts) {
                row[countIdx] = counts.get(i).toString();
            }
            details.add(row);
        }
        return details;
    }

    public String[] getHeaderDetails(String field, boolean includeCounts, boolean includeSynonyms) {
        if (this.baseHeader == null) {
            this.initHeaders();
        }
        Object[] startArray = this.baseHeader;
        if (includeCounts) {
            startArray = includeSynonyms ? this.countSynonymHeader : this.countBaseHeader;
        } else if (includeSynonyms) {
            startArray = this.synonymHeader;
        }
        return (String[])ArrayUtils.add((Object[])startArray, (int)0, (Object)this.messageSource.getMessage("facet." + field, null, field, null));
    }

    private void initHeaders() {
        this.baseHeader = new String[]{this.messageSource.getMessage("species.name", null, "Species Name", null), this.messageSource.getMessage("species.author", null, "Scientific Name Author", null), this.messageSource.getMessage("species.rank", null, "Taxon Rank", null), this.messageSource.getMessage("species.kingdom", null, "Kingdom", null), this.messageSource.getMessage("species.phylum", null, "Phylum", null), this.messageSource.getMessage("species.class", null, "Class", null), this.messageSource.getMessage("species.order", null, "Order", null), this.messageSource.getMessage("species.family", null, "Family", null), this.messageSource.getMessage("species.genus", null, "Genus", null), this.messageSource.getMessage("species.common", null, "Vernacular Name", null)};
        this.countBaseHeader = (String[])ArrayUtils.add((Object[])this.baseHeader, (Object)this.messageSource.getMessage("species.count", null, "Number of Records", null));
        this.synonymHeader = (String[])ArrayUtils.add((Object[])this.baseHeader, (Object)this.messageSource.getMessage("species.synonyms", null, "Synonyms", null));
        this.countSynonymHeader = (String[])ArrayUtils.add((Object[])this.synonymHeader, (Object)this.messageSource.getMessage("species.count", null, "Number of Records", null));
    }

    public void setBieUriPrefix(String bieUriPrefix) {
        this.bieUriPrefix = bieUriPrefix;
    }

    public void setRestTemplate(RestOperations restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setMessageSource(AbstractMessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

