/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.service.LoggerRestService;
import au.org.ala.biocache.service.LoggerService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestOperations;

@Component(value="loggerRestService")
public class LoggerRestService
implements LoggerService {
    private static final Logger logger = Logger.getLogger(LoggerRestService.class);
    private List<Map<String, Object>> loggerReasons;
    private List<Map<String, Object>> loggerSources;
    private List<Integer> reasonIds;
    private List<Integer> sourceIds;
    @Value(value="${logger.service.url:http://logger.ala.org.au/service/logger/}")
    protected String loggerUriPrefix;
    @Value(value="${caches.log.enabled:true}")
    protected Boolean enabled = null;
    @Inject
    private RestOperations restTemplate;

    public List<Map<String, Object>> getReasons() {
        return this.loggerReasons;
    }

    public List<Map<String, Object>> getSources() {
        return this.loggerSources;
    }

    public List<Integer> getReasonIds() {
        return this.reasonIds;
    }

    public List<Integer> getSourceIds() {
        return this.sourceIds;
    }

    @Scheduled(fixedDelay=43200000L)
    public void reloadCache() {
        if (this.enabled.booleanValue()) {
            logger.info((Object)"Refreshing the log sources and reasons");
            this.loggerReasons = this.getEntities(LoggerType.reasons);
            this.loggerSources = this.getEntities(LoggerType.sources);
            this.reasonIds = this.getIdList(this.loggerReasons);
            this.sourceIds = this.getIdList(this.loggerSources);
        } else if (this.reasonIds == null) {
            logger.info((Object)"Providing some sensible default values for the log cache");
            this.reasonIds = new ArrayList();
            this.sourceIds = new ArrayList();
            Integer i = 0;
            while (i < 11) {
                this.reasonIds.add(i);
                if (i < 8) {
                    this.sourceIds.add(i);
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
    }

    protected List<Integer> getIdList(List<Map<String, Object>> list) {
        ArrayList<Integer> returnList = new ArrayList<Integer>();
        for (Map<String, Object> value : list) {
            returnList.add((Integer)value.get("id"));
        }
        return returnList;
    }

    protected List<Map<String, Object>> getEntities(LoggerType type) {
        List<Map<String, Object>> entities = new ArrayList<Map<String, Object>>();
        try {
            String jsonUri = this.loggerUriPrefix + type.name();
            logger.info((Object)("Requesting " + type.name() + " via: " + jsonUri));
            entities = (List)this.restTemplate.getForObject(jsonUri, List.class, new Object[0]);
            logger.info((Object)("The values : " + entities));
        }
        catch (Exception ex) {
            logger.error((Object)("RestTemplate error: " + ex.getMessage()), (Throwable)ex);
        }
        return entities;
    }
}

