/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.biocache.dao.PersistentQueueDAO;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.DownloadRequestParams;
import au.org.ala.biocache.service.DownloadService;
import au.org.ala.biocache.service.EmailService;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.ala.client.appender.RestLevel;
import org.ala.client.model.LogEventVO;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestOperations;

@Component(value="downloadService")
public class DownloadService {
    private static final Logger logger = Logger.getLogger(DownloadService.class);
    @Value(value="${concurrent.downloads:1}")
    protected int concurrentDownloads = 1;
    @Inject
    protected PersistentQueueDAO persistentQueueDAO;
    @Inject
    SearchDAO searchDAO;
    @Inject
    private RestOperations restTemplate;
    @Inject
    private ObjectMapper objectMapper;
    @Inject
    private EmailService emailService;
    @Inject
    private AbstractMessageSource messageSource;
    @Value(value="${webservices.root:http://localhost:8080/biocache-service}")
    protected String webservicesRoot;
    @Value(value="${citations.enabled:true}")
    protected Boolean citationsEnabled;
    private List<DownloadDetailsDTO> currentDownloads = Collections.synchronizedList(new ArrayList());
    @Value(value="${data.description.url:https://docs.google.com/spreadsheet/ccc?key=0AjNtzhUIIHeNdHhtcFVSM09qZ3c3N3ItUnBBc09TbHc}")
    private String dataFieldDescriptionURL;
    @Value(value="${registry.url:http://collections.ala.org.au/ws}")
    protected String registryUrl;
    @Value(value="${citations.url:http://collections.ala.org.au/ws/citations}")
    protected String citationServiceUrl;
    @Value(value="${media.url:http://biocache.ala.org.au/biocache-media/}")
    public static String biocacheMediaUrl;
    @Value(value="${media.dir:/data/biocache-media/}")
    public static String biocacheMediaDir;

    @PostConstruct
    public void init() {
        for (int i = 0; i < this.concurrentDownloads; ++i) {
            new Thread((Runnable)new DownloadThread(this, null)).start();
        }
    }

    public DownloadDetailsDTO registerDownload(DownloadRequestParams requestParams, String ip, DownloadDetailsDTO.DownloadType type) {
        DownloadDetailsDTO dd = new DownloadDetailsDTO(requestParams.toString(), ip, type);
        this.currentDownloads.add(dd);
        return dd;
    }

    public void unregisterDownload(DownloadDetailsDTO dd) {
        this.currentDownloads.remove(dd);
    }

    public List<DownloadDetailsDTO> getCurrentDownloads() {
        return this.currentDownloads;
    }

    private void writeQueryToStream(DownloadDetailsDTO dd, DownloadRequestParams requestParams, String ip, OutputStream out, boolean includeSensitive, boolean fromIndex) throws Exception {
        this.writeQueryToStream(dd, requestParams, ip, out, includeSensitive, fromIndex, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeQueryToStream(DownloadDetailsDTO dd, DownloadRequestParams requestParams, String ip, OutputStream out, boolean includeSensitive, boolean fromIndex, boolean limit) throws Exception {
        String filename = requestParams.getFile();
        String originalParams = requestParams.toString();
        ZipOutputStream zop = new ZipOutputStream(out);
        String suffix = requestParams.getFileType().equals("shp") ? "zip" : requestParams.getFileType();
        zop.putNextEntry(new ZipEntry(filename + "." + suffix));
        if ("all".equals(requestParams.getQa())) {
            requestParams.setFacets(new String[]{"assertions", "data_resource_uid"});
        } else {
            requestParams.setFacets(new String[]{"data_resource_uid"});
        }
        Map uidStats = null;
        try {
            uidStats = fromIndex ? this.searchDAO.writeResultsFromIndexToStream(requestParams, (OutputStream)zop, includeSensitive, dd, limit) : this.searchDAO.writeResultsToStream(requestParams, (OutputStream)zop, 100, includeSensitive, dd);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.unregisterDownload(dd);
        }
        zop.closeEntry();
        zop.putNextEntry(new ZipEntry("README.html"));
        zop.write(("For more information about the fields that are being downloaded please consult <a href='" + this.dataFieldDescriptionURL + "'>Download Fields</a>.").getBytes());
        if (dd.getHeaderMap() != null) {
            zop.putNextEntry(new ZipEntry("Shape-README.html"));
            zop.write("The name of features is limited to 10 characters. Listed below are the mappings of feature name to download field:".getBytes());
            zop.write("<table><td><b>Feature</b></td><td><b>Download Field<b></td>".getBytes());
            for (String key : dd.getHeaderMap().keySet()) {
                zop.write(("<tr><td>" + key + "</td><td>" + (String)dd.getHeaderMap().get(key) + "</td></tr>").getBytes());
            }
            zop.write("</table>".getBytes());
        }
        if (uidStats != null && !uidStats.isEmpty() && this.citationsEnabled.booleanValue()) {
            zop.putNextEntry(new ZipEntry("citation.csv"));
            try {
                this.getCitations(uidStats, (OutputStream)zop, requestParams.getSep().charValue(), requestParams.getEsc().charValue());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            zop.closeEntry();
        } else {
            logger.debug((Object)("Not adding citation. Enabled: " + this.citationsEnabled + " uids: " + uidStats));
        }
        zop.flush();
        zop.close();
        String sourceUrl = originalParams.contains("qid:") ? this.webservicesRoot + "?" + requestParams.toString() : this.webservicesRoot + "?" + originalParams;
        LogEventVO vo = new LogEventVO(1002, requestParams.getReasonTypeId(), requestParams.getSourceTypeId(), requestParams.getEmail(), requestParams.getReason(), ip, null, uidStats, sourceUrl);
        logger.log((Priority)RestLevel.REMOTE, (Object)vo);
    }

    public void writeQueryToStream(DownloadRequestParams requestParams, HttpServletResponse response, String ip, ServletOutputStream out, boolean includeSensitive, boolean fromIndex) throws Exception {
        String filename = requestParams.getFile();
        response.setHeader("Cache-Control", "must-revalidate");
        response.setHeader("Pragma", "must-revalidate");
        response.setHeader("Content-Disposition", "attachment;filename=" + filename + ".zip");
        response.setContentType("application/zip");
        DownloadDetailsDTO.DownloadType type = fromIndex ? DownloadDetailsDTO.DownloadType.RECORDS_INDEX : DownloadDetailsDTO.DownloadType.RECORDS_DB;
        DownloadDetailsDTO dd = this.registerDownload(requestParams, ip, type);
        this.writeQueryToStream(dd, requestParams, ip, (OutputStream)out, includeSensitive, fromIndex);
    }

    public void getCitations(Map<String, Integer> uidStats, OutputStream out, char sep, char esc) throws IOException {
        if (this.citationsEnabled.booleanValue()) {
            if (uidStats == null || uidStats.isEmpty() || out == null) {
                logger.error((Object)"Unable to generate citations: keys and/or out is null!!");
                return;
            }
            CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter(out), sep, '\"', esc);
            List entities = (List)this.restTemplate.postForObject(this.citationServiceUrl, uidStats.keySet(), List.class, new Object[0]);
            if (entities.size() > 0) {
                writer.writeNext(new String[]{this.messageSource.getMessage("citation.uid", null, "UID", null), this.messageSource.getMessage("citation.name", null, "Name", null), this.messageSource.getMessage("citation.citation", null, "Citation", null), this.messageSource.getMessage("citation.rights", null, "Rights", null), this.messageSource.getMessage("citation.link", null, "More Information", null), this.messageSource.getMessage("citation.dataGeneralizations", null, "Data generalisations", null), this.messageSource.getMessage("citation.informationWithheld", null, "Information withheld", null), this.messageSource.getMessage("citation.downloadLimit", null, "Download limit", null), this.messageSource.getMessage("citation.count", null, "Number of Records in Download", null)});
                for (Map record : entities) {
                    StringBuilder sb = new StringBuilder();
                    if (record != null) {
                        String count = uidStats.get(record.get("uid")).toString();
                        String[] row = new String[]{this.getOrElse(record, "uid", ""), this.getOrElse(record, "name", ""), this.getOrElse(record, "citation", ""), this.getOrElse(record, "rights", ""), this.getOrElse(record, "link", ""), this.getOrElse(record, "dataGeneralizations", ""), this.getOrElse(record, "informationWithheld", ""), this.getOrElse(record, "downloadLimit", ""), count};
                        writer.writeNext(row);
                        continue;
                    }
                    logger.warn((Object)("A null record was returned from the collectory citation service: " + entities));
                }
            }
            writer.flush();
        }
    }

    private String getOrElse(Map map, String key, String value) {
        if (map.containsKey(key)) {
            return map.get(key).toString();
        }
        return value;
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }

    static /* synthetic */ List access$200(DownloadService x0) {
        return x0.currentDownloads;
    }

    static /* synthetic */ void access$300(DownloadService x0, DownloadDetailsDTO x1, DownloadRequestParams x2, String x3, OutputStream x4, boolean x5, boolean x6, boolean x7) throws Exception {
        x0.writeQueryToStream(x1, x2, x3, x4, x5, x6, x7);
    }

    static /* synthetic */ AbstractMessageSource access$400(DownloadService x0) {
        return x0.messageSource;
    }

    static /* synthetic */ EmailService access$500(DownloadService x0) {
        return x0.emailService;
    }

    static /* synthetic */ ObjectMapper access$600(DownloadService x0) {
        return x0.objectMapper;
    }
}

