/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.Config;
import au.org.ala.biocache.dto.Facet;
import au.org.ala.biocache.dto.OccurrenceSourceDTO;
import au.org.ala.biocache.dto.SearchRequestParams;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.service.AuthService;
import au.org.ala.biocache.service.SpeciesLookupService;
import au.org.ala.biocache.util.CollectionsCache;
import au.org.ala.biocache.util.SearchUtils;
import au.org.ala.names.model.NameSearchResult;
import au.org.ala.names.model.RankType;
import au.org.ala.names.search.ALANameSearcher;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="searchUtils")
public class SearchUtils {
    private static final Logger logger;
    @Inject
    private CollectionsCache collectionCache;
    @Inject
    private AuthService authService;
    @Inject
    private AbstractMessageSource messageSource;
    @Inject
    private SpeciesLookupService speciesLookupService;
    @Value(value="${name.index.dir:/data/lucene/namematching_v13}")
    protected String nameIndexLocation;
    ALANameSearcher nameIndex = null;
    protected static List<String> defaultParams;
    private final List<String> ranks = CollectionUtils.arrayToList((Object)new String[]{"kingdom", "phylum", "class", "order", "family", "genus", "species"});

    public boolean updateCollectionSearchString(SearchRequestParams searchParams, String uid) {
        try {
            String[] uids = uid.split(",");
            searchParams.setQ(this.getUIDSearchString(uids));
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("Problem contacting the collectory: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public String getUIDSearchString(String[] uids) {
        StringBuilder sb = new StringBuilder();
        for (String uid : uids) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append(this.getUidSearchField(uid));
            sb.append(":");
            sb.append(uid);
        }
        return sb.toString();
    }

    public static String stripEscapedQuotes(String uid) {
        if (uid == null) {
            return null;
        }
        if (uid.startsWith("\"") && uid.endsWith("\"") && uid.length() > 2) {
            return uid.substring(1, uid.length() - 1);
        }
        if (uid.startsWith("\\\"") && uid.endsWith("\\\"") && uid.length() > 4) {
            return uid.substring(2, uid.length() - 2);
        }
        return uid;
    }

    public String getUidDisplayString(String fieldName, String uid) {
        return this.getUidDisplayString(fieldName, uid, true);
    }

    public String getUidDisplayString(String fieldName, String uid, boolean includeField) {
        if ((uid = SearchUtils.stripEscapedQuotes((String)uid)).startsWith("in") && this.collectionCache.getInstitutions().containsKey(uid)) {
            if (includeField) {
                return "Institution: " + (String)this.collectionCache.getInstitutions().get(uid);
            }
            return (String)this.collectionCache.getInstitutions().get(uid);
        }
        if (uid.startsWith("co") && this.collectionCache.getCollections().containsKey(uid)) {
            if (includeField) {
                return "Collection: " + (String)this.collectionCache.getCollections().get(uid);
            }
            return (String)this.collectionCache.getCollections().get(uid);
        }
        if (uid.startsWith("drt") && this.collectionCache.getTempDataResources().containsKey(uid)) {
            if (includeField) {
                return "Temporary Data resource: " + (String)this.collectionCache.getTempDataResources().get(uid);
            }
            return (String)this.collectionCache.getTempDataResources().get(uid);
        }
        if (uid.startsWith("dr") && this.collectionCache.getDataResources().containsKey(uid)) {
            if (includeField) {
                return "Data resource: " + (String)this.collectionCache.getDataResources().get(uid);
            }
            return (String)this.collectionCache.getDataResources().get(uid);
        }
        if (uid.startsWith("dp") && this.collectionCache.getDataProviders().containsKey(uid)) {
            if (includeField) {
                return "Data provider: " + (String)this.collectionCache.getDataProviders().get(uid);
            }
            return (String)this.collectionCache.getDataProviders().get(uid);
        }
        if (uid.startsWith("dh") && this.collectionCache.getDataHubs().containsKey(uid)) {
            if (includeField) {
                return "Data hub: " + (String)this.collectionCache.getDataHubs().get(uid);
            }
            return (String)this.collectionCache.getDataHubs().get(uid);
        }
        return this.messageSource.getMessage(fieldName + "." + StringUtils.remove((String)uid, (String)"\""), null, uid, null);
    }

    public String convertRankAndName(String query) {
        Pattern rankAndName = Pattern.compile("([a-z]{1,})\\:([A-Za-z \\(\\)\\.]{1,})");
        int position = 0;
        Matcher m = rankAndName.matcher(query);
        if (m.find(position) && m.groupCount() == 2) {
            String rank = m.group(1);
            String scientificName = m.group(2);
            RankType rankType = RankType.getForName((String)rank.toLowerCase());
            if (rankType != null) {
                try {
                    NameSearchResult r = Config.nameIndex().searchForRecord(scientificName, rankType);
                    if (r != null) {
                        return "lft:[" + r.getLeft() + " TO " + r.getRight() + "]";
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return query;
    }

    public String[] getTaxonSearch(String lsid) {
        String[] result = new String[]{};
        try {
            NameSearchResult nsr;
            if (this.nameIndex == null) {
                this.nameIndex = new ALANameSearcher(this.nameIndexLocation);
            }
            if ((nsr = this.nameIndex.searchForRecordByLsid(lsid)) != null) {
                String rank = nsr.getRank() != null ? nsr.getRank().toString() : "Unknown Rank";
                String scientificName = nsr.getRankClassification() != null ? nsr.getRankClassification().getScientificName() : null;
                StringBuffer dispSB = new StringBuffer(rank + ": " + scientificName);
                StringBuilder sb = new StringBuilder("lft:[");
                String lft = nsr.getLeft() != null ? nsr.getLeft() : "0";
                String rgt = nsr.getRight() != null ? nsr.getRight() : "0";
                sb.append(lft).append(" TO ").append(rgt).append("]");
                return new String[]{sb.toString(), dispSB.toString()};
            }
            return new String[]{"taxon_concept_lsid:" + ClientUtils.escapeQueryChars((String)lsid), "taxon_concept_lsid:" + lsid};
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return result;
        }
    }

    public static String formatSearchQuery(String query) {
        StringBuilder queryString = new StringBuilder();
        if (query.equals("*:*") || query.contains(" AND ") || query.contains(" OR ") || query.startsWith("(") || query.endsWith("*") || query.startsWith("{")) {
            queryString.append(query);
        } else if (query.contains(":") && !query.startsWith("urn")) {
            queryString.append(SearchUtils.formatGuid((String)query));
        } else {
            queryString.append(ClientUtils.escapeQueryChars((String)query));
        }
        return queryString.toString();
    }

    public static String formatGuid(String guid) {
        String[] bits = StringUtils.split((String)guid, (String)":", (int)2);
        StringBuffer queryString = new StringBuffer();
        queryString.append(ClientUtils.escapeQueryChars((String)bits[0]));
        queryString.append(":");
        queryString.append(ClientUtils.escapeQueryChars((String)bits[1]));
        return queryString.toString();
    }

    public String getUidSearchField(String uid) {
        if (uid.startsWith("co")) {
            return "collection_uid";
        }
        if (uid.startsWith("in")) {
            return "institution_uid";
        }
        if (uid.startsWith("dr")) {
            return "data_resource_uid";
        }
        if (uid.startsWith("dp")) {
            return "data_provider_uid";
        }
        if (uid.startsWith("dh")) {
            return "data_hub_uid";
        }
        return null;
    }

    public List<String> getNextRanks(String rank, boolean includeSuppliedRank) {
        int start;
        int n = start = includeSuppliedRank ? this.ranks.indexOf(rank) : this.ranks.indexOf(rank) + 1;
        if (start > 0) {
            return this.ranks.subList(start, this.ranks.size());
        }
        return this.ranks;
    }

    public List<String> getRanks() {
        return this.ranks;
    }

    public List<OccurrenceSourceDTO> getSourceInformation(Map<String, Integer> sources) {
        Set<String> keys = sources.keySet();
        logger.debug((Object)("Listing the source information for : " + keys));
        ArrayList<OccurrenceSourceDTO> lsources = new ArrayList<OccurrenceSourceDTO>();
        try {
            Iterator<String> i$ = keys.iterator();
            while (i$.hasNext()) {
                String key;
                String name = key = i$.next();
                if (key.startsWith("co")) {
                    name = (String)this.collectionCache.getCollections().get(key);
                } else if (key.startsWith("in")) {
                    name = (String)this.collectionCache.getInstitutions().get(key);
                } else if (key.startsWith("dr")) {
                    name = (String)this.collectionCache.getDataResources().get(key);
                }
                lsources.add(new OccurrenceSourceDTO(name, key, sources.get(key).intValue()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        Collections.sort(lsources, new /* Unavailable Anonymous Inner Class!! */);
        return lsources;
    }

    public static void setDefaultParams(SearchRequestParams requestParams) {
        SearchRequestParams blankRequestParams = new SearchRequestParams();
        logger.debug((Object)("requestParams = " + requestParams));
        if (requestParams.getStart() == null) {
            requestParams.setStart(blankRequestParams.getStart());
        }
        if (requestParams.getPageSize() == null) {
            requestParams.setPageSize(blankRequestParams.getPageSize());
        }
        if (requestParams.getSort() == null || requestParams.getSort().isEmpty()) {
            requestParams.setSort(blankRequestParams.getSort());
        }
        if (requestParams.getDir() == null || requestParams.getDir().isEmpty()) {
            requestParams.setDir(blankRequestParams.getDir());
        }
    }

    public static Map<String, String[]> getExtraParams(Map map) {
        HashMap<String, String[]> extraParams = new HashMap<String, String[]>(map);
        for (String field : defaultParams) {
            extraParams.remove(field);
        }
        return extraParams;
    }

    private boolean isDynamicField(String fieldName) {
        return fieldName.endsWith("_s") || fieldName.endsWith("_i") || fieldName.endsWith("_d");
    }

    public static String formatDynamicFieldName(String fieldName) {
        if (fieldName.length() > 2) {
            return StringUtils.capitalize((String)fieldName.substring(0, fieldName.length() - 2).replace("_", " "));
        }
        return fieldName;
    }

    public Map<String, Facet> addFacetMap(String[] filterQuery, Set<String> authIndexFields) {
        HashMap<String, Facet> afs = new HashMap<String, Facet>();
        if (filterQuery != null && filterQuery.length > 0) {
            for (String fq : filterQuery) {
                if (fq == null || fq.isEmpty()) continue;
                Boolean isExcludeFilter = false;
                String prefix = "";
                String suffix = "";
                if (fq.startsWith("(") && fq.endsWith(")")) {
                    fq = StringUtils.remove((String)fq, (String)"(");
                    fq = StringUtils.removeEnd((String)fq, (String)")");
                    prefix = "(";
                    suffix = ")";
                } else if (fq.startsWith("-(") && fq.endsWith(")")) {
                    fq = StringUtils.remove((String)fq, (String)"-(");
                    fq = StringUtils.removeEnd((String)fq, (String)")");
                    isExcludeFilter = true;
                    prefix = "(";
                    suffix = ")";
                }
                String[] fqBits = StringUtils.split((String)fq, (String)":", (int)2);
                if (fqBits.length != 2) continue;
                String key = fqBits[0];
                String value = fqBits[1];
                if ("data_hub_uid".equals(key)) continue;
                Facet f = new Facet();
                f.setName(key);
                f.setValue(value);
                logger.debug((Object)("1. fq = " + key + " => " + value));
                String patternStr = "[ ]+(OR)[ ]+";
                String[] tokens = fq.split(patternStr, -1);
                ArrayList<String> labels = new ArrayList<String>();
                for (String token : tokens) {
                    logger.debug((Object)("token: " + token));
                    String[] tokenBits = StringUtils.split((String)token, (String)":", (int)2);
                    if (tokenBits.length != 2) continue;
                    String fn = tokenBits[0];
                    String fv = tokenBits[1];
                    String i18n = null;
                    i18n = this.isDynamicField(fn) ? SearchUtils.formatDynamicFieldName((String)fn) : this.messageSource.getMessage("facet." + fn, null, fn, null);
                    if (StringUtils.equals((String)fn, (String)"species_guid") || StringUtils.equals((String)fn, (String)"genus_guid")) {
                        fv = this.substituteLsidsForNames(fv.replaceAll("\"", ""));
                    } else if (StringUtils.equals((String)fn, (String)"occurrence_year")) {
                        fv = this.substituteYearsForDates(fv);
                    } else if (StringUtils.equals((String)fn, (String)"month")) {
                        fv = this.substituteMonthNamesForNums(fv);
                    } else if (authIndexFields.contains(fn)) {
                        if (this.authService.getMapOfAllUserNamesById().containsKey(StringUtils.remove((String)fv, (String)"\""))) {
                            fv = (String)this.authService.getMapOfAllUserNamesById().get(StringUtils.remove((String)fv, (String)"\""));
                        } else if (this.authService.getMapOfAllUserNamesByNumericId().containsKey(StringUtils.remove((String)fv, (String)"\""))) {
                            fv = (String)this.authService.getMapOfAllUserNamesByNumericId().get(StringUtils.remove((String)fv, (String)"\""));
                        }
                    } else {
                        fv = StringUtils.contains((String)fv, (String)"@") ? (this.authService.getMapOfAllUserNamesById().containsKey(StringUtils.remove((String)fv, (String)"\"")) ? (String)this.authService.getMapOfAllUserNamesById().get(StringUtils.remove((String)fv, (String)"\"")) : fv.replaceAll("\\@\\w+", "@..")) : this.getUidDisplayString(fn, fv, false);
                    }
                    labels.add(i18n + ":" + fv);
                }
                String label = prefix + StringUtils.join(labels, (String)" OR ") + suffix;
                if (isExcludeFilter.booleanValue()) {
                    label = "-" + label;
                }
                logger.debug((Object)("label = " + label));
                f.setDisplayName(label);
                afs.put(StringUtils.removeStart((String)key, (String)"-"), f);
            }
        }
        return afs;
    }

    private String substituteLsidsForNames(String fieldValue) {
        String name = fieldValue;
        ArrayList<String> guids = new ArrayList<String>();
        guids.add(fieldValue);
        List names = this.speciesLookupService.getNamesForGuids(guids);
        if (names != null && names.size() >= 1) {
            name = (String)names.get(0);
        }
        return name;
    }

    private String substituteMonthNamesForNums(String fv) {
        String monthStr = new String(fv);
        try {
            int m = Integer.parseInt(monthStr);
            Month month = Month.get((int)(m - 1));
            monthStr = month.name();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return monthStr;
    }

    private String substituteYearsForDates(String fieldValue) {
        String dateRange = URLDecoder.decode(fieldValue);
        String formattedDate = StringUtils.replaceChars((String)dateRange, (String)"[]", (String)"");
        String[] dates = formattedDate.split(" TO ");
        if (dates != null && dates.length > 1) {
            dateRange = StringUtils.substring((String)dates[0], (int)0, (int)4) + "-" + StringUtils.substring((String)dates[1], (int)0, (int)4);
        }
        return dateRange;
    }

    static {
        Field[] fields;
        logger = Logger.getLogger(SearchUtils.class);
        defaultParams = new ArrayList();
        for (Field field : fields = (Field[])ArrayUtils.addAll((Object[])SpatialSearchRequestParams.class.getDeclaredFields(), (Object[])SearchRequestParams.class.getDeclaredFields())) {
            defaultParams.add(field.getName());
        }
    }
}

