/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dao;

import au.org.ala.biocache.dao.PersistentQueueDAO;
import au.org.ala.biocache.dto.DownloadDetailsDTO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.stereotype.Component;

@Component(value="persistentQueueDao")
public class JsonPersistentQueueDAOImpl
implements PersistentQueueDAO {
    private static final Logger logger = Logger.getLogger(JsonPersistentQueueDAOImpl.class);
    private String cacheDirectory = "/data/cache/downloads";
    private String FILE_PREFIX = "offline";
    private String downloadDirectory = "/data/biocache-download";
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private List<DownloadDetailsDTO> offlineDownloadList;

    @PostConstruct
    public void init() {
        this.offlineDownloadList = Collections.synchronizedList(new ArrayList());
        File file = new File(this.cacheDirectory);
        this.jsonMapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            FileUtils.forceMkdir((File)file);
        }
        catch (IOException e) {
            logger.error((Object)"Unable to construct cache directory.", (Throwable)e);
        }
        this.refreshFromPersistent();
    }

    private File getFile(long key) {
        return new File(this.cacheDirectory + File.separator + this.FILE_PREFIX + key + ".json");
    }

    public void addDownloadToQueue(DownloadDetailsDTO download) {
        this.offlineDownloadList.add(download);
        File f = this.getFile(download.getStartTime());
        try {
            this.jsonMapper.writeValue(f, (Object)download);
        }
        catch (Exception e) {
            logger.error((Object)"Unable to cache the download", (Throwable)e);
        }
    }

    public DownloadDetailsDTO getNextDownload() {
        if (this.offlineDownloadList.size() > 0) {
            for (DownloadDetailsDTO dd : this.offlineDownloadList) {
                if (dd.getFileLocation() != null) continue;
                dd.setFileLocation(this.downloadDirectory + File.separator + UUID.nameUUIDFromBytes(dd.getEmail().getBytes()) + File.separator + dd.getStartTime() + File.separator + dd.getRequestParams().getFile() + ".zip");
                return dd;
            }
        }
        return null;
    }

    public int getTotalDownloads() {
        return this.offlineDownloadList.size();
    }

    public void removeDownloadFromQueue(DownloadDetailsDTO download) {
        logger.debug((Object)"Removing the download from the queue");
        File f = this.getFile(download.getStartTime());
        logger.info((Object)("Deleting " + f.getAbsolutePath() + " " + f.exists()));
        FileUtils.deleteQuietly((File)f);
        this.offlineDownloadList.remove(download);
    }

    public List<DownloadDetailsDTO> getAllDownloads() {
        return this.offlineDownloadList;
    }

    public void refreshFromPersistent() {
        this.offlineDownloadList.clear();
        File file = new File(this.cacheDirectory);
        File[] files = file.listFiles();
        Arrays.sort(files, new /* Unavailable Anonymous Inner Class!! */);
        for (File f : files) {
            if (!f.isFile()) continue;
            try {
                DownloadDetailsDTO dd = (DownloadDetailsDTO)this.jsonMapper.readValue(f, DownloadDetailsDTO.class);
                this.offlineDownloadList.add(dd);
            }
            catch (Exception e) {
                logger.error((Object)("Unable to load cached downlaod " + f.getAbsolutePath()), (Throwable)e);
            }
        }
    }
}

