/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.config;

import au.org.ala.biocache.service.SpeciesLookupIndexService;
import au.org.ala.biocache.service.SpeciesLookupRestService;
import au.org.ala.biocache.service.SpeciesLookupService;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.web.client.RestOperations;

@Configuration
public class AppConfig {
    private static final Logger logger = Logger.getLogger(AppConfig.class);
    @Inject
    private AbstractMessageSource messageSource;
    @Value(value="${name.index.dir:/data/lucene/namematching_v13}")
    protected String nameIndexLocation;
    @Inject
    @Qualifier(value="restTemplate")
    private RestOperations restTemplate;
    @Value(value="${service.bie.ws.url:http://bie.ala.org.au/ws}")
    protected String bieUriPrefix;
    @Value(value="${service.bie.enabled:false}")
    protected Boolean enabled;

    @Bean(name={"speciesLookupService"})
    public SpeciesLookupService speciesLookupServiceBean() {
        logger.info((Object)"Initialising species lookup services.");
        if (this.enabled.booleanValue()) {
            logger.info((Object)"Initialising rest-based species lookup services.");
            SpeciesLookupRestService service = new SpeciesLookupRestService();
            service.setBieUriPrefix(this.bieUriPrefix);
            service.setEnabled(this.enabled);
            service.setRestTemplate(this.restTemplate);
            service.setMessageSource(this.messageSource);
            return service;
        }
        logger.info((Object)"Initialising local index-based species lookup services.");
        SpeciesLookupIndexService service = new SpeciesLookupIndexService();
        service.setNameIndexLocation(this.nameIndexLocation);
        service.setMessageSource(this.messageSource);
        return service;
    }
}

