/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.writer;

import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.biocache.RecordWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVRecordWriter
implements RecordWriter {
    private static final Logger logger = LoggerFactory.getLogger(CSVRecordWriter.class);
    private CSVWriter csvWriter;

    public CSVRecordWriter(OutputStream out, String[] header) {
        this.csvWriter = new CSVWriter((Writer)new OutputStreamWriter(out), ',', '\"');
        this.csvWriter.writeNext(header);
    }

    public CSVRecordWriter(OutputStream out, String[] header, char sep, char esc) {
        this.csvWriter = new CSVWriter((Writer)new OutputStreamWriter(out), sep, '\"', esc);
        this.csvWriter.writeNext(header);
    }

    public void write(String[] record) {
        this.csvWriter.writeNext(record);
    }

    public void finalise() {
        try {
            this.csvWriter.flush();
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }
}

