/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.dao.QidCacheDAO;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dao.TaxonDAO;
import au.org.ala.biocache.dto.DataProviderCountDTO;
import au.org.ala.biocache.dto.FacetResultDTO;
import au.org.ala.biocache.dto.OccurrencePoint;
import au.org.ala.biocache.dto.PointType;
import au.org.ala.biocache.dto.SearchResultDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.dto.TaxaCountDTO;
import au.org.ala.biocache.model.Qid;
import au.org.ala.biocache.util.LegendItem;
import au.org.ala.biocache.util.SearchUtils;
import au.org.ala.biocache.util.WMSCache;
import au.org.ala.biocache.util.WMSTile;
import au.org.ala.biocache.web.ImgObj;
import au.org.ala.biocache.web.WmsEnv;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class WMSController {
    private final int DEFAULT_PAGE_SIZE = 1000000;
    private final int[] colourList = new int[]{0x3366CC, 14432530, 0xFF9900, 1087000, 0x990099, 39366, 0xDD4477, 0x66AA00, 12070446, 3236757, 0x994499, 0x22AA99, 0xAAAA11, 0x6633CC, 15102720, 9111303, 6623335, 3314274, 5600422, 3882668, 12022562, 1496608, 12129155, 16004510, 10246453, 11125779, 2783117, 6720796, 12493843, 809250, 7615505};
    final String[] colorsNames = new String[]{"DarkRed", "IndianRed", "DarkSalmon", "SaddleBrown", "Chocolate", "SandyBrown", "Orange", "DarkGreen", "Green", "Lime", "LightGreen", "MidnightBlue", "Blue", "SteelBlue", "CadetBlue", "Aqua", "PowderBlue", "DarkOliveGreen", "DarkKhaki", "Yellow", "Moccasin", "Indigo", "Purple", "Fuchsia", "Plum", "Black", "White"};
    final String[] colorsCodes = new String[]{"8b0000", "FF0000", "CD5C5C", "E9967A", "8B4513", "D2691E", "F4A460", "FFA500", "006400", "008000", "00FF00", "90EE90", "191970", "0000FF", "4682B4", "5F9EA0", "00FFFF", "B0E0E6", "556B2F", "BDB76B", "FFFF00", "FFE4B5", "4B0082", "800080", "FF00FF", "DDA0DD", "000000", "FFFFFF"};
    private final int DEFAULT_COLOUR = 0;
    private final int MAX_IMAGE_PIXEL_COUNT = 36000000;
    private final String NULL_NAME = "Unknown";
    private final double MAX_UNCERTAINTY = 30000.0;
    private static final int HIGHLIGHT_RADIUS = 3;
    private static final Logger logger = Logger.getLogger(WMSController.class);
    @Inject
    protected SearchDAO searchDAO;
    @Inject
    protected TaxonDAO taxonDAO;
    @Inject
    protected SearchUtils searchUtils;
    @Inject
    protected QidCacheDAO qidCacheDAO;
    static final byte[] blankImageBytes;
    @Value(value="${webservices.root:http://biocache.ala.org.au/ws}")
    protected String baseWsUrl;
    @Value(value="${geoserver.url:http://spatial.ala.org.au/geoserver}")
    protected String geoserverUrl;
    @Value(value="${organizationName:Atlas of Living Australia}")
    protected String organizationName;
    @Value(value="${orgCity:Canberra}")
    protected String orgCity;
    @Value(value="${orgStateProvince:ACT}")
    protected String orgStateProvince;
    @Value(value="${orgPostcode:2601}")
    protected String orgPostcode;
    @Value(value="${orgCountry:Australia}")
    protected String orgCountry;
    @Value(value="${orgPhone:+61 (0) 2 6246 4400}")
    protected String orgPhone;
    @Value(value="${orgFax:+61 (0) 2 6246 4400}")
    protected String orgFax;
    @Value(value="${orgEmail:support@ala.org.au}")
    protected String orgEmail;
    private int map_offset = 0x10000000;
    private double map_radius = (double)this.map_offset / Math.PI;

    @RequestMapping(value={"/webportal/params", "/mapping/params"}, method={RequestMethod.POST})
    public void storeParams(SpatialSearchRequestParams requestParams, @RequestParam(value="bbox", required=false, defaultValue="false") String bbox, @RequestParam(value="title", required=false) String title, @RequestParam(value="maxage", required=false, defaultValue="-1") Long maxage, @RequestParam(value="source", required=false) String source, HttpServletResponse response) throws Exception {
        String[] fqs;
        double[] bb = null;
        if (bbox != null && bbox.equals("true")) {
            bb = this.getBBox(requestParams);
        } else {
            requestParams.setPageSize(Integer.valueOf(0));
            this.searchDAO.findByFulltext(requestParams);
        }
        if (title == null) {
            title = requestParams.getDisplayString();
        }
        if ((fqs = this.getFq(requestParams)) != null && fqs.length == 1 && fqs[0].length() == 0) {
            fqs = null;
        }
        String qid = this.qidCacheDAO.put(requestParams.getFormattedQuery(), title, requestParams.getWkt(), bb, fqs, maxage.longValue(), source);
        response.setContentType("text/plain");
        this.writeBytes(response, qid.getBytes());
    }

    @RequestMapping(value={"/webportal/params/{id}", "/mapping/params/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean storeParams(@PathVariable(value="id") Long id) throws Exception {
        return this.qidCacheDAO.get(String.valueOf(id)) != null;
    }

    @RequestMapping(value={"/webportal/params/details/{id}", "/mapping/params/details/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public Qid getQid(@PathVariable(value="id") Long id) throws Exception {
        return this.qidCacheDAO.get(String.valueOf(id));
    }

    @RequestMapping(value={"/webportal/species", "/mapping/species"}, method={RequestMethod.GET})
    @ResponseBody
    public List<TaxaCountDTO> listSpecies(SpatialSearchRequestParams requestParams) throws Exception {
        return this.searchDAO.findAllSpecies(requestParams);
    }

    @RequestMapping(value={"/webportal/species.csv", "/mapping/species.csv"}, method={RequestMethod.GET})
    public void listSpeciesCsv(SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        List list = this.searchDAO.findAllSpecies(requestParams);
        StringBuilder sb = new StringBuilder();
        sb.append("Family,Scientific name,Common name,Taxon rank,LSID,# Occurrences");
        for (TaxaCountDTO d : list) {
            String family = d.getFamily();
            String name = d.getName();
            String commonName = d.getCommonName();
            String guid = d.getGuid();
            String rank = d.getRank();
            if (family == null) {
                family = "";
            }
            if (name == null) {
                name = "";
            }
            if (commonName == null) {
                commonName = "";
            }
            if (d.getGuid() == null && d.getName() != null) {
                String[] nameLsid = d.getName().split("\\|");
                if (nameLsid.length >= 2) {
                    name = nameLsid[0];
                    guid = nameLsid[1];
                    rank = "scientific name";
                    if (nameLsid.length >= 3) {
                        commonName = nameLsid[2];
                    }
                } else {
                    name = "Unknown";
                }
            }
            if (d.getCount() == null || guid == null) continue;
            sb.append("\n\"").append(family.replace("\"", "\"\"").trim()).append("\",\"").append(name.replace("\"", "\"\"").trim()).append("\",\"").append(commonName.replace("\"", "\"\"").trim()).append("\",").append(rank).append(",").append(guid).append(",").append(d.getCount());
        }
        this.writeBytes(response, sb.toString().getBytes("UTF-8"));
    }

    @RequestMapping(value={"/webportal/legend", "/mapping/legend"}, method={RequestMethod.GET})
    @ResponseBody
    public List<LegendItem> legend(SpatialSearchRequestParams requestParams, @RequestParam(value="cm", required=false, defaultValue="") String colourMode, @RequestParam(value="type", required=false, defaultValue="application/csv") String returnType, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] acceptableTypes = new String[]{"application/json", "application/csv"};
        String accepts = request.getHeader("Accept");
        String string = returnType = StringUtils.isNotEmpty((String)accepts) && !accepts.contains(",") ? accepts : returnType;
        if (!Arrays.asList(acceptableTypes).contains(returnType)) {
            response.sendError(406, "Unable to produce a legend in the supplied \"Accept\" format: " + returnType);
            return null;
        }
        boolean isCsv = returnType.equals("application/csv");
        String[] s = colourMode.split(",");
        String[] cutpoints = null;
        if (s.length > 1) {
            cutpoints = new String[s.length - 1];
            System.arraycopy(s, 1, cutpoints, 0, cutpoints.length);
        }
        List legend = this.searchDAO.getLegend(requestParams, s[0], cutpoints);
        if (cutpoints == null) {
            Collections.sort(legend);
        }
        StringBuilder sb = new StringBuilder();
        if (isCsv) {
            sb.append("name,red,green,blue,count");
        }
        int i = 0;
        int offset = 0;
        for (i = 0; i < legend.size(); ++i) {
            LegendItem li = (LegendItem)legend.get(i);
            String name = li.getName();
            if (name == null) {
                name = "Unknown";
            }
            int colour = 0;
            if (cutpoints == null) {
                colour = this.colourList[Math.min(i, this.colourList.length - 1)];
            } else if (cutpoints != null && i - offset < cutpoints.length) {
                if (name.equals("Unknown") || name.startsWith("-")) {
                    ++offset;
                    colour = 0;
                } else {
                    colour = this.getRangedColour(i - offset, cutpoints.length / 2);
                }
            }
            li.setRGB(colour);
            if (!isCsv) continue;
            sb.append("\n\"").append(name.replace("\"", "\"\"")).append("\",").append(this.getRGB(colour)).append(",").append(((LegendItem)legend.get(i)).getCount());
        }
        if (returnType.equals("application/json")) {
            return legend;
        }
        this.writeBytes(response, sb.toString().getBytes("UTF-8"));
        return null;
    }

    @RequestMapping(value={"/webportal/dataProviders", "/mapping/dataProviders"}, method={RequestMethod.GET})
    @ResponseBody
    public List<DataProviderCountDTO> queryInfo(SpatialSearchRequestParams requestParams) throws Exception {
        return this.searchDAO.getDataProviderList(requestParams);
    }

    @RequestMapping(value={"/webportal/bbox", "/mapping/bbox"}, method={RequestMethod.GET})
    public void boundingBox(SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        double[] bbox = null;
        String q = requestParams.getQ();
        if (q.startsWith("qid:")) {
            try {
                bbox = this.qidCacheDAO.get(q.substring(4)).getBbox();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (bbox == null) {
            bbox = this.getBBox(requestParams);
        }
        this.writeBytes(response, (bbox[0] + "," + bbox[1] + "," + bbox[2] + "," + bbox[3]).getBytes("UTF-8"));
    }

    @RequestMapping(value={"/webportal/bounds", "/mapping/bounds"}, method={RequestMethod.GET})
    @ResponseBody
    public double[] jsonBoundingBox(SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        double[] bbox = null;
        String q = requestParams.getQ();
        if (q.startsWith("qid:")) {
            try {
                bbox = this.qidCacheDAO.get(q.substring(4)).getBbox();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (bbox == null) {
            bbox = this.getBBox(requestParams);
        }
        return bbox;
    }

    @RequestMapping(value={"/webportal/occurrences*", "/mapping/occurrences*"}, method={RequestMethod.GET})
    @ResponseBody
    public SearchResultDTO occurrences(SpatialSearchRequestParams requestParams, Model model) throws Exception {
        SearchResultDTO searchResult = new SearchResultDTO();
        if (StringUtils.isEmpty((String)requestParams.getQ())) {
            return searchResult;
        }
        searchResult = this.searchDAO.findByFulltextSpatialQuery(requestParams, null);
        model.addAttribute("searchResult", (Object)searchResult);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning results set with: " + searchResult.getTotalRecords()));
        }
        return searchResult;
    }

    @RequestMapping(value={"/webportal/occurrences.gz", "/mapping/occurrences.gz"}, method={RequestMethod.GET})
    public void occurrenceGz(SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        response.setContentType("text/plain");
        response.setCharacterEncoding("gzip");
        ServletOutputStream outStream = response.getOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream((OutputStream)outStream);
        this.writeOccurrencesCsvToStream(requestParams, (OutputStream)gzip);
        gzip.flush();
        gzip.close();
    }

    private void writeOccurrencesCsvToStream(SpatialSearchRequestParams requestParams, OutputStream stream) throws Exception {
        SolrDocumentList sdl = this.searchDAO.findByFulltext(requestParams);
        byte[] bComma = ",".getBytes("UTF-8");
        byte[] bNewLine = "\n".getBytes("UTF-8");
        byte[] bDblQuote = "\"".getBytes("UTF-8");
        if (sdl != null && sdl.size() > 0) {
            int i;
            int i2;
            ArrayList<String> header = new ArrayList<String>();
            if (requestParams.getFl() == null || requestParams.getFl().isEmpty()) {
                TreeSet unique = new TreeSet();
                for (i2 = 0; i2 < sdl.size(); ++i2) {
                    unique.addAll(((SolrDocument)sdl.get(i2)).getFieldNames());
                }
                header = new ArrayList(unique);
            } else {
                String[] fields = requestParams.getFl().split(",");
                for (i2 = 0; i2 < fields.length; ++i2) {
                    if (fields[i2].length() <= 0) continue;
                    header.add(fields[i2]);
                }
            }
            for (i = 0; i < header.size(); ++i) {
                if (i > 0) {
                    stream.write(bComma);
                }
                stream.write(((String)header.get(i)).getBytes("UTF-8"));
            }
            for (i = 0; i < sdl.size(); ++i) {
                stream.write(bNewLine);
                for (int j = 0; j < header.size(); ++j) {
                    if (j > 0) {
                        stream.write(bComma);
                    }
                    if (!((SolrDocument)sdl.get(i)).containsKey(header.get(j))) continue;
                    stream.write(bDblQuote);
                    stream.write(String.valueOf(((SolrDocument)sdl.get(i)).getFieldValue((String)header.get(j))).replace("\"", "\"\"").getBytes("UTF-8"));
                    stream.write(bDblQuote);
                }
            }
        }
    }

    private void writeBytes(HttpServletResponse response, byte[] bytes) throws IOException {
        response.setContentType("text/plain");
        response.setCharacterEncoding("UTF-8");
        ServletOutputStream outStream = response.getOutputStream();
        outStream.write(bytes);
        outStream.flush();
        outStream.close();
    }

    int convertLatToPixel(double lat) {
        return (int)Math.round((double)this.map_offset - this.map_radius * Math.log((1.0 + Math.sin(lat * Math.PI / 180.0)) / (1.0 - Math.sin(lat * Math.PI / 180.0))) / 2.0);
    }

    int convertLatToPixel4326(double lat, double top, double bottom, int pixelHeight) {
        return (int)((lat - top) / (bottom - top) * (double)pixelHeight);
    }

    int convertLngToPixel4326(double lng, double left, double right, int pixelWidth) {
        return (int)((lng - left) / (right - left) * (double)pixelWidth);
    }

    int convertLngToPixel(double lng) {
        return (int)Math.round((double)this.map_offset + this.map_radius * lng * Math.PI / 180.0);
    }

    double convertMetersToLng(double meters) {
        return meters / 2.0037508342789244E7 * 180.0;
    }

    double convertLngToMeters(double lng) {
        return 111319.49079327358 * lng;
    }

    double convertLatToMeters(double lat) {
        return 6378137.0 * Math.log(Math.tan(Math.PI / 180 * (45.0 + lat / 2.0)));
    }

    double convertMetersToLat(double meters) {
        return 57.29577951308232 * (2.0 * Math.atan(Math.exp(meters / 2.0037508342789244E7 * Math.PI)) - 1.5707963267948966);
    }

    protected PointType getPointTypeForDegreesPerPixel(double resolution) {
        PointType pointType = null;
        pointType = resolution >= 1.0 ? PointType.POINT_1 : (resolution >= 0.1 ? PointType.POINT_01 : (resolution >= 0.01 ? PointType.POINT_001 : (resolution >= 0.001 ? PointType.POINT_0001 : (resolution >= 1.0E-4 ? PointType.POINT_00001 : PointType.POINT_RAW))));
        return pointType;
    }

    void displayBlankImage(HttpServletResponse response) {
        try {
            ServletOutputStream outStream = response.getOutputStream();
            outStream.write(blankImageBytes);
            outStream.flush();
            outStream.close();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to write image", (Throwable)e);
        }
    }

    private double getBBoxes(String bboxString, int width, int height, int size, boolean uncertainty, double[] mbbox, double[] bbox, double[] pbbox, double[] tilebbox) {
        int i = 0;
        for (String s : bboxString.split(",")) {
            try {
                tilebbox[i] = Double.parseDouble(s);
                mbbox[i] = tilebbox[i];
                ++i;
            }
            catch (Exception e) {
                logger.error((Object)("Problem parsing BBOX: '" + bboxString + "'"), (Throwable)e);
            }
        }
        double pixelWidth = (mbbox[2] - mbbox[0]) / (double)width;
        double pixelHeight = (mbbox[3] - mbbox[1]) / (double)height;
        mbbox[0] = mbbox[0] + pixelWidth / 2.0;
        mbbox[2] = mbbox[2] - pixelWidth / 2.0;
        mbbox[1] = mbbox[1] + pixelHeight / 2.0;
        mbbox[3] = mbbox[3] - pixelHeight / 2.0;
        double xoffset = (mbbox[2] - mbbox[0]) / (double)width * (double)size;
        double yoffset = (mbbox[3] - mbbox[1]) / (double)height * (double)size;
        if (uncertainty) {
            if (xoffset < 30000.0) {
                xoffset = 30000.0;
            }
            if (yoffset < 30000.0) {
                yoffset = 30000.0;
            }
        }
        xoffset += pixelWidth;
        yoffset += pixelHeight;
        pbbox[0] = this.convertLngToPixel(this.convertMetersToLng(mbbox[0]));
        pbbox[1] = this.convertLatToPixel(this.convertMetersToLat(mbbox[1]));
        pbbox[2] = this.convertLngToPixel(this.convertMetersToLng(mbbox[2]));
        pbbox[3] = this.convertLatToPixel(this.convertMetersToLat(mbbox[3]));
        bbox[0] = this.convertMetersToLng(mbbox[0] - xoffset);
        bbox[1] = this.convertMetersToLat(mbbox[1] - yoffset);
        bbox[2] = this.convertMetersToLng(mbbox[2] + xoffset);
        bbox[3] = this.convertMetersToLat(mbbox[3] + yoffset);
        double degreesPerPixel = Math.min((this.convertMetersToLng(mbbox[2]) - this.convertMetersToLng(mbbox[0])) / (double)width, (this.convertMetersToLng(mbbox[3]) - this.convertMetersToLng(mbbox[1])) / (double)height);
        return degreesPerPixel;
    }

    private double getBBoxes4326(String bboxString, int width, int height, int size, boolean uncertainty, double[] mbbox, double[] bbox, double[] pbbox, double[] tilebbox) {
        int i = 0;
        for (String s : bboxString.split(",")) {
            try {
                tilebbox[i] = Double.parseDouble(s);
                mbbox[i] = tilebbox[i];
                ++i;
            }
            catch (Exception e) {
                logger.error((Object)("Problem parsing BBOX: '" + bboxString + "'"), (Throwable)e);
            }
        }
        double pixelWidth = (mbbox[2] - mbbox[0]) / (double)width;
        double pixelHeight = (mbbox[3] - mbbox[1]) / (double)height;
        mbbox[0] = mbbox[0] + pixelWidth / 2.0;
        mbbox[2] = mbbox[2] - pixelWidth / 2.0;
        mbbox[1] = mbbox[1] + pixelHeight / 2.0;
        mbbox[3] = mbbox[3] - pixelHeight / 2.0;
        double xoffset = (mbbox[2] - mbbox[0]) / (double)width * (double)size;
        double yoffset = (mbbox[3] - mbbox[1]) / (double)height * (double)size;
        if (uncertainty) {
            double scale = 1.0E-5;
            if (xoffset < 30000.0 * scale) {
                xoffset = 30000.0 * scale;
            }
            if (yoffset < 30000.0 * scale) {
                yoffset = 30000.0 * scale;
            }
        }
        bbox[0] = mbbox[0] - (xoffset += pixelWidth);
        bbox[1] = mbbox[1] - (yoffset += pixelHeight);
        bbox[2] = mbbox[2] + xoffset;
        bbox[3] = mbbox[3] + yoffset;
        double degreesPerPixel = Math.min(pixelWidth, pixelHeight);
        return degreesPerPixel;
    }

    private String getQ(String cql_filter) {
        String q = cql_filter;
        int p1 = cql_filter.indexOf("qid:");
        if (p1 >= 0) {
            int p2 = cql_filter.indexOf(38, p1 + 1);
            if (p2 < 0) {
                p2 = cql_filter.indexOf(59, p1 + 1);
            }
            if (p2 < 0) {
                p2 = cql_filter.length();
            }
            q = cql_filter.substring(p1, p2);
        }
        return q;
    }

    private List<LegendItem> getColours(SpatialSearchRequestParams request, String colourMode) throws Exception {
        ArrayList<LegendItem> colours = new ArrayList<LegendItem>();
        if (colourMode.equals("grid")) {
            for (int i = 0; i <= 500; i += 100) {
                LegendItem li = i == 0 ? new LegendItem(">0", 0L, null) : new LegendItem(String.valueOf(i), 0L, null);
                li.setColour((500 - i) / 2 << 8 | 0xFF0000);
                colours.add(li);
            }
        } else {
            SpatialSearchRequestParams requestParams = new SpatialSearchRequestParams();
            requestParams.setQ(request.getQ());
            requestParams.setQc(request.getQc());
            requestParams.setFq(this.getFq(request));
            String[] s = colourMode.split(",");
            String[] cutpoints = null;
            if (s.length > 1) {
                cutpoints = new String[s.length - 1];
                System.arraycopy(s, 1, cutpoints, 0, cutpoints.length);
            }
            if (s[0].equals("-1") || s[0].equals("grid")) {
                return null;
            }
            List legend = this.searchDAO.getLegend(requestParams, s[0], cutpoints);
            if (cutpoints == null) {
                Collections.sort(legend);
            }
            int i = 0;
            int offset = 0;
            for (i = 0; i < legend.size() && i < this.colourList.length - 1; ++i) {
                colours.add(new LegendItem(((LegendItem)legend.get(i)).getName(), ((LegendItem)legend.get(i)).getCount(), ((LegendItem)legend.get(i)).getFq()));
                int colour = 0;
                if (cutpoints == null) {
                    colour = this.colourList[i];
                } else if (cutpoints != null && i - offset < cutpoints.length) {
                    if (((LegendItem)legend.get(i)).getName() == null || ((LegendItem)legend.get(i)).getName().equals("Unknown") || ((LegendItem)legend.get(i)).getName().startsWith("-")) {
                        ++offset;
                    } else {
                        colour = this.getRangedColour(i - offset, cutpoints.length / 2);
                    }
                }
                ((LegendItem)colours.get(colours.size() - 1)).setColour(colour);
            }
        }
        return colours;
    }

    int getRangedColour(int pos, int length) {
        int[] colourRange = new int[]{11728, 23458, 35955, 47428, 59158, 0xA0FF00, 0xFFFF00, 16762900, 0xFFA000, 16734976, 0xFF0000};
        double step = 1.0 / (double)colourRange.length;
        double p = (double)pos / (double)length;
        double dist = p / step;
        int minI = (int)Math.floor(dist);
        int maxI = (int)Math.ceil(dist);
        if (maxI >= colourRange.length) {
            maxI = colourRange.length - 1;
        }
        double minorP = p - (double)minI * step;
        double minorDist = minorP / step;
        int colour = 0;
        for (int i = 0; i < 3; ++i) {
            int minC = colourRange[minI] >> i * 8 & 0xFF;
            int maxC = colourRange[maxI] >> i * 8 & 0xFF;
            int c = Math.min((int)((double)(maxC - minC) * minorDist + (double)minC), 255);
            colour |= (c & 0xFF) << i * 8;
        }
        return colour;
    }

    String getRGB(int colour) {
        return (colour >> 16 & 0xFF) + "," + (colour >> 8 & 0xFF) + "," + (colour & 0xFF);
    }

    double[] getBBox(SpatialSearchRequestParams requestParams) throws Exception {
        double[] bbox = new double[4];
        String[] sort = new String[]{"longitude", "latitude", "longitude", "latitude"};
        String[] dir = new String[]{"asc", "asc", "desc", "desc"};
        String[] fq = (String[])ArrayUtils.addAll((Object[])this.getFq(requestParams), (Object[])new String[]{"longitude:[* TO *]", "latitude:[* TO *]"});
        requestParams.setFq(fq);
        requestParams.setPageSize(Integer.valueOf(10));
        for (int i = 0; i < sort.length; ++i) {
            requestParams.setSort(sort[i]);
            requestParams.setDir(dir[i]);
            requestParams.setFl(sort[i]);
            SolrDocumentList sdl = this.searchDAO.findByFulltext(requestParams);
            if (sdl == null || sdl.size() <= 0) continue;
            if (sdl.get(0) != null) {
                bbox[i] = (Double)((SolrDocument)sdl.get(0)).getFieldValue(sort[i]);
                continue;
            }
            logger.error((Object)"searchDAO.findByFulltext returning SolrDocumentList with null records");
        }
        return bbox;
    }

    private String convertBBox4326To900913(String bbox) {
        int i = 0;
        Object[] mbbox = new Double[4];
        for (String s : bbox.split(",")) {
            mbbox[i] = i % 2 == 0 ? Double.valueOf(this.convertLngToMeters(Double.parseDouble(s))) : Double.valueOf(this.convertLatToMeters(Double.parseDouble(s)));
            ++i;
        }
        return StringUtils.join((Object[])mbbox, (String)",");
    }

    @RequestMapping(value={"/ogc/getMetadata"}, method={RequestMethod.GET})
    public String getMetadata(@RequestParam(value="LAYER", required=false, defaultValue="") String layer, @RequestParam(value="q", required=false, defaultValue="") String query, HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
        String[] parts;
        String taxonName = "";
        String rank = "";
        String q = "";
        if (StringUtils.trimToNull((String)layer) != null) {
            parts = layer.split(":");
            taxonName = parts[parts.length - 1];
            if (parts.length > 1) {
                rank = parts[0];
            }
            q = layer;
        } else if (StringUtils.trimToNull((String)query) != null) {
            parts = query.split(":");
            taxonName = parts[parts.length - 1];
            if (parts.length > 1) {
                rank = parts[0];
            }
            q = query;
        } else {
            response.sendError(400);
        }
        ObjectMapper om = new ObjectMapper();
        String guid = null;
        JsonNode guidLookupNode = om.readTree(new URL("http://bie.ala.org.au/ws/guid/" + URLEncoder.encode(taxonName, "UTF-8")));
        if (guidLookupNode.isArray() && guidLookupNode.size() > 0) {
            JsonNode idNode = guidLookupNode.get(0).get("acceptedIdentifier");
            guid = idNode != null ? idNode.asText() : null;
        }
        String newQuery = "raw_name:" + taxonName;
        if (guid != null) {
            JsonNode authorshipNode;
            JsonNode nameNode;
            String imageUrl;
            model.addAttribute("guid", (Object)guid);
            model.addAttribute("speciesPageUrl", (Object)("http://bie.ala.org.au/species/" + guid));
            JsonNode node = om.readTree(new URL("http://bie.ala.org.au/ws/species/info/" + guid + ".json"));
            JsonNode tc = node.get("taxonConcept");
            JsonNode imageNode = tc.get("smallImageUrl");
            String string = imageUrl = imageNode != null ? imageNode.asText() : null;
            if (imageUrl != null) {
                model.addAttribute("imageUrl", (Object)imageUrl);
                JsonNode imageMetadataNode = node.get("taxonConcept").get("imageMetadataUrl");
                String imageMetadataUrl = imageMetadataNode != null ? imageMetadataNode.asText() : null;
                JsonNode imageMetadata = om.readTree(new URL(imageMetadataUrl));
                if (imageMetadata != null) {
                    if (imageMetadata.get("http://purl.org/dc/elements/1.1/creator") != null) {
                        model.addAttribute("imageCreator", (Object)imageMetadata.get("http://purl.org/dc/elements/1.1/creator").asText());
                    }
                    if (imageMetadata.get("http://purl.org/dc/elements/1.1/license") != null) {
                        model.addAttribute("imageLicence", (Object)imageMetadata.get("http://purl.org/dc/elements/1.1/license").asText());
                    }
                    if (imageMetadata.get("http://purl.org/dc/elements/1.1/source") != null) {
                        model.addAttribute("imageSource", (Object)imageMetadata.get("http://purl.org/dc/elements/1.1/source").asText());
                    }
                }
            }
            JsonNode leftNode = tc.get("left");
            JsonNode rightNode = tc.get("right");
            newQuery = leftNode != null && rightNode != null ? "lft:[" + leftNode.asText() + " TO " + rightNode.asText() + "]" : "taxon_concept_lsid:" + guid;
            logger.debug((Object)("The new query : " + newQuery));
            JsonNode commonNameNode = tc.get("commonNameSingle");
            if (commonNameNode != null) {
                model.addAttribute("commonName", (Object)commonNameNode.asText());
                logger.debug((Object)("retrieved name: " + commonNameNode.asText()));
            }
            if ((nameNode = tc.get("nameComplete")) != null) {
                model.addAttribute("name", (Object)nameNode.asText());
                logger.debug((Object)("retrieved name: " + nameNode.asText()));
            }
            if ((authorshipNode = node.get("taxonConcept").get("author")) != null) {
                model.addAttribute("authorship", (Object)authorshipNode.asText());
            }
            JsonNode node2 = om.readTree(new URL("http://bie.ala.org.au/ws/species/" + guid + ".json"));
            JsonNode classificationNode = node2.get("classification");
            model.addAttribute("kingdom", (Object)StringUtils.capitalize((String)classificationNode.get("kingdom").asText().toLowerCase()));
            model.addAttribute("phylum", (Object)StringUtils.capitalize((String)classificationNode.get("phylum").asText().toLowerCase()));
            model.addAttribute("clazz", (Object)StringUtils.capitalize((String)classificationNode.get("clazz").asText().toLowerCase()));
            model.addAttribute("order", (Object)StringUtils.capitalize((String)classificationNode.get("order").asText().toLowerCase()));
            model.addAttribute("family", (Object)StringUtils.capitalize((String)classificationNode.get("family").asText().toLowerCase()));
            model.addAttribute("genus", (Object)classificationNode.get("genus").asText());
            JsonNode taxonNameNode = node2.get("taxonName");
            if (taxonNameNode != null && taxonNameNode.get("specificEpithet") != null) {
                model.addAttribute("specificEpithet", (Object)taxonNameNode.get("specificEpithet").asText());
            }
        }
        SpatialSearchRequestParams searchParams = new SpatialSearchRequestParams();
        searchParams.setQ(newQuery);
        searchParams.setFacets(new String[]{"data_resource"});
        searchParams.setPageSize(Integer.valueOf(0));
        List facets = this.searchDAO.getFacetCounts(searchParams);
        model.addAttribute("query", (Object)newQuery);
        model.addAttribute("dataProviders", (Object)((FacetResultDTO)facets.get(0)).getFieldResult());
        return "metadata/mcp";
    }

    @RequestMapping(value={"/ogc/getFeatureInfo"}, method={RequestMethod.GET})
    public String getFeatureInfo(@RequestParam(value="CQL_FILTER", required=false, defaultValue="") String cql_filter, @RequestParam(value="ENV", required=false, defaultValue="") String env, @RequestParam(value="BBOX", required=true, defaultValue="0,-90,180,0") String bboxString, @RequestParam(value="WIDTH", required=true, defaultValue="256") Integer width, @RequestParam(value="HEIGHT", required=true, defaultValue="256") Integer height, @RequestParam(value="STYLES", required=false, defaultValue="") String styles, @RequestParam(value="SRS", required=false, defaultValue="") String srs, @RequestParam(value="QUERY_LAYERS", required=false, defaultValue="") String queryLayers, @RequestParam(value="X", required=true, defaultValue="0") Double x, @RequestParam(value="Y", required=true, defaultValue="0") Double y, HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
        logger.debug((Object)("WMS - GetFeatureInfo requested for: " + queryLayers));
        if ("EPSG:4326".equals(srs)) {
            bboxString = this.convertBBox4326To900913(bboxString);
        }
        WmsEnv vars = new WmsEnv(env, styles);
        double[] mbbox = new double[4];
        double[] bbox = new double[4];
        double[] pbbox = new double[4];
        double[] tilebbox = new double[4];
        int size = vars.size + (vars.highlight != null ? 6 + (int)((double)vars.size * 0.2) : 0) + 5;
        double resolution = this.getBBoxes(bboxString, width.intValue(), height.intValue(), size, vars.uncertainty, mbbox, bbox, pbbox, tilebbox);
        PointType pointType = this.getPointTypeForDegreesPerPixel(resolution);
        double longitude = bbox[0] + (bbox[2] - bbox[0]) / (double)width.intValue() * x;
        double latitude = bbox[3] - (bbox[3] - bbox[1]) / (double)height.intValue() * y;
        double roundedLongitude = pointType.roundToPointType(longitude);
        double roundedLatitude = pointType.roundToPointType(latitude);
        double minLng = pointType.roundDownToPointType(roundedLongitude - (double)(pointType.getValue().floatValue() * 2.0f * (float)(size + 3)));
        double maxLng = pointType.roundUpToPointType(roundedLongitude + (double)(pointType.getValue().floatValue() * 2.0f * (float)(size + 3)));
        double minLat = pointType.roundDownToPointType(roundedLatitude - (double)(pointType.getValue().floatValue() * 2.0f * (float)(size + 3)));
        double maxLat = pointType.roundUpToPointType(roundedLatitude + (double)(pointType.getValue().floatValue() * 2.0f * (float)(size + 3)));
        SpatialSearchRequestParams requestParams = new SpatialSearchRequestParams();
        String q = this.convertLayersParamToQ(queryLayers);
        requestParams.setQ(this.convertLayersParamToQ(queryLayers));
        logger.debug((Object)("WMS GetFeatureInfo for " + queryLayers + ", longitude:[" + minLng + " TO " + maxLng + "],  latitude:[" + minLat + " TO " + maxLat + "]"));
        String[] fqs = new String[]{"longitude:[" + minLng + " TO " + maxLng + "]", "latitude:[" + minLat + " TO " + maxLat + "]"};
        requestParams.setFq(fqs);
        requestParams.setFacet(Boolean.valueOf(false));
        SolrDocumentList sdl = this.searchDAO.findByFulltext(requestParams);
        String body = "";
        if (sdl != null && sdl.size() > 0) {
            SolrDocument doc = (SolrDocument)sdl.get(0);
            model.addAttribute("record", (Object)doc.getFieldValueMap());
            model.addAttribute("totalRecords", (Object)sdl.getNumFound());
        }
        model.addAttribute("uriUrl", (Object)("http://biocache.ala.org.au/occurrences/search?q=" + URLEncoder.encode(q, "UTF-8") + "&fq=" + URLEncoder.encode(fqs[0], "UTF-8") + "&fq=" + URLEncoder.encode(fqs[1], "UTF-8")));
        model.addAttribute("pointType", (Object)pointType.name());
        model.addAttribute("minLng", (Object)minLng);
        model.addAttribute("maxLng", (Object)maxLng);
        model.addAttribute("minLat", (Object)minLat);
        model.addAttribute("maxLat", (Object)maxLat);
        model.addAttribute("latitudeClicked", (Object)latitude);
        model.addAttribute("longitudeClicked", (Object)longitude);
        return "metadata/getFeatureInfo";
    }

    String convertLayersParamToQ(String layers) {
        if (StringUtils.trimToNull((String)layers) != null) {
            String[] parts = layers.split(",");
            Object[] formattedParts = new String[parts.length];
            int i = 0;
            for (String part : parts) {
                formattedParts[i] = part.contains(":") ? part.replace('_', ' ').replace(":", ":\"") + "\"" : (part.startsWith("\"") ? "\"" + part + "\"" : part);
                ++i;
            }
            return StringUtils.join((Object[])formattedParts, (String)" OR ");
        }
        return null;
    }

    @RequestMapping(value={"/ogc/legendGraphic"}, method={RequestMethod.GET})
    public void getLegendGraphic(@RequestParam(value="ENV", required=false, defaultValue="") String env, @RequestParam(value="STYLE", required=false, defaultValue="8b0000;opacity=1;size=5") String style, @RequestParam(value="WIDTH", required=false, defaultValue="30") Integer width, @RequestParam(value="HEIGHT", required=false, defaultValue="20") Integer height, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            if (StringUtils.trimToNull((String)env) == null && StringUtils.trimToNull((String)style) == null) {
                style = "8b0000;opacity=1;size=5";
            }
            WmsEnv wmsEnv = new WmsEnv(env, style);
            BufferedImage img = new BufferedImage(width, height, 2);
            Graphics2D g = (Graphics2D)img.getGraphics();
            int size = width > height ? height : width;
            Color fill = new Color(wmsEnv.colour | wmsEnv.alpha << 24);
            g.setPaint(fill);
            g.fillOval(0, 0, size, size);
            ServletOutputStream out = response.getOutputStream();
            logger.debug((Object)("WMS - GetLegendGraphic requested : " + request.getQueryString()));
            response.setContentType("image/png");
            ImageIO.write((RenderedImage)img, "png", (OutputStream)out);
            out.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/ogc/ows", "/ogc/capabilities"}, method={RequestMethod.GET})
    public void getCapabilities(SpatialSearchRequestParams requestParams, @RequestParam(value="CQL_FILTER", required=false, defaultValue="") String cql_filter, @RequestParam(value="ENV", required=false, defaultValue="") String env, @RequestParam(value="SRS", required=false, defaultValue="EPSG:900913") String srs, @RequestParam(value="STYLES", required=false, defaultValue="") String styles, @RequestParam(value="STYLE", required=false, defaultValue="") String style, @RequestParam(value="BBOX", required=false, defaultValue="") String bboxString, @RequestParam(value="WIDTH", required=false, defaultValue="256") Integer width, @RequestParam(value="HEIGHT", required=false, defaultValue="256") Integer height, @RequestParam(value="CACHE", required=false, defaultValue="off") String cache, @RequestParam(value="REQUEST", required=false, defaultValue="") String requestString, @RequestParam(value="OUTLINE", required=false, defaultValue="false") boolean outlinePoints, @RequestParam(value="OUTLINECOLOUR", required=false, defaultValue="0x000000") String outlineColour, @RequestParam(value="LAYERS", required=false, defaultValue="") String layers, @RequestParam(value="q", required=false, defaultValue="*:*") String query, @RequestParam(value="fq", required=false) String[] filterQueries, @RequestParam(value="X", required=true, defaultValue="0") Double x, @RequestParam(value="Y", required=true, defaultValue="0") Double y, @RequestParam(value="spatiallyValidOnly", required=false, defaultValue="true") boolean spatiallyValidOnly, @RequestParam(value="marineSpecies", required=false, defaultValue="false") boolean marineOnly, @RequestParam(value="terrestrialSpecies", required=false, defaultValue="false") boolean terrestrialOnly, @RequestParam(value="limitToFocus", required=false, defaultValue="true") boolean limitToFocus, @RequestParam(value="useSpeciesGroups", required=false, defaultValue="false") boolean useSpeciesGroups, HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
        if ("GetMap".equalsIgnoreCase(requestString)) {
            this.generateWmsTile(requestParams, cql_filter, env, srs, styles, bboxString, width, height, cache, requestString, outlinePoints, outlineColour, layers, null, request, response);
            return;
        }
        if ("GetLegendGraphic".equalsIgnoreCase(requestString)) {
            this.getLegendGraphic(env, style, Integer.valueOf(30), Integer.valueOf(20), request, response);
            return;
        }
        if ("GetFeatureInfo".equalsIgnoreCase(requestString)) {
            this.getFeatureInfo(cql_filter, env, bboxString, width, height, styles, srs, layers, x, y, request, response, model);
            return;
        }
        response.setContentType("text/xml");
        response.setHeader("Content-Description", "File Transfer");
        response.setHeader("Content-Disposition", "attachment; filename=GetCapabilities.xml");
        response.setHeader("Content-Transfer-Encoding", "binary");
        try {
            String biocacheServerUrl = request.getSession().getServletContext().getInitParameter("webservicesRoot");
            PrintWriter writer = response.getWriter();
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE WMT_MS_Capabilities SYSTEM \"http://spatial.ala.org.au/geoserver/schemas/wms/1.1.1/WMS_MS_Capabilities.dtd\">\n<WMT_MS_Capabilities version=\"1.1.1\" updateSequence=\"28862\">\n  <Service>\n    <Name>OGC:WMS</Name>\n    <Title>" + this.organizationName + "(WMS) - Species occurrences</Title>\n" + "    <Abstract>WMS services for species occurrences.</Abstract>\n" + "    <KeywordList>\n" + "      <Keyword>WMS</Keyword>\n" + "      <Keyword>Species occurrence data</Keyword>\n" + "      <Keyword>ALA</Keyword>\n" + "      <Keyword>CRIS</Keyword>\n" + "    </KeywordList>\n" + "    <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + biocacheServerUrl + "/ogc/wms\"/>\n" + "    <ContactInformation>\n" + "      <ContactPersonPrimary>\n" + "        <ContactPerson>ALA Support</ContactPerson>\n" + "        <ContactOrganization>" + this.organizationName + "</ContactOrganization>\n" + "      </ContactPersonPrimary>\n" + "      <ContactPosition>Support Manager</ContactPosition>\n" + "      <ContactAddress>\n" + "        <AddressType></AddressType>\n" + "        <Address/>\n" + "        <City>" + this.orgCity + "</City>\n" + "        <StateOrProvince>" + this.orgStateProvince + "</StateOrProvince>\n" + "        <PostCode>" + this.orgPostcode + "</PostCode>\n" + "        <Country>" + this.orgCountry + "</Country>\n" + "      </ContactAddress>\n" + "      <ContactVoiceTelephone>" + this.orgPhone + "</ContactVoiceTelephone>\n" + "      <ContactFacsimileTelephone>" + this.orgFax + "</ContactFacsimileTelephone>\n" + "      <ContactElectronicMailAddress>" + this.orgEmail + "</ContactElectronicMailAddress>\n" + "    </ContactInformation>\n" + "    <Fees>NONE</Fees>\n" + "    <AccessConstraints>NONE</AccessConstraints>\n" + "  </Service>\n" + "  <Capability>\n" + "    <Request>\n" + "      <GetCapabilities>\n" + "        <Format>application/vnd.ogc.wms_xml</Format>\n" + "        <DCPType>\n" + "          <HTTP>\n" + "            <Get>\n" + "              <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.baseWsUrl + "/ogc/capabilities?SERVICE=WMS&amp;\"/>\n" + "            </Get>\n" + "            <Post>\n" + "              <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.baseWsUrl + "/ogc/capabilities?SERVICE=WMS&amp;\"/>\n" + "            </Post>\n" + "          </HTTP>\n" + "        </DCPType>\n" + "      </GetCapabilities>\n" + "      <GetMap>\n" + "        <Format>image/png</Format>\n" + "        <DCPType>\n" + "          <HTTP>\n" + "            <Get>\n" + "              <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.baseWsUrl + "/ogc/wms/reflect?SERVICE=WMS&amp;OUTLINE=TRUE&amp;\"/>\n" + "            </Get>\n" + "          </HTTP>\n" + "        </DCPType>\n" + "      </GetMap>\n" + "      <GetFeatureInfo>\n" + "        <Format>text/html</Format>\n" + "        <DCPType>\n" + "          <HTTP>\n" + "            <Get>\n" + "              <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.baseWsUrl + "/ogc/getFeatureInfo\"/>\n" + "            </Get>\n" + "            <Post>\n" + "              <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.baseWsUrl + "/ogc/getFeatureInfo\"/>\n" + "            </Post>\n" + "          </HTTP>\n" + "        </DCPType>\n" + "      </GetFeatureInfo>\n" + "      <GetLegendGraphic>\n" + "        <Format>image/png</Format>\n" + "        <Format>image/jpeg</Format>\n" + "        <Format>image/gif</Format>\n" + "        <DCPType>\n" + "          <HTTP>\n" + "            <Get>\n" + "              <OnlineResource xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"" + this.baseWsUrl + "/ogc/legendGraphic\"/>\n" + "            </Get>\n" + "          </HTTP>\n" + "        </DCPType>\n" + "      </GetLegendGraphic>\n" + "    </Request>\n" + "    <Exception>\n" + "      <Format>application/vnd.ogc.se_xml</Format>\n" + "      <Format>application/vnd.ogc.se_inimage</Format>\n" + "    </Exception>\n" + "    <Layer>\n" + "      <Title>" + this.organizationName + " - Species occurrence layers</Title>\n" + "      <Abstract>Custom WMS services for " + this.organizationName + " species occurrences</Abstract>\n" + "      <SRS>EPSG:900913</SRS>\n" + "      <SRS>EPSG:4326</SRS>\n" + "     <LatLonBoundingBox minx=\"-179.9\" miny=\"-89.9\" maxx=\"179.9\" maxy=\"89.9\"/>\n");
            writer.write(this.generateStylesForPoints());
            if (spatiallyValidOnly) {
                filterQueries = (String[])org.apache.commons.lang3.ArrayUtils.add((Object[])filterQueries, (Object)"geospatial_kosher:true");
            }
            if (marineOnly) {
                filterQueries = (String[])org.apache.commons.lang3.ArrayUtils.add((Object[])filterQueries, (Object)"species_habitats:Marine OR species_habitats:\"Marine and Non-marine\"");
            }
            if (terrestrialOnly) {
                filterQueries = (String[])org.apache.commons.lang3.ArrayUtils.add((Object[])filterQueries, (Object)"species_habitats:\"Non-marine\" OR species_habitats:Limnetic");
            }
            if (limitToFocus) {
                filterQueries = (String[])org.apache.commons.lang3.ArrayUtils.add((Object[])filterQueries, (Object)"latitude:[-89 TO -8] AND longitude:[100 TO 165]");
            }
            query = this.searchUtils.convertRankAndName(query);
            logger.debug((Object)("GetCapabilities query in use: " + query));
            if (useSpeciesGroups) {
                this.taxonDAO.extractBySpeciesGroups(this.baseWsUrl + "/ogc/getMetadata", query, filterQueries, (Writer)writer);
            } else {
                this.taxonDAO.extractHierarchy(this.baseWsUrl + "/ogc/getMetadata", query, filterQueries, (Writer)writer);
            }
            writer.write("</Layer></Capability></WMT_MS_Capabilities>\n");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String generateStylesForPoints() {
        String[] sizes = new String[]{"5", "10", "2"};
        String[] sizesNames = new String[]{"medium", "large", "small"};
        String[] opacities = new String[]{"0.5", "1", "0.2"};
        String[] opacitiesNames = new String[]{"medium", "opaque", "transparency"};
        StringBuffer sb = new StringBuffer();
        int colorIdx = 0;
        int sizeIdx = 0;
        int opIdx = 0;
        for (String color : this.colorsNames) {
            for (String size : sizes) {
                for (String opacity : opacities) {
                    sb.append("<Style>\n<Name>" + this.colorsCodes[colorIdx] + ";opacity=" + opacity + ";size=" + size + "</Name> \n" + "<Title>" + color + ";opacity=" + opacitiesNames[opIdx] + ";size=" + sizesNames[sizeIdx] + "</Title> \n" + "</Style>\n");
                    ++opIdx;
                }
                opIdx = 0;
                ++sizeIdx;
            }
            sizeIdx = 0;
            ++colorIdx;
        }
        return sb.toString();
    }

    @RequestMapping(value={"/webportal/wms/reflect", "/ogc/wms/reflect", "/mapping/wms/reflect"}, method={RequestMethod.GET})
    public void generateWmsTile(SpatialSearchRequestParams requestParams, @RequestParam(value="CQL_FILTER", required=false, defaultValue="") String cql_filter, @RequestParam(value="ENV", required=false, defaultValue="") String env, @RequestParam(value="SRS", required=false, defaultValue="EPSG:900913") String srs, @RequestParam(value="STYLES", required=false, defaultValue="") String styles, @RequestParam(value="BBOX", required=true, defaultValue="") String bboxString, @RequestParam(value="WIDTH", required=true, defaultValue="256") Integer width, @RequestParam(value="HEIGHT", required=true, defaultValue="256") Integer height, @RequestParam(value="CACHE", required=true, defaultValue="off") String cache, @RequestParam(value="REQUEST", required=true, defaultValue="") String requestString, @RequestParam(value="OUTLINE", required=true, defaultValue="false") boolean outlinePoints, @RequestParam(value="OUTLINECOLOUR", required=true, defaultValue="0x000000") String outlineColour, @RequestParam(value="LAYERS", required=false, defaultValue="") String layers, @RequestParam(value="HQ", required=false) String[] hqs, HttpServletRequest request, HttpServletResponse response) throws Exception {
        double[] queryBBox;
        double resolution;
        if ("GetLegendGraphic".equalsIgnoreCase(requestString)) {
            this.getLegendGraphic(env, styles, Integer.valueOf(30), Integer.valueOf(20), request, response);
            return;
        }
        HashSet<Integer> hq = new HashSet<Integer>();
        if (hqs != null && hqs.length > 0) {
            for (String h : hqs) {
                hq.add(Integer.parseInt(h));
            }
        }
        logger.debug((Object)("WMS tile: " + request.getQueryString()));
        response.setHeader("Cache-Control", "max-age=86400");
        response.setContentType("image/png");
        boolean is4326 = false;
        WmsEnv vars = new WmsEnv(env, styles);
        double[] mbbox = new double[4];
        double[] bbox = new double[4];
        double[] pbbox = new double[4];
        double[] tilebbox = new double[4];
        int size = vars.size + (vars.highlight != null ? 6 + (int)((double)vars.size * 0.2) : 0) + 5;
        if ("EPSG:4326".equals(srs)) {
            is4326 = true;
            resolution = this.getBBoxes4326(bboxString, width.intValue(), height.intValue(), size, vars.uncertainty, mbbox, bbox, pbbox, tilebbox);
        } else {
            resolution = this.getBBoxes(bboxString, width.intValue(), height.intValue(), size, vars.uncertainty, mbbox, bbox, pbbox, tilebbox);
        }
        PointType pointType = this.getPointTypeForDegreesPerPixel(resolution);
        logger.debug((Object)("Rendering: " + pointType.name()));
        String q = "";
        if (StringUtils.trimToNull((String)cql_filter) != null) {
            q = this.getQ(cql_filter);
        } else if (StringUtils.trimToNull((String)layers) != null && !"ALA:Occurrences".equalsIgnoreCase(layers)) {
            q = this.convertLayersParamToQ(layers);
        }
        String[] boundingBoxFqs = new String[]{String.format("longitude:[%f TO %f]", bbox[0], bbox[2]), String.format("latitude:[%f TO %f]", bbox[1], bbox[3])};
        int pointWidth = vars.size * 2;
        double width_mult = (double)width.intValue() / (pbbox[2] - pbbox[0]);
        double height_mult = (double)height.intValue() / (pbbox[1] - pbbox[3]);
        if (q.length() > 0) {
            requestParams.setQ(q);
        } else {
            q = requestParams.getQ();
        }
        if (q.startsWith("qid:") && (queryBBox = this.qidCacheDAO.get(q.substring(4)).getBbox()) != null && (queryBBox[0] > bbox[2] || queryBBox[2] < bbox[0] || queryBBox[1] > bbox[3] || queryBBox[3] < bbox[1])) {
            this.displayBlankImage(response);
            return;
        }
        String[] originalFqs = this.getFq(requestParams);
        WMSTile wco = null;
        if (WMSCache.isEnabled() && cache.equalsIgnoreCase("on")) {
            wco = this.getWMSCacheObject(vars, pointType, requestParams, bbox);
        } else if (!cache.equalsIgnoreCase("on")) {
            WMSCache.remove((String)requestParams.getUrlParams(), (String)vars.colourMode, (PointType)pointType);
        }
        ImgObj imgObj = null;
        imgObj = wco == null ? this.wmsUncached(requestParams, vars, pointType, pbbox, mbbox, width.intValue(), height.intValue(), width_mult, height_mult, pointWidth, originalFqs, hq, boundingBoxFqs, outlinePoints, outlineColour, response, is4326, tilebbox) : this.wmsCached(wco, requestParams, vars, pointType, pbbox, bbox, mbbox, width.intValue(), height.intValue(), width_mult, height_mult, pointWidth, originalFqs, hq, boundingBoxFqs, outlinePoints, outlineColour, response, is4326, tilebbox);
        if (imgObj != null && imgObj.g != null) {
            imgObj.g.dispose();
            try {
                ServletOutputStream outStream = response.getOutputStream();
                ImageIO.write((RenderedImage)imgObj.img, "png", (OutputStream)outStream);
                outStream.flush();
                outStream.close();
            }
            catch (Exception e) {
                logger.error((Object)"Unable to write image", (Throwable)e);
            }
        } else {
            this.displayBlankImage(response);
        }
    }

    @RequestMapping(value={"/webportal/wms/image", "/mapping/wms/image"}, method={RequestMethod.GET})
    public void generatePublicationMap(SpatialSearchRequestParams requestParams, @RequestParam(value="format", required=false, defaultValue="jpg") String format, @RequestParam(value="extents", required=true) String extents, @RequestParam(value="widthmm", required=false, defaultValue="60") Double widthMm, @RequestParam(value="pradiusmm", required=false, defaultValue="2") Double pointRadiusMm, @RequestParam(value="pradiuspx", required=false) Integer pradiusPx, @RequestParam(value="pcolour", required=false, defaultValue="FF0000") String pointColour, @RequestParam(value="popacity", required=false, defaultValue="0.8") Double pointOpacity, @RequestParam(value="baselayer", required=false, defaultValue="world") String baselayer, @RequestParam(value="scale", required=false, defaultValue="off") String scale, @RequestParam(value="dpi", required=false, defaultValue="300") Integer dpi, @RequestParam(value="outline", required=true, defaultValue="false") boolean outlinePoints, @RequestParam(value="outlineColour", required=true, defaultValue="#000000") String outlineColour, @RequestParam(value="fileName", required=false) String fileName, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] bb = extents.split(",");
        double long1 = Double.parseDouble(bb[0]);
        double lat1 = Double.parseDouble(bb[1]);
        double long2 = Double.parseDouble(bb[2]);
        double lat2 = Double.parseDouble(bb[3]);
        if (lat1 <= -90.0) {
            lat1 = -89.999;
        }
        if (lat2 >= 90.0) {
            lat2 = 89.999;
        }
        int pminx = this.convertLngToPixel(long1);
        int pminy = this.convertLatToPixel(lat1);
        int pmaxx = this.convertLngToPixel(long2);
        int pmaxy = this.convertLatToPixel(lat2);
        int width = (int)((double)dpi.intValue() / 25.4 * widthMm);
        int height = (int)Math.round((double)width * ((double)(pminy - pmaxy) / (double)(pmaxx - pminx)));
        if (height * width > 36000000) {
            String errorMessage = "Image size in pixels " + width + "x" + height + " exceeds " + 36000000 + " pixels.  Make the image smaller";
            response.sendError(406, errorMessage);
            throw new Exception(errorMessage);
        }
        int pointSize = -1;
        pointSize = pradiusPx != null ? pradiusPx : (int)((double)dpi.intValue() / 25.4 * pointRadiusMm);
        double[] boundingBox = this.transformBbox4326To900913(Double.parseDouble(bb[0]), Double.parseDouble(bb[1]), Double.parseDouble(bb[2]), Double.parseDouble(bb[3]));
        String speciesAddress = this.baseWsUrl + "/ogc/wms/reflect?" + "ENV=color%3A" + pointColour + "%3Bname%3Acircle%3Bsize%3A" + pointSize + "%3Bopacity%3A" + pointOpacity + "&BBOX=" + boundingBox[0] + "," + boundingBox[1] + "," + boundingBox[2] + "," + boundingBox[3] + "&WIDTH=" + width + "&HEIGHT=" + height + "&OUTLINE=" + outlinePoints + "&OUTLINECOLOUR=" + outlineColour + "&" + request.getQueryString();
        URL speciesURL = new URL(speciesAddress);
        BufferedImage speciesImage = ImageIO.read(speciesURL);
        String layout = "";
        if (!scale.equals("off")) {
            layout = layout + "layout:scale";
        }
        String basemapAddress = this.geoserverUrl + "/wms/reflect?" + "LAYERS=ALA%3A" + baselayer + "&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&STYLES=" + "&FORMAT=image%2Fpng&SRS=EPSG%3A900913" + "&BBOX=" + boundingBox[0] + "," + boundingBox[1] + "," + boundingBox[2] + "," + boundingBox[3] + "&WIDTH=" + width + "&HEIGHT=" + height + "&OUTLINE=" + outlinePoints + "&format_options=dpi:" + dpi + ";" + layout;
        BufferedImage basemapImage = ImageIO.read(new URL(basemapAddress));
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D combined = (Graphics2D)img.getGraphics();
        combined.drawImage(basemapImage, 0, 0, Color.WHITE, null);
        combined.setComposite(AlphaComposite.getInstance(3, 1.0f));
        combined.drawImage(speciesImage, null, 0, 0);
        combined.dispose();
        if (fileName != null) {
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Description", "File Transfer");
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            response.setHeader("Content-Transfer-Encoding", "binary");
        } else if (format.equalsIgnoreCase("png")) {
            response.setContentType("image/png");
        } else {
            response.setContentType("image/jpeg");
        }
        if (format.equalsIgnoreCase("png")) {
            ServletOutputStream os = response.getOutputStream();
            ImageIO.write((RenderedImage)img, format, (OutputStream)os);
            os.close();
        } else {
            BufferedImage img2 = new BufferedImage(width, height, 1);
            Graphics2D c2 = (Graphics2D)img2.getGraphics();
            c2.drawImage(img, 0, 0, Color.WHITE, null);
            c2.dispose();
            ServletOutputStream os = response.getOutputStream();
            ImageIO.write((RenderedImage)img2, format, (OutputStream)os);
            os.close();
        }
    }

    private ImgObj wmsCached(WMSTile wco, SpatialSearchRequestParams requestParams, WmsEnv vars, PointType pointType, double[] pbbox, double[] bbox, double[] mbbox, int width, int height, double width_mult, double height_mult, int pointWidth, String[] originalFqs, Set<Integer> hq, String[] boundingBoxFqs, boolean outlinePoints, String outlineColour, HttpServletResponse response, boolean is4326, double[] tilebbox) throws Exception {
        int y;
        int x;
        ImgObj imgObj = null;
        int divs = 16;
        int[][] gridCounts = new int[divs][divs];
        int xstep = 256 / divs;
        int ystep = 256 / divs;
        double grid_width_mult = (double)width / (pbbox[2] - pbbox[0]) / (double)(width / divs);
        double grid_height_mult = (double)height / (pbbox[1] - pbbox[3]) / (double)(height / divs);
        if (vars.alpha > 0 && vars.size > 0) {
            List points = wco.getPoints();
            List counts = wco.getCounts();
            List pColour = wco.getColours();
            if (pColour.size() == 1 && vars.colourMode.equals("-1")) {
                pColour.set(0, vars.colour | vars.alpha << 24);
            }
            imgObj = ImgObj.create((int)width, (int)height);
            for (int j = 0; j < points.size(); ++j) {
                float[] ps;
                if (hq != null && hq.contains(j) || (ps = (float[])points.get(j)) == null || ps.length == 0) continue;
                double top = tilebbox[3];
                double bottom = tilebbox[1];
                double left = tilebbox[0];
                double right = tilebbox[2];
                if (vars.colourMode.equals("grid")) {
                    int[] count = (int[])counts.get(j);
                    for (int i = 0; i < ps.length; i += 2) {
                        float lng = ps[i];
                        float lat = ps[i + 1];
                        if (!((double)lng >= bbox[0]) || !((double)lng <= bbox[2]) || !((double)lat >= bbox[1]) || !((double)lat <= bbox[3])) continue;
                        if (is4326) {
                            x = this.convertLngToPixel4326((double)lng, left, right, width);
                            y = this.convertLatToPixel4326((double)lat, top, bottom, height);
                        } else {
                            x = (int)(((double)this.convertLngToPixel((double)lng) - pbbox[0]) * grid_width_mult);
                            y = (int)(((double)this.convertLatToPixel((double)lat) - pbbox[3]) * grid_height_mult);
                        }
                        if (x < 0 || x >= divs || y < 0 || y >= divs) continue;
                        int[] nArray = gridCounts[x];
                        int n = y;
                        nArray[n] = nArray[n] + count[i / 2];
                    }
                    continue;
                }
                Color currentFill = new Color((Integer)pColour.get(j), true);
                imgObj.g.setPaint(currentFill);
                Color oColour = Color.decode(outlineColour);
                for (int i = 0; i < ps.length; i += 2) {
                    float lng = ps[i];
                    float lat = ps[i + 1];
                    if (!((double)lng >= bbox[0]) || !((double)lng <= bbox[2]) || !((double)lat >= bbox[1]) || !((double)lat <= bbox[3])) continue;
                    if (is4326) {
                        x = this.convertLngToPixel4326((double)lng, left, right, width);
                        y = this.convertLatToPixel4326((double)lat, top, bottom, height);
                    } else {
                        x = (int)(((double)this.convertLngToPixel((double)lng) - pbbox[0]) * width_mult);
                        y = (int)(((double)this.convertLatToPixel((double)lat) - pbbox[3]) * height_mult);
                    }
                    imgObj.g.fillOval(x - vars.size, y - vars.size, pointWidth, pointWidth);
                    if (!outlinePoints) continue;
                    imgObj.g.setPaint(oColour);
                    imgObj.g.drawOval(x - vars.size, y - vars.size, pointWidth, pointWidth);
                    imgObj.g.setPaint(currentFill);
                }
            }
        }
        if (imgObj == null) {
            if (vars.highlight == null) {
                this.displayBlankImage(response);
                return null;
            }
        } else if (vars.colourMode.equals("grid")) {
            for (x = 0; x < divs; ++x) {
                for (y = 0; y < divs; ++y) {
                    int v = gridCounts[x][y];
                    if (v <= 0) continue;
                    if (v > 500) {
                        v = 500;
                    }
                    int colour = (500 - v) / 2 << 8 | vars.alpha << 24 | 0xFF0000;
                    imgObj.g.setColor(new Color(colour));
                    imgObj.g.fillRect(x * xstep, y * ystep, xstep, ystep);
                }
            }
        } else {
            this.drawUncertaintyCircles(requestParams, vars, height, width, pbbox, mbbox, width_mult, height_mult, imgObj.g, originalFqs, boundingBoxFqs, is4326, tilebbox);
        }
        if (vars.highlight != null) {
            imgObj = this.drawHighlight(requestParams, vars, pointType, width, height, pbbox, width_mult, height_mult, imgObj, originalFqs, boundingBoxFqs, is4326, tilebbox);
        }
        return imgObj;
    }

    void drawUncertaintyCircles(SpatialSearchRequestParams requestParams, WmsEnv vars, int height, int width, double[] pbbox, double[] mbbox, double width_mult, double height_mult, Graphics2D g, String[] originalFqs, String[] boundingBoxFqs, boolean is4326, double[] tilebbox) throws Exception {
        double hmult = (double)height / (mbbox[3] - mbbox[1]);
        if (vars.uncertainty && 30000.0 * hmult > 1.0) {
            Color[] uncertaintyColours = new Color[]{new Color(255, 170, 0, vars.alpha), new Color(255, 255, 100, vars.alpha), new Color(50, 255, 50, vars.alpha)};
            String[] uncertaintyFqs = new String[]{"coordinate_uncertainty:[* TO 30000.0] AND -assertions:uncertaintyNotSpecified", "assertions:uncertaintyNotSpecified", "coordinate_uncertainty:[30000.0 TO *]"};
            double[] uncertaintyR = new double[]{-1.0, 30000.0, 30000.0};
            String[] fqs = new String[originalFqs.length + 3];
            System.arraycopy(originalFqs, 0, fqs, 3, originalFqs.length);
            fqs[1] = boundingBoxFqs[0];
            fqs[2] = boundingBoxFqs[1];
            requestParams.setPageSize(Integer.valueOf(1000000));
            for (int j = 0; j < uncertaintyFqs.length; ++j) {
                if (j == 1) continue;
                fqs[0] = uncertaintyFqs[j];
                requestParams.setFq(fqs);
                requestParams.setFl("longitude,latitude,coordinate_uncertainty");
                requestParams.setFacet(Boolean.valueOf(false));
                SolrDocumentList sdl = this.searchDAO.findByFulltext(requestParams);
                double top = tilebbox[3];
                double bottom = tilebbox[1];
                double left = tilebbox[0];
                double right = tilebbox[2];
                int uncertaintyRadius = (int)Math.ceil(uncertaintyR[j] * hmult);
                if (sdl == null || sdl.size() <= 0) continue;
                g.setColor(uncertaintyColours[j]);
                for (int i = 0; i < sdl.size(); ++i) {
                    int y;
                    int x;
                    if (uncertaintyR[j] < 0.0) {
                        uncertaintyRadius = (int)Math.ceil((Double)((SolrDocument)sdl.get(i)).getFieldValue("coordinate_uncertainty") * hmult);
                    }
                    double lng = (Double)((SolrDocument)sdl.get(i)).getFieldValue("longitude");
                    double lat = (Double)((SolrDocument)sdl.get(i)).getFieldValue("latitude");
                    if (is4326) {
                        x = this.convertLngToPixel4326(lng, left, right, width);
                        y = this.convertLatToPixel4326(lat, top, bottom, height);
                    } else {
                        x = (int)(((double)this.convertLngToPixel(lng) - pbbox[0]) * width_mult);
                        y = (int)(((double)this.convertLatToPixel(lat) - pbbox[3]) * height_mult);
                    }
                    if (uncertaintyRadius > 0) {
                        g.drawOval(x - uncertaintyRadius, y - uncertaintyRadius, uncertaintyRadius * 2, uncertaintyRadius * 2);
                        continue;
                    }
                    g.drawRect(x, y, 1, 1);
                }
            }
        }
    }

    ImgObj drawHighlight(SpatialSearchRequestParams requestParams, WmsEnv vars, PointType pointType, int width, int height, double[] pbbox, double width_mult, double height_mult, ImgObj imgObj, String[] originalFqs, String[] boundingBoxFqs, boolean is4326, double[] tilebbox) throws Exception {
        String[] fqs = new String[originalFqs.length + 3];
        System.arraycopy(originalFqs, 0, fqs, 3, originalFqs.length);
        fqs[0] = vars.highlight;
        fqs[1] = boundingBoxFqs[0];
        fqs[2] = boundingBoxFqs[1];
        requestParams.setFq(fqs);
        List ps = this.searchDAO.getFacetPoints(requestParams, pointType);
        if (ps != null && ps.size() > 0) {
            if (imgObj == null || imgObj.img == null) {
                imgObj = ImgObj.create((int)width, (int)height);
            }
            int highightRadius = vars.size + 3;
            int highlightWidth = highightRadius * 2;
            imgObj.g.setStroke(new BasicStroke(2.0f));
            imgObj.g.setColor(new Color(255, 0, 0, 255));
            double top = tilebbox[3];
            double bottom = tilebbox[1];
            double left = tilebbox[0];
            double right = tilebbox[2];
            for (int i = 0; i < ps.size(); ++i) {
                int y;
                int x;
                OccurrencePoint pt = (OccurrencePoint)ps.get(i);
                float lng = ((Float)pt.getCoordinates().get(0)).floatValue();
                float lat = ((Float)pt.getCoordinates().get(1)).floatValue();
                if (is4326) {
                    x = this.convertLngToPixel4326((double)lng, left, right, width);
                    y = this.convertLatToPixel4326((double)lat, top, bottom, height);
                } else {
                    x = (int)(((double)this.convertLngToPixel((double)lng) - pbbox[0]) * width_mult);
                    y = (int)(((double)this.convertLatToPixel((double)lat) - pbbox[3]) * height_mult);
                }
                imgObj.g.drawOval(x - highightRadius, y - highightRadius, highlightWidth, highlightWidth);
            }
        }
        return imgObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WMSTile getWMSCacheObject(WmsEnv vars, PointType pointType, SpatialSearchRequestParams requestParams, double[] bbox) throws Exception {
        if (WMSCache.isFull() || !WMSCache.isEnabled()) {
            return null;
        }
        String q = requestParams.getUrlParams();
        WMSTile wco = WMSCache.get((String)q, (String)vars.colourMode, (PointType)pointType);
        if (wco.getCached()) {
            return wco;
        }
        if (!wco.isCacheable()) {
            return null;
        }
        WMSTile wMSTile = wco;
        synchronized (wMSTile) {
            if (wco.getCached()) {
                return wco;
            }
            if (!wco.isCacheable()) {
                return null;
            }
            List colours = vars.colourMode.equals("-1") || vars.colourMode.equals("grid") ? null : this.getColours(requestParams, vars.colourMode);
            int sz = colours == null ? 1 : colours.size() + 1;
            SpatialSearchRequestParams r = new SpatialSearchRequestParams();
            r.setQ(requestParams.getQ());
            r.setFq(this.getFq(requestParams));
            r.setQc(requestParams.getQc());
            r.setPageSize(Integer.valueOf(0));
            r.setFacet(Boolean.valueOf(false));
            SolrDocumentList sdl = this.searchDAO.findByFulltext(r);
            int occurrenceCount = (int)sdl.getNumFound();
            if (!WMSCache.isCachable((WMSTile)wco, (int)occurrenceCount, (boolean)vars.colourMode.equals("grid"))) {
                return null;
            }
            ArrayList<List> points = new ArrayList<List>(sz);
            ArrayList<Integer> pColour = new ArrayList<Integer>(sz);
            ArrayList<String> forNulls = new ArrayList<String>(sz);
            String[] fqs = null;
            String[] originalFqs = this.getFq(requestParams);
            if (originalFqs == null || originalFqs.length == 0) {
                fqs = new String[1];
            } else {
                fqs = new String[originalFqs.length + 1];
                System.arraycopy(originalFqs, 0, fqs, 1, originalFqs.length);
            }
            requestParams.setFq(fqs);
            if (colours != null) {
                for (int i = 0; i < colours.size(); ++i) {
                    LegendItem li = (LegendItem)colours.get(i);
                    fqs[0] = li.getFq();
                    if (li.getName() == null) {
                        forNulls.add(fqs[0].substring(1));
                    } else if (fqs[0].charAt(0) == '-') {
                        forNulls.add(fqs[0].substring(1));
                    } else {
                        forNulls.add("-" + fqs[0]);
                    }
                    requestParams.setFq(fqs);
                    points.add(this.searchDAO.getFacetPoints(requestParams, pointType));
                    pColour.add(li.getColour() | vars.alpha << 24);
                }
            }
            if (colours == null || colours.isEmpty()) {
                requestParams.setFq(originalFqs);
                points.add(this.searchDAO.getFacetPoints(requestParams, pointType));
                pColour.add(vars.colour);
            } else if (colours.size() >= this.colourList.length - 1) {
                fqs = new String[forNulls.size()];
                forNulls.toArray(fqs);
                requestParams.setFq(fqs);
                points.add(this.searchDAO.getFacetPoints(requestParams, pointType));
                pColour.add(this.colourList[this.colourList.length - 1] | vars.alpha << 24);
            }
            ArrayList<float[]> pointsArrays = new ArrayList<float[]>(points.size());
            for (int i = 0; i < points.size(); ++i) {
                List ops = (List)points.get(i);
                float[] d = new float[ops.size() * 2];
                int k = 0;
                int j = 0;
                while (k < ops.size()) {
                    d[j] = ((Float)((OccurrencePoint)ops.get(k)).getCoordinates().get(0)).floatValue();
                    d[j + 1] = ((Float)((OccurrencePoint)ops.get(k)).getCoordinates().get(1)).floatValue();
                    ++k;
                    j += 2;
                }
                pointsArrays.add(d);
            }
            ArrayList<int[]> countsArrays = null;
            if (vars.colourMode.equals("grid")) {
                countsArrays = new ArrayList<int[]>(points.size());
                for (int i = 0; i < points.size(); ++i) {
                    List ops = (List)points.get(i);
                    int[] c = new int[ops.size()];
                    for (int k = 0; k < ops.size(); ++k) {
                        c[k] = ((OccurrencePoint)ops.get(k)).getCount().intValue();
                    }
                    countsArrays.add(c);
                }
            }
            wco.setBbox(bbox);
            wco.setColourmode(q);
            wco.setColourmode(vars.colourMode);
            wco.setColours(pColour);
            wco.setCounts(countsArrays);
            wco.setPoints(pointsArrays);
            wco.setQuery(q);
            WMSCache.put((String)q, (String)vars.colourMode, (PointType)pointType, (WMSTile)wco);
            return wco;
        }
    }

    private String[] getFq(SpatialSearchRequestParams requestParams) {
        int requestParamsFqLength = requestParams.getFq() != null ? requestParams.getFq().length : 0;
        String[] qidFq = null;
        int qidFqLength = 0;
        String q = requestParams.getQ();
        if (q.startsWith("qid:")) {
            try {
                qidFq = this.qidCacheDAO.get(q.substring(4)).getFqs();
                if (qidFq != null) {
                    qidFqLength = qidFq.length;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (requestParamsFqLength + qidFqLength == 0) {
            return null;
        }
        String[] allFqs = new String[requestParamsFqLength + qidFqLength];
        if (requestParamsFqLength > 0) {
            System.arraycopy(requestParams.getFq(), 0, allFqs, 0, requestParamsFqLength);
        }
        if (qidFqLength > 0) {
            System.arraycopy(qidFq, 0, allFqs, requestParamsFqLength, qidFqLength);
        }
        return allFqs;
    }

    private ImgObj wmsUncached(SpatialSearchRequestParams requestParams, WmsEnv vars, PointType pointType, double[] pbbox, double[] mbbox, int width, int height, double width_mult, double height_mult, int pointWidth, String[] originalFqs, Set<Integer> hq, String[] boundingBoxFqs, boolean outlinePoints, String outlineColour, HttpServletResponse response, boolean is4326, double[] tilebbox) throws Exception {
        int y;
        int x;
        List colours = vars.colourMode.equals("-1") || vars.colourMode.equals("grid") ? null : this.getColours(requestParams, vars.colourMode);
        int sz = colours == null ? 1 : colours.size() + 1;
        ArrayList<List> points = new ArrayList<List>(sz);
        ArrayList<Integer> pColour = new ArrayList<Integer>(sz);
        ArrayList<String> forNulls = new ArrayList<String>(sz);
        String[] fqs = null;
        String[] origAndBBoxFqs = null;
        if (originalFqs == null || originalFqs.length == 0) {
            fqs = new String[3];
            fqs[1] = boundingBoxFqs[0];
            fqs[2] = boundingBoxFqs[1];
            origAndBBoxFqs = boundingBoxFqs;
        } else {
            fqs = new String[originalFqs.length + 3];
            System.arraycopy(originalFqs, 0, fqs, 3, originalFqs.length);
            fqs[1] = boundingBoxFqs[0];
            fqs[2] = boundingBoxFqs[1];
            origAndBBoxFqs = new String[originalFqs.length + 2];
            System.arraycopy(originalFqs, 0, origAndBBoxFqs, 2, originalFqs.length);
            origAndBBoxFqs[0] = boundingBoxFqs[0];
            origAndBBoxFqs[1] = boundingBoxFqs[1];
        }
        requestParams.setFq(fqs);
        if (vars.alpha > 0 && vars.size > 0) {
            if (colours != null) {
                for (int i = 0; i < colours.size(); ++i) {
                    LegendItem li = (LegendItem)colours.get(i);
                    fqs[0] = li.getFq();
                    if (li.getName() == null) {
                        forNulls.add(fqs[0].substring(1));
                    } else if (fqs[0].charAt(0) == '-') {
                        forNulls.add(fqs[0].substring(1));
                    } else {
                        forNulls.add("-" + fqs[0]);
                    }
                    requestParams.setFq(fqs);
                    points.add(this.searchDAO.getFacetPoints(requestParams, pointType));
                    pColour.add(li.getColour() | vars.alpha << 24);
                }
            }
            if (colours == null || colours.isEmpty()) {
                requestParams.setFq(origAndBBoxFqs);
                points.add(this.searchDAO.getFacetPoints(requestParams, pointType));
                pColour.add(vars.colour);
            } else if (colours.size() >= this.colourList.length - 1) {
                fqs = new String[forNulls.size()];
                forNulls.toArray(fqs);
                String[] newFqs = new String[originalFqs.length + forNulls.size()];
                if (originalFqs.length > 0) {
                    System.arraycopy(originalFqs, 0, newFqs, 0, originalFqs.length);
                }
                if (fqs.length > 0) {
                    System.arraycopy(fqs, 0, newFqs, originalFqs.length, fqs.length);
                }
                requestParams.setFq(newFqs);
                points.add(this.searchDAO.getFacetPoints(requestParams, pointType));
                pColour.add(this.colourList[this.colourList.length - 1] | vars.alpha << 24);
            }
        }
        ImgObj imgObj = null;
        int divs = 16;
        int[][] gridCounts = new int[divs][divs];
        int xstep = 256 / divs;
        int ystep = 256 / divs;
        double grid_width_mult = (double)width / (pbbox[2] - pbbox[0]) / (double)(width / divs);
        double grid_height_mult = (double)height / (pbbox[1] - pbbox[3]) / (double)(height / divs);
        double top = tilebbox[3];
        double bottom = tilebbox[1];
        double left = tilebbox[0];
        double right = tilebbox[2];
        for (int j = 0; j < points.size(); ++j) {
            List ps;
            if (hq != null && hq.contains(j) || (ps = (List)points.get(j)) == null || ps.isEmpty()) continue;
            if (imgObj == null || imgObj.img == null) {
                imgObj = ImgObj.create((int)width, (int)height);
            }
            if (vars.colourMode.equals("grid")) {
                for (int i = 0; i < ps.size(); ++i) {
                    OccurrencePoint pt = (OccurrencePoint)ps.get(i);
                    float lng = ((Float)pt.getCoordinates().get(0)).floatValue();
                    float lat = ((Float)pt.getCoordinates().get(1)).floatValue();
                    if (is4326) {
                        x = this.convertLngToPixel4326((double)lng, left, right, width);
                        y = this.convertLatToPixel4326((double)lat, top, bottom, height);
                    } else {
                        x = (int)(((double)this.convertLngToPixel((double)lng) - pbbox[0]) * grid_width_mult);
                        y = (int)(((double)this.convertLatToPixel((double)lat) - pbbox[3]) * grid_height_mult);
                    }
                    if (x < 0 || x >= divs || y < 0 || y >= divs) continue;
                    int[] nArray = gridCounts[x];
                    int n = y;
                    nArray[n] = (int)((long)nArray[n] + pt.getCount());
                }
                continue;
            }
            this.renderPoints(vars, pbbox, width_mult, height_mult, pointWidth, outlinePoints, outlineColour, pColour, imgObj, j, ps, is4326, tilebbox, height, width);
        }
        if (imgObj == null || imgObj.img == null) {
            if (vars.highlight == null) {
                this.displayBlankImage(response);
                return null;
            }
        } else if (vars.colourMode.equals("grid")) {
            for (x = 0; x < divs; ++x) {
                for (y = 0; y < divs; ++y) {
                    int v = gridCounts[x][y];
                    if (v <= 0) continue;
                    if (v > 500) {
                        v = 500;
                    }
                    int colour = (500 - v) / 2 << 8 | vars.alpha << 24 | 0xFF0000;
                    imgObj.g.setColor(new Color(colour));
                    imgObj.g.fillRect(x * xstep, y * ystep, xstep, ystep);
                }
            }
        } else {
            this.drawUncertaintyCircles(requestParams, vars, height, width, pbbox, mbbox, width_mult, height_mult, imgObj.g, originalFqs, boundingBoxFqs, is4326, tilebbox);
        }
        if (vars.highlight != null) {
            imgObj = this.drawHighlight(requestParams, vars, pointType, width, height, pbbox, width_mult, height_mult, imgObj, originalFqs, boundingBoxFqs, is4326, tilebbox);
        }
        return imgObj;
    }

    private void renderPoints(WmsEnv vars, double[] pbbox, double width_mult, double height_mult, int pointWidth, boolean outlinePoints, String outlineColour, List<Integer> pColour, ImgObj imgObj, int j, List<OccurrencePoint> ps, boolean is4326, double[] tilebbox, int height, int width) {
        Color currentFill = new Color(pColour.get(j), true);
        imgObj.g.setPaint(currentFill);
        Color oColour = Color.decode(outlineColour);
        double top = tilebbox[3];
        double bottom = tilebbox[1];
        double left = tilebbox[0];
        double right = tilebbox[2];
        for (int i = 0; i < ps.size(); ++i) {
            int y;
            int x;
            OccurrencePoint pt = ps.get(i);
            float lng = ((Float)pt.getCoordinates().get(0)).floatValue();
            float lat = ((Float)pt.getCoordinates().get(1)).floatValue();
            if (is4326) {
                x = this.convertLngToPixel4326((double)lng, left, right, width);
                y = this.convertLatToPixel4326((double)lat, top, bottom, height);
            } else {
                x = (int)(((double)this.convertLngToPixel((double)lng) - pbbox[0]) * width_mult);
                y = (int)(((double)this.convertLatToPixel((double)lat) - pbbox[3]) * height_mult);
            }
            imgObj.g.fillOval(x - vars.size, y - vars.size, pointWidth, pointWidth);
            if (!outlinePoints) continue;
            imgObj.g.setPaint(oColour);
            imgObj.g.drawOval(x - vars.size, y - vars.size, pointWidth, pointWidth);
            imgObj.g.setPaint(currentFill);
        }
    }

    private double[] transformBbox4326To900913(double long1, double lat1, double long2, double lat2) {
        return new double[]{6378137.0 * long1 * Math.PI / 180.0, 6378137.0 * Math.log(Math.tan(0.7853981633974483 + lat1 * Math.PI / 360.0)), 6378137.0 * long2 * Math.PI / 180.0, 6378137.0 * Math.log(Math.tan(0.7853981633974483 + lat2 * Math.PI / 360.0))};
    }

    public void setTaxonDAO(TaxonDAO taxonDAO) {
        this.taxonDAO = taxonDAO;
    }

    public void setSearchDAO(SearchDAO searchDAO) {
        this.searchDAO = searchDAO;
    }

    public void setSearchUtils(SearchUtils searchUtils) {
        this.searchUtils = searchUtils;
    }

    public void setBaseWsUrl(String baseWsUrl) {
        this.baseWsUrl = baseWsUrl;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public void setOrgCity(String orgCity) {
        this.orgCity = orgCity;
    }

    public void setOrgStateProvince(String orgStateProvince) {
        this.orgStateProvince = orgStateProvince;
    }

    public void setOrgPostcode(String orgPostcode) {
        this.orgPostcode = orgPostcode;
    }

    public void setOrgCountry(String orgCountry) {
        this.orgCountry = orgCountry;
    }

    public void setOrgPhone(String orgPhone) {
        this.orgPhone = orgPhone;
    }

    public void setOrgFax(String orgFax) {
        this.orgFax = orgFax;
    }

    public void setOrgEmail(String orgEmail) {
        this.orgEmail = orgEmail;
    }

    static {
        byte[] b = null;
        try {
            RandomAccessFile raf = new RandomAccessFile(WMSController.class.getResource("/blank.png").getFile(), "r");
            b = new byte[(int)raf.length()];
            raf.read(b);
            raf.close();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to open blank image file");
        }
        blankImageBytes = b;
    }
}

