/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.biocache.Store;
import au.org.ala.biocache.dto.Facet;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.parser.AdHocParser;
import au.org.ala.biocache.web.UploaderThread;
import au.org.ala.biocache.web.UserUpload;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class UploadController {
    private static final Logger logger = Logger.getLogger(UploadController.class);
    @Value(value="${registry.url:http://collections.ala.org.au/ws}")
    protected String registryUrl;
    @Value(value="${upload.status:/data/biocache-upload/status}")
    protected String uploadStatusDir;
    @Value(value="${upload.temp:/data/biocache-upload/temp}")
    protected String uploadTempDir;
    @Value(value="${upload.threads:4}")
    protected Integer uploadThreads;
    private Pattern dataResourceUidP = Pattern.compile("data_resource_uid:([\\\"]{0,1}[a-z]{2,3}[0-9]{1,}[\\\"]{0,1})");
    protected static List<String> alreadyIndexedFields = Arrays.asList("eventDate", "scientificName", "commonName", "isoCountryCode", "country", "kingdom", "phylum", "class", "order", "family", "genus", "species", "stateProvince", "imcra", "ibra", "places", "decimalLatitude", "decimalLongitude", "year", "month", "basisOfRecord", "typeStatus", "collector", "establishmentMeans", "coordinateUncertaintyInMeters", "decimalLatitude", "decimalLongitude");

    @RequestMapping(value={"/upload/status/{tempDataResourceUid}.json"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> uploadStatus(@PathVariable String tempDataResourceUid, HttpServletResponse response) throws Exception {
        response.setContentType("application/json");
        File file = new File(this.uploadStatusDir + File.separator + tempDataResourceUid);
        for (int retries = 5; file.exists() && retries > 0; --retries) {
            try {
                String value = FileUtils.readFileToString((File)file);
                ObjectMapper om = new ObjectMapper();
                return (Map)om.readValue(value, Map.class);
            }
            catch (Exception e) {
                Thread.sleep(50L);
                continue;
            }
        }
        response.sendError(404);
        return null;
    }

    @RequestMapping(value={"/upload/customIndexes/{tempDataResourceUid}.json"}, method={RequestMethod.GET})
    @ResponseBody
    public String[] customIndexes(@PathVariable String tempDataResourceUid, HttpServletResponse response) throws Exception {
        response.setContentType("application/json");
        return Store.retrieveCustomIndexFields((String)tempDataResourceUid);
    }

    private List<String> getDrs(String queryExpression) {
        ArrayList<String> drs = new ArrayList<String>();
        if (queryExpression != null) {
            Matcher m = this.dataResourceUidP.matcher(queryExpression);
            while (m.find()) {
                for (int x = 0; x < m.groupCount(); ++x) {
                    drs.add(m.group(x).replaceAll("data_resource_uid:", "").replaceAll("\\\"", ""));
                }
            }
        }
        return drs;
    }

    @RequestMapping(value={"/upload/dynamicFacets"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Facet> dynamicFacets(SpatialSearchRequestParams requestParams, HttpServletResponse response) throws Exception {
        ArrayList drs = new ArrayList();
        drs.addAll(this.getDrs(requestParams.getQ()));
        drs.addAll(this.getDrs(requestParams.getQc()));
        for (String fq : requestParams.getFq()) {
            drs.addAll(this.getDrs(fq));
        }
        response.setContentType("application/json");
        ArrayList<Facet> fs = new ArrayList<Facet>();
        for (String dr : drs) {
            String[] facetsRaw;
            String[] arr$ = facetsRaw = Store.retrieveCustomIndexFields((String)dr);
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String f;
                String displayName = f = arr$[i$];
                boolean isRange = false;
                if (displayName.endsWith("_s")) {
                    displayName = displayName.substring(0, displayName.length() - 2);
                } else if (displayName.endsWith("_i") || displayName.endsWith("_d")) {
                    displayName = displayName.substring(0, displayName.length() - 2);
                    isRange = true;
                }
                displayName = displayName.replaceAll("_", " ");
                fs.add(new Facet(f, StringUtils.capitalize((String)displayName)));
                if (!isRange) continue;
                fs.add(new Facet(f + "_RNG", StringUtils.capitalize((String)displayName) + "(Range)"));
            }
        }
        return fs;
    }

    public List<String> filterCustomIndexFields(List<String> suppliedHeaders) {
        ArrayList<String> customIndexFields = new ArrayList<String>();
        for (String hdr : suppliedHeaders) {
            if (alreadyIndexedFields.contains(hdr)) continue;
            customIndexFields.add(hdr);
        }
        return customIndexFields;
    }

    public List<String> filterByMaxColumnLengths(String[] headers, CSVReader csvReader, int maxColumnLength) throws Exception {
        int[] columnLengths = new int[headers.length];
        for (int i = 0; i < columnLengths.length; ++i) {
            columnLengths[i] = 0;
        }
        String[] fields = csvReader.readNext();
        while (fields != null) {
            for (int j = 0; j < columnLengths.length; ++j) {
                if (fields.length <= j || columnLengths[j] >= fields[j].length()) continue;
                columnLengths[j] = fields[j].length();
            }
            fields = csvReader.readNext();
        }
        ArrayList<String> filterList = new ArrayList<String>();
        for (int k = 0; k < columnLengths.length; ++k) {
            logger.debug((Object)("Column length: " + headers[k] + " = " + columnLengths[k]));
            if (columnLengths[k] > maxColumnLength) continue;
            filterList.add(headers[k]);
        }
        return filterList;
    }

    private void mkWorkingDirs() throws Exception {
        File uploadTempDirF;
        File uploadStatusDirF = new File(this.uploadStatusDir);
        if (!uploadStatusDirF.exists()) {
            FileUtils.forceMkdir((File)uploadStatusDirF);
        }
        if (!(uploadTempDirF = new File(this.uploadTempDir)).exists()) {
            FileUtils.forceMkdir((File)uploadTempDirF);
        }
    }

    public String[] getHeaders(HttpServletRequest request) {
        String headers = request.getParameter("headers");
        String[] headerUnmatched = this.cleanUpHeaders(headers.split(","));
        return AdHocParser.mapOrReturnColumnHeadersArray((String[])headerUnmatched);
    }

    String[] cleanUpHeaders(String[] headers) {
        int i = 0;
        for (String hdr : headers) {
            headers[i] = hdr.replaceAll("[^a-zA-Z0-9]+", "_");
            ++i;
        }
        return headers;
    }

    @RequestMapping(value={"/upload/post"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, String> uploadOccurrenceData(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String urlToZippedData = request.getParameter("csvZippedUrl");
        String csvDataAsString = request.getParameter("csvData");
        String datasetName = request.getParameter("datasetName");
        String alaId = request.getParameter("alaId");
        if (StringUtils.isEmpty((String)urlToZippedData) && StringUtils.isEmpty((String)csvDataAsString)) {
            response.sendError(400, "Must supply 'csvZippedUrl' or 'csvData'");
            return null;
        }
        if (StringUtils.isEmpty((String)datasetName)) {
            response.sendError(400, "Must supply 'datasetName'");
            return null;
        }
        try {
            List filteredHeaders;
            CSVReader readerForCol;
            this.mkWorkingDirs();
            String[] headers = this.getHeaders(request);
            boolean firstLineIsData = ServletRequestUtils.getBooleanParameter((ServletRequest)request, (String)"firstLineIsData");
            String[] customIndexFields = null;
            int lineCount = -1;
            CSVReader csvData = null;
            if (urlToZippedData != null) {
                File csvFile = this.downloadCSV(urlToZippedData);
                lineCount = this.doLineCount(csvFile);
                logger.debug((Object)("Line count: " + lineCount));
                readerForCol = new CSVReader((Reader)new FileReader(csvFile), ',', '\"');
                filteredHeaders = this.filterByMaxColumnLengths(headers, readerForCol, 50);
                filteredHeaders = this.filterCustomIndexFields(filteredHeaders);
                customIndexFields = filteredHeaders.toArray(new String[0]);
                readerForCol.close();
                csvData = new CSVReader((Reader)new FileReader(csvFile), ',', '\"');
            } else {
                char separatorChar = this.getSeparatorChar(request);
                lineCount = this.doLineCount(csvDataAsString);
                readerForCol = new CSVReader((Reader)new StringReader(csvDataAsString), separatorChar, '\"');
                filteredHeaders = this.filterByMaxColumnLengths(headers, readerForCol, 50);
                filteredHeaders = this.filterCustomIndexFields(filteredHeaders);
                customIndexFields = filteredHeaders.toArray(new String[0]);
                readerForCol.close();
                csvData = new CSVReader((Reader)new StringReader(csvDataAsString), separatorChar, '\"');
            }
            String tempUid = this.createTempResource(datasetName, lineCount, alaId);
            UploaderThread ut = new UploaderThread();
            ut.headers = headers;
            ut.datasetName = datasetName;
            ut.firstLineIsData = firstLineIsData;
            ut.csvData = csvData;
            ut.lineCount = lineCount;
            ut.uploadStatusDir = this.uploadStatusDir;
            ut.recordsToLoad = lineCount;
            ut.tempUid = tempUid;
            ut.customIndexFields = customIndexFields;
            ut.threads = this.uploadThreads;
            ut.alaId = alaId;
            new Thread((Runnable)ut).start();
            logger.debug((Object)("Temporary UID being returned...." + tempUid));
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("uid", tempUid);
            return details;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private int doLineCount(String csvDataAsString) throws IOException {
        int lineCount = 0;
        BufferedReader reader = new BufferedReader(new StringReader(csvDataAsString));
        while (reader.readLine() != null) {
            ++lineCount;
        }
        reader.close();
        return lineCount;
    }

    private char getSeparatorChar(HttpServletRequest request) {
        int separatorChar = 44;
        String separator = request.getParameter("separator");
        if (separator != null && "TAB".equalsIgnoreCase(separator)) {
            separatorChar = 9;
        }
        return (char)separatorChar;
    }

    private int doLineCount(File csvFile) throws IOException {
        int lineCount = 0;
        BufferedReader reader = new BufferedReader(new FileReader(csvFile));
        while (reader.readLine() != null) {
            ++lineCount;
        }
        reader.close();
        return lineCount;
    }

    private File downloadCSV(String urlToZippedData) throws IOException {
        int len;
        long fileId = System.currentTimeMillis();
        String zipFilePath = this.uploadTempDir + File.separator + fileId + ".zip";
        String unzippedFilePath = this.uploadTempDir + File.separator + fileId + ".csv";
        InputStream input = new URL(urlToZippedData).openStream();
        FileOutputStream output = new FileOutputStream(zipFilePath);
        IOUtils.copyLarge((InputStream)input, (OutputStream)output);
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry ze = zis.getNextEntry();
        byte[] buffer = new byte[10240];
        FileOutputStream fos = new FileOutputStream(unzippedFilePath);
        while ((len = zis.read(buffer)) > 0) {
            fos.write(buffer, 0, len);
        }
        fos.flush();
        fos.close();
        return new File(unzippedFilePath);
    }

    private String createTempResource(String datasetName, int lineCount, String alaId) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        UserUpload uu = new UserUpload();
        uu.setNumberOfRecords(Integer.valueOf(lineCount));
        uu.setName(datasetName);
        uu.setAlaId(alaId);
        String json = mapper.writeValueAsString((Object)uu);
        PostMethod post = new PostMethod(this.registryUrl + "/tempDataResource");
        post.setRequestBody(json);
        HttpClient httpClient = new HttpClient();
        httpClient.executeMethod((HttpMethod)post);
        logger.debug((Object)("######### Retrieved: " + post.getResponseHeader("location").getValue()));
        logger.debug((Object)"######### Data uploaded....");
        String collectoryUrl = post.getResponseHeader("location").getValue();
        return collectoryUrl.substring(collectoryUrl.lastIndexOf(47) + 1);
    }

    public void setRegistryUrl(String registryUrl) {
        this.registryUrl = registryUrl;
    }

    public void setUploadStatusDir(String uploadStatusDir) {
        this.uploadStatusDir = uploadStatusDir;
    }

    public void setUploadTempDir(String uploadTempDir) {
        this.uploadTempDir = uploadTempDir;
    }
}

