/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.Store;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.model.DuplicateRecordDetails;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.response.FieldStatsInfo;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DuplicationController {
    private static final Logger logger = Logger.getLogger(DuplicationController.class);
    @Inject
    protected SearchDAO searchDAO;

    @RequestMapping(value={"/duplicates/{guid:.+}.json*", "/duplicates/{guid:.+}*"})
    @ResponseBody
    public DuplicateRecordDetails getDuplicateStats(@PathVariable(value="guid") String guid) throws Exception {
        try {
            return Store.getDuplicateDetails((String)guid);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to get duplicate details for " + guid), (Throwable)e);
            return new DuplicateRecordDetails();
        }
    }

    @RequestMapping(value={"/stats/{guid:.+}.json*", "/stats/{guid:.+}*"})
    @ResponseBody
    public Map<String, FieldStatsInfo> printStats(@PathVariable(value="guid") String guid) throws Exception {
        SpatialSearchRequestParams searchParams = new SpatialSearchRequestParams();
        searchParams.setQ("*:*");
        searchParams.setFacets(new String[]{guid});
        return this.searchDAO.getStatistics(searchParams);
    }
}

