/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.dao.PersistentQueueDAO;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.DownloadRequestParams;
import au.org.ala.biocache.web.AbstractSecureController;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DownloadController
extends AbstractSecureController {
    @Inject
    protected SearchDAO searchDAO;
    @Inject
    protected PersistentQueueDAO persistentQueueDAO;

    @RequestMapping(value={"/offline/download/stats"})
    @ResponseBody
    public List<DownloadDetailsDTO> getCurrentDownloads() {
        return this.persistentQueueDAO.getAllDownloads();
    }

    @RequestMapping(value={"occurrences/offline/{type}/download*"}, method={RequestMethod.GET})
    public String occurrenceDownload(DownloadRequestParams requestParams, @RequestParam(value="ip", required=false) String ip, @RequestParam(value="apiKey", required=false) String apiKey, @PathVariable(value="type") String type, HttpServletResponse response, HttpServletRequest request) throws Exception {
        boolean sensitive = false;
        if (apiKey != null) {
            if (this.shouldPerformOperation(apiKey, response, false)) {
                sensitive = true;
            }
        } else if (StringUtils.isEmpty((String)requestParams.getEmail())) {
            response.sendError(412, "Unable to perform an offline download without an email address");
        }
        ip = ip == null ? request.getRemoteAddr() : ip;
        DownloadDetailsDTO.DownloadType downloadType = "index".equals(type.toLowerCase()) ? DownloadDetailsDTO.DownloadType.RECORDS_INDEX : DownloadDetailsDTO.DownloadType.RECORDS_DB;
        DownloadDetailsDTO dd = new DownloadDetailsDTO(requestParams, ip, downloadType);
        dd.setIncludeSensitive(sensitive);
        this.persistentQueueDAO.addDownloadToQueue(dd);
        return null;
    }
}

