/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.Store;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.model.QualityAssertion;
import au.org.ala.biocache.model.Version;
import au.org.ala.biocache.model.Versions;
import au.org.ala.biocache.service.AuthService;
import au.org.ala.biocache.util.AssertionUtils;
import au.org.ala.biocache.vocab.ErrorCode;
import au.org.ala.biocache.web.AbstractSecureController;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AssertionController
extends AbstractSecureController {
    private static final Logger logger = Logger.getLogger(AssertionController.class);
    @Inject
    protected AssertionUtils assertionUtils;
    @Value(value="${registry.url:http://collections.ala.org.au}")
    protected String registryUrl = "http://collections.ala.org.au";
    @Inject
    protected AuthService authService;

    @RequestMapping(value={"/assertions/codes", "/assertions/codes/"}, method={RequestMethod.GET})
    @ResponseBody
    public ErrorCode[] showCodes() throws Exception {
        return Store.retrieveAssertionCodes();
    }

    @RequestMapping(value={"/assertions/geospatial/codes", "/assertions/geospatial/codes/"}, method={RequestMethod.GET})
    @ResponseBody
    public ErrorCode[] showGeospatialCodes() throws Exception {
        return Store.retrieveGeospatialCodes();
    }

    @RequestMapping(value={"/assertions/taxonomic/codes", "/assertions/taxonomic/codes/"}, method={RequestMethod.GET})
    @ResponseBody
    public ErrorCode[] showTaxonomicCodes() throws Exception {
        return Store.retrieveTaxonomicCodes();
    }

    @RequestMapping(value={"/assertions/temporal/codes", "/assertions/temporal/codes/"}, method={RequestMethod.GET})
    @ResponseBody
    public ErrorCode[] showTemporalCodes() throws Exception {
        return Store.retrieveTemporalCodes();
    }

    @RequestMapping(value={"/assertions/miscellaneous/codes", "/assertions/miscellaneous/codes/"}, method={RequestMethod.GET})
    @ResponseBody
    public ErrorCode[] showMiscellaneousCodes() throws Exception {
        return Store.retrieveMiscellaneousCodes();
    }

    @RequestMapping(value={"/assertions/user/codes", "/assertions/user/codes/"}, method={RequestMethod.GET})
    @ResponseBody
    public ErrorCode[] showUserCodes() throws Exception {
        return Store.retrieveUserAssertionCodes();
    }

    @RequestMapping(value={"/occurrences/assertions/add"}, method={RequestMethod.POST})
    public void addAssertionWithParams(@RequestParam(value="recordUuid", required=true) String recordUuid, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.addAssertion(recordUuid, request, response);
    }

    @RequestMapping(value={"/bulk/assertions/add"}, method={RequestMethod.POST})
    public void addBulkAssertions(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ObjectMapper om = new ObjectMapper();
        try {
            String json = request.getParameter("assertions");
            String userId = request.getParameter("userId");
            String userDisplayName = request.getParameter("userDisplayName");
            String apiKey = request.getParameter("apiKey");
            if (this.shouldPerformOperation(apiKey, response)) {
                List assertions = (List)om.readValue(json, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                logger.debug((Object)("The assertions in a list of maps: " + assertions));
                HashMap<String, QualityAssertion> qas = new HashMap<String, QualityAssertion>(assertions.size());
                for (Map assertion : assertions) {
                    String code = (String)assertion.get("code");
                    String comment = (String)assertion.get("comment");
                    String recordUuid = (String)assertion.get("recordUuid");
                    QualityAssertion qa = QualityAssertion.apply((int)Integer.parseInt(code));
                    qa.setComment(comment);
                    qa.setUserId(userId);
                    qa.setUserDisplayName(userDisplayName);
                    qas.put(recordUuid, qa);
                }
                if (qas.size() > 0) {
                    Store.addUserAssertions(qas);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            response.sendError(400);
        }
    }

    @RequestMapping(value={"/occurrences/{recordUuid}/assertions/add"}, method={RequestMethod.POST})
    public void addAssertion(@PathVariable(value="recordUuid") String recordUuid, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String code = request.getParameter("code");
        String comment = request.getParameter("comment");
        String userId = request.getParameter("userId");
        String userDisplayName = request.getParameter("userDisplayName");
        String apiKey = request.getParameter("apiKey");
        if (this.shouldPerformOperation(apiKey, response)) {
            try {
                logger.debug((Object)("Adding assertion to:" + recordUuid + ", code:" + code + ", comment:" + comment + ", userId:" + userId + ", userDisplayName:" + userDisplayName));
                QualityAssertion qa = QualityAssertion.apply((int)Integer.parseInt(code));
                qa.setComment(comment);
                qa.setUserId(userId);
                qa.setUserDisplayName(userDisplayName);
                Store.addUserAssertion((String)recordUuid, (QualityAssertion)qa);
                String server = request.getSession().getServletContext().getInitParameter("serverName");
                response.setHeader("Location", server + "/occurrences/" + recordUuid + "/assertions/" + qa.getUuid());
                response.setStatus(201);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                response.setStatus(400);
            }
        }
    }

    @RequestMapping(value={"/occurrences/assertions/delete"}, method={RequestMethod.POST})
    public void deleteAssertionWithParams(@RequestParam(value="recordUuid", required=true) String recordUuid, @RequestParam(value="assertionUuid", required=true) String assertionUuid, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.deleteAssertion(recordUuid, assertionUuid, request, response);
    }

    @RequestMapping(value={"/occurrences/{recordUuid}/assertions/delete"}, method={RequestMethod.POST})
    public void deleteAssertion(@PathVariable(value="recordUuid") String recordUuid, @RequestParam(value="assertionUuid", required=true) String assertionUuid, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String apiKey = request.getParameter("apiKey");
        if (this.shouldPerformOperation(apiKey, response)) {
            try {
                Store.deleteUserAssertion((String)recordUuid, (String)assertionUuid);
                response.setStatus(200);
            }
            catch (Exception e) {
                response.sendError(400, e.getMessage());
            }
        }
    }

    @Deprecated
    private void postNotificationEvent(String type, String recordUuid, String id) {
        String uid;
        FullRecord processed = Store.getByUuid((String)recordUuid, (Version)Versions.PROCESSED());
        if (processed == null) {
            processed = Store.getByRowKey((String)recordUuid, (Version)Versions.PROCESSED());
        }
        String string = uid = processed == null ? null : processed.getAttribution().getCollectionUid();
        if (uid != null) {
            String uri = this.registryUrl + "/ws/notify";
            HttpClient h = new HttpClient();
            PostMethod m = new PostMethod(uri);
            try {
                m.setRequestEntity((RequestEntity)new StringRequestEntity("{ event: 'user annotation', id: '" + id + "', uid: '" + uid + "', type:'" + type + "' }", "text/json", "UTF-8"));
                logger.debug((Object)("Adding notification: " + type + ":" + uid + " - " + id));
                int status = h.executeMethod((HttpMethod)m);
                logger.debug((Object)("STATUS: " + status));
                if (status == 200) {
                    logger.debug((Object)"Successfully posted an event to the notification service");
                } else {
                    logger.info((Object)"Failed to post an event to the notification service");
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @RequestMapping(value={"/occurrences/assertions", "/occurrences/assertions/"}, method={RequestMethod.GET})
    @ResponseBody
    public Object getAssertionWithParams(@RequestParam(value="recordUuid", required=true) String recordUuid, @RequestParam(value="assertionUuid", required=false) String assertionUuid, HttpServletResponse response) throws Exception {
        if (assertionUuid != null) {
            return this.getAssertion(recordUuid, assertionUuid, response);
        }
        return this.getAssertions(recordUuid);
    }

    @RequestMapping(value={"/occurrences/{recordUuid}/assertions/{assertionUuid}", "/occurrences/{recordUuid}/assertions/{assertionUuid}/"}, method={RequestMethod.GET})
    @ResponseBody
    public QualityAssertion getAssertion(@PathVariable(value="recordUuid") String recordUuid, @PathVariable(value="assertionUuid") String assertionUuid, HttpServletResponse response) throws Exception {
        QualityAssertion qa = this.assertionUtils.getUserAssertion(recordUuid, assertionUuid);
        if (qa != null) {
            return qa;
        }
        response.setStatus(404);
        return null;
    }

    @RequestMapping(value={"/occurrences/{recordUuid}/assertions", "/occurrences/{recordUuid}/assertions/"}, method={RequestMethod.GET})
    @ResponseBody
    public List<QualityAssertion> getAssertions(@PathVariable(value="recordUuid") String recordUuid) throws Exception {
        return this.assertionUtils.getUserAssertions(recordUuid);
    }

    public void setAssertionUtils(AssertionUtils assertionUtils) {
        this.assertionUtils = assertionUtils;
    }
}

