/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.validate;

import au.org.ala.biocache.service.LoggerService;
import au.org.ala.biocache.validate.LogType;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.beans.factory.annotation.Autowired;

public class LogTypeValidator
implements ConstraintValidator<LogType, Integer> {
    @Autowired
    private LoggerService loggerService;
    private String type;

    public void initialize(LogType logType) {
        this.type = logType.type();
    }

    public boolean isValid(Integer value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if ("reason".equals(this.type)) {
            return this.loggerService.getReasonIds().contains(value);
        }
        if ("source".equals(this.type)) {
            return this.loggerService.getSourceIds().contains(value);
        }
        return true;
    }
}

