/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestOperations;

@Component(value="authService")
public class AuthService {
    private static final Logger logger = Logger.getLogger(AuthService.class);
    @Inject
    protected RestOperations restTemplate;
    @Value(value="${auth.user.details.url}")
    protected String userDetailsUrl = null;
    @Value(value="${auth.user.names.id.path:getUserList}")
    protected String userNamesForIdPath = null;
    @Value(value="${auth.usernames.for.numeric.id.path:getUserListWithIds}")
    protected String userNamesForNumericIdPath = null;
    @Value(value="${auth.usernames.full.path:getUserListWithIds}")
    protected String userNamesFullPath = null;
    @Value(value="${auth.startup.initialise:false}")
    protected boolean startupInitialise = false;
    @Value(value="${caches.auth.enabled:true}")
    protected Boolean enabled = true;
    protected Map<String, String> userNamesById = new HashMap();
    protected Map<String, String> userNamesByNumericIds = new HashMap();
    protected Map<String, String> userEmailToId = new HashMap();

    public AuthService() {
        logger.info((Object)("Instantiating AuthService: " + this));
        if (this.startupInitialise) {
            logger.info((Object)"Loading auth caches now");
            this.reloadCaches();
        }
    }

    public Map<String, String> getMapOfAllUserNamesById() {
        return this.userNamesById;
    }

    public Map<String, String> getMapOfAllUserNamesByNumericId() {
        return this.userNamesByNumericIds;
    }

    public Map<String, String> getMapOfEmailToId() {
        return this.userEmailToId;
    }

    public String getDisplayNameFor(String value) {
        String displayName = value;
        if (value != null) {
            displayName = this.userNamesById.containsKey(value) ? (String)this.userNamesById.get(value) : (this.userNamesByNumericIds.containsKey(value) ? (String)this.userNamesByNumericIds.get(value) : displayName.replaceAll("\\@\\w+", "@.."));
        }
        return displayName;
    }

    public String substituteEmailAddress(String raw) {
        return raw == null ? raw : raw.replaceAll("\\@\\w+", "@..");
    }

    private void loadMapOfAllUserNamesById() {
        try {
            String jsonUri = this.userDetailsUrl + this.userNamesForIdPath;
            logger.info((Object)("authCache requesting: " + jsonUri));
            this.userNamesById = (Map)this.restTemplate.postForObject(jsonUri, null, Map.class, new Object[0]);
        }
        catch (Exception ex) {
            logger.error((Object)("RestTemplate error: " + ex.getMessage()), (Throwable)ex);
        }
    }

    private void loadMapOfAllUserNamesByNumericId() {
        try {
            String jsonUri = this.userDetailsUrl + this.userNamesForNumericIdPath;
            logger.info((Object)("authCache requesting: " + jsonUri));
            this.userNamesByNumericIds = (Map)this.restTemplate.postForObject(jsonUri, null, Map.class, new Object[0]);
        }
        catch (Exception ex) {
            logger.error((Object)("RestTemplate error: " + ex.getMessage()), (Throwable)ex);
        }
    }

    private void loadMapOfEmailToUserId() {
        try {
            String jsonUri = this.userDetailsUrl + this.userNamesFullPath;
            logger.info((Object)("authCache requesting: " + jsonUri));
            List users = (List)this.restTemplate.postForObject(jsonUri, null, List.class, new Object[0]);
            for (Map user : users) {
                this.userEmailToId.put(user.get("email").toString(), user.get("id").toString());
            }
            logger.info((Object)("authCache userEmail cache: " + this.userEmailToId.size()));
            if (this.userEmailToId.size() > 0) {
                String email = (String)this.userEmailToId.keySet().iterator().next();
                String id = (String)this.userEmailToId.get(email);
                logger.info((Object)("authCache userEmail example: " + email + " -> " + id));
            }
        }
        catch (Exception ex) {
            logger.error((Object)("RestTemplate error: " + ex.getMessage()), (Throwable)ex);
        }
    }

    @Scheduled(fixedDelay=600000L)
    public void reloadCaches() {
        if (this.enabled.booleanValue()) {
            logger.info((Object)"Triggering reload of auth user names");
            this.loadMapOfAllUserNamesById();
            this.loadMapOfAllUserNamesByNumericId();
            this.loadMapOfEmailToUserId();
            logger.info((Object)"Finished reload of auth user names");
        } else {
            logger.info((Object)"Authentication Cache has been disabled");
        }
    }
}

