/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dto;

import au.org.ala.biocache.dto.FacetThemes;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class FacetThemes {
    public static String[] allFacets = new String[0];
    public static List<FacetTheme> allThemes = new ArrayList();
    public static LinkedHashMap<String, Facet> facetsMap = new LinkedHashMap();

    public FacetThemes(String configFilePath) throws IOException {
        if (configFilePath != null && new File(configFilePath).exists()) {
            allThemes.clear();
            ObjectMapper om = new ObjectMapper();
            List config = (List)om.readValue(new File(configFilePath), List.class);
            for (Map facetGroup : config) {
                String title = (String)facetGroup.get("title");
                List facetsConfig = (List)facetGroup.get("facets");
                ArrayList<Facet> facets = new ArrayList<Facet>();
                for (Map facetsMap : facetsConfig) {
                    facets.add(new Facet((String)facetsMap.get("field"), (String)facetsMap.get("sort")));
                }
                allThemes.add(new FacetTheme(title, facets));
            }
            this.initAllFacets();
        } else {
            this.defaultInit();
        }
    }

    private void initAllFacets() {
        facetsMap.clear();
        for (FacetTheme theme : allThemes) {
            for (Facet f : FacetTheme.access$000((FacetTheme)theme)) {
                facetsMap.put(Facet.access$100((Facet)f), f);
            }
            allFacets = facetsMap.keySet().toArray(new String[0]);
        }
    }

    public FacetThemes() {
        this.defaultInit();
    }

    private void defaultInit() {
        allThemes.clear();
        allThemes.add(new FacetTheme("Taxonomic", new Facet[]{new Facet("taxon_name", "index"), new Facet("raw_taxon_name", "index"), new Facet("common_name", "index"), new Facet("subspecies_name", "index"), new Facet("species", "index"), new Facet("genus", "index"), new Facet("family", "index"), new Facet("order", "index"), new Facet("class", "index"), new Facet("phylum", "index"), new Facet("kingdom", "index"), new Facet("species_group", "index"), new Facet("rank", "count"), new Facet("interaction", "count"), new Facet("species_habitats", "count")}));
        allThemes.add(new FacetTheme("Geospatial", new Facet[]{new Facet("uncertainty", "index"), new Facet("sensitive", "count"), new Facet("state_conservation", "count"), new Facet("raw_state_conservation", "count"), new Facet("cl966", "count"), new Facet("cl959", "count"), new Facet("state", "count"), new Facet("country", "index"), new Facet("biogeographic_region", "count"), new Facet("ibra", "count"), new Facet("imcra", "count"), new Facet("cl1918", "count"), new Facet("cl617", "count"), new Facet("cl620", "count"), new Facet("geospatial_kosher", "count")}));
        allThemes.add(new FacetTheme("Temporal", new Facet[]{new Facet("month", "index"), new Facet("year", "index"), new Facet("decade", "index")}));
        allThemes.add(new FacetTheme("Record details", new Facet[]{new Facet("basis_of_record", "index"), new Facet("type_status", "index"), new Facet("multimedia", "count"), new Facet("collector", "index"), new Facet("occurrence_status_s", "index")}));
        allThemes.add(new FacetTheme("Attribution", new Facet[]{new Facet("alau_user_id", "count"), new Facet("data_provider_uid", "count"), new Facet("data_resource_uid", "count"), new Facet("institution_uid", "count"), new Facet("collection_uid", "count"), new Facet("provenance", "count")}));
        allThemes.add(new FacetTheme("Record assertions", new Facet[]{new Facet("assertions", "count"), new Facet("assertion_user_id", "index"), new Facet("outlier_layer", "count"), new Facet("outlier_layer_count", "count"), new Facet("taxonomic_issue", "count"), new Facet("duplicate_status", "count")}));
        this.initAllFacets();
    }
}

