/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dao;

import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.biocache.Config;
import au.org.ala.biocache.RecordWriter;
import au.org.ala.biocache.Store;
import au.org.ala.biocache.dao.QidCacheDAO;
import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dao.SearchDAOImpl;
import au.org.ala.biocache.dto.BreakdownRequestParams;
import au.org.ala.biocache.dto.DataProviderCountDTO;
import au.org.ala.biocache.dto.DownloadDetailsDTO;
import au.org.ala.biocache.dto.DownloadRequestParams;
import au.org.ala.biocache.dto.FacetResultDTO;
import au.org.ala.biocache.dto.FacetThemes;
import au.org.ala.biocache.dto.FieldResultDTO;
import au.org.ala.biocache.dto.IndexFieldDTO;
import au.org.ala.biocache.dto.OccurrenceIndex;
import au.org.ala.biocache.dto.OccurrencePoint;
import au.org.ala.biocache.dto.PointType;
import au.org.ala.biocache.dto.SearchRequestParams;
import au.org.ala.biocache.dto.SearchResultDTO;
import au.org.ala.biocache.dto.SensitiveOccurrenceIndex;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import au.org.ala.biocache.dto.StatsIndexFieldDTO;
import au.org.ala.biocache.dto.TaxaCountDTO;
import au.org.ala.biocache.dto.TaxaRankCountDTO;
import au.org.ala.biocache.index.IndexDAO;
import au.org.ala.biocache.index.SolrIndexDAO;
import au.org.ala.biocache.model.Qid;
import au.org.ala.biocache.service.AuthService;
import au.org.ala.biocache.service.LayersService;
import au.org.ala.biocache.service.SpeciesLookupService;
import au.org.ala.biocache.util.CollectionsCache;
import au.org.ala.biocache.util.DownloadFields;
import au.org.ala.biocache.util.LegendItem;
import au.org.ala.biocache.util.QidMissingException;
import au.org.ala.biocache.util.RangeBasedFacets;
import au.org.ala.biocache.util.SearchUtils;
import au.org.ala.biocache.util.SpatialUtils;
import au.org.ala.biocache.util.thread.EndemicCallable;
import au.org.ala.biocache.writer.CSVRecordWriter;
import au.org.ala.biocache.writer.ShapeFileRecordWriter;
import com.googlecode.ehcache.annotations.Cacheable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.FieldStatsInfo;
import org.apache.solr.client.solrj.response.Group;
import org.apache.solr.client.solrj.response.GroupCommand;
import org.apache.solr.client.solrj.response.GroupResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.RangeFacet;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="searchDao")
public class SearchDAOImpl
implements SearchDAO {
    private static final Logger logger = Logger.getLogger(SearchDAOImpl.class);
    protected SolrServer server;
    protected SolrRequest.METHOD queryMethod;
    protected Integer MAX_DOWNLOAD_SIZE = 500000;
    private Integer throttle = 100;
    protected Integer downloadBatchSize = 500;
    public static final String NAMES_AND_LSID = "names_and_lsid";
    public static final String COMMON_NAME_AND_LSID = "common_name_and_lsid";
    protected static final String DECADE_FACET_NAME = "decade";
    protected static final Integer FACET_PAGE_SIZE = 1000;
    protected static final String QUOTE = "\"";
    protected static final char[] CHARS = new char[]{' ', ':'};
    protected static final String RANGE_SUFFIX = "_RNG";
    private String spatialField = "geohash";
    protected Pattern lsidPattern = Pattern.compile("(^|\\s|\"|\\(|\\[|')lsid:\"?([a-zA-Z0-9\\.:\\-_]*)\"?");
    protected Pattern urnPattern = Pattern.compile("urn:[a-zA-Z0-9\\.:-]*");
    protected Pattern spacesPattern = Pattern.compile("[^\\s\"\\(\\)\\[\\]{}']+|\"[^\"]*\"|'[^']*'");
    protected Pattern uidPattern = Pattern.compile("(?:[\"]*)?([a-z_]*_uid:)([a-z0-9]*)(?:[\"]*)?");
    protected Pattern spatialPattern = Pattern.compile(this.spatialField + ":\"Intersects\\([a-zA-Z=\\-\\s0-9\\.\\,():]*\\)\\\"");
    protected Pattern qidPattern = QidCacheDAO.qidPattern;
    protected Pattern termPattern = Pattern.compile("([a-zA-z_]+?):((\".*?\")|(\\\\ |[^: \\)\\(])+)");
    protected Pattern indexFieldPatternMatcher = Pattern.compile("[a-z_0-9]{1,}:");
    protected Pattern layersPattern = Pattern.compile("(el|cl)[0-9abc]+");
    protected DownloadFields downloadFields;
    @Inject
    protected SearchUtils searchUtils;
    @Inject
    private CollectionsCache collectionCache;
    @Inject
    private AbstractMessageSource messageSource;
    @Inject
    private SpeciesLookupService speciesLookupService;
    @Inject
    protected AuthService authService;
    @Inject
    protected LayersService layersService;
    @Inject
    protected QidCacheDAO qidCacheDao;
    @Value(value="${media.store.local:true}")
    protected Boolean usingLocalMediaRepo = true;
    @Value(value="${max.query.thread:5}")
    protected Integer maxMultiPartThreads = 5;
    private ExecutorService executor = null;
    @Value(value="${check.download.limits:false}")
    private boolean checkDownloadLimits = false;
    @Value(value="${term.query.limit:1000}")
    protected Integer termQueryLimit = 1000;
    @Value(value="${auth.substitution.fields:}")
    protected String authServiceFields = "";
    @Value(value="${media.url:http://biocache.ala.org.au/biocache-media/}")
    public static String biocacheMediaUrl = "http://biocache.ala.org.au/biocache-media/";
    @Value(value="${media.dir:/data/biocache-media/}")
    public static String biocacheMediaDir = "/data/biocache-media/";
    private Set<IndexFieldDTO> indexFields = null;
    private Map<String, IndexFieldDTO> indexFieldMap = null;
    private Map<String, StatsIndexFieldDTO> rangeFieldCache = null;
    private Set<String> authIndexFields = null;

    private SolrServer getServer() {
        if (this.server == null) {
            this.initServer();
        }
        return this.server;
    }

    private void initServer() {
        if (this.server == null) {
            try {
                SolrIndexDAO dao = (SolrIndexDAO)Config.getInstance(IndexDAO.class);
                dao.init();
                this.server = dao.solrServer();
                this.queryMethod = this.server instanceof EmbeddedSolrServer ? SolrRequest.METHOD.GET : SolrRequest.METHOD.POST;
                logger.debug((Object)("The server " + this.server.getClass()));
                this.downloadFields = new DownloadFields(this.getIndexedFields());
            }
            catch (Exception ex) {
                logger.error((Object)("Error initialising embedded SOLR server: " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public Set<String> getAuthIndexFields() {
        if (this.authIndexFields == null) {
            logger.debug((Object)("Auth substitution fields to use: " + this.authServiceFields));
            this.authIndexFields = new HashSet();
            CollectionUtils.mergeArrayIntoCollection((Object)this.authServiceFields.split(","), (Collection)this.authIndexFields);
        }
        return this.authIndexFields;
    }

    public void refreshCaches() {
        this.collectionCache.updateCache();
        this.indexFields = null;
        this.rangeFieldCache = null;
        try {
            this.indexFields = this.getIndexedFields();
            this.downloadFields = new DownloadFields(this.getIndexedFields());
        }
        catch (Exception e) {
            logger.error((Object)"Unable to refresh cache.", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Cacheable(cacheName="endemicCache")
    public List<FieldResultDTO> getEndemicSpecies(SpatialSearchRequestParams requestParams) throws Exception {
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(this.maxMultiPartThreads);
        }
        logger.debug((Object)"Starting to get Endemic Species...");
        List list1 = this.getValuesForFacet(requestParams);
        logger.debug((Object)("Retrieved species within area...(" + list1.size() + ")"));
        String reverseQuery = SpatialUtils.getWKTQuery((String)this.spatialField, (String)requestParams.getWkt(), (boolean)true);
        logger.debug((Object)("The reverse query:" + reverseQuery));
        requestParams.setWkt(null);
        int i = 0;
        int localterms = 0;
        String facet = requestParams.getFacets()[0];
        Object[] originalFqs = requestParams.getFq();
        originalFqs = (String[])ArrayUtils.add((Object[])originalFqs, (Object)reverseQuery);
        ArrayList threads = new ArrayList();
        while (i < list1.size()) {
            void var10_10;
            StringBuffer sb = new StringBuffer();
            while ((localterms == 0 || localterms % this.termQueryLimit != 0) && i < list1.size()) {
                if (localterms != 0) {
                    sb.append(" OR ");
                }
                sb.append(facet).append(":").append(ClientUtils.escapeQueryChars((String)((FieldResultDTO)list1.get(i)).getFieldValue()));
                ++i;
                ++localterms;
            }
            String string = sb.toString();
            if (localterms == 1) {
                String string2 = string + " OR " + string;
            }
            localterms = 0;
            SpatialSearchRequestParams srp = new SpatialSearchRequestParams();
            BeanUtils.copyProperties((Object)requestParams, (Object)srp);
            srp.setFq((String[])ArrayUtils.add((Object[])originalFqs, (Object)var10_10));
            int batch = i / this.termQueryLimit;
            EndemicCallable callable = new EndemicCallable(srp, batch, (SearchDAO)this);
            threads.add(this.executor.submit(callable));
        }
        for (Future future : threads) {
            List list = (List)future.get();
            if (list == null) continue;
            list1.removeAll(list);
        }
        logger.debug((Object)("Determined final endemic list (" + list1.size() + ")..."));
        return list1;
    }

    /*
     * WARNING - void declaration
     */
    public List<FieldResultDTO> getSubquerySpeciesOnly(SpatialSearchRequestParams subQuery, SpatialSearchRequestParams parentQuery) throws Exception {
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(this.maxMultiPartThreads);
        }
        logger.debug((Object)"Starting to get Endemic Species...");
        subQuery.setFacet(Boolean.valueOf(true));
        subQuery.setFacets(parentQuery.getFacets());
        List list1 = this.getValuesForFacet(subQuery);
        logger.debug((Object)("Retrieved species within area...(" + list1.size() + ")"));
        int i = 0;
        int localterms = 0;
        String facet = parentQuery.getFacets()[0];
        Object[] originalFqs = parentQuery.getFq();
        ArrayList threads = new ArrayList();
        while (i < list1.size()) {
            void var10_10;
            StringBuffer sb = new StringBuffer();
            while ((localterms == 0 || localterms % this.termQueryLimit != 0) && i < list1.size()) {
                void var10_17;
                if (localterms != 0) {
                    sb.append(" OR ");
                }
                String string = ((FieldResultDTO)list1.get(i)).getFieldValue();
                if (facet.equals(NAMES_AND_LSID)) {
                    void var10_14;
                    if (string.startsWith(QUOTE) && string.endsWith(QUOTE)) {
                        String string2 = string.substring(1, string.length() - 1);
                    }
                    String string3 = QUOTE + ClientUtils.escapeQueryChars((String)var10_14) + QUOTE;
                } else {
                    String string4 = ClientUtils.escapeQueryChars((String)string);
                }
                sb.append(facet).append(":").append((String)var10_17);
                ++i;
                ++localterms;
            }
            String string = sb.toString();
            if (localterms == 1) {
                String string5 = string + " OR " + string;
            }
            localterms = 0;
            SpatialSearchRequestParams srp = new SpatialSearchRequestParams();
            BeanUtils.copyProperties((Object)parentQuery, (Object)srp);
            srp.setFq((String[])ArrayUtils.add((Object[])originalFqs, (Object)var10_10));
            int batch = i / this.termQueryLimit;
            EndemicCallable callable = new EndemicCallable(srp, batch, (SearchDAO)this);
            threads.add(this.executor.submit(callable));
        }
        Collections.sort(list1);
        for (Future future : threads) {
            List list = (List)future.get();
            if (list == null) continue;
            for (FieldResultDTO find : list) {
                int idx = Collections.binarySearch(list1, find);
                if (idx < 0 || ((FieldResultDTO)list1.get(idx)).getCount() >= find.getCount()) continue;
                list1.remove(idx);
            }
        }
        logger.debug((Object)("Determined final endemic list (" + list1.size() + ")..."));
        return list1;
    }

    public List<FieldResultDTO> getValuesForFacet(SpatialSearchRequestParams requestParams) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.writeFacetToStream(requestParams, true, false, false, (OutputStream)outputStream, null);
        outputStream.flush();
        outputStream.close();
        String includedValues = outputStream.toString();
        includedValues = includedValues == null ? "" : includedValues;
        String[] values = includedValues.split("\n");
        ArrayList<FieldResultDTO> list = new ArrayList<FieldResultDTO>();
        boolean first = true;
        for (String value : values) {
            if (first) {
                first = false;
                continue;
            }
            int idx = value.lastIndexOf(",");
            list.add(new FieldResultDTO(value.substring(0, idx), Long.parseLong(value.substring(idx + 1).replace(QUOTE, ""))));
        }
        return list;
    }

    public SearchResultDTO findByFulltextSpatialQuery(SpatialSearchRequestParams searchParams, Map<String, String[]> extraParams) {
        return this.findByFulltextSpatialQuery(searchParams, false, extraParams);
    }

    public SearchResultDTO findByFulltextSpatialQuery(SpatialSearchRequestParams searchParams, boolean includeSensitive, Map<String, String[]> extraParams) {
        SearchResultDTO searchResults = new SearchResultDTO();
        SpatialSearchRequestParams original = new SpatialSearchRequestParams();
        BeanUtils.copyProperties((Object)searchParams, (Object)original);
        try {
            this.formatSearchQuery(searchParams);
            this.updateQueryContext((SearchRequestParams)searchParams);
            String queryString = this.buildSpatialQueryString(searchParams);
            SolrQuery solrQuery = this.initSolrQuery((SearchRequestParams)searchParams, true, extraParams);
            solrQuery.setQuery(queryString);
            QueryResponse qr = this.runSolrQuery(solrQuery, (SearchRequestParams)searchParams);
            Class resultClass = includeSensitive ? SensitiveOccurrenceIndex.class : OccurrenceIndex.class;
            searchResults = this.processSolrResponse((SearchRequestParams)original, qr, solrQuery, resultClass);
            searchResults.setQueryTitle(searchParams.getDisplayString());
            searchResults.setUrlParameters(original.getUrlParams());
            searchResults.setActiveFacetMap(this.searchUtils.addFacetMap(searchParams.getFq(), this.getAuthIndexFields()));
            logger.info((Object)("spatial search query: " + queryString));
        }
        catch (Exception ex) {
            logger.error((Object)("Error executing query with requestParams: " + searchParams.toString() + " EXCEPTION: " + ex.getMessage()));
            searchResults.setStatus("ERROR");
            searchResults.setErrorMessage(ex.getMessage());
        }
        return searchResults;
    }

    public int writeSpeciesCountByCircleToStream(SpatialSearchRequestParams searchParams, String speciesGroup, ServletOutputStream out) throws Exception {
        logger.debug((Object)"Writing CSV file for species count by circle");
        searchParams.setPageSize(Integer.valueOf(-1));
        List species = this.findAllSpeciesByCircleAreaAndHigherTaxa(searchParams, speciesGroup);
        logger.debug((Object)("There are " + species.size() + "records being downloaded"));
        CSVWriter csvWriter = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)out), '\t', '\"');
        csvWriter.writeNext(new String[]{"Taxon ID", "Kingdom", "Family", "Scientific name", "Common name", "Record count"});
        int count = 0;
        for (TaxaCountDTO item : species) {
            String[] record = new String[]{item.getGuid(), item.getKingdom(), item.getFamily(), item.getName(), item.getCommonName(), item.getCount().toString()};
            csvWriter.writeNext(record);
            csvWriter.flush();
            ++count;
        }
        return count;
    }

    public void writeFacetToStream(SpatialSearchRequestParams searchParams, boolean includeCount, boolean lookupName, boolean includeSynonyms, OutputStream out, DownloadDetailsDTO dd) throws Exception {
        FacetField ff;
        searchParams.setFlimit(Integer.valueOf(-1));
        this.formatSearchQuery(searchParams);
        this.updateQueryContext((SearchRequestParams)searchParams);
        String queryString = this.buildSpatialQueryString(searchParams);
        SolrQuery solrQuery = this.initSolrQuery((SearchRequestParams)searchParams, false, null);
        solrQuery.setQuery(queryString);
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacetLimit(FACET_PAGE_SIZE.intValue());
        int offset = 0;
        boolean shouldLookup = lookupName && (searchParams.getFacets()[0].contains("_guid") || searchParams.getFacets()[0].contains("_lsid"));
        QueryResponse qr = this.runSolrQuery(solrQuery, (SearchRequestParams)searchParams);
        logger.debug((Object)"Retrieved facet results from server...");
        if (!qr.getResults().isEmpty() && (ff = qr.getFacetField(searchParams.getFacets()[0])) != null) {
            Object[] header = new String[]{ff.getName()};
            if (shouldLookup) {
                header = this.speciesLookupService.getHeaderDetails(ff.getName(), includeCount, includeSynonyms);
            } else if (includeCount) {
                header = (String[])ArrayUtils.add((Object[])header, (Object)"count");
            }
            CSVRecordWriter writer = new CSVRecordWriter(out, (String[])header);
            while (ff.getValueCount() > 0) {
                if (ff.getValueCount() > 0) {
                    if (shouldLookup) {
                        ArrayList<String> guids = new ArrayList<String>();
                        ArrayList<Long> counts = new ArrayList<Long>();
                        logger.debug((Object)("Downloading " + ff.getValueCount() + " species guids"));
                        for (FacetField.Count value : ff.getValues()) {
                            guids.add(value.getName());
                            if (includeCount) {
                                counts.add(value.getCount());
                            }
                            if (guids.size() != 30) continue;
                            this.writeTaxonDetailsToStream(guids, counts, includeCount, includeSynonyms, writer);
                            guids.clear();
                            counts.clear();
                        }
                        this.writeTaxonDetailsToStream(guids, counts, includeCount, includeSynonyms, writer);
                    } else {
                        for (FacetField.Count value : ff.getValues()) {
                            String[] stringArray;
                            if (includeCount) {
                                String[] stringArray2 = new String[2];
                                stringArray2[0] = value.getName();
                                stringArray = stringArray2;
                                stringArray2[1] = Long.toString(value.getCount());
                            } else {
                                String[] stringArray3 = new String[1];
                                stringArray = stringArray3;
                                stringArray3[0] = value.getName();
                            }
                            String[] row = stringArray;
                            writer.write(row);
                        }
                    }
                    offset += FACET_PAGE_SIZE.intValue();
                    if (dd != null) {
                        dd.updateCounts(FACET_PAGE_SIZE.intValue());
                    }
                    solrQuery.remove("facet.offset");
                    solrQuery.add("facet.offset", new String[]{Integer.toString(offset)});
                    qr = this.runSolrQuery(solrQuery, (SearchRequestParams)searchParams);
                    ff = qr.getFacetField(searchParams.getFacets()[0]);
                }
                writer.finalise();
            }
        }
    }

    private void writeTaxonDetailsToStream(List<String> guids, List<Long> counts, boolean includeCounts, boolean includeSynonyms, CSVRecordWriter writer) throws Exception {
        List values = this.speciesLookupService.getSpeciesDetails(guids, counts, includeCounts, includeSynonyms);
        for (String[] value : values) {
            writer.write(value);
        }
    }

    public void writeCoordinatesToStream(SearchRequestParams searchParams, OutputStream out) throws Exception {
        FacetField ff;
        SearchRequestParams srp = new SearchRequestParams();
        SearchUtils.setDefaultParams((SearchRequestParams)srp);
        srp.setFacets(searchParams.getFacets());
        SolrQuery solrQuery = this.initSolrQuery(srp, false, null);
        solrQuery.setFacetLimit(-1);
        solrQuery.setFacetSort("count");
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setQuery(searchParams.getQ());
        QueryResponse qr = this.runSolrQuery(solrQuery, srp);
        if (qr.getResults().size() > 0 && (ff = qr.getFacetField(searchParams.getFacets()[0])) != null && ff.getValueCount() > 0) {
            out.write("latitude,longitude\n".getBytes());
            for (FacetField.Count value : ff.getValues()) {
                out.write(value.getName().getBytes());
                out.write("\n".getBytes());
            }
        }
    }

    public Map<String, Integer> writeResultsFromIndexToStream(DownloadRequestParams downloadParams, OutputStream out, boolean includeSensitive, DownloadDetailsDTO dd, boolean checkLimit) throws Exception {
        long start = System.currentTimeMillis();
        HashMap<String, Integer> uidStats = new HashMap<String, Integer>();
        if (this.server == null) {
            this.initServer();
        }
        try {
            CSVRecordWriter rw;
            SolrQuery monthAssertionsQuery;
            SolrQuery solrQuery = new SolrQuery();
            this.formatSearchQuery((SpatialSearchRequestParams)downloadParams);
            String dFields = downloadParams.getFields();
            if (includeSensitive) {
                dFields = dFields.replaceFirst("decimalLatitude.p", "sensitive_latitude,sensitive_longitude,decimalLatitude.p").replaceFirst(",locality,", ",locality,sensitive_locality,");
            }
            StringBuilder sb = new StringBuilder(dFields);
            if (!downloadParams.getExtra().isEmpty()) {
                sb.append(",").append(downloadParams.getExtra());
            }
            String[] requestedFields = sb.toString().split(",");
            List[] indexedFields = this.downloadFields.getIndexFields(requestedFields);
            logger.debug((Object)("Fields included in download: " + indexedFields[0]));
            logger.debug((Object)("Fields excluded from download: " + indexedFields[1]));
            logger.debug((Object)("The headers in downloads: " + indexedFields[2]));
            Object[] fields = indexedFields[0].toArray(new String[0]);
            solrQuery.setFields((String[])fields);
            StringBuilder qasb = new StringBuilder();
            if (!"none".equals(downloadParams.getQa())) {
                solrQuery.addField("assertions");
                if (!"all".equals(downloadParams.getQa())) {
                    qasb.append(downloadParams.getQa());
                }
            }
            solrQuery.addField("institution_uid").addField("collection_uid").addField("data_resource_uid").addField("data_provider_uid");
            this.updateQueryContext((SearchRequestParams)downloadParams);
            solrQuery.setQuery(this.buildSpatialQueryString((SpatialSearchRequestParams)downloadParams));
            solrQuery.setFacetMinCount(1);
            solrQuery.setFacetLimit(-1);
            boolean getAssertionsFromFacets = "all".equals(downloadParams.getQa());
            SolrQuery solrQuery2 = monthAssertionsQuery = getAssertionsFromFacets ? solrQuery.getCopy().addFacetField(new String[]{"month", "assertions"}) : solrQuery.getCopy().addFacetField(new String[]{"month"});
            if (getAssertionsFromFacets) {
                monthAssertionsQuery.add("f.assertions.facet.sort", new String[]{"index"});
            }
            QueryResponse facetQuery = this.runSolrQuery(monthAssertionsQuery, downloadParams.getFq(), Integer.valueOf(0), Integer.valueOf(0), "score", "asc");
            dd.setTotalRecords(facetQuery.getResults().getNumFound());
            if (checkLimit && dd.getTotalRecords() < (long)this.MAX_DOWNLOAD_SIZE.intValue()) {
                checkLimit = false;
            }
            List splitByFacet = null;
            for (FacetField facet : facetQuery.getFacetFields()) {
                if (facet.getName().equals("assertions") && facet.getValueCount() > 0) {
                    for (FacetField.Count facetEntry : facet.getValues()) {
                        if (qasb.length() > 0) {
                            qasb.append(",");
                        }
                        qasb.append(facetEntry.getName());
                    }
                }
                if (!facet.getName().equals("month") || facet.getValueCount() <= 0) continue;
                splitByFacet = facet.getValues();
            }
            String qas = qasb.toString();
            Object[] qaFields = qas.equals("") ? new String[]{} : qas.split(",");
            Object[] qaTitles = this.downloadFields.getHeader((String[])qaFields, false);
            String[] header = (String[])org.apache.commons.lang3.ArrayUtils.addAll((Object[])indexedFields[2].toArray(new String[0]), (Object[])qaTitles);
            Object object = rw = downloadParams.getFileType().equals("csv") ? new CSVRecordWriter(out, header, downloadParams.getSep().charValue(), downloadParams.getEsc().charValue()) : new ShapeFileRecordWriter(downloadParams.getFile(), out, (String[])ArrayUtils.addAll((Object[])fields, (Object[])qaFields));
            if (rw instanceof ShapeFileRecordWriter) {
                dd.setHeaderMap(((ShapeFileRecordWriter)rw).getHeaderMappings());
            }
            solrQuery.addSortField("_docid_", SolrQuery.ORDER.asc);
            ArrayList<SolrQuery> queries = new ArrayList<SolrQuery>();
            if (splitByFacet != null) {
                for (FacetField.Count facet : splitByFacet) {
                    if (facet.getCount() <= 0L) continue;
                    SolrQuery splitByFacetQuery = solrQuery.getCopy().addFilterQuery(new String[]{facet.getFacetField().getName() + ":" + facet.getName()});
                    splitByFacetQuery.setFacet(false);
                    queries.add(splitByFacetQuery);
                }
                SolrQuery remainderQuery = solrQuery.getCopy().addFilterQuery(new String[]{"-" + ((FacetField.Count)splitByFacet.get(0)).getFacetField().getName() + ":[* TO *]"});
                queries.add(0, remainderQuery);
            } else {
                queries.add(0, solrQuery);
            }
            ExecutorService pool = Executors.newFixedThreadPool(6);
            HashSet futures = new HashSet();
            AtomicInteger resultsCount = new AtomicInteger(0);
            boolean threadCheckLimit = checkLimit;
            for (SolrQuery splitByFacetQuery : queries) {
                1 solrCallable = new /* Unavailable Anonymous Inner Class!! */;
                futures.add(pool.submit(solrCallable));
            }
            int totalDownload = 0;
            HashSet<Future> completeFutures = new HashSet<Future>();
            boolean allComplete = false;
            while (!allComplete) {
                for (Future future : futures) {
                    if (completeFutures.contains(future) || !future.isDone()) continue;
                    totalDownload += ((Integer)future.get()).intValue();
                    completeFutures.add(future);
                }
                allComplete = completeFutures.size() == futures.size();
                if (allComplete) continue;
                Thread.sleep(1000L);
            }
            pool.shutdown();
            rw.finalise();
            out.flush();
            long finish = System.currentTimeMillis();
            long timeTakenInSecs = (finish - start) / 1000L;
            if (timeTakenInSecs == 0L) {
                timeTakenInSecs = 1L;
            }
            logger.info((Object)("Download of " + resultsCount + " records in " + timeTakenInSecs + " seconds. Record/sec: " + (long)resultsCount.intValue() / timeTakenInSecs));
        }
        catch (SolrServerException ex) {
            logger.error((Object)("Problem communicating with SOLR server while processing download. " + ex.getMessage()), (Throwable)ex);
        }
        return uidStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processQueryResults(Map<String, Integer> uidStats, String[] fields, String[] qaFields, RecordWriter rw, QueryResponse qr, DownloadDetailsDTO dd, boolean checkLimit, AtomicInteger resultsCount) {
        int count = 0;
        for (SolrDocument sd : qr.getResults()) {
            if (sd.getFieldValue("data_resource_uid") == null || checkLimit && (!checkLimit || resultsCount.intValue() >= this.MAX_DOWNLOAD_SIZE)) continue;
            ++count;
            AtomicInteger atomicInteger = resultsCount;
            synchronized (atomicInteger) {
                resultsCount.incrementAndGet();
            }
            String[] values = new String[fields.length + qaFields.length];
            for (int j = 0; j < fields.length; ++j) {
                Object value = sd.getFirstValue(fields[j]);
                values[j] = value instanceof Date ? (value == null ? "" : DateFormatUtils.format((Date)((Date)value), (String)"yyyy-MM-dd")) : (value == null ? "" : value.toString());
            }
            Collection assertions = sd.getFieldValues("assertions");
            if (assertions == null) {
                assertions = Collections.EMPTY_LIST;
            }
            for (int k = 0; k < qaFields.length; ++k) {
                values[fields.length + k] = Boolean.toString(assertions.contains(qaFields[k]));
            }
            rw.write(values);
            this.incrementCount(uidStats, sd.getFieldValue("institution_uid"));
            this.incrementCount(uidStats, sd.getFieldValue("collection_uid"));
            this.incrementCount(uidStats, sd.getFieldValue("data_provider_uid"));
            this.incrementCount(uidStats, sd.getFieldValue("data_resource_uid"));
        }
        dd.updateCounts(count);
        return count;
    }

    public Map<String, Integer> writeResultsToStream(DownloadRequestParams downloadParams, OutputStream out, int i, boolean includeSensitive, DownloadDetailsDTO dd) throws Exception {
        int resultsCount = 0;
        HashMap<String, Integer> uidStats = new HashMap<String, Integer>();
        HashMap downloadLimit = new HashMap();
        try {
            CSVRecordWriter rw;
            SolrQuery solrQuery = this.initSolrQuery((SearchRequestParams)downloadParams, false, null);
            boolean getAssertionsFromFacets = "all".equals(downloadParams.getQa());
            if (getAssertionsFromFacets) {
                solrQuery.add("f.assertions.facet.sort", new String[]{"index"});
            }
            this.formatSearchQuery((SpatialSearchRequestParams)downloadParams);
            this.updateQueryContext((SearchRequestParams)downloadParams);
            logger.info((Object)("search query: " + downloadParams.getFormattedQuery()));
            solrQuery.setQuery(this.buildSpatialQueryString((SpatialSearchRequestParams)downloadParams));
            solrQuery.setFields(new String[]{"row_key", "institution_uid", "collection_uid", "data_resource_uid", "data_provider_uid"});
            String dFields = downloadParams.getFields();
            if (includeSensitive) {
                dFields = dFields.replaceFirst("decimalLatitude.p", "decimalLatitude,decimalLongitude,decimalLatitude.p").replaceFirst(",locality,", ",locality,sensitive_locality,");
            }
            StringBuilder sb = new StringBuilder(dFields);
            if (downloadParams.getExtra().length() > 0) {
                sb.append(",").append(downloadParams.getExtra());
            }
            StringBuilder qasb = new StringBuilder();
            QueryResponse qr = this.runSolrQuery(solrQuery, downloadParams.getFq(), Integer.valueOf(0), Integer.valueOf(0), "_docid_", "asc");
            dd.setTotalRecords(qr.getResults().getNumFound());
            List facets = qr.getFacetFields();
            for (FacetField facet : facets) {
                if (facet.getName().equals("assertions") && facet.getValueCount() > 0) {
                    for (FacetField.Count facetEntry : facet.getValues()) {
                        if (qasb.length() > 0) {
                            qasb.append(",");
                        }
                        qasb.append(facetEntry.getName());
                    }
                    continue;
                }
                if (!facet.getName().equals("data_resource_uid") || !this.checkDownloadLimits) continue;
                this.initDownloadLimits(downloadLimit, facet);
            }
            String qas = qasb.toString();
            Object[] fields = sb.toString().split(",");
            Object[] qaFields = qas.equals("") ? new String[]{} : qas.split(",");
            Object[] qaTitles = this.downloadFields.getHeader((String[])qaFields, false);
            Object[] titles = this.downloadFields.getHeader((String[])fields, true);
            String[] header = (String[])org.apache.commons.lang3.ArrayUtils.addAll((Object[])titles, (Object[])qaTitles);
            Object object = rw = downloadParams.getFileType().equals("csv") ? new CSVRecordWriter(out, header, downloadParams.getSep().charValue(), downloadParams.getEsc().charValue()) : new ShapeFileRecordWriter(downloadParams.getFile(), out, (String[])ArrayUtils.addAll((Object[])fields, (Object[])qaFields));
            if (rw instanceof ShapeFileRecordWriter) {
                dd.setHeaderMap(((ShapeFileRecordWriter)rw).getHeaderMappings());
            }
            if (downloadLimit.size() > 0) {
                Object[] originalFq = downloadParams.getFq();
                StringBuilder fqBuilder = new StringBuilder("-(");
                for (String dr : downloadLimit.keySet()) {
                    downloadParams.setFq((String[])ArrayUtils.add((Object[])originalFq, (Object)("data_resource_uid:" + dr)));
                    resultsCount = this.downloadRecords(downloadParams, (RecordWriter)rw, downloadLimit, uidStats, (String[])fields, (String[])qaFields, resultsCount, dr, includeSensitive, dd);
                    if (fqBuilder.length() > 2) {
                        fqBuilder.append(" OR ");
                    }
                    fqBuilder.append("data_resource_uid:").append(dr);
                }
                fqBuilder.append(")");
                downloadParams.setFq((String[])ArrayUtils.add((Object[])originalFq, (Object)fqBuilder.toString()));
                resultsCount = this.downloadRecords(downloadParams, (RecordWriter)rw, downloadLimit, uidStats, (String[])fields, (String[])qaFields, resultsCount, null, includeSensitive, dd);
            } else {
                this.downloadRecords(downloadParams, (RecordWriter)rw, downloadLimit, uidStats, (String[])fields, (String[])qaFields, resultsCount, null, includeSensitive, dd);
            }
            rw.finalise();
        }
        catch (SolrServerException ex) {
            logger.error((Object)("Problem communicating with SOLR server. " + ex.getMessage()), (Throwable)ex);
        }
        return uidStats;
    }

    private int downloadRecords(DownloadRequestParams downloadParams, RecordWriter writer, Map<String, Integer> downloadLimit, Map<String, Integer> uidStats, String[] fields, String[] qaFields, int resultsCount, String dataResource, boolean includeSensitive, DownloadDetailsDTO dd) throws Exception {
        logger.info((Object)("download query: " + downloadParams.getQ()));
        SolrQuery solrQuery = this.initSolrQuery((SearchRequestParams)downloadParams, false, null);
        solrQuery.setRows(this.MAX_DOWNLOAD_SIZE);
        this.formatSearchQuery((SpatialSearchRequestParams)downloadParams);
        solrQuery.setQuery(this.buildSpatialQueryString((SpatialSearchRequestParams)downloadParams));
        solrQuery.setFields(new String[]{"row_key", "institution_uid", "collection_uid", "data_resource_uid", "data_provider_uid"});
        int startIndex = 0;
        int pageSize = this.downloadBatchSize;
        StringBuilder sb = new StringBuilder(downloadParams.getFields());
        if (downloadParams.getExtra().length() > 0) {
            sb.append(",").append(downloadParams.getExtra());
        }
        StringBuilder qasb = new StringBuilder();
        QueryResponse qr = this.runSolrQuery(solrQuery, downloadParams.getFq(), Integer.valueOf(pageSize), Integer.valueOf(startIndex), "_docid_", "asc");
        ArrayList<String> uuids = new ArrayList<String>();
        while (qr.getResults().size() > 0 && resultsCount < this.MAX_DOWNLOAD_SIZE && this.shouldDownload(dataResource, downloadLimit, false)) {
            logger.debug((Object)("Start index: " + startIndex));
            for (SolrDocument sd : qr.getResults()) {
                String druid;
                if (sd.getFieldValue("data_resource_uid") == null || !this.shouldDownload(druid = sd.getFieldValue("data_resource_uid").toString(), downloadLimit, true) || resultsCount >= this.MAX_DOWNLOAD_SIZE) continue;
                ++resultsCount;
                uuids.add(sd.getFieldValue("row_key").toString());
                this.incrementCount(uidStats, sd.getFieldValue("institution_uid"));
                this.incrementCount(uidStats, sd.getFieldValue("collection_uid"));
                this.incrementCount(uidStats, sd.getFieldValue("data_provider_uid"));
                this.incrementCount(uidStats, (Object)druid);
            }
            Store.writeToWriter((RecordWriter)writer, (String[])uuids.toArray(new String[0]), (String[])fields, (String[])qaFields, (boolean)includeSensitive);
            startIndex += pageSize;
            uuids.clear();
            dd.updateCounts(qr.getResults().size());
            if (resultsCount >= this.MAX_DOWNLOAD_SIZE) continue;
            qr = this.runSolrQuery(solrQuery, null, Integer.valueOf(pageSize), Integer.valueOf(startIndex), "_docid_", "asc");
        }
        return resultsCount;
    }

    private boolean shouldDownload(String druid, Map<String, Integer> limits, boolean decrease) {
        if (this.checkDownloadLimits && !limits.isEmpty() && limits.containsKey(druid)) {
            Integer remainingLimit = limits.get(druid);
            if (remainingLimit == 0) {
                return false;
            }
            if (decrease) {
                limits.put(druid, remainingLimit - 1);
            }
        }
        return true;
    }

    private void initDownloadLimits(Map<String, Integer> map, FacetField facet) {
        LinkedHashMap limits = this.collectionCache.getDownloadLimits();
        for (FacetField.Count facetEntry : facet.getValues()) {
            Integer limit = (Integer)limits.get(facetEntry.getName());
            if (limit == null || limit <= 0 || (long)limit.intValue() >= facetEntry.getCount()) continue;
            map.put(facetEntry.getName(), limit);
        }
        if (map.size() > 0) {
            logger.debug((Object)("Downloading with the following limits: " + map));
        }
    }

    private void incrementCount(Map<String, Integer> values, Object uid) {
        if (uid != null) {
            Integer count;
            Integer n = count = Integer.valueOf(values.containsKey(uid) ? values.get(uid) : 0);
            Integer n2 = count = Integer.valueOf(count + 1);
            values.put(uid.toString(), count);
        }
    }

    public List<OccurrencePoint> getFacetPoints(SpatialSearchRequestParams searchParams, PointType pointType) throws Exception {
        ArrayList<OccurrencePoint> points = new ArrayList<OccurrencePoint>();
        this.formatSearchQuery(searchParams);
        logger.info((Object)("search query: " + searchParams.getFormattedQuery()));
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQueryType("standard");
        solrQuery.setQuery(this.buildSpatialQueryString(searchParams));
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(true);
        solrQuery.addFacetField(new String[]{pointType.getLabel()});
        solrQuery.setFacetMinCount(1);
        solrQuery.setFacetLimit(-1);
        this.updateQueryContext((SearchRequestParams)searchParams);
        QueryResponse qr = this.runSolrQuery(solrQuery, searchParams.getFq(), Integer.valueOf(1), Integer.valueOf(0), "score", "asc");
        List facets = qr.getFacetFields();
        if (facets != null) {
            for (FacetField facet : facets) {
                List facetEntries = facet.getValues();
                if (!facet.getName().contains(pointType.getLabel()) || facetEntries == null || facetEntries.size() <= 0) continue;
                for (FacetField.Count fcount : facetEntries) {
                    OccurrencePoint point = new OccurrencePoint(pointType);
                    point.setCount(Long.valueOf(fcount.getCount()));
                    String[] pointsDelimited = StringUtils.split((String)fcount.getName(), (char)',');
                    ArrayList<Float> coords = new ArrayList<Float>();
                    for (String coord : pointsDelimited) {
                        try {
                            Float decimalCoord = Float.valueOf(Float.parseFloat(coord));
                            coords.add(decimalCoord);
                        }
                        catch (NumberFormatException numberFormatException) {
                            logger.warn((Object)("Error parsing Float for Lat/Long: " + numberFormatException.getMessage()), (Throwable)numberFormatException);
                        }
                    }
                    if (coords.isEmpty()) continue;
                    Collections.reverse(coords);
                    point.setCoordinates(coords);
                    points.add(point);
                }
            }
        }
        return points;
    }

    public List<OccurrencePoint> getOccurrences(SpatialSearchRequestParams searchParams, PointType pointType, String colourBy, int searchType) throws Exception {
        ArrayList<OccurrencePoint> points = new ArrayList<OccurrencePoint>();
        searchParams.setPageSize(Integer.valueOf(100));
        String queryString = "";
        this.formatSearchQuery(searchParams);
        if (searchType == 0) {
            queryString = searchParams.getFormattedQuery();
        } else if (searchType == 1) {
            queryString = this.buildSpatialQueryString(searchParams.getFormattedQuery(), searchParams.getLat(), searchParams.getLon(), searchParams.getRadius());
        }
        logger.info((Object)("search query: " + queryString));
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQueryType("standard");
        solrQuery.setQuery(queryString);
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(true);
        solrQuery.addFacetField(new String[]{pointType.getLabel()});
        solrQuery.setFacetMinCount(1);
        solrQuery.setFacetLimit(this.MAX_DOWNLOAD_SIZE.intValue());
        this.updateQueryContext((SearchRequestParams)searchParams);
        QueryResponse qr = this.runSolrQuery(solrQuery, (SearchRequestParams)searchParams);
        SearchResultDTO searchResults = this.processSolrResponse((SearchRequestParams)searchParams, qr, solrQuery, OccurrenceIndex.class);
        List ocs = searchResults.getOccurrences();
        if (!ocs.isEmpty() && ocs.size() > 0) {
            for (OccurrenceIndex oc : ocs) {
                ArrayList<Float> coords = new ArrayList<Float>();
                coords.add(Float.valueOf(oc.getDecimalLongitude().floatValue()));
                coords.add(Float.valueOf(oc.getDecimalLatitude().floatValue()));
                OccurrencePoint point = new OccurrencePoint();
                point.setCoordinates(coords);
                if (searchType == 0) {
                    String value = "Not available";
                    if (StringUtils.isNotBlank((String)colourBy)) {
                        try {
                            Map map;
                            if (oc != null && (map = oc.toMap()) != null) {
                                if (map.containsKey(colourBy)) {
                                    value = (String)map.get(colourBy);
                                }
                                point.setOccurrenceUid(value);
                            }
                        }
                        catch (Exception e) {
                            logger.debug((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                } else if (searchType == 1) {
                    point.setOccurrenceUid(oc.getUuid());
                }
                points.add(point);
            }
        }
        return points;
    }

    public List<DataProviderCountDTO> getDataProviderCounts() throws Exception {
        ArrayList<DataProviderCountDTO> dpDTOs = new ArrayList<DataProviderCountDTO>();
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQueryType("standard");
        solrQuery.setQuery("*:*");
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(true);
        solrQuery.addFacetField(new String[]{"data_provider_uid"});
        solrQuery.addFacetField(new String[]{"data_provider"});
        solrQuery.setFacetMinCount(1);
        QueryResponse qr = this.runSolrQuery(solrQuery, null, Integer.valueOf(1), Integer.valueOf(0), "data_provider", "asc");
        List facets = qr.getFacetFields();
        if (facets != null && facets.size() == 2) {
            FacetField dataProviderIdFacet = (FacetField)facets.get(0);
            FacetField dataProviderNameFacet = (FacetField)facets.get(1);
            List dpIdEntries = dataProviderIdFacet.getValues();
            List dpNameEntries = dataProviderNameFacet.getValues();
            if (dpIdEntries != null) {
                for (int i = 0; i < dpIdEntries.size(); ++i) {
                    FacetField.Count dpIdEntry = (FacetField.Count)dpIdEntries.get(i);
                    FacetField.Count dpNameEntry = (FacetField.Count)dpNameEntries.get(i);
                    String dataProviderId = dpIdEntry.getName();
                    String dataProviderName = dpNameEntry.getName();
                    long count = dpIdEntry.getCount();
                    DataProviderCountDTO dto = new DataProviderCountDTO(dataProviderId, dataProviderName, count);
                    dpDTOs.add(dto);
                }
            }
        }
        logger.info((Object)("Find data providers = " + dpDTOs.size()));
        return dpDTOs;
    }

    public List<OccurrencePoint> findRecordsForLocation(SpatialSearchRequestParams requestParams, PointType pointType) throws Exception {
        ArrayList<OccurrencePoint> points = new ArrayList<OccurrencePoint>();
        this.updateQueryContext((SearchRequestParams)requestParams);
        String queryString = this.buildSpatialQueryString(requestParams);
        logger.info((Object)("location search query: " + queryString + "; pointType: " + pointType.getLabel()));
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQueryType("standard");
        solrQuery.setQuery(queryString);
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(true);
        solrQuery.addFacetField(new String[]{pointType.getLabel()});
        solrQuery.setFacetMinCount(1);
        solrQuery.setFacetLimit(this.MAX_DOWNLOAD_SIZE.intValue());
        QueryResponse qr = this.runSolrQuery(solrQuery, requestParams.getFq(), Integer.valueOf(1), Integer.valueOf(0), "score", "asc");
        logger.info((Object)("qr number found: " + qr.getResults().getNumFound()));
        List facets = qr.getFacetFields();
        if (facets != null) {
            for (FacetField facet : facets) {
                List facetEntries = facet.getValues();
                if (!facet.getName().contains(pointType.getLabel()) || facetEntries == null || facetEntries.size() <= 0) continue;
                for (FacetField.Count fcount : facetEntries) {
                    OccurrencePoint point = new OccurrencePoint(pointType);
                    point.setCount(Long.valueOf(fcount.getCount()));
                    String[] pointsDelimited = StringUtils.split((String)fcount.getName(), (char)',');
                    ArrayList<Float> coords = new ArrayList<Float>();
                    for (String coord : pointsDelimited) {
                        try {
                            Float decimalCoord = Float.valueOf(Float.parseFloat(coord));
                            coords.add(decimalCoord);
                        }
                        catch (NumberFormatException numberFormatException) {
                            logger.warn((Object)("Error parsing Float for Lat/Long: " + numberFormatException.getMessage()), (Throwable)numberFormatException);
                        }
                    }
                    if (coords.isEmpty()) continue;
                    Collections.reverse(coords);
                    point.setCoordinates(coords);
                    points.add(point);
                }
            }
        }
        logger.info((Object)("findRecordsForLocation: number of points = " + points.size()));
        return points;
    }

    public List<TaxaCountDTO> findAllSpeciesByCircleAreaAndHigherTaxa(SpatialSearchRequestParams requestParams, String speciesGroup) throws Exception {
        this.updateQueryContext((SearchRequestParams)requestParams);
        this.formatSearchQuery(requestParams);
        String queryString = this.buildSpatialQueryString(requestParams);
        logger.debug((Object)("The species count query " + queryString));
        ArrayList fqList = new ArrayList();
        if (requestParams.getFq().length > 0 && requestParams.getFq()[0].length() > 0) {
            org.apache.commons.collections.CollectionUtils.addAll(fqList, (Object[])requestParams.getFq());
        }
        List speciesWithCounts = this.getSpeciesCounts(queryString, fqList, CollectionUtils.arrayToList((Object)requestParams.getFacets()), requestParams.getPageSize(), requestParams.getStart(), requestParams.getSort(), requestParams.getDir());
        return speciesWithCounts;
    }

    public List<FieldResultDTO> findRecordByStateFor(String query) throws Exception {
        ArrayList<FieldResultDTO> fDTOs = new ArrayList<FieldResultDTO>();
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQueryType("standard");
        solrQuery.setQuery(query);
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(true);
        solrQuery.addFacetField(new String[]{"state"});
        solrQuery.setFacetMinCount(1);
        QueryResponse qr = this.runSolrQuery(solrQuery, null, Integer.valueOf(1), Integer.valueOf(0), "data_provider", "asc");
        List facets = qr.getFacetFields();
        FacetField ff = qr.getFacetField("state");
        if (ff != null) {
            for (FacetField.Count count : ff.getValues()) {
                FieldResultDTO f = new FieldResultDTO(count.getName(), count.getCount());
                fDTOs.add(f);
            }
        }
        return fDTOs;
    }

    public TaxaRankCountDTO calculateBreakdown(BreakdownRequestParams queryParams) throws Exception {
        TaxaRankCountDTO trDTO;
        block9: {
            List ffs;
            QueryResponse qr;
            block10: {
                logger.debug((Object)("Attempting to find the counts for " + queryParams));
                trDTO = null;
                SolrQuery solrQuery = new SolrQuery();
                solrQuery.setQueryType("standard");
                this.formatSearchQuery((SpatialSearchRequestParams)queryParams);
                solrQuery.setQuery(this.buildSpatialQueryString((SpatialSearchRequestParams)queryParams));
                queryParams.setPageSize(Integer.valueOf(0));
                solrQuery.setFacet(true);
                solrQuery.setFacetMinCount(1);
                solrQuery.setFacetSort("count");
                solrQuery.setFacetLimit(-1);
                this.updateQueryContext((SearchRequestParams)queryParams);
                if (StringUtils.isNotEmpty((String)queryParams.getName()) && StringUtils.isNotEmpty((String)queryParams.getRank())) {
                    queryParams.setFq((String[])ArrayUtils.addAll((Object[])queryParams.getFq(), (Object[])new String[]{queryParams.getRank() + ":" + queryParams.getName()}));
                }
                if (queryParams.getLevel() == null) {
                    List ranks = queryParams.getRank() != null ? this.searchUtils.getNextRanks(queryParams.getRank(), queryParams.getName() == null) : this.searchUtils.getRanks();
                    for (String r : ranks) {
                        solrQuery.addFacetField(new String[]{r});
                    }
                } else {
                    solrQuery.addFacetField(new String[]{queryParams.getLevel()});
                }
                qr = this.runSolrQuery(solrQuery, (SearchRequestParams)queryParams);
                if (queryParams.getMax() == null || queryParams.getMax() <= 0) break block10;
                if (qr.getResults().getNumFound() <= 0L) break block9;
                ffs = qr.getFacetFields();
                Collections.reverse(ffs);
                for (FacetField ff : ffs) {
                    trDTO = new TaxaRankCountDTO(ff.getName());
                    if (ff.getValues() == null || ff.getValues().size() > queryParams.getMax()) continue;
                    ArrayList<FieldResultDTO> fDTOs = new ArrayList<FieldResultDTO>();
                    for (FacetField.Count count : ff.getValues()) {
                        FieldResultDTO f = new FieldResultDTO(count.getName(), count.getCount());
                        fDTOs.add(f);
                    }
                    trDTO.setTaxa(fDTOs);
                    break block9;
                }
                break block9;
            }
            if ((queryParams.getRank() != null || queryParams.getLevel() != null) && qr.getResults().getNumFound() > 0L) {
                ffs = qr.getFacetFields();
                for (FacetField ff : ffs) {
                    List counts;
                    trDTO = new TaxaRankCountDTO(ff.getName());
                    if (ff == null || ff.getValues() == null || (counts = ff.getValues()).size() <= 0) continue;
                    ArrayList<FieldResultDTO> fDTOs = new ArrayList<FieldResultDTO>();
                    for (FacetField.Count count : counts) {
                        FieldResultDTO f = new FieldResultDTO(count.getName(), count.getCount());
                        fDTOs.add(f);
                    }
                    trDTO.setTaxa(fDTOs);
                    break;
                }
            }
        }
        return trDTO;
    }

    @Deprecated
    public TaxaRankCountDTO findTaxonCountForUid(BreakdownRequestParams breakdownParams, String query) throws Exception {
        ArrayList<String> ranks;
        TaxaRankCountDTO trDTO = null;
        List<String> list = breakdownParams.getLevel() == null ? this.searchUtils.getNextRanks(breakdownParams.getRank(), breakdownParams.getName() == null) : (ranks = new ArrayList<String>());
        if (breakdownParams.getLevel() != null) {
            ranks.add(breakdownParams.getLevel());
        }
        if (ranks != null && ranks.size() > 0) {
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setQueryType("standard");
            solrQuery.setQuery(query);
            solrQuery.setRows(Integer.valueOf(0));
            solrQuery.setFacet(true);
            solrQuery.setFacetMinCount(1);
            solrQuery.setFacetSort("count");
            solrQuery.setFacetLimit(-1);
            for (String r : ranks) {
                solrQuery.addFacetField(new String[]{r});
            }
            QueryResponse qr = this.runSolrQuery(solrQuery, this.getQueryContextAsArray(breakdownParams.getQc()), Integer.valueOf(1), Integer.valueOf(0), breakdownParams.getRank(), "asc");
            if (qr.getResults().size() > 0) {
                for (String r : ranks) {
                    List counts;
                    trDTO = new TaxaRankCountDTO(r);
                    FacetField ff = qr.getFacetField(r);
                    if (ff == null || ff.getValues() == null || (counts = ff.getValues()).size() <= 0) continue;
                    ArrayList<FieldResultDTO> fDTOs = new ArrayList<FieldResultDTO>();
                    for (FacetField.Count count : counts) {
                        FieldResultDTO f = new FieldResultDTO(count.getName(), count.getCount());
                        fDTOs.add(f);
                    }
                    trDTO.setTaxa(fDTOs);
                    break;
                }
            }
        }
        return trDTO;
    }

    private QueryResponse runSolrQuery(SolrQuery solrQuery, String[] filterQuery, Integer pageSize, Integer startIndex, String sortField, String sortDirection) throws SolrServerException {
        SearchRequestParams requestParams = new SearchRequestParams();
        requestParams.setFq(filterQuery);
        requestParams.setPageSize(pageSize);
        requestParams.setStart(startIndex);
        requestParams.setSort(sortField);
        requestParams.setDir(sortDirection);
        return this.runSolrQuery(solrQuery, requestParams);
    }

    private QueryResponse runSolrQuery(SolrQuery solrQuery, SearchRequestParams requestParams) throws SolrServerException {
        if (requestParams.getFq() != null) {
            for (String fq : requestParams.getFq()) {
                if (fq == null || fq.isEmpty()) continue;
                if (fq.contains(" OR ") || fq.contains(" AND ") || fq.contains("Intersects(")) {
                    solrQuery.addFilterQuery(new String[]{fq});
                    logger.info((Object)("adding filter query: " + fq));
                    continue;
                }
                String[] parts = fq.split(":", 2);
                if (parts.length <= 1) continue;
                logger.debug((Object)("fq split into: " + parts.length + " parts: " + parts[0] + " & " + parts[1]));
                String prefix = null;
                String suffix = null;
                if (parts[1].contains("[") && parts[1].contains(" TO ") && parts[1].contains("]") || parts[0].startsWith("-(") || parts[0].startsWith("(")) {
                    prefix = parts[0];
                    suffix = parts[1];
                } else {
                    prefix = parts[0].startsWith("-") ? "-" + ClientUtils.escapeQueryChars((String)parts[0].substring(1)) : ClientUtils.escapeQueryChars((String)parts[0]);
                    if (parts[1].equals("*")) {
                        suffix = parts[1];
                    } else {
                        boolean quoted = false;
                        StringBuffer sb = new StringBuffer();
                        if (parts[1].startsWith(QUOTE) && parts[1].endsWith(QUOTE)) {
                            quoted = true;
                            parts[1] = parts[1].substring(1, parts[1].length() - 1);
                            sb.append(QUOTE);
                        }
                        sb.append(ClientUtils.escapeQueryChars((String)parts[1]));
                        if (quoted) {
                            sb.append(QUOTE);
                        }
                        suffix = sb.toString();
                    }
                }
                if (StringUtils.isEmpty((String)suffix)) {
                    suffix = "Unknown";
                }
                solrQuery.addFilterQuery(new String[]{prefix + ":" + suffix});
                logger.info((Object)("adding filter query: " + prefix + ":" + suffix));
            }
        }
        solrQuery.setRows(requestParams.getPageSize());
        solrQuery.setStart(requestParams.getStart());
        solrQuery.setSortField(requestParams.getSort(), SolrQuery.ORDER.valueOf((String)requestParams.getDir()));
        logger.debug((Object)("runSolrQuery: " + solrQuery.toString()));
        QueryResponse qr = this.getServer().query((SolrParams)solrQuery, this.queryMethod);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("matched records: " + qr.getResults().getNumFound()));
        }
        return qr;
    }

    private SearchResultDTO processSolrResponse(SearchRequestParams params, QueryResponse qr, SolrQuery solrQuery, Class resultClass) {
        SearchResultDTO searchResult = new SearchResultDTO();
        SolrDocumentList sdl = qr.getResults();
        List facets = qr.getFacetFields();
        List facetDates = qr.getFacetDates();
        Map facetQueries = qr.getFacetQuery();
        if (facetDates != null) {
            logger.debug((Object)("Facet dates size: " + facetDates.size()));
            facets.addAll(facetDates);
        }
        List results = qr.getBeans(resultClass);
        ArrayList<FacetResultDTO> facetResults = new ArrayList<FacetResultDTO>();
        searchResult.setTotalRecords(sdl.getNumFound());
        searchResult.setStartIndex(sdl.getStart());
        searchResult.setPageSize((long)solrQuery.getRows().intValue());
        searchResult.setStatus("OK");
        Object[] solrSort = StringUtils.split((String)solrQuery.getSortField(), (String)" ");
        logger.debug((Object)("sortField post-split: " + StringUtils.join((Object[])solrSort, (String)"|")));
        searchResult.setSort((String)solrSort[0]);
        searchResult.setDir((String)solrSort[1]);
        searchResult.setQuery(params.getUrlParams());
        searchResult.setOccurrences(results);
        if (facets != null) {
            for (FacetField facet : facets) {
                List facetEntries = facet.getValues();
                if (facetEntries == null || facetEntries.size() <= 0) continue;
                ArrayList<FieldResultDTO> r = new ArrayList<FieldResultDTO>();
                Matcher m = this.uidPattern.matcher(facet.getName() + ":value");
                boolean isUid = m.matches();
                for (FacetField.Count fcount : facetEntries) {
                    String displayName;
                    if (isUid) {
                        displayName = this.searchUtils.getUidDisplayString(facet.getName(), fcount.getName(), false);
                        r.add(new FieldResultDTO(displayName, fcount.getCount(), facet.getName() + ":\"" + fcount.getName() + QUOTE));
                        continue;
                    }
                    if (this.getAuthIndexFields().contains(facet.getName())) {
                        displayName = this.authService.getDisplayNameFor(fcount.getName());
                        r.add(new FieldResultDTO(displayName, fcount.getCount(), facet.getName() + ":\"" + fcount.getName() + QUOTE));
                        continue;
                    }
                    r.add(new FieldResultDTO(fcount.getName(), fcount.getCount()));
                }
                if (r.size() <= 0) continue;
                FacetResultDTO fr = new FacetResultDTO(facet.getName(), r);
                facetResults.add(fr);
            }
        }
        if (facetQueries != null && !facetQueries.isEmpty()) {
            Map rangeMap = RangeBasedFacets.getRangeMap((String)"uncertainty");
            ArrayList<FieldResultDTO> fqr = new ArrayList<FieldResultDTO>();
            for (String value : facetQueries.keySet()) {
                if ((Integer)facetQueries.get(value) <= 0) continue;
                fqr.add(new FieldResultDTO((String)rangeMap.get(value), (long)((Integer)facetQueries.get(value)).intValue(), value));
            }
            facetResults.add(new FacetResultDTO("uncertainty", fqr));
        }
        if (qr.getFacetRanges() != null) {
            for (RangeFacet rfacet : qr.getFacetRanges()) {
                ArrayList<FieldResultDTO> fqr = new ArrayList<FieldResultDTO>();
                if (!(rfacet instanceof RangeFacet.Numeric)) continue;
                RangeFacet.Numeric nrfacet = (RangeFacet.Numeric)rfacet;
                List counts = nrfacet.getCounts();
                if (nrfacet.getBefore().intValue() > 0) {
                    fqr.add(new FieldResultDTO("[* TO " + this.getUpperRange(((Number)nrfacet.getStart()).toString(), (Number)nrfacet.getGap(), false) + "]", (long)nrfacet.getBefore().intValue()));
                }
                for (RangeFacet.Count count : counts) {
                    String title = this.getRangeValue(count.getValue(), (Number)nrfacet.getGap());
                    fqr.add(new FieldResultDTO(title, (long)count.getCount()));
                }
                if (nrfacet.getAfter().intValue() > 0) {
                    fqr.add(new FieldResultDTO("[" + ((Number)nrfacet.getEnd()).toString() + " TO *]", (long)nrfacet.getAfter().intValue()));
                }
                facetResults.add(new FacetResultDTO(nrfacet.getName(), fqr));
            }
        }
        for (OccurrenceIndex oi : results) {
            this.updateImageUrls(oi);
        }
        searchResult.setFacetResults(facetResults);
        searchResult.setQr(qr);
        return searchResult;
    }

    private void updateImageUrls(OccurrenceIndex oi) {
        if (!StringUtils.isNotBlank((String)oi.getImage())) {
            return;
        }
        Map formats = Config.mediaStore().getImageFormats(oi.getImage());
        oi.setImageUrl((String)formats.get("raw"));
        oi.setThumbnailUrl((String)formats.get("thumb"));
        oi.setSmallImageUrl((String)formats.get("small"));
        oi.setLargeImageUrl((String)formats.get("large"));
        String[] images = oi.getImages();
        if (images != null && images.length > 0) {
            String[] imageUrls = new String[images.length];
            for (int i = 0; i < images.length; ++i) {
                Map availableFormats = Config.mediaStore().getImageFormats(images[i]);
                imageUrls[i] = (String)availableFormats.get("large");
            }
            oi.setImageUrls(imageUrls);
        }
    }

    private String getRangeValue(String lower, Number gap) {
        StringBuilder value = new StringBuilder("[");
        value.append(lower).append(" TO ").append(this.getUpperRange(lower, gap, true));
        return value.append("]").toString();
    }

    private String getUpperRange(String lower, Number gap, boolean addGap) {
        if (gap instanceof Integer) {
            Integer upper = Integer.parseInt(lower) - 1;
            if (addGap) {
                upper = upper + (Integer)gap;
            }
            return upper.toString();
        }
        if (gap instanceof Double) {
            BigDecimal upper = new BigDecimal(lower).add(new BigDecimal(-0.001));
            if (addGap) {
                upper = upper.add(new BigDecimal(gap.doubleValue()));
            }
            return upper.setScale(3, RoundingMode.HALF_UP).toString();
        }
        return lower;
    }

    protected String buildSpatialQueryString(String fullTextQuery, Float latitude, Float longitude, Float radius) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.spatialField).append(":\"Intersects(Circle(").append(longitude.toString());
        sb.append(" ").append(latitude.toString()).append(" d=").append(SpatialUtils.convertToDegrees((Float)radius).toString());
        sb.append("))\"");
        if (StringUtils.isNotEmpty((String)fullTextQuery)) {
            sb.append(" AND (").append(fullTextQuery).append(")");
        }
        return sb.toString();
    }

    protected String buildSpatialQueryString(SpatialSearchRequestParams searchParams) {
        if (searchParams != null) {
            String query;
            StringBuilder sb = new StringBuilder();
            if (searchParams.getLat() != null) {
                sb.append(this.spatialField).append(":\"Intersects(Circle(");
                sb.append(searchParams.getLon().toString()).append(" ").append(searchParams.getLat().toString());
                sb.append(" d=").append(SpatialUtils.convertToDegrees((Float)searchParams.getRadius()).toString());
                sb.append("))\"");
            } else if (!StringUtils.isEmpty((String)searchParams.getWkt())) {
                sb.append(SpatialUtils.getWKTQuery((String)this.spatialField, (String)searchParams.getWkt(), (boolean)false));
            }
            String string = query = StringUtils.isEmpty((String)searchParams.getFormattedQuery()) ? searchParams.getQ() : searchParams.getFormattedQuery();
            if (StringUtils.isNotEmpty((String)query)) {
                if (sb.length() > 0) {
                    sb.append(" AND (");
                    sb.append(query).append(")");
                } else {
                    sb.append(query);
                }
            }
            return sb.toString();
        }
        return null;
    }

    protected void formatSearchQuery(SpatialSearchRequestParams searchParams) {
        this.formatSearchQuery(searchParams, false);
    }

    protected void formatSearchQuery(SpatialSearchRequestParams searchParams, boolean forceQueryFormat) {
        if (forceQueryFormat || StringUtils.isEmpty((String)searchParams.getFormattedQuery())) {
            String[] values;
            String value;
            Matcher matcher;
            String query = searchParams.getQ();
            if (query.contains("qid:")) {
                Matcher matcher2 = this.qidPattern.matcher(query);
                long qidId = 0L;
                while (matcher2.find()) {
                    String value2 = matcher2.group();
                    try {
                        String qidValue = SearchUtils.stripEscapedQuotes((String)value2.substring(4));
                        qidId = Long.parseLong(qidValue);
                        Qid qid = this.qidCacheDao.get(qidValue);
                        if (qid == null) continue;
                        searchParams.setQId(Long.valueOf(qidId));
                        searchParams.setQ(qid.getQ());
                        if (qid.getFqs() != null) {
                            Object[] currentFqs = searchParams.getFq();
                            if (currentFqs == null || currentFqs.length == 1 && currentFqs[0].length() == 0) {
                                searchParams.setFq(qid.getFqs());
                            } else {
                                searchParams.setFq((String[])ArrayUtils.addAll((Object[])currentFqs, (Object[])qid.getFqs()));
                            }
                        }
                        String displayString = qid.getDisplayString();
                        if (StringUtils.isNotEmpty((String)qid.getWkt())) {
                            displayString = displayString + " within user defined polygon";
                        }
                        searchParams.setDisplayString(displayString);
                        if (searchParams instanceof SpatialSearchRequestParams) {
                            searchParams.setWkt(qid.getWkt());
                        } else if (StringUtils.isNotEmpty((String)qid.getWkt())) {
                            String originalQ = searchParams.getQ();
                            searchParams.setQ(this.spatialField + ":\"Intersects(" + qid.getWkt() + ")");
                            if (StringUtils.isNotEmpty((String)originalQ)) {
                                searchParams.setQ(searchParams.getQ() + " AND " + originalQ);
                            }
                        }
                        searchParams.setFormattedQuery(searchParams.getQ());
                        return;
                    }
                    catch (NumberFormatException e) {
                    }
                    catch (QidMissingException e) {
                    }
                }
            }
            StringBuffer queryString = new StringBuffer();
            StringBuffer displaySb = new StringBuffer();
            String displayString = query;
            if (query.contains(":")) {
                Matcher matcher3 = this.termPattern.matcher(query);
                queryString.setLength(0);
                while (matcher3.find()) {
                    String guid;
                    String queryText;
                    String field;
                    String value3 = matcher3.group();
                    logger.debug((Object)("term query: " + value3));
                    logger.debug((Object)("groups: " + matcher3.group(1) + "|" + matcher3.group(2)));
                    if ("matched_name".equals(matcher3.group(1))) {
                        field = matcher3.group(1);
                        queryText = matcher3.group(2);
                        if (queryText != null && !queryText.isEmpty()) {
                            guid = this.speciesLookupService.getGuidForName(queryText.replaceAll(QUOTE, ""));
                            logger.info((Object)("GUID for " + queryText + " = " + guid));
                            if (guid != null && !guid.isEmpty()) {
                                String acceptedName = this.speciesLookupService.getAcceptedNameForGuid(guid);
                                logger.info((Object)("acceptedName for " + queryText + " = " + acceptedName));
                                if (acceptedName != null && !acceptedName.isEmpty()) {
                                    field = "taxon_name";
                                    queryText = acceptedName;
                                }
                            } else {
                                field = "taxon_name";
                            }
                            displayString = displayString.replaceAll("matched_name", "taxon_name");
                        }
                        if (StringUtils.containsAny((String)queryText, (char[])CHARS) && !queryText.startsWith("[")) {
                            queryText = QUOTE + queryText + QUOTE;
                        }
                        logger.debug((Object)("queryText: " + queryText));
                        matcher3.appendReplacement(queryString, Matcher.quoteReplacement(field + ":" + queryText));
                        continue;
                    }
                    if ("matched_name_children".equals(matcher3.group(1))) {
                        field = matcher3.group(1);
                        queryText = matcher3.group(2);
                        if (queryText != null && !queryText.isEmpty()) {
                            guid = this.speciesLookupService.getGuidForName(queryText.replaceAll(QUOTE, ""));
                            logger.info((Object)("GUID for " + queryText + " = " + guid));
                            if (guid != null && !guid.isEmpty()) {
                                field = "lsid";
                                queryText = guid;
                            } else {
                                field = "taxon_name";
                            }
                        }
                        if (StringUtils.containsAny((String)queryText, (char[])CHARS) && !queryText.startsWith("[")) {
                            queryText = QUOTE + queryText + QUOTE;
                        }
                        matcher3.appendReplacement(queryString, Matcher.quoteReplacement(field + ":" + queryText));
                        continue;
                    }
                    matcher3.appendReplacement(queryString, Matcher.quoteReplacement(value3));
                }
                matcher3.appendTail(queryString);
                query = queryString.toString();
            }
            int last = 0;
            if (query.contains("lsid:")) {
                matcher = this.lsidPattern.matcher(query);
                queryString.setLength(0);
                while (matcher.find()) {
                    if ((matcher.start() <= 0 || query.charAt(matcher.start() - 1) == '_') && matcher.start() != 0) continue;
                    value = matcher.group();
                    logger.debug((Object)("preprocessing " + value));
                    String lsid = matcher.group(2);
                    if (lsid.contains(QUOTE)) {
                        lsid = lsid.replaceAll(QUOTE, "");
                    }
                    if (lsid.contains("\\")) {
                        lsid = lsid.replaceAll("\\\\", "");
                    }
                    logger.debug((Object)("lsid = " + lsid));
                    values = this.searchUtils.getTaxonSearch(lsid);
                    String lsidHeader = matcher.group(1).length() > 0 ? matcher.group(1) : "";
                    matcher.appendReplacement(queryString, lsidHeader + values[0]);
                    displaySb.append(query.substring(last, matcher.start()));
                    if (!values[1].startsWith("taxon_concept_lsid:")) {
                        displaySb.append(lsidHeader).append("<span class='lsid' id='").append(lsid).append("'>").append(values[1]).append("</span>");
                    } else {
                        displaySb.append(lsidHeader).append(values[1]);
                    }
                    last = matcher.end();
                }
                matcher.appendTail(queryString);
                displaySb.append(query.substring(last, query.length()));
                query = queryString.toString();
                displayString = displaySb.toString();
            }
            if (query.contains("urn")) {
                matcher = this.urnPattern.matcher(query);
                queryString.setLength(0);
                while (matcher.find()) {
                    value = matcher.group();
                    logger.debug((Object)("escaping lsid urns  " + value));
                    matcher.appendReplacement(queryString, this.prepareSolrStringForReplacement(value));
                }
                matcher.appendTail(queryString);
                query = queryString.toString();
            }
            if (query.contains("Intersects")) {
                matcher = this.spatialPattern.matcher(query);
                if (matcher.find()) {
                    String spatial = matcher.group();
                    SpatialSearchRequestParams subQuery = new SpatialSearchRequestParams();
                    logger.debug((Object)("region Start : " + matcher.regionStart() + " start :  " + matcher.start() + " spatial length " + spatial.length() + " query length " + query.length()));
                    subQuery.setQ(query.substring(matcher.start() + spatial.length(), query.length()));
                    this.formatSearchQuery(subQuery);
                    queryString.setLength(0);
                    queryString.append(query.substring(0, matcher.start()));
                    queryString.append(spatial);
                    queryString.append(subQuery.getFormattedQuery());
                    searchParams.setFormattedQuery(queryString.toString());
                    if (spatial.contains("circles")) {
                        values = spatial.substring(spatial.indexOf("=") + 1, spatial.indexOf("}")).split(",");
                        if (values.length == 3) {
                            displaySb.setLength(0);
                            displaySb.append(subQuery.getDisplayString());
                            displaySb.append(" - within ").append(values[2]).append(" km of point(").append(values[0]).append(",").append(values[1]).append(")");
                            searchParams.setDisplayString(displaySb.toString());
                        }
                    } else {
                        searchParams.setDisplayString(subQuery.getDisplayString() + " - within supplied region");
                    }
                }
            } else {
                queryString.setLength(0);
                matcher = this.spacesPattern.matcher(query);
                while (matcher.find()) {
                    value = matcher.group();
                    if (value.equals("-") || value.endsWith("*")) continue;
                    String[] bits = StringUtils.split((String)value, (String)":", (int)2);
                    if (bits.length == 2) {
                        if (bits[0].contains("urn") || bits[1].contains("urn\\")) continue;
                        matcher.appendReplacement(queryString, bits[0] + ":" + this.prepareSolrStringForReplacement(bits[1]));
                        continue;
                    }
                    if (value.endsWith(":")) continue;
                    matcher.appendReplacement(queryString, this.prepareSolrStringForReplacement(value));
                }
                matcher.appendTail(queryString);
                if (displayString.contains("_uid")) {
                    displaySb.setLength(0);
                    String normalised = displayString.replaceAll(QUOTE, "");
                    matcher = this.uidPattern.matcher(normalised);
                    while (matcher.find()) {
                        String newVal = "<span>" + this.searchUtils.getUidDisplayString(matcher.group(1), matcher.group(2)) + "</span>";
                        if (newVal == null) continue;
                        matcher.appendReplacement(displaySb, newVal);
                    }
                    matcher.appendTail(displaySb);
                    displayString = displaySb.toString();
                }
                if (searchParams.getQ().equals("*:*")) {
                    displayString = "[all records]";
                }
                if (searchParams.getLat() != null && searchParams.getLon() != null && searchParams.getRadius() != null) {
                    displaySb.setLength(0);
                    displaySb.append(displayString);
                    displaySb.append(" - within ").append(searchParams.getRadius()).append(" km of point(").append(searchParams.getLat()).append(",").append(searchParams.getLon()).append(")");
                    displayString = displaySb.toString();
                }
                displayString = this.formatDisplayStringWithI18n(displayString);
                searchParams.setFormattedQuery(queryString.toString());
                logger.debug((Object)("formattedQuery = " + queryString));
                logger.debug((Object)("displayString = " + displayString));
                searchParams.setDisplayString(displayString);
            }
            for (int i = 0; i < searchParams.getFq().length; ++i) {
                String fq = searchParams.getFq()[i];
                String[] parts = fq.split(":", 2);
                Map titleMap = RangeBasedFacets.getTitleMap((String)parts[0]);
                if (titleMap == null) continue;
                searchParams.getFq()[i] = (String)titleMap.get(parts[1]);
            }
        }
        searchParams.setDisplayString(this.formatDisplayStringWithI18n(searchParams.getDisplayString()));
    }

    public String formatDisplayStringWithI18n(String displayText) {
        if (StringUtils.trimToNull((String)displayText) == null) {
            return displayText;
        }
        try {
            String formatted = displayText;
            Matcher m = this.indexFieldPatternMatcher.matcher(displayText);
            int currentPos = 0;
            while (m.find(currentPos)) {
                String matchedIndexTerm = m.group(0).replaceAll(":", "");
                MatchResult mr = m.toMatchResult();
                Matcher lm = this.layersPattern.matcher(matchedIndexTerm);
                String i18n = "";
                if (lm.matches()) {
                    i18n = this.layersService.getName(matchedIndexTerm);
                    if (i18n == null) {
                        i18n = matchedIndexTerm;
                    }
                } else {
                    i18n = this.messageSource.getMessage("facet." + matchedIndexTerm, null, matchedIndexTerm, null);
                }
                if (!matchedIndexTerm.equals(i18n)) {
                    int nextWhitespace = displayText.substring(mr.end()).indexOf(" ");
                    String extractedValue = null;
                    extractedValue = nextWhitespace > 0 ? displayText.substring(mr.end(), mr.end() + nextWhitespace) : displayText.substring(mr.end());
                    String formattedExtractedValue = SearchUtils.stripEscapedQuotes((String)extractedValue);
                    String i18nForValue = this.messageSource.getMessage(matchedIndexTerm + "." + formattedExtractedValue, null, "", null);
                    if (i18nForValue.length() == 0) {
                        i18nForValue = this.messageSource.getMessage(formattedExtractedValue, null, "", null);
                    }
                    formatted = i18nForValue.length() > 0 ? formatted.replaceAll(matchedIndexTerm + ":" + extractedValue, i18n + ":" + i18nForValue) : formatted.replaceAll(matchedIndexTerm, i18n);
                }
                currentPos = mr.end();
            }
            return formatted;
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
            return displayText;
        }
    }

    private String prepareSolrStringForReplacement(String value) {
        boolean quoted = false;
        StringBuffer sb = new StringBuffer();
        if (value.startsWith(QUOTE) && value.endsWith(QUOTE)) {
            quoted = true;
            value = value.substring(1, value.length() - 1);
            sb.append(QUOTE);
        }
        sb.append(ClientUtils.escapeQueryChars((String)value).replaceAll("\\\\", "\\\\\\\\"));
        if (quoted) {
            sb.append(QUOTE);
        }
        return sb.toString();
    }

    protected void updateQueryContext(SearchRequestParams searchParams) {
        String qc = searchParams.getQc();
        if (StringUtils.isNotEmpty((String)qc)) {
            searchParams.setFq((String[])ArrayUtils.addAll((Object[])searchParams.getFq(), (Object[])this.getQueryContextAsArray(qc)));
        }
    }

    protected String[] getQueryContextAsArray(String queryContext) {
        if (StringUtils.isNotEmpty((String)queryContext)) {
            String[] values = queryContext.split(",");
            for (int i = 0; i < values.length; ++i) {
                String field = values[i];
                values[i] = field.replace("hub:", "data_hub_uid:");
            }
            return values;
        }
        return new String[0];
    }

    protected void initDecadeBasedFacet(SolrQuery solrQuery, String field) {
        solrQuery.add("facet.date", new String[]{field});
        solrQuery.add("facet.date.start", new String[]{"1850-01-01T00:00:00Z"});
        solrQuery.add("facet.date.end", new String[]{"NOW/DAY"});
        solrQuery.add("facet.date.gap", new String[]{"+10YEAR"});
        solrQuery.add("facet.date.other", new String[]{"before"});
        solrQuery.add("facet.date.include", new String[]{"lower"});
    }

    protected SolrQuery initSolrQuery(SearchRequestParams searchParams, boolean substituteDefaultFacetOrder, Map<String, String[]> extraSolrParams) {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQueryType("standard");
        boolean rangeAdded = false;
        solrQuery.setFacet(searchParams.getFacet().booleanValue());
        if (searchParams.getFacet().booleanValue()) {
            for (String facet : searchParams.getFacets()) {
                if (facet.equals("date") || facet.equals(DECADE_FACET_NAME)) {
                    String fname = facet.equals(DECADE_FACET_NAME) ? "occurrence_year" : "occurrence_" + facet;
                    this.initDecadeBasedFacet(solrQuery, fname);
                    continue;
                }
                if (facet.equals("uncertainty")) {
                    Map rangeMap = RangeBasedFacets.getRangeMap((String)"uncertainty");
                    for (String range : rangeMap.keySet()) {
                        solrQuery.add("facet.query", new String[]{range});
                    }
                    continue;
                }
                if (facet.endsWith(RANGE_SUFFIX)) {
                    String field;
                    StatsIndexFieldDTO details;
                    if (!rangeAdded) {
                        solrQuery.add("facet.range.other", new String[]{"before"});
                        solrQuery.add("facet.range.other", new String[]{"after"});
                    }
                    if ((details = this.getRangeFieldDetails(field = facet.replaceAll(RANGE_SUFFIX, ""))) == null) continue;
                    solrQuery.addNumericRangeFacet(field, details.getStart(), details.getEnd(), details.getGap());
                    continue;
                }
                solrQuery.addFacetField(new String[]{facet});
                if (!"".equals(searchParams.getFsort()) || !substituteDefaultFacetOrder || !FacetThemes.facetsMap.containsKey(facet)) continue;
                String thisSort = ((FacetThemes.Facet)FacetThemes.facetsMap.get(facet)).getSort();
                if (searchParams.getFsort().equalsIgnoreCase(thisSort)) continue;
                solrQuery.add("f." + facet + ".facet.sort", new String[]{thisSort});
            }
            solrQuery.setFacetMinCount(1);
            solrQuery.setFacetLimit(searchParams.getFlimit().intValue());
            String fsort = "".equals(searchParams.getFsort()) ? "count" : searchParams.getFsort();
            solrQuery.setFacetSort(fsort);
            if (searchParams.getFoffset() > 0) {
                solrQuery.add("facet.offset", new String[]{Integer.toString(searchParams.getFoffset())});
            }
            if (StringUtils.isNotEmpty((String)searchParams.getFprefix())) {
                solrQuery.add("facet.prefix", new String[]{searchParams.getFprefix()});
            }
        }
        solrQuery.setRows(Integer.valueOf(10));
        solrQuery.setStart(Integer.valueOf(0));
        if (searchParams.getFl().length() > 0) {
            solrQuery.setFields(new String[]{searchParams.getFl()});
        } else {
            solrQuery.setFields(new String[]{"id,row_key,occurrence_id,data_hub_uid,data_hub,institution_uid,institution_code,institution_name,collection_uid,collection_code,collection_name,catalogue_number,taxon_concept_lsid,occurrence_date,occurrence_year,taxon_name,common_name,rank,rank_id,country_code,country,kingdom,phylum,class,order,family,genus,genus_guid,species,species_guid,subspecies,subspecies_guid,state,latitude,longitude,coordinate_uncertainty,year,month,basis_of_record,type_status,location_remarks,occurrence_remarks,lft,rgt,ibra,imcra,places,data_provider_uid,data_provider,data_resource_uid,data_resource,assertions,user_assertions,species_group,image_url,all_image_url,geospatial_kosher,taxonomic_kosher,collector,collectors,raw_taxon_name,raw_basis_of_record,raw_type_status,raw_common_name,lat_long,point-1,point-0.1,point-0.01,point-0.001,point-0.0001,names_and_lsid,multimedia,aust_conservation,state_conservation,sensitive,record_number"});
        }
        if (extraSolrParams != null) {
            if (!rangeAdded) {
                solrQuery.add("facet.range.other", new String[]{"before"});
                solrQuery.add("facet.range.other", new String[]{"after"});
            }
            for (String key : extraSolrParams.keySet()) {
                String[] values = extraSolrParams.get(key);
                solrQuery.add(key, values);
            }
        }
        return solrQuery;
    }

    private StatsIndexFieldDTO getRangeFieldDetails(String field) {
        StatsIndexFieldDTO details;
        block5: {
            if (this.rangeFieldCache == null) {
                this.rangeFieldCache = new HashMap();
            }
            if ((details = (StatsIndexFieldDTO)this.rangeFieldCache.get(field)) == null && this.indexFieldMap != null) {
                SpatialSearchRequestParams searchParams = new SpatialSearchRequestParams();
                searchParams.setQ("*:*");
                searchParams.setFacets(new String[]{field});
                try {
                    Map stats = this.getStatistics(searchParams);
                    if (stats == null) break block5;
                    IndexFieldDTO ifdto = (IndexFieldDTO)this.indexFieldMap.get(field);
                    if (ifdto != null) {
                        String type = ifdto.getDataType();
                        details = new StatsIndexFieldDTO((FieldStatsInfo)stats.get(field), type);
                        this.rangeFieldCache.put(field, details);
                        break block5;
                    }
                    logger.debug((Object)("Unable to locate field:  " + field));
                    return null;
                }
                catch (Exception e) {
                    logger.warn((Object)"Unable to obtain range from cache.", (Throwable)e);
                    details = null;
                }
            }
        }
        return details;
    }

    protected List<TaxaCountDTO> getSpeciesCounts(String queryString, List<String> filterQueries, List<String> facetFields, Integer pageSize, Integer startIndex, String sortField, String sortDirection) throws SolrServerException {
        ArrayList<TaxaCountDTO> speciesCounts = new ArrayList<TaxaCountDTO>();
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQueryType("standard");
        solrQuery.setQuery(queryString);
        if (filterQueries != null && filterQueries.size() > 0) {
            for (String fq : filterQueries) {
                solrQuery.addFilterQuery(new String[]{fq});
            }
        }
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(true);
        solrQuery.setFacetSort(sortField);
        for (String facet : facetFields) {
            solrQuery.addFacetField(new String[]{facet});
            logger.debug((Object)("adding facetField: " + facet));
        }
        solrQuery.setFacetMinCount(1);
        solrQuery.setFacetLimit(pageSize.intValue());
        solrQuery.add("facet.offset", new String[]{Integer.toString(startIndex)});
        logger.debug((Object)("getSpeciesCount query :" + solrQuery.getQuery()));
        QueryResponse qr = this.runSolrQuery(solrQuery, null, Integer.valueOf(1), Integer.valueOf(0), "score", sortDirection);
        logger.info((Object)("SOLR query: " + solrQuery.getQuery() + "; total hits: " + qr.getResults().getNumFound()));
        List facets = qr.getFacetFields();
        Pattern p = Pattern.compile("\\|");
        if (facets != null && facets.size() > 0) {
            logger.debug((Object)("Facets: " + facets.size() + "; facet #1: " + ((FacetField)facets.get(0)).getName()));
            for (FacetField facet : facets) {
                List facetEntries = facet.getValues();
                if (facetEntries == null || facetEntries.size() <= 0) continue;
                for (FacetField.Count fcount : facetEntries) {
                    String[] values;
                    TaxaCountDTO tcDTO = null;
                    if (fcount.getFacetField().getName().equals(NAMES_AND_LSID)) {
                        values = p.split(fcount.getName(), 5);
                        if (values.length >= 5) {
                            if (!"||||".equals(fcount.getName())) {
                                tcDTO = new TaxaCountDTO(values[0], Long.valueOf(fcount.getCount()));
                                tcDTO.setGuid(StringUtils.trimToNull((String)values[1]));
                                tcDTO.setCommonName(values[2]);
                                tcDTO.setKingdom(values[3]);
                                tcDTO.setFamily(values[4]);
                                if (StringUtils.isNotEmpty((String)tcDTO.getGuid())) {
                                    tcDTO.setRank(this.searchUtils.getTaxonSearch(tcDTO.getGuid())[1].split(":")[0]);
                                }
                            }
                        } else {
                            logger.debug((Object)("The values length: " + values.length + " :" + fcount.getName()));
                            tcDTO = new TaxaCountDTO(fcount.getName(), Long.valueOf(fcount.getCount()));
                        }
                        if (tcDTO == null) continue;
                        speciesCounts.add(tcDTO);
                        continue;
                    }
                    if (!fcount.getFacetField().getName().equals(COMMON_NAME_AND_LSID)) continue;
                    values = p.split(fcount.getName(), 6);
                    if (values.length >= 5) {
                        if (!"|||||".equals(fcount.getName())) {
                            tcDTO = new TaxaCountDTO(values[1], Long.valueOf(fcount.getCount()));
                            tcDTO.setGuid(StringUtils.trimToNull((String)values[2]));
                            tcDTO.setCommonName(values[0]);
                            tcDTO.setKingdom(values[values.length - 2]);
                            tcDTO.setFamily(values[values.length - 1]);
                            if (StringUtils.isNotEmpty((String)tcDTO.getGuid())) {
                                tcDTO.setRank(this.searchUtils.getTaxonSearch(tcDTO.getGuid())[1].split(":")[0]);
                            }
                        }
                    } else {
                        logger.debug((Object)("The values length: " + values.length + " :" + fcount.getName()));
                        tcDTO = new TaxaCountDTO(fcount.getName(), Long.valueOf(fcount.getCount()));
                    }
                    if (tcDTO == null) continue;
                    speciesCounts.add(tcDTO);
                }
            }
        }
        return speciesCounts;
    }

    public Map<String, Integer> getSourcesForQuery(SpatialSearchRequestParams searchParams) throws Exception {
        HashMap<String, Integer> uidStats = new HashMap<String, Integer>();
        SolrQuery solrQuery = new SolrQuery();
        this.formatSearchQuery(searchParams);
        logger.info((Object)("The query : " + searchParams.getFormattedQuery()));
        solrQuery.setQuery(this.buildSpatialQueryString(searchParams));
        solrQuery.setQueryType("standard");
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(true);
        solrQuery.setFacetMinCount(1);
        solrQuery.addFacetField(new String[]{"data_provider_uid"});
        solrQuery.addFacetField(new String[]{"data_resource_uid"});
        solrQuery.addFacetField(new String[]{"collection_uid"});
        solrQuery.addFacetField(new String[]{"institution_uid"});
        QueryResponse qr = this.runSolrQuery(solrQuery, searchParams.getFq(), Integer.valueOf(1), Integer.valueOf(0), "score", "asc");
        List facets = qr.getFacetFields();
        for (FacetField facet : facets) {
            if (facet.getValues() == null) continue;
            for (FacetField.Count ffc : facet.getValues()) {
                uidStats.put(ffc.getName(), new Integer((int)ffc.getCount()));
            }
        }
        return uidStats;
    }

    public Set<IndexFieldDTO> getIndexFieldDetails(String ... fields) throws Exception {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("qt", new String[]{"/admin/luke"});
        params.set("tr", new String[]{"luke.xsl"});
        if (fields != null) {
            params.set("fl", fields);
            params.set("numTerms", new String[]{"1"});
        } else {
            params.set("numTerms", new String[]{"0"});
        }
        QueryResponse response = this.getServer().query((SolrParams)params, this.queryMethod);
        return this.parseLukeResponse(response.toString(), fields != null);
    }

    public List<FacetResultDTO> getFacetCounts(SpatialSearchRequestParams searchParams) throws Exception {
        this.formatSearchQuery(searchParams);
        this.updateQueryContext((SearchRequestParams)searchParams);
        String queryString = this.buildSpatialQueryString(searchParams);
        searchParams.setFacet(Boolean.valueOf(false));
        searchParams.setPageSize(Integer.valueOf(0));
        SolrQuery query = this.initSolrQuery((SearchRequestParams)searchParams, false, null);
        query.setQuery(queryString);
        query.setFields(null);
        query.add("group", new String[]{"true"});
        query.add("group.ngroups", new String[]{"true"});
        query.add("group.limit", new String[]{"0"});
        for (String facet : searchParams.getFacets()) {
            query.add("group.field", new String[]{facet});
        }
        QueryResponse response = this.getServer().query((SolrParams)query, this.queryMethod);
        GroupResponse groupResponse = response.getGroupResponse();
        ArrayList<FacetResultDTO> facetResults = new ArrayList<FacetResultDTO>();
        for (GroupCommand gc : groupResponse.getValues()) {
            ArrayList<FieldResultDTO> r = new ArrayList<FieldResultDTO>();
            for (Group g : gc.getValues()) {
                r.add(new FieldResultDTO(g.getGroupValue(), g.getResult().getNumFound()));
            }
            facetResults.add(new FacetResultDTO(gc.getName(), r, gc.getNGroups()));
        }
        return facetResults;
    }

    public Set<IndexFieldDTO> getIndexedFields() throws Exception {
        if (this.indexFields == null) {
            this.indexFields = this.getIndexFieldDetails(null);
            this.indexFieldMap = new HashMap();
            for (IndexFieldDTO field : this.indexFields) {
                this.indexFieldMap.put(field.getName(), field);
            }
        }
        return this.indexFields;
    }

    private Set<IndexFieldDTO> parseLukeResponse(String str, boolean includeCounts) {
        String[] fieldsStr;
        LinkedHashSet<IndexFieldDTO> fieldList = includeCounts ? new LinkedHashSet() : new TreeSet();
        Pattern typePattern = Pattern.compile("(?:type=)([a-z]{1,})");
        Pattern schemaPattern = Pattern.compile("(?:schema=)([a-zA-Z\\-]{1,})");
        Pattern distinctPattern = Pattern.compile("(?:distinct=)([0-9]{1,})");
        for (String fieldStr : fieldsStr = str.split("fields=\\{")) {
            String[] fields;
            if (fieldStr == null || "".equals(fieldStr)) continue;
            for (String field : fields = includeCounts ? fieldStr.split("\\}\\},") : fieldStr.split("\\},")) {
                Matcher distinctMatcher;
                Matcher schemaMatcher;
                if (field == null || "".equals(field)) continue;
                IndexFieldDTO f = new IndexFieldDTO();
                String fieldName = field.split("=")[0];
                String type = null;
                String schema = null;
                Matcher typeMatcher = typePattern.matcher(field);
                if (typeMatcher.find(0)) {
                    type = typeMatcher.group(1);
                }
                if ((schemaMatcher = schemaPattern.matcher(field)).find(0)) {
                    schema = schemaMatcher.group(1);
                }
                if (schema != null && fieldName != null && !fieldName.startsWith("sensitive")) {
                    String description;
                    f.setName(fieldName);
                    f.setDataType(type);
                    f.setIndexed(schema.contains("I"));
                    f.setStored(schema.contains("S"));
                    if (this.layersPattern.matcher(fieldName).matches()) {
                        description = (String)this.layersService.getLayerNameMap().get(fieldName);
                        f.setDescription(description);
                    } else {
                        description = this.messageSource.getMessage("facet." + fieldName, null, "", Locale.getDefault());
                        if (!description.startsWith("facet.")) {
                            f.setDescription(description);
                        }
                    }
                    fieldList.add(f);
                }
                if (!(distinctMatcher = distinctPattern.matcher(field)).find(0)) continue;
                Integer distinct = Integer.parseInt(distinctMatcher.group(1));
                f.setNumberDistinctValues(distinct);
            }
        }
        return fieldList;
    }

    public SolrDocumentList findByFulltext(SpatialSearchRequestParams searchParams) throws Exception {
        SolrDocumentList sdl = null;
        try {
            this.formatSearchQuery(searchParams);
            this.updateQueryContext((SearchRequestParams)searchParams);
            String queryString = this.buildSpatialQueryString(searchParams);
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setQuery(queryString);
            solrQuery.setFields(new String[]{searchParams.getFl()});
            solrQuery.setFacet(false);
            solrQuery.setRows(searchParams.getPageSize());
            sdl = this.runSolrQuery(solrQuery, (SearchRequestParams)searchParams).getResults();
        }
        catch (SolrServerException ex) {
            logger.error((Object)("Problem communicating with SOLR server. " + ex.getMessage()), (Throwable)ex);
        }
        return sdl;
    }

    public Map<String, FieldStatsInfo> getStatistics(SpatialSearchRequestParams searchParams) throws Exception {
        String[] values = new String[2];
        try {
            this.formatSearchQuery(searchParams);
            this.updateQueryContext((SearchRequestParams)searchParams);
            String queryString = this.buildSpatialQueryString(searchParams);
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setQuery(queryString);
            for (String field : searchParams.getFacets()) {
                solrQuery.setGetFieldStatistics(field);
            }
            QueryResponse qr = this.runSolrQuery(solrQuery, (SearchRequestParams)searchParams);
            logger.debug((Object)qr.getFieldStatsInfo());
            return qr.getFieldStatsInfo();
        }
        catch (SolrServerException ex) {
            logger.error((Object)("Problem communicating with SOLR server. " + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    public List<LegendItem> getLegend(SpatialSearchRequestParams searchParams, String facetField, String[] cutpoints) throws Exception {
        List facetDates;
        Map facetq;
        ArrayList<LegendItem> legend = new ArrayList<LegendItem>();
        this.formatSearchQuery(searchParams);
        logger.info((Object)("search query: " + searchParams.getFormattedQuery()));
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQueryType("standard");
        solrQuery.setQuery(this.buildSpatialQueryString(searchParams));
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(true);
        if (cutpoints == null) {
            if (DECADE_FACET_NAME.equals(facetField)) {
                this.initDecadeBasedFacet(solrQuery, "occurrence_year");
            } else {
                solrQuery.addFacetField(new String[]{facetField});
            }
        } else {
            solrQuery.addFacetQuery("-" + facetField + ":[* TO *]");
            for (int i = 0; i < cutpoints.length; i += 2) {
                solrQuery.addFacetQuery(facetField + ":[" + cutpoints[i] + " TO " + cutpoints[i + 1] + "]");
            }
        }
        solrQuery.setFacetMinCount(1);
        solrQuery.setFacetLimit(-1);
        this.updateQueryContext((SearchRequestParams)searchParams);
        solrQuery.setFacetMissing(Boolean.valueOf(true));
        QueryResponse qr = this.runSolrQuery(solrQuery, searchParams.getFq(), Integer.valueOf(1), Integer.valueOf(0), "score", "asc");
        List facets = qr.getFacetFields();
        if (facets != null) {
            for (FacetField facet : facets) {
                List facetEntries = facet.getValues();
                if (!facet.getName().contains(facetField) || facetEntries == null || facetEntries.size() <= 0) continue;
                int i = 0;
                for (i = 0; i < facetEntries.size(); ++i) {
                    FacetField.Count fcount = (FacetField.Count)facetEntries.get(i);
                    String fq = facetField + ":\"" + fcount.getName() + QUOTE;
                    if (fcount.getName() == null) {
                        fq = "-" + facetField + ":[* TO *]";
                    }
                    legend.add(new LegendItem(fcount.getName(), fcount.getCount(), fq));
                }
            }
        }
        if ((facetq = qr.getFacetQuery()) != null && facetq.size() > 0) {
            for (Map.Entry es : facetq.entrySet()) {
                legend.add(new LegendItem((String)es.getKey(), (long)((Integer)es.getValue()).intValue(), (String)es.getKey()));
            }
        }
        if ((facetDates = qr.getFacetDates()) != null && facetDates.size() > 0) {
            FacetField ff = (FacetField)facetDates.get(0);
            String firstDate = null;
            for (FacetField.Count facetEntry : ff.getValues()) {
                String startDate = facetEntry.getName();
                if (firstDate == null) {
                    firstDate = startDate;
                }
                String finishDate = "*";
                if ("before".equals(startDate)) {
                    startDate = "*";
                    finishDate = firstDate;
                } else {
                    int startYear = Integer.parseInt(startDate.substring(0, 4));
                    finishDate = startYear - 1 + "-12-31T23:59:59Z";
                }
                legend.add(new LegendItem(facetEntry.getName(), facetEntry.getCount(), "occurrence_year:[" + startDate + " TO " + finishDate + "]"));
            }
        }
        return legend;
    }

    public FacetField getFacet(SpatialSearchRequestParams searchParams, String facet) throws Exception {
        this.formatSearchQuery(searchParams);
        logger.info((Object)("search query: " + searchParams.getFormattedQuery()));
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQueryType("standard");
        solrQuery.setQuery(this.buildSpatialQueryString(searchParams));
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(true);
        solrQuery.addFacetField(new String[]{facet});
        solrQuery.setFacetMinCount(1);
        solrQuery.setFacetLimit(-1);
        this.updateQueryContext((SearchRequestParams)searchParams);
        QueryResponse qr = this.runSolrQuery(solrQuery, searchParams.getFq(), Integer.valueOf(1), Integer.valueOf(0), "score", "asc");
        return (FacetField)qr.getFacetFields().get(0);
    }

    public List<DataProviderCountDTO> getDataProviderList(SpatialSearchRequestParams requestParams) throws Exception {
        ArrayList<DataProviderCountDTO> dataProviderList = new ArrayList<DataProviderCountDTO>();
        FacetField facet = this.getFacet(requestParams, "data_provider_uid");
        String[] oldFq = requestParams.getFacets();
        if (facet != null) {
            String[] dp = new String[1];
            List facetEntries = facet.getValues();
            if (facetEntries != null && facetEntries.size() > 0) {
                for (int i = 0; i < facetEntries.size(); ++i) {
                    FacetField.Count fcount = (FacetField.Count)facetEntries.get(i);
                    dp[0] = fcount.getAsFilterQuery();
                    requestParams.setFq(dp);
                    String dataProviderName = ((FacetField.Count)this.getFacet(requestParams, "data_provider").getValues().get(0)).getName();
                    dataProviderList.add(new DataProviderCountDTO(fcount.getName(), dataProviderName, fcount.getCount()));
                }
            }
        }
        requestParams.setFacets(oldFq);
        return dataProviderList;
    }

    public List<TaxaCountDTO> findAllSpecies(SpatialSearchRequestParams requestParams) throws Exception {
        this.formatSearchQuery(requestParams);
        ArrayList<String> facetFields = new ArrayList<String>();
        facetFields.add(NAMES_AND_LSID);
        logger.debug((Object)("The species count query " + requestParams.getFormattedQuery()));
        ArrayList fqList = new ArrayList();
        if (requestParams.getFq().length > 0 && requestParams.getFq()[0].length() > 0) {
            org.apache.commons.collections.CollectionUtils.addAll(fqList, (Object[])requestParams.getFq());
        }
        String query = this.buildSpatialQueryString(requestParams);
        List speciesWithCounts = this.getSpeciesCounts(query, fqList, facetFields, requestParams.getPageSize(), requestParams.getStart(), requestParams.getSort(), requestParams.getDir());
        return speciesWithCounts;
    }

    public Map<String, Integer> getOccurrenceCountsForTaxa(List<String> taxa) throws Exception {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQueryType("standard");
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(true);
        solrQuery.setFacetLimit(taxa.size());
        StringBuilder sb = new StringBuilder();
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        HashMap<String, String> lftToGuid = new HashMap<String, String>();
        for (String lsid : taxa) {
            String[] values = this.searchUtils.getTaxonSearch(lsid);
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append(values[0]);
            lftToGuid.put(values[0], lsid);
            solrQuery.add("facet.query", new String[]{values[0]});
        }
        solrQuery.setQuery(sb.toString());
        QueryResponse qr = this.runSolrQuery(solrQuery, null, Integer.valueOf(1), Integer.valueOf(0), "score", "asc");
        Map facetQueries = qr.getFacetQuery();
        for (String facet : facetQueries.keySet()) {
            String lsid = (String)lftToGuid.get(facet);
            Integer count = (Integer)facetQueries.get(facet);
            if (lsid == null || count == null) continue;
            counts.put(lsid, count);
        }
        logger.debug((Object)facetQueries);
        return counts;
    }

    public Integer getMaxMultiPartThreads() {
        return this.maxMultiPartThreads;
    }

    public void setMaxMultiPartThreads(Integer maxMultiPartThreads) {
        this.maxMultiPartThreads = maxMultiPartThreads;
    }

    public Integer getThrottle() {
        return this.throttle;
    }

    public void setThrottle(Integer throttle) {
        this.throttle = throttle;
    }

    static /* synthetic */ QueryResponse access$000(SearchDAOImpl x0, SolrQuery x1, String[] x2, Integer x3, Integer x4, String x5, String x6) throws SolrServerException {
        return x0.runSolrQuery(x1, x2, x3, x4, x5, x6);
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }

    static /* synthetic */ int access$200(SearchDAOImpl x0, Map x1, String[] x2, String[] x3, RecordWriter x4, QueryResponse x5, DownloadDetailsDTO x6, boolean x7, AtomicInteger x8) {
        return x0.processQueryResults(x1, x2, x3, x4, x5, x6, x7, x8);
    }

    static /* synthetic */ Integer access$300(SearchDAOImpl x0) {
        return x0.throttle;
    }
}

