/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.dao;

import au.org.ala.biocache.Config;
import au.org.ala.biocache.dao.QidCacheDAO;
import au.org.ala.biocache.dao.QidDAO;
import au.org.ala.biocache.model.Qid;
import au.org.ala.biocache.util.QidMissingException;
import au.org.ala.biocache.util.QidSizeException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component(value="qidCacheDao")
public class QidCacheDAOImpl
implements QidCacheDAO {
    private final Logger logger = Logger.getLogger(QidCacheDAOImpl.class);
    private long MAX_CACHE_SIZE = 0x6400000L;
    private long MIN_CACHE_SIZE = 0x3200000L;
    private long LARGEST_CACHEABLE_SIZE = 0x500000L;
    private ConcurrentHashMap<String, Qid> cache = new ConcurrentHashMap();
    private final Object counterLock = new Object();
    private long cacheSize;
    private CountDownLatch counter;
    private long triggerCleanSize = this.MIN_CACHE_SIZE + (this.MAX_CACHE_SIZE - this.MIN_CACHE_SIZE) / 2L;
    private Thread cacheCleaner;
    private Properties qidProperties;
    protected QidDAO qidDao = (QidDAO)Config.getInstance(QidDAO.class);

    public QidCacheDAOImpl() {
        this.counter = new CountDownLatch(1);
        this.cacheCleaner = new /* Unavailable Anonymous Inner Class!! */;
        this.cacheCleaner.start();
        try {
            this.qidProperties = new Properties();
            InputStream is = QidCacheDAOImpl.class.getResourceAsStream("/qid.properties");
            this.qidProperties.load(is);
            this.MAX_CACHE_SIZE = Long.parseLong(this.qidProperties.getProperty("MAX_CACHE_SIZE", String.valueOf(this.MAX_CACHE_SIZE)));
            this.MIN_CACHE_SIZE = Long.parseLong(this.qidProperties.getProperty("MIN_CACHE_SIZE", String.valueOf(this.MIN_CACHE_SIZE)));
            this.LARGEST_CACHEABLE_SIZE = Long.parseLong(this.qidProperties.getProperty("LARGEST_CACHEABLE_SIZE", String.valueOf(this.LARGEST_CACHEABLE_SIZE)));
            this.updateTriggerCleanSize();
            this.logger.info((Object)("MAX_CACHE_SIZE > " + this.MAX_CACHE_SIZE));
            this.logger.info((Object)("MIN_CACHE_SIZE > " + this.MIN_CACHE_SIZE));
        }
        catch (Exception e) {
            this.logger.error((Object)"cannot load qid.properties", (Throwable)e);
        }
    }

    public String put(String q, String displayQ, String wkt, double[] bbox, String[] fqs, long maxAge, String source) throws QidSizeException {
        Qid qid = new Qid(null, q, displayQ, wkt, bbox, 0L, fqs, maxAge, source);
        if ((long)qid.size() > this.LARGEST_CACHEABLE_SIZE) {
            throw new QidSizeException((long)qid.size());
        }
        this.save(qid);
        while (!this.put(qid)) {
        }
        return qid.getRowKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean put(Qid qid) {
        boolean runCleaner = false;
        Object object = this.counterLock;
        synchronized (object) {
            this.logger.debug((Object)("new cache size: " + this.cacheSize));
            if (this.cacheSize + (long)qid.size() > this.MAX_CACHE_SIZE) {
                runCleaner = true;
                this.logger.error((Object)"not putting qid");
            } else {
                if (this.cacheSize + (long)qid.size() > this.triggerCleanSize) {
                    this.counter.countDown();
                }
                this.cacheSize += (long)qid.size();
                this.logger.error((Object)"putting qid");
                this.cache.put(qid.getRowKey(), qid);
            }
        }
        if (runCleaner) {
            this.logger.error((Object)"cleaning qid cache");
            this.cleanCache();
            return false;
        }
        return true;
    }

    public Qid get(String key) throws QidMissingException {
        Qid obj = (Qid)this.cache.get(key);
        if (obj == null) {
            obj = this.load(key);
        }
        if (obj != null) {
            obj.setLastUse(System.currentTimeMillis());
        }
        if (obj == null) {
            throw new QidMissingException(key);
        }
        return obj;
    }

    public Qid getQidFromQuery(String query) throws QidMissingException {
        Matcher matcher;
        Qid qid = null;
        if (query.contains("qid:") && (matcher = qidPattern.matcher(query)).find()) {
            String value = matcher.group();
            qid = this.get(value.substring(4));
        }
        return qid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void cleanCache() {
        if (this.cacheSize < this.triggerCleanSize) {
            return;
        }
        ArrayList entries = new ArrayList(this.cache.entrySet());
        Collections.sort(entries, new /* Unavailable Anonymous Inner Class!! */);
        long size = 0L;
        int numberRemoved = 0;
        for (int i = 0; i < entries.size(); ++i) {
            if (size + (long)((Qid)((Map.Entry)entries.get(i)).getValue()).size() > this.MIN_CACHE_SIZE) {
                String key = (String)((Map.Entry)entries.get(i)).getKey();
                this.cache.remove(key);
                ++numberRemoved;
                continue;
            }
            size += (long)((Qid)((Map.Entry)entries.get(i)).getValue()).size();
        }
        Object object = this.counterLock;
        synchronized (object) {
            this.cacheSize -= this.MIN_CACHE_SIZE - size;
            size = this.cacheSize;
        }
        this.logger.debug((Object)("removed " + numberRemoved + " cached qids, new cache size " + size));
    }

    void save(Qid value) {
        try {
            this.qidDao.put(value);
        }
        catch (Exception e) {
            this.logger.error((Object)"faild to save qid to db", (Throwable)e);
        }
    }

    Qid load(String key) throws QidMissingException {
        Qid value = null;
        try {
            value = this.qidDao.get(key);
        }
        catch (Exception e) {
            this.logger.error((Object)("failed to find qid:" + key), (Throwable)e);
            throw new QidMissingException(key);
        }
        return value;
    }

    public void setMaxCacheSize(long sizeInBytes) {
        this.MAX_CACHE_SIZE = sizeInBytes;
        this.updateTriggerCleanSize();
    }

    public long getMaxCacheSize() {
        return this.MAX_CACHE_SIZE;
    }

    public void setMinCacheSize(long sizeInBytes) {
        this.MIN_CACHE_SIZE = sizeInBytes;
        this.updateTriggerCleanSize();
    }

    public long getMinCacheSize() {
        return this.MIN_CACHE_SIZE;
    }

    public void setLargestCacheableSize(long sizeInBytes) {
        this.LARGEST_CACHEABLE_SIZE = sizeInBytes;
    }

    public long getLargestCacheableSize() {
        return this.LARGEST_CACHEABLE_SIZE;
    }

    public long getSize() {
        return this.cacheSize;
    }

    void updateTriggerCleanSize() {
        this.triggerCleanSize = this.MIN_CACHE_SIZE + (this.MAX_CACHE_SIZE - this.MIN_CACHE_SIZE) / 2L;
        this.logger.debug((Object)("triggerCleanSize=" + this.triggerCleanSize + " MIN_CACHE_SIZE=" + this.MIN_CACHE_SIZE + " MAX_CACHE_SIZE=" + this.MAX_CACHE_SIZE));
    }

    static /* synthetic */ CountDownLatch access$000(QidCacheDAOImpl x0) {
        return x0.counter;
    }

    static /* synthetic */ Object access$100(QidCacheDAOImpl x0) {
        return x0.counterLock;
    }

    static /* synthetic */ long access$202(QidCacheDAOImpl x0, long x1) {
        x0.cacheSize = x1;
        return x0.cacheSize;
    }

    static /* synthetic */ long access$300(QidCacheDAOImpl x0) {
        return x0.MIN_CACHE_SIZE;
    }

    static /* synthetic */ CountDownLatch access$002(QidCacheDAOImpl x0, CountDownLatch x1) {
        x0.counter = x1;
        return x0.counter;
    }

    static /* synthetic */ Logger access$400(QidCacheDAOImpl x0) {
        return x0.logger;
    }
}

