/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.writer;

import au.org.ala.biocache.RecordWriter;
import au.org.ala.biocache.util.AlaFileUtils;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapeFileRecordWriter
implements RecordWriter {
    private static final Logger logger = LoggerFactory.getLogger(ShapeFileRecordWriter.class);
    private static final String tmpDownloadDirectory = "/data/biocache-download/tmp";
    private ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
    private SimpleFeatureBuilder featureBuilder;
    private SimpleFeatureType simpleFeature;
    private OutputStream outputStream;
    private File temporaryShapeFile;
    private int latIdx;
    private int longIdx;
    private SimpleFeatureCollection collection = FeatureCollections.newCollection();
    private Map<String, String> headerMappings = null;
    GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);

    public ShapeFileRecordWriter(String filename, OutputStream out, String[] header) {
        this.headerMappings = AlaFileUtils.generateShapeHeader((String[])header);
        this.outputStream = out;
        this.temporaryShapeFile = new File(tmpDownloadDirectory + File.separator + System.currentTimeMillis() + File.separator + filename + File.separator + filename + ".shp");
        try {
            FileUtils.forceMkdir((File)this.temporaryShapeFile.getParentFile());
            this.latIdx = ArrayUtils.indexOf((Object[])header, (Object)"latitude");
            this.longIdx = ArrayUtils.indexOf((Object[])header, (Object)"longitude");
            if (this.latIdx < 0 || this.longIdx < 0) {
                this.latIdx = ArrayUtils.indexOf((Object[])header, (Object)"decimalLatitude.p");
                this.longIdx = ArrayUtils.indexOf((Object[])header, (Object)"decimalLongitude.p");
            }
            this.simpleFeature = this.createFeatureType(this.headerMappings.keySet(), null);
            this.featureBuilder = new SimpleFeatureBuilder(this.simpleFeature);
            if (this.latIdx < 0 || this.longIdx < 0) {
                logger.error("The invalid header..." + StringUtils.join((Object[])header, (String)"|"));
                throw new IllegalArgumentException("A Shape File Export needs to include latitude and longitude in the headers.");
            }
        }
        catch (IOException e) {
            logger.error("Unable to create the temporary file necessary for ShapeFile exporting.", (Throwable)e);
        }
    }

    private SimpleFeatureType createFeatureType(Set<String> features, Class[] types) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Occurrence");
        builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.add("Location", Point.class);
        int i = 0;
        for (String feature : features) {
            Class type = types != null ? types[i] : String.class;
            String lcFeature = feature.toLowerCase();
            if (i != this.longIdx && i != this.latIdx) {
                builder.add(feature, type);
            }
            ++i;
        }
        SimpleFeatureType LOCATION = builder.buildFeatureType();
        logger.debug("FEATURES IN HEADER::: " + StringUtils.join(features, (String)"|"));
        logger.debug("LOCATION INFO:::" + LOCATION.getAttributeCount() + " " + i + " " + LOCATION.getAttributeDescriptors());
        return LOCATION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalise() {
        block16: {
            FileInputStream inputStream = null;
            try {
                HashMap<String, Serializable> params = new HashMap<String, Serializable>();
                params.put("url", this.temporaryShapeFile.toURI().toURL());
                params.put("create spatial index", Boolean.TRUE);
                ShapefileDataStore newDataStore = (ShapefileDataStore)this.dataStoreFactory.createNewDataStore(params);
                newDataStore.createSchema(this.simpleFeature);
                String typeName = newDataStore.getTypeNames()[0];
                SimpleFeatureSource featureSource = newDataStore.getFeatureSource(typeName);
                if (featureSource instanceof SimpleFeatureStore) {
                    SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
                    try {
                        featureStore.addFeatures((FeatureCollection)this.collection);
                    }
                    catch (Exception problem) {
                        logger.error(problem.getMessage(), (Throwable)problem);
                    }
                    String targetZipFile = this.temporaryShapeFile.getParentFile().getParent() + File.separator + this.temporaryShapeFile.getName().replace(".shp", ".zip");
                    AlaFileUtils.createZip((String)this.temporaryShapeFile.getParent(), (String)targetZipFile);
                    inputStream = new FileInputStream(targetZipFile);
                    logger.info("Copying Shape zip file to outputstream");
                    IOUtils.copy((InputStream)inputStream, (OutputStream)this.outputStream);
                    FileUtils.deleteDirectory((File)this.temporaryShapeFile.getParentFile().getParentFile());
                    break block16;
                }
                logger.error(typeName + " does not support read/write access");
            }
            catch (IOException e) {
                logger.error("Unable to create ShapeFile", (Throwable)e);
            }
            finally {
                try {
                    this.outputStream.flush();
                    IOUtils.closeQuietly(inputStream);
                }
                catch (Exception e) {
                    logger.error("Unable to flush the file ", (Throwable)e);
                }
            }
        }
    }

    public void write(String[] record) {
        if (StringUtils.isNotBlank((String)record[this.longIdx]) && StringUtils.isNotBlank((String)record[this.latIdx])) {
            double longitude = Double.parseDouble(record[this.longIdx]);
            double latitude = Double.parseDouble(record[this.latIdx]);
            Point point = this.geometryFactory.createPoint(new Coordinate(longitude, latitude));
            this.featureBuilder.add((Object)point);
            int i = 0;
            int max = this.simpleFeature.getAttributeCount() + 2;
            for (String value : record) {
                if (i != this.longIdx && i != this.latIdx && i < max) {
                    this.featureBuilder.add((Object)value);
                }
                ++i;
            }
            SimpleFeature feature = this.featureBuilder.buildFeature(null);
            this.collection.add((Feature)feature);
        } else {
            logger.debug("Not adding record with missing lat/long: " + record[0]);
        }
    }

    public Map<String, String> getHeaderMappings() {
        return this.headerMappings;
    }
}

