/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.dao.SearchDAO;
import au.org.ala.biocache.dto.IndexFieldDTO;
import au.org.ala.biocache.dto.SpatialSearchRequestParams;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.encoders.EncoderUtil;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ScatterplotController {
    private static Logger logger = Logger.getLogger(ScatterplotController.class);
    private static final int PAGE_SIZE = 100000000;
    private static final String DEFAULT_SCATTERPLOT_TITLE = " ";
    private static final String DEFAULT_SCATTERPLOT_HEIGHT = "256";
    private static final String DEFAULT_SCATTERPLOT_WIDTH = "256";
    private static final String DEFAULT_SCATTERPLOT_POINTCOLOUR = "0000FF";
    private static final String DEFAULT_SCATTERPLOT_POINTRADIUS = "3";
    private static final String[] VALID_DATATYPES = new String[]{"double", "int", "long"};
    @Inject
    protected SearchDAO searchDAO;

    @RequestMapping(value={"/scatterplot"}, method={RequestMethod.GET})
    public void scatterplot(SpatialSearchRequestParams requestParams, @RequestParam(value="x", required=true) String x, @RequestParam(value="y", required=true) String y, @RequestParam(value="height", required=false, defaultValue="256") Integer height, @RequestParam(value="width", required=false, defaultValue="256") Integer width, @RequestParam(value="title", required=false, defaultValue=" ") String title, @RequestParam(value="pointcolour", required=false, defaultValue="0000FF") String pointcolour, @RequestParam(value="pointradius", required=false, defaultValue="3") Double pointradius, HttpServletResponse response) throws Exception {
        JFreeChart jChart = this.makeScatterplot(requestParams, x, y, title, pointcolour, pointradius);
        ChartRenderingInfo chartRenderingInfo = new ChartRenderingInfo();
        BufferedImage bi = jChart.createBufferedImage(width.intValue(), height.intValue(), 3, chartRenderingInfo);
        byte[] bytes = EncoderUtil.encode((BufferedImage)bi, (String)"png", (boolean)true);
        response.setContentType("image/png");
        response.getOutputStream().write(bytes);
    }

    @RequestMapping(value={"/scatterplot/point"}, method={RequestMethod.GET})
    public Map scatterplotPointInfo(SpatialSearchRequestParams requestParams, @RequestParam(value="x", required=true) String x, @RequestParam(value="y", required=true) String y, @RequestParam(value="height", required=false, defaultValue="256") Integer height, @RequestParam(value="width", required=false, defaultValue="256") Integer width, @RequestParam(value="title", required=false, defaultValue=" ") String title, @RequestParam(value="pointx1", required=true) Integer pointx1, @RequestParam(value="pointy1", required=true) Integer pointy1, @RequestParam(value="pointx2", required=true) Integer pointx2, @RequestParam(value="pointy2", required=true) Integer pointy2) throws Exception {
        JFreeChart jChart = this.makeScatterplot(requestParams, x, y, title, "000000", Double.valueOf(1.0));
        ChartRenderingInfo chartRenderingInfo = new ChartRenderingInfo();
        BufferedImage bi = jChart.createBufferedImage(width.intValue(), height.intValue(), 3, chartRenderingInfo);
        XYPlot plot = (XYPlot)jChart.getPlot();
        double tx1 = plot.getRangeAxis().java2DToValue((double)pointx1.intValue(), chartRenderingInfo.getPlotInfo().getDataArea(), RectangleEdge.BOTTOM);
        double tx2 = plot.getRangeAxis().java2DToValue((double)pointx2.intValue(), chartRenderingInfo.getPlotInfo().getDataArea(), RectangleEdge.BOTTOM);
        double ty1 = plot.getDomainAxis().java2DToValue((double)pointy1.intValue(), chartRenderingInfo.getPlotInfo().getDataArea(), RectangleEdge.LEFT);
        double ty2 = plot.getDomainAxis().java2DToValue((double)pointy2.intValue(), chartRenderingInfo.getPlotInfo().getDataArea(), RectangleEdge.LEFT);
        double x1 = Math.min(tx1, tx2);
        double x2 = Math.max(tx1, tx2);
        double y1 = Math.min(ty1, ty2);
        double y2 = Math.max(ty1, ty2);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("xaxis_pixel_selection", new int[]{pointx1, pointx2});
        map.put("yaxis_pixel_selection", new int[]{pointy1, pointy2});
        map.put("xaxis", x);
        map.put("yaxis", y);
        map.put("xaxis_range", new double[]{x1, x2});
        map.put("yaxis_range", new double[]{y1, y2});
        return map;
    }

    JFreeChart makeScatterplot(SpatialSearchRequestParams requestParams, String x, String y, String title, String pointcolour, Double pointradius) throws Exception {
        String displayNameX = null;
        String displayNameY = null;
        for (IndexFieldDTO indexFieldDTO : this.searchDAO.getIndexFieldDetails(new String[]{x})) {
            if (!Arrays.asList(VALID_DATATYPES).contains(indexFieldDTO.getDataType())) {
                throw new Exception("Invalid datatype: " + indexFieldDTO.getDataType() + " for x: " + x);
            }
            if (!indexFieldDTO.isStored()) {
                throw new Exception("Cannot use x: " + x + ".  It is not a stored field.");
            }
            displayNameX = indexFieldDTO.getDescription();
        }
        for (IndexFieldDTO indexFieldDTO : this.searchDAO.getIndexFieldDetails(new String[]{y})) {
            if (!Arrays.asList(VALID_DATATYPES).contains(indexFieldDTO.getDataType())) {
                throw new Exception("Invalid datatype: " + indexFieldDTO.getDataType() + " for y: " + y);
            }
            if (!indexFieldDTO.isStored()) {
                throw new Exception("Cannot use y: " + y + ".  It is not a stored field.");
            }
            displayNameY = indexFieldDTO.getDescription();
        }
        if (displayNameX == null) {
            throw new Exception("Unknown value for x: " + x);
        }
        if (displayNameY == null) {
            throw new Exception("Unknown value for y: " + y);
        }
        requestParams.setPageSize(Integer.valueOf(100000000));
        requestParams.setFl(x + "," + y);
        SolrDocumentList sdl = this.searchDAO.findByFulltext(requestParams);
        int size = sdl.size();
        double[][] data = new double[2][size];
        int count = 0;
        for (int i = 0; i < size; ++i) {
            try {
                Object a = ((SolrDocument)sdl.get(i)).getFieldValue(y);
                Object b = ((SolrDocument)sdl.get(i)).getFieldValue(x);
                data[1][i] = Double.parseDouble(String.valueOf(((SolrDocument)sdl.get(i)).getFieldValue(y)));
                data[0][i] = a instanceof Double ? (Double)a : Double.parseDouble(String.valueOf(a));
                data[1][i] = b instanceof Double ? (Double)b : Double.parseDouble(String.valueOf(b));
                ++count;
                continue;
            }
            catch (Exception e) {
                data[0][i] = Double.NaN;
                data[1][i] = Double.NaN;
            }
        }
        if (count == 0) {
            throw new Exception("valid records found for these input parameters");
        }
        DefaultXYDataset xyDataset = new DefaultXYDataset();
        xyDataset.addSeries((Comparable)((Object)"series"), data);
        JFreeChart jChart = ChartFactory.createScatterPlot((String)(title.equals(DEFAULT_SCATTERPLOT_TITLE) ? requestParams.getDisplayString() : title), (String)displayNameX, (String)displayNameY, (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)false, (boolean)false);
        jChart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = (XYPlot)jChart.getPlot();
        Font axisfont = new Font("Arial", 0, 10);
        Font titlefont = new Font("Arial", 1, 11);
        plot.getDomainAxis().setLabelFont(axisfont);
        plot.getDomainAxis().setTickLabelFont(axisfont);
        plot.getRangeAxis().setLabelFont(axisfont);
        plot.getRangeAxis().setTickLabelFont(axisfont);
        plot.setBackgroundPaint((Paint)new Color(220, 220, 220));
        jChart.getTitle().setFont(titlefont);
        Color c = new Color(Integer.parseInt(pointcolour, 16));
        plot.getRenderer().setSeriesPaint(0, (Paint)c);
        plot.getRenderer().setSeriesShape(0, (Shape)new Ellipse2D.Double(-pointradius.doubleValue(), -pointradius.doubleValue(), pointradius * 2.0, pointradius * 2.0));
        return jChart;
    }
}

