/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.web;

import au.org.ala.biocache.parser.AdHocParser;
import au.org.ala.biocache.parser.ParsedRecord;
import au.org.ala.biocache.web.UploadController;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ParserController {
    private static final Logger logger = Logger.getLogger(UploadController.class);

    @RequestMapping(value={"/parser/areDwcTerms"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean areDwcTerms(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ObjectMapper om = new ObjectMapper();
        try {
            ServletInputStream input = request.getInputStream();
            List terms = (List)om.readValue((InputStream)input, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            input.close();
            String[] termArray = terms.toArray(new String[0]);
            return AdHocParser.areColumnHeaders((String[])termArray);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            response.sendError(400);
            return false;
        }
    }

    @RequestMapping(value={"/parser/matchTerms"}, method={RequestMethod.POST})
    @ResponseBody
    public String[] guessFieldTypes(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ObjectMapper om = new ObjectMapper();
        try {
            ServletInputStream input = request.getInputStream();
            List terms = (List)om.readValue((InputStream)input, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            input.close();
            String[] termArray = terms.toArray(new String[0]);
            return AdHocParser.guessColumnHeadersArray((String[])termArray);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            response.sendError(400);
            return null;
        }
    }

    @RequestMapping(value={"/parser/mapTerms"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, String> guessFieldTypesWithOriginal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ObjectMapper om = new ObjectMapper();
        try {
            ServletInputStream input = request.getInputStream();
            List terms = (List)om.readValue((InputStream)input, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            input.close();
            String[] termArray = terms.toArray(new String[0]);
            String[] matchedTerms = AdHocParser.mapColumnHeadersArray((String[])termArray);
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (int i = 0; i < termArray.length; ++i) {
                map.put(termArray[i], matchedTerms[i]);
            }
            return map;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            response.sendError(400);
            return null;
        }
    }

    @RequestMapping(value={"/process/adhoc"}, method={RequestMethod.POST})
    @ResponseBody
    public ParsedRecord processRecord(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ObjectMapper om = new ObjectMapper();
        try {
            ServletInputStream input = request.getInputStream();
            String json = IOUtils.toString((InputStream)input);
            logger.debug((Object)json);
            String utf8String = new String(json.getBytes(), "UTF-8");
            LinkedHashMap record = (LinkedHashMap)om.readValue(utf8String, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            input.close();
            logger.debug((Object)"Mapping column headers...");
            String[] headers = AdHocParser.mapOrReturnColumnHeadersArray((String[])record.keySet().toArray(new String[0]));
            logger.debug((Object)"Processing line...");
            return AdHocParser.processLineArrays((String[])headers, (String[])record.values().toArray(new String[0]));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            response.sendError(400);
            return null;
        }
    }
}

