/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.dto.PointType;
import au.org.ala.biocache.util.ParamsCache;
import au.org.ala.biocache.util.WMSTile;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class WMSCache {
    private static final Logger logger = Logger.getLogger(WMSCache.class);
    static long MAX_CACHE_SIZE = 0x6400000L;
    static long MIN_CACHE_SIZE = 0x3200000L;
    static long LARGEST_CACHEABLE_SIZE = 0x3200000L;
    static long MAX_AGE = 3600000L;
    static ConcurrentHashMap<String, WMSTile> cache = new ConcurrentHashMap();
    static final Object counterLock = new Object();
    static long cacheSize;
    static CountDownLatch counter;
    static final Thread cacheCleaner;
    static Properties wmsProperties;
    static final Object getLock;
    static long triggerCleanSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean put(String q, String colourMode, PointType pointType, WMSTile wco) {
        if (WMSCache.isFull() || !WMSCache.isEnabled()) {
            return false;
        }
        wco.updateSize();
        if (wco.getSize() < LARGEST_CACHEABLE_SIZE) {
            Object object = counterLock;
            synchronized (object) {
                if (cacheSize + wco.getSize() > MAX_CACHE_SIZE) {
                    return false;
                }
                cache.put(WMSCache.getKey((String)q, (String)colourMode, (PointType)pointType), wco);
                logger.debug((Object)("new cache size: " + (cacheSize += wco.getSize())));
                if (cacheSize > triggerCleanSize) {
                    counter.countDown();
                }
            }
            wco.setCached(true);
            return true;
        }
        return false;
    }

    public static String getKey(String query, String colourmode, PointType pointType) {
        return query + "|" + colourmode + "|" + pointType.getLabel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WMSTile get(String query, String colourmode, PointType pointType) {
        String key = WMSCache.getKey((String)query, (String)colourmode, (PointType)pointType);
        WMSTile obj = null;
        Object object = getLock;
        synchronized (object) {
            obj = (WMSTile)cache.get(key);
            if (obj != null && obj.getCreated() + MAX_AGE < System.currentTimeMillis()) {
                cache.remove(key);
                obj = null;
            }
            if (obj == null) {
                obj = new WMSTile();
                cache.put(key, obj);
            }
        }
        if (obj != null) {
            obj.lastUse = System.currentTimeMillis();
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cleanCache() {
        ArrayList entries = new ArrayList(cache.entrySet());
        Collections.sort(entries, new /* Unavailable Anonymous Inner Class!! */);
        long size = 0L;
        int numberRemoved = 0;
        for (int i = 0; i < entries.size(); ++i) {
            if (size + ((WMSTile)((Map.Entry)entries.get(i)).getValue()).getSize() > MIN_CACHE_SIZE) {
                String key = (String)((Map.Entry)entries.get(i)).getKey();
                cache.remove(key);
                ++numberRemoved;
                continue;
            }
            size += ((WMSTile)((Map.Entry)entries.get(i)).getValue()).getSize();
        }
        Object object = counterLock;
        synchronized (object) {
            cacheSize -= MIN_CACHE_SIZE - size;
            size = cacheSize;
        }
        logger.debug((Object)("removed " + numberRemoved + " cached wms points, new cache size " + size));
    }

    public static boolean isEnabled() {
        return MAX_CACHE_SIZE > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void empty() {
        Object object = counterLock;
        synchronized (object) {
            cacheSize = 0L;
            counter = new CountDownLatch(1);
        }
        cache.clear();
    }

    public static void remove(String q, String colourMode, PointType pointType) {
        cache.remove(WMSCache.getKey((String)q, (String)colourMode, (PointType)pointType));
    }

    public static boolean isCachable(WMSTile wco, int occurrenceCount, boolean hasCounts) {
        long size = WMSTile.sizeOf((int)occurrenceCount, (boolean)hasCounts);
        if (size > LARGEST_CACHEABLE_SIZE) {
            if (wco != null) {
                wco.setSize(size);
            }
            return false;
        }
        return true;
    }

    public static boolean isFull() {
        return cacheSize >= MAX_CACHE_SIZE;
    }

    public static void setMaxCacheSize(long sizeInBytes) {
        MAX_CACHE_SIZE = sizeInBytes;
        WMSCache.updateTriggerCleanSize();
    }

    public static long getMaxCacheSize() {
        return MAX_CACHE_SIZE;
    }

    public static void setMinCacheSize(long sizeInBytes) {
        MIN_CACHE_SIZE = sizeInBytes;
        WMSCache.updateTriggerCleanSize();
    }

    public static long getMinCacheSize() {
        return MIN_CACHE_SIZE;
    }

    public static void setLargestCacheableSize(long sizeInBytes) {
        LARGEST_CACHEABLE_SIZE = sizeInBytes;
    }

    public static long getLargestCacheableSize() {
        return LARGEST_CACHEABLE_SIZE;
    }

    static long getSize() {
        return cacheSize;
    }

    static void updateTriggerCleanSize() {
        triggerCleanSize = MIN_CACHE_SIZE + (MAX_CACHE_SIZE - MIN_CACHE_SIZE) / 2L;
        logger.debug((Object)("triggerCleanSize=" + triggerCleanSize + " MIN_CACHE_SIZE=" + MIN_CACHE_SIZE + " MAX_CACHE_SIZE=" + MAX_CACHE_SIZE));
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static {
        getLock = new Object();
        triggerCleanSize = MIN_CACHE_SIZE + (MAX_CACHE_SIZE - MIN_CACHE_SIZE) / 2L;
        counter = new CountDownLatch(1);
        cacheCleaner = new /* Unavailable Anonymous Inner Class!! */;
        cacheCleaner.start();
        try {
            wmsProperties = new Properties();
            InputStream is = ParamsCache.class.getResourceAsStream("/wms.properties");
            wmsProperties.load(is);
            MAX_CACHE_SIZE = Long.parseLong(wmsProperties.getProperty("MAX_CACHE_SIZE", String.valueOf(MAX_CACHE_SIZE)));
            MIN_CACHE_SIZE = Long.parseLong(wmsProperties.getProperty("MIN_CACHE_SIZE", String.valueOf(MIN_CACHE_SIZE)));
            LARGEST_CACHEABLE_SIZE = Long.parseLong(wmsProperties.getProperty("LARGEST_CACHEABLE_SIZE", String.valueOf(LARGEST_CACHEABLE_SIZE)));
            MAX_AGE = Long.parseLong(wmsProperties.getProperty("MAX_AGE", String.valueOf(MAX_AGE)));
            logger.info((Object)("MAX_CACHE_SIZE > " + MAX_CACHE_SIZE));
            logger.info((Object)("MIN_CACHE_SIZE > " + MIN_CACHE_SIZE));
            logger.info((Object)("LARGEST_CACHEABLE_SIZE > " + LARGEST_CACHEABLE_SIZE));
            logger.info((Object)("MAX_AGE > " + MAX_AGE));
        }
        catch (Exception e) {
            logger.error((Object)"cannot load wms.properties", (Throwable)e);
        }
    }
}

