/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.util.ParamsCache;
import au.org.ala.biocache.util.ParamsCacheMissingException;
import au.org.ala.biocache.util.ParamsCacheObject;
import au.org.ala.biocache.util.ParamsCacheSizeException;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

/*
 * Exception performing whole class analysis ignored.
 */
public class ParamsCache {
    private static final Logger logger = Logger.getLogger(ParamsCache.class);
    static long MAX_CACHE_SIZE = 0x6400000L;
    static long MIN_CACHE_SIZE = 0x3200000L;
    static long LARGEST_CACHEABLE_SIZE = 0x500000L;
    static String TEMP_FILE_PATH = System.getProperty("java.io.tmpdir");
    static final String FILE_PREFIX = "qid_";
    static long MAX_FILE_AGE = 86400000L;
    static ConcurrentHashMap<Long, ParamsCacheObject> cache = new ConcurrentHashMap();
    static Long lastKey = 0L;
    static final Object counterLock = new Object();
    static long cacheSize;
    static CountDownLatch counter;
    static long triggerCleanSize;
    static final Thread cacheCleaner;
    static Properties qidProperties;
    static final ObjectMapper jsonMapper;
    public static Pattern qidPattern;

    public static long put(String q, String displayQ, String wkt, double[] bbox, String[] fqs) throws ParamsCacheSizeException {
        long key = ParamsCache.getNextKey();
        ParamsCacheObject pco = new ParamsCacheObject(key, q, displayQ, wkt, bbox, fqs);
        if (pco.getSize() > LARGEST_CACHEABLE_SIZE) {
            throw new ParamsCacheSizeException(pco.getSize());
        }
        ParamsCache.save((long)key, (ParamsCacheObject)pco);
        while (!ParamsCache.put((long)key, (ParamsCacheObject)pco)) {
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean put(long key, ParamsCacheObject pco) {
        boolean runCleaner = false;
        Object object = counterLock;
        synchronized (object) {
            logger.debug((Object)("new cache size: " + cacheSize));
            if (cacheSize + pco.getSize() > MAX_CACHE_SIZE) {
                runCleaner = true;
            } else {
                if (cacheSize + pco.getSize() > triggerCleanSize) {
                    counter.countDown();
                }
                cacheSize += pco.getSize();
                cache.put(key, pco);
            }
        }
        if (runCleaner) {
            ParamsCache.cleanCache();
            return false;
        }
        return true;
    }

    public static ParamsCacheObject get(long key) throws ParamsCacheMissingException {
        ParamsCacheObject obj = (ParamsCacheObject)cache.get(key);
        if (obj == null) {
            obj = ParamsCache.load((long)key);
        }
        if (obj != null) {
            obj.lastUse = System.currentTimeMillis();
        }
        if (obj == null) {
            throw new ParamsCacheMissingException(key);
        }
        return obj;
    }

    public static ParamsCacheObject getParamCacheObjectFromQuery(String query) throws ParamsCacheMissingException {
        if (query.contains("qid:")) {
            Matcher matcher = qidPattern.matcher(query);
            long qid = 0L;
            if (matcher.find()) {
                String value = matcher.group();
                qid = Long.parseLong(value.substring(4));
                ParamsCacheObject pco = ParamsCache.get((long)qid);
                return pco;
            }
        }
        return null;
    }

    static synchronized long getNextKey() {
        long nextKey = System.currentTimeMillis();
        if (nextKey <= lastKey) {
            nextKey = lastKey + 1L;
        }
        lastKey = nextKey;
        return lastKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void cleanCache() {
        if (cacheSize < triggerCleanSize) {
            return;
        }
        ArrayList entries = new ArrayList(cache.entrySet());
        Collections.sort(entries, new /* Unavailable Anonymous Inner Class!! */);
        long size = 0L;
        int numberRemoved = 0;
        for (int i = 0; i < entries.size(); ++i) {
            if (size + ((ParamsCacheObject)((Map.Entry)entries.get(i)).getValue()).getSize() > MIN_CACHE_SIZE) {
                long key = (Long)((Map.Entry)entries.get(i)).getKey();
                cache.remove(key);
                ++numberRemoved;
                continue;
            }
            size += ((ParamsCacheObject)((Map.Entry)entries.get(i)).getValue()).getSize();
        }
        Object object = counterLock;
        synchronized (object) {
            cacheSize -= MIN_CACHE_SIZE - size;
            size = cacheSize;
        }
        logger.debug((Object)("removed " + numberRemoved + " cached qids, new cache size " + size));
    }

    public static void deleteOldParamFiles() {
        try {
            File[] filesToRemove;
            File dir = new File(TEMP_FILE_PATH);
            3 ff = new /* Unavailable Anonymous Inner Class!! */;
            for (File f : filesToRemove = dir.listFiles((FileFilter)ff)) {
                FileUtils.deleteQuietly((File)f);
                logger.info((Object)("removing cached query file: " + f.getName()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static File getFile(long key) {
        return new File(TEMP_FILE_PATH + File.separator + "qid_" + key + ".json");
    }

    static void save(long key, ParamsCacheObject value) {
        try {
            File file = ParamsCache.getFile((long)key);
            jsonMapper.writeValue(file, (Object)value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ParamsCacheObject load(long key) throws ParamsCacheMissingException {
        ParamsCacheObject value = null;
        File file = ParamsCache.getFile((long)key);
        if (!file.exists()) throw new ParamsCacheMissingException(key);
        try {
            value = (ParamsCacheObject)jsonMapper.readValue(file, ParamsCacheObject.class);
            if (value == null || value.getSize() >= LARGEST_CACHEABLE_SIZE) return value;
            file.setLastModified(System.currentTimeMillis());
            while (!ParamsCache.put((long)key, (ParamsCacheObject)value)) {
            }
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return value;
        }
    }

    public static void setMaxCacheSize(long sizeInBytes) {
        MAX_CACHE_SIZE = sizeInBytes;
        ParamsCache.updateTriggerCleanSize();
    }

    public static long getMaxCacheSize() {
        return MAX_CACHE_SIZE;
    }

    public static void setMinCacheSize(long sizeInBytes) {
        MIN_CACHE_SIZE = sizeInBytes;
        ParamsCache.updateTriggerCleanSize();
    }

    public static long getMinCacheSize() {
        return MIN_CACHE_SIZE;
    }

    public static void setLargestCacheableSize(long sizeInBytes) {
        LARGEST_CACHEABLE_SIZE = sizeInBytes;
    }

    public static long getLargestCacheableSize() {
        return LARGEST_CACHEABLE_SIZE;
    }

    static long getSize() {
        return cacheSize;
    }

    public static void setTempFilePath(String path) {
        TEMP_FILE_PATH = path;
    }

    public static String getTempFilePath() {
        return TEMP_FILE_PATH;
    }

    static void updateTriggerCleanSize() {
        triggerCleanSize = MIN_CACHE_SIZE + (MAX_CACHE_SIZE - MIN_CACHE_SIZE) / 2L;
        logger.debug((Object)("triggerCleanSize=" + triggerCleanSize + " MIN_CACHE_SIZE=" + MIN_CACHE_SIZE + " MAX_CACHE_SIZE=" + MAX_CACHE_SIZE));
    }

    public static void setMaxFileAge(long ageInMs) {
        MAX_FILE_AGE = ageInMs;
    }

    public static long getMaxFileAge() {
        return MAX_FILE_AGE;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static {
        triggerCleanSize = MIN_CACHE_SIZE + (MAX_CACHE_SIZE - MIN_CACHE_SIZE) / 2L;
        jsonMapper = new ObjectMapper();
        qidPattern = Pattern.compile("qid:(\")?[0-9]*(\")?");
        counter = new CountDownLatch(1);
        cacheCleaner = new /* Unavailable Anonymous Inner Class!! */;
        cacheCleaner.start();
        try {
            qidProperties = new Properties();
            InputStream is = ParamsCache.class.getResourceAsStream("/qid.properties");
            qidProperties.load(is);
            MAX_CACHE_SIZE = Long.parseLong(qidProperties.getProperty("MAX_CACHE_SIZE", String.valueOf(MAX_CACHE_SIZE)));
            MIN_CACHE_SIZE = Long.parseLong(qidProperties.getProperty("MIN_CACHE_SIZE", String.valueOf(MIN_CACHE_SIZE)));
            LARGEST_CACHEABLE_SIZE = Long.parseLong(qidProperties.getProperty("LARGEST_CACHEABLE_SIZE", String.valueOf(LARGEST_CACHEABLE_SIZE)));
            ParamsCache.updateTriggerCleanSize();
            TEMP_FILE_PATH = qidProperties.getProperty("TEMP_FILE_PATH", TEMP_FILE_PATH);
            File tfp = new File(TEMP_FILE_PATH);
            if (!tfp.exists() && !tfp.mkdirs()) {
                logger.error((Object)("cannot find or create directory for qid files: " + TEMP_FILE_PATH));
            }
            logger.info((Object)("MAX_CACHE_SIZE > " + MAX_CACHE_SIZE));
            logger.info((Object)("MIN_CACHE_SIZE > " + MIN_CACHE_SIZE));
            logger.info((Object)("TEMP_FILE_PATH > " + TEMP_FILE_PATH));
        }
        catch (Exception e) {
            logger.error((Object)"cannot load qid.properties", (Throwable)e);
        }
    }
}

