/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.Store;
import au.org.ala.biocache.dto.IndexFieldDTO;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadFields {
    private static final Logger logger = LoggerFactory.getLogger(DownloadFields.class);
    private String defaultFields = "uuid,dataResourceUid,catalogNumber,taxonConceptID.p,scientificName,vernacularName,scientificName.p,taxonRank.p,vernacularName.p,kingdom.p,phylum.p,classs.p,order.p,family.p,genus.p,species.p,subspecies.p,institutionCode,collectionCode,longitude.p,latitude.p,coordinatePrecision,country.p,ibra.p,imcra.p,stateProvince.p,lga.p,minimumElevationInMeters,maximumElevationInMeters,minimumDepthInMeters,maximumDepthInMeters,year.p,month.p,day.p,eventDate.p,eventTime.p,basisOfRecord,typeStatus.p,sex,preparations";
    private Properties downloadProperties;
    private Map<String, IndexFieldDTO> indexFieldMaps;

    public DownloadFields(Set<IndexFieldDTO> indexFields) {
        try {
            this.downloadProperties = new Properties();
            InputStream is = this.getClass().getResourceAsStream("/download.properties");
            this.downloadProperties.load(is);
            this.indexFieldMaps = new TreeMap();
            for (IndexFieldDTO field : indexFields) {
                this.indexFieldMaps.put(field.getName(), field);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (this.downloadProperties.getProperty("fields") == null) {
            this.downloadProperties.setProperty("fields", this.defaultFields);
        }
    }

    public String getFields() {
        return this.downloadProperties.getProperty("fields");
    }

    public String[] getHeader(String[] values, boolean useSuffix) {
        String[] header = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            String v = this.downloadProperties.getProperty(values[i]);
            header[i] = v != null ? v : this.generateTitle(values[i], useSuffix);
        }
        return header;
    }

    private String generateTitle(String value, boolean useSuffix) {
        String suffix = "";
        if (value.endsWith(".p")) {
            suffix = " - Processed";
            value = value.replaceAll("\\.p", "");
        }
        value = StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)value), (String)" ");
        if (useSuffix) {
            value = value + suffix;
        }
        return value;
    }

    public List<String>[] getIndexFields(String[] values) {
        LinkedList<String> mappedNames = new LinkedList<String>();
        LinkedList<String> headers = new LinkedList<String>();
        LinkedList<String> unmappedNames = new LinkedList<String>();
        Map storageFieldMap = Store.getStorageFieldMap();
        for (String value : values) {
            String indexName = storageFieldMap.containsKey(value) ? (String)storageFieldMap.get(value) : value;
            IndexFieldDTO field = (IndexFieldDTO)this.indexFieldMaps.get(indexName);
            if (field != null && field.isStored() || value.startsWith("sensitive")) {
                mappedNames.add(indexName);
                headers.add(this.downloadProperties.getProperty(value, this.generateTitle(value, true)));
                continue;
            }
            unmappedNames.add(indexName);
        }
        return new List[]{mappedNames, unmappedNames, headers};
    }
}

