/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.util.CollectionsCache;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestOperations;

@Component(value="collectionsCache")
public class CollectionsCache {
    protected LinkedHashMap<String, String> dataResources = new LinkedHashMap();
    protected LinkedHashMap<String, String> dataProviders = new LinkedHashMap();
    protected LinkedHashMap<String, String> tempDataResources = new LinkedHashMap();
    protected LinkedHashMap<String, Integer> downloadLimits = new LinkedHashMap();
    protected LinkedHashMap<String, String> institutions = new LinkedHashMap();
    protected LinkedHashMap<String, String> collections = new LinkedHashMap();
    protected LinkedHashMap<String, String> dataHubs = new LinkedHashMap();
    protected List<String> institution_uid = null;
    protected List<String> collection_uid = null;
    protected List<String> data_resource_uid = null;
    protected List<String> data_provider_uid = null;
    protected List<String> data_hub_uid = null;
    @Value(value="${registry.url:http://collections.ala.org.au/ws}")
    protected String registryUrl;
    @Value(value="${caches.collections.enabled:true}")
    protected Boolean enabled = null;
    @Inject
    private RestOperations restTemplate;
    private static final Logger logger = Logger.getLogger(CollectionsCache.class);

    public LinkedHashMap<String, String> getInstitutions() {
        return this.institutions;
    }

    public LinkedHashMap<String, String> getDataResources() {
        return this.dataResources;
    }

    public LinkedHashMap<String, String> getDataProviders() {
        return this.dataProviders;
    }

    public LinkedHashMap<String, String> getTempDataResources() {
        return this.tempDataResources;
    }

    public LinkedHashMap<String, String> getCollections() {
        return this.collections;
    }

    public LinkedHashMap<String, String> getDataHubs() {
        return this.dataHubs;
    }

    public LinkedHashMap<String, Integer> getDownloadLimits() {
        return this.downloadLimits;
    }

    @Scheduled(fixedDelay=3600000L)
    public void updateCache() {
        if (this.enabled.booleanValue()) {
            logger.info((Object)"Updating collectory cache...");
            this.collections = this.getCodesMap(ResourceType.COLLECTION, this.collection_uid);
            this.institutions = this.getCodesMap(ResourceType.INSTITUTION, this.institution_uid);
            this.dataResources = this.getCodesMap(ResourceType.DATA_RESOURCE, this.data_resource_uid);
            this.dataProviders = this.getCodesMap(ResourceType.DATA_PROVIDER, this.data_provider_uid);
            this.tempDataResources = this.getCodesMap(ResourceType.TEMP_DATA_RESOURCE, null);
            this.dataHubs = this.getCodesMap(ResourceType.DATA_HUB, this.data_hub_uid);
            this.dataResources.putAll(this.tempDataResources);
        } else {
            logger.info((Object)"Collectory cache has been disabled");
        }
    }

    protected LinkedHashMap<String, String> getCodesMap(ResourceType type, List<String> guids) {
        LinkedHashMap<String, String> entityMap = null;
        logger.info((Object)("Updating code map with " + guids));
        try {
            Field f = CollectionsCache.class.getDeclaredField(type.getType() + "s");
            entityMap = (LinkedHashMap<String, String>)f.get(this);
            logger.debug((Object)("checking map size: " + entityMap.size()));
        }
        catch (Exception ex) {
            logger.error((Object)("Java reflection error: " + ex.getMessage()), (Throwable)ex);
        }
        try {
            entityMap = new LinkedHashMap<String, String>();
            String jsonUri = this.registryUrl + "/" + type.getType() + ".json";
            logger.debug((Object)("Requesting: " + jsonUri));
            List entities = (List)this.restTemplate.getForObject(jsonUri, List.class, new Object[0]);
            logger.debug((Object)("number of entities = " + entities.size()));
            for (LinkedHashMap je : entities) {
                if (!this.addToCodeMap((String)je.get("uid"), guids)) continue;
                entityMap.put((String)je.get("uid"), (String)je.get("name"));
            }
        }
        catch (Exception ex) {
            logger.error((Object)("RestTemplate error: " + ex.getMessage()), (Throwable)ex);
        }
        return entityMap;
    }

    private boolean addToCodeMap(String uid, List<String> guids) {
        if (guids != null) {
            return guids.contains(uid);
        }
        return true;
    }
}

