/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.service.SpeciesLookupService;
import au.org.ala.names.model.LinnaeanRankClassification;
import au.org.ala.names.model.NameSearchResult;
import au.org.ala.names.search.ALANameSearcher;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.context.support.AbstractMessageSource;

public class SpeciesLookupIndexService
implements SpeciesLookupService {
    private AbstractMessageSource messageSource;
    protected String nameIndexLocation;
    private ALANameSearcher nameIndex = null;

    private ALANameSearcher getNameIndex() throws RuntimeException {
        if (this.nameIndex == null) {
            try {
                this.nameIndex = new ALANameSearcher(this.nameIndexLocation);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return this.nameIndex;
    }

    public String getGuidForName(String name) {
        try {
            return this.getNameIndex().searchForLSID(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getAcceptedNameForGuid(String guid) {
        NameSearchResult nsr = this.getNameIndex().searchForRecordByLsid(guid);
        if (nsr != null) {
            return nsr.getRankClassification() != null ? nsr.getRankClassification().getScientificName() : null;
        }
        return null;
    }

    public List<String> getNamesForGuids(List<String> guids) {
        ArrayList<String> results = new ArrayList<String>(guids.size());
        int idx = 0;
        for (String guid : guids) {
            results.add(idx, this.getAcceptedNameForGuid(guid));
            ++idx;
        }
        return results;
    }

    public List<String[]> getSpeciesDetails(List<String> guids, List<Long> counts, boolean includeCounts, boolean includeSynonyms) {
        ArrayList<String[]> results = new ArrayList<String[]>(guids.size());
        int idx = 0;
        for (String guid : guids) {
            String lsid;
            NameSearchResult nsr = this.getNameIndex().searchForRecordByLsid(guid);
            if (nsr == null && (lsid = this.getNameIndex().searchForLsidById(guid)) != null) {
                nsr = this.getNameIndex().searchForRecordByLsid(lsid);
            }
            Object[] result = null;
            if (nsr != null) {
                LinnaeanRankClassification classification = nsr.getRankClassification();
                result = new String[]{classification.getScientificName(), classification.getAuthorship(), classification.getKingdom(), classification.getPhylum(), classification.getKlass(), classification.getOrder(), classification.getFamily(), classification.getGenus(), classification.getSpecies(), classification.getSubspecies()};
            } else {
                result = new String[]{"", "", "", "", "", "", "", "", "", ""};
            }
            if (includeCounts) {
                result = (String[])ArrayUtils.add((Object[])result, (Object)counts.get(idx).toString());
            }
            results.add((String[])result);
            ++idx;
        }
        return results;
    }

    public String[] getHeaderDetails(String field, boolean includeCounts, boolean includeSynonyms) {
        Object[] baseHeader = new String[]{this.messageSource.getMessage("species.name", null, "Species Name", null), this.messageSource.getMessage("species.author", null, "Scientific Name Author", null), this.messageSource.getMessage("species.kingdom", null, "Kingdom", null), this.messageSource.getMessage("species.phylum", null, "Phylum", null), this.messageSource.getMessage("species.class", null, "Class", null), this.messageSource.getMessage("species.order", null, "Order", null), this.messageSource.getMessage("species.family", null, "Family", null), this.messageSource.getMessage("species.genus", null, "Genus", null), this.messageSource.getMessage("species.species", null, "Species", null), this.messageSource.getMessage("species.subspecies", null, "Subspecies", null)};
        if (includeCounts) {
            return (String[])ArrayUtils.add((Object[])baseHeader, (Object)this.messageSource.getMessage("species.count", null, "Number of Records", null));
        }
        return baseHeader;
    }

    public void setMessageSource(AbstractMessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setNameIndexLocation(String nameIndexLocation) {
        this.nameIndexLocation = nameIndexLocation;
    }
}

