/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.service.LayersService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestOperations;

@Component(value="layersService")
public class AlaLayersService
implements LayersService {
    private Map<String, String> idToNameMap = new HashMap();
    private List<Map<String, Object>> layers = new ArrayList();
    @Value(value="${caches.layers.enabled:true}")
    protected Boolean enabled = null;
    @Value(value="${spatial.layers.url:http://spatial.ala.org.au/ws/fields}")
    protected String spatialUrl;
    @Inject
    private RestOperations restTemplate;

    public Map<String, String> getLayerNameMap() {
        return this.idToNameMap;
    }

    @Scheduled(fixedDelay=43200000L)
    public void refreshCache() {
        if (this.enabled.booleanValue()) {
            HashMap<String, String> tmpMap = new HashMap<String, String>();
            this.layers = (List)this.restTemplate.getForObject(this.spatialUrl, List.class, new Object[0]);
            for (Map values : this.layers) {
                tmpMap.put((String)values.get("id"), (String)values.get("desc"));
            }
            this.idToNameMap = tmpMap;
        }
    }

    public String getName(String code) {
        return this.idToNameMap != null ? (String)this.idToNameMap.get(code) : null;
    }
}

