/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.service;

import au.org.ala.biocache.service.ImageMetadataService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="imageMetadataService")
public class AlaImageMetadataService
implements ImageMetadataService {
    private static final Logger logger = Logger.getLogger(AlaImageMetadataService.class);
    @Value(value="${image.service.url:http://images-dev.ala.org.au/ws}")
    protected String imageServiceUrl;

    public Map<String, List<Map<String, Object>>> getImageMetadataForOccurrences(List<String> occurrenceIDs) throws Exception {
        logger.debug((Object)("Retrieving the image metadata for " + occurrenceIDs.size() + " records"));
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("key", "occurrenceid");
        payload.put("values", occurrenceIDs);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpPost post = new HttpPost(this.imageServiceUrl + "/findImagesByMetadata");
        ObjectMapper om = new ObjectMapper();
        post.setEntity((HttpEntity)new StringEntity(om.writeValueAsString(payload), "UTF-8"));
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)post);
        String jsonResponseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        Map jsonResponse = (Map)om.readValue(jsonResponseString, Map.class);
        Map imageMetadata = (Map)jsonResponse.get("images");
        logger.debug((Object)("Obtained image metadata for " + imageMetadata.size() + " records"));
        return imageMetadata;
    }
}

