/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.heatmap;

import au.org.ala.biocache.heatmap.HeatMap;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.ByteLookupTable;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.LookupOp;
import java.awt.image.LookupTable;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class HeatMap {
    private static final Logger logger = Logger.getLogger(HeatMap.class);
    private int radius = 8;
    private int numColours = 10;
    private BufferedImage backgroundImage;
    private BufferedImage legendImage;
    private BufferedImage monochromeImage;
    private BufferedImage heatmapImage;
    private BufferedImage colorImage;
    private LookupTable colorTable;
    private LookupOp colorOp;
    private double minX = 110.911;
    private double minY = -44.778;
    private double maxX = 156.113;
    private double maxY = -9.221;

    public HeatMap() throws Exception {
        InputStream bkImageInput = HeatMap.class.getResourceAsStream("/images/heatmap_background.png");
        InputStream legendImageInput = HeatMap.class.getResourceAsStream("/images/heatmap_legend.png");
        this.backgroundImage = ImageIO.read(bkImageInput);
        this.legendImage = ImageIO.read(legendImageInput);
        int width = this.backgroundImage.getWidth();
        int height = this.backgroundImage.getHeight();
        this.colorImage = HeatMap.createEvenlyDistributedGradientImage((Dimension)new Dimension(512, 20), (Color[])new Color[]{new Color(255, 0, 0), new Color(255, 30, 0), new Color(255, 60, 0), new Color(255, 90, 0), new Color(255, 120, 0), new Color(255, 150, 0), new Color(255, 180, 0), new Color(255, 210, 0), new Color(255, 230, 0), new Color(255, 255, 0), Color.WHITE});
        this.colorTable = HeatMap.createColorLookupTable((BufferedImage)this.colorImage, (float)0.5f);
        this.colorOp = new LookupOp(this.colorTable, null);
        this.monochromeImage = HeatMap.createCompatibleTranslucentImage((int)width, (int)height);
        Graphics g = this.monochromeImage.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
    }

    private static LookupTable createColorLookupTable(BufferedImage im, float alpha) {
        int tableSize = 256;
        Raster imageRaster = im.getData();
        double sampleStep = 1.0 * (double)im.getWidth() / (double)tableSize;
        byte[][] colorTable = new byte[4][tableSize];
        int[] pixel = new int[1];
        for (int i = 0; i < tableSize; ++i) {
            imageRaster.getDataElements((int)((double)i * sampleStep), 0, pixel);
            Color c = new Color(pixel[0]);
            colorTable[0][i] = (byte)c.getRed();
            colorTable[1][i] = (byte)c.getGreen();
            colorTable[2][i] = (byte)c.getBlue();
            colorTable[3][i] = (byte)(alpha * 255.0f);
        }
        return new ByteLookupTable(0, colorTable);
    }

    private static BufferedImage createEvenlyDistributedGradientImage(Dimension size, Color ... colors) {
        BufferedImage im = HeatMap.createCompatibleTranslucentImage((int)size.width, (int)size.height);
        Graphics2D g = im.createGraphics();
        float[] fractions = new float[colors.length];
        float step = 1.0f / (float)colors.length;
        for (int i = 0; i < colors.length; ++i) {
            fractions[i] = (float)i * step;
        }
        LinearGradientPaint gradient = new LinearGradientPaint(0.0f, 0.0f, size.width, 1.0f, fractions, colors, MultipleGradientPaint.CycleMethod.REPEAT);
        g.setPaint(gradient);
        g.fillRect(0, 0, size.width, size.height);
        g.dispose();
        return im;
    }

    private static BufferedImage createCompatibleTranslucentImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        int[] image_bytes = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
        for (int i = 0; i < image_bytes.length; ++i) {
            image_bytes[i] = 0;
        }
        image.setRGB(0, 0, image.getWidth(), image.getHeight(), image_bytes, 0, image.getWidth());
        return image;
    }

    private BufferedImage doColorize() {
        int[] image_bytes = this.colorImage.getRGB(0, 0, this.colorImage.getWidth(), this.colorImage.getHeight(), null, 0, this.colorImage.getWidth());
        int[] image_bytes2 = this.monochromeImage.getRGB(0, 0, this.monochromeImage.getWidth(), this.monochromeImage.getHeight(), null, 0, this.monochromeImage.getWidth());
        for (int i = 0; i < image_bytes2.length; ++i) {
            int pos = image_bytes2[i] & 0xFF;
            image_bytes2[i] = image_bytes[pos * 2] & 0x99FFFFFF;
        }
        BufferedImage biColorized = new BufferedImage(this.monochromeImage.getWidth(), this.monochromeImage.getHeight(), 2);
        biColorized.setRGB(0, 0, biColorized.getWidth(), biColorized.getHeight(), image_bytes2, 0, biColorized.getWidth());
        return biColorized;
    }

    private static Image makeColorTransparent(BufferedImage im, Color color) {
        1 filter = new /* Unavailable Anonymous Inner Class!! */;
        FilteredImageSource ip = new FilteredImageSource(im.getSource(), (ImageFilter)filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }

    private void addDotImage(Point p, Color pointColor) {
        Graphics2D g = (Graphics2D)this.monochromeImage.getGraphics();
        float radius = 10.0f;
        Ellipse2D.Float circle = new Ellipse2D.Float((float)p.x - radius / 2.0f, (float)p.y - radius / 2.0f, radius, radius);
        g.draw(circle);
        g.setPaint(pointColor);
        g.fill(circle);
    }

    private Point translate(double x, double y) {
        try {
            x = (x - this.minX) / (this.maxX - this.minX);
            y = (y - this.minY) / (this.maxY - this.minY);
            y = (1.0 - y) * (double)this.backgroundImage.getHeight();
            return new Point(new Double(x *= (double)this.backgroundImage.getWidth()).intValue(), new Double(y).intValue());
        }
        catch (Exception e) {
            logger.error((Object)("Exception with translating " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private void generateLogScaleCircle(int[][] dPoints) {
        try {
            int maxValue = 0;
            int width = this.monochromeImage.getWidth();
            int height = this.monochromeImage.getHeight();
            for (int mi = 0; mi < width; ++mi) {
                for (int mj = 0; mj < height; ++mj) {
                    if (maxValue >= dPoints[mi][mj]) continue;
                    maxValue = dPoints[mi][mj];
                }
            }
            if (maxValue > 0) {
                int roundFactor = 1;
                for (int mi = 0; mi < width; ++mi) {
                    for (int mj = 0; mj < height; ++mj) {
                        int rgba = (int)(255.0 - Math.log(dPoints[mi][mj]) * 255.0 / Math.log(maxValue));
                        if (rgba < 255 && rgba > 255 - 255 / this.numColours - roundFactor) {
                            rgba = 255 - 255 / this.numColours - roundFactor;
                        }
                        rgba = rgba | rgba << 8 | rgba << 16 | 0xFF000000;
                        this.monochromeImage.setRGB(mi, mj, rgba);
                    }
                }
                this.generateLegend(maxValue);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error generating log scale circle: " + e.getMessage()), (Throwable)e);
        }
    }

    public void generateClasses(double[] points) {
        int width = this.backgroundImage.getWidth();
        int height = this.backgroundImage.getHeight();
        int[][] dPoints = new int[width][height];
        for (int i = 0; i < points.length; i += 2) {
            double cx = points[i];
            double cy = points[i + 1];
            Point p = this.translate(cx, cy);
            int pradius = this.radius * this.radius;
            for (int ci = p.x - this.radius; ci <= p.x + this.radius; ++ci) {
                for (int cj = p.y - this.radius; cj <= p.y + this.radius; ++cj) {
                    double d;
                    if (ci < 0 || ci >= width || cj < 0 || cj >= height || (int)(d = Math.pow(p.x - ci, 2.0) + Math.pow(p.y - cj, 2.0)) > pradius) continue;
                    int[] nArray = dPoints[ci];
                    int n = cj;
                    nArray[n] = (int)((double)nArray[n] + ((double)this.numColours - d * (double)this.numColours / (double)pradius));
                }
            }
        }
        this.generateLogScaleCircle(dPoints);
    }

    public void generatePoints(double[] points, Color pointColour) {
        for (int i = 0; i < points.length; i += 2) {
            double cx = points[i];
            double cy = points[i + 1];
            Point p = this.translate(cx, cy);
            this.addDotImage(p, pointColour);
        }
    }

    private void generateLegend(int maxValue) {
        int[] scale = new int[this.numColours - 1];
        scale[0] = maxValue;
        for (int i = 1; i < scale.length - 1; ++i) {
            scale[i] = (int)Math.pow(Math.E, (double)(this.numColours - i) * (Math.log(maxValue) / (double)this.numColours));
        }
        scale[scale.length - 1] = 0;
        Graphics2D cg = (Graphics2D)this.legendImage.getGraphics();
        cg.setColor(Color.BLACK);
        Font font = new Font("SanSerif", 0, 11);
        cg.setFont(font);
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        cg.setRenderingHints(rh);
        int padding = 10;
        int keyHeight = 30;
        int keyWidth = 25;
        int scaleLength = scale.length;
        String value = scale[scaleLength - 1] + 1 + "-" + scale[scaleLength - 3];
        int left = padding * 2 + keyWidth;
        int top = padding + keyHeight / 2;
        cg.drawString(value, left, top);
        value = scale[scaleLength - 3] + 1 + "-" + scale[scaleLength - 5];
        top = padding + keyHeight / 2 + keyHeight;
        cg.drawString(value, left, top);
        value = scale[scaleLength - 5] + 1 + "-" + scale[scaleLength - 6];
        top = padding + keyHeight / 2 + keyHeight * 2;
        cg.drawString(value, left, top);
        value = scale[scaleLength - 6] + 1 + "-" + scale[scaleLength - 7];
        top = padding + keyHeight / 2 + keyHeight * 3;
        cg.drawString(value, left, top);
        value = scale[scaleLength - 7] + 1 + "-" + scale[scaleLength - 8];
        top = padding + keyHeight / 2 + keyHeight * 4;
        cg.drawString(value, left, top);
        value = scale[scaleLength - 8] + 1 + "+";
        top = padding + keyHeight / 2 + keyHeight * 5;
        cg.drawString(value, left, top);
    }

    public void drawLegend(String outfile) {
        File legOut = new File(outfile);
        try {
            ImageIO.write((RenderedImage)this.legendImage, "png", legOut);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to write legendImage: " + e.getMessage()), (Throwable)e);
        }
    }

    public void drawOutput(String outputFilePath, boolean colorize) throws IOException {
        try {
            this.heatmapImage = colorize ? this.doColorize() : this.monochromeImage;
            Graphics2D g = (Graphics2D)this.backgroundImage.getGraphics();
            g.drawImage(HeatMap.makeColorTransparent((BufferedImage)this.heatmapImage, (Color)Color.WHITE), 0, 0, null);
            File hmOut = new File(outputFilePath);
            ImageIO.write((RenderedImage)this.backgroundImage, "png", hmOut);
        }
        catch (IOException ex) {
            logger.error((Object)("An error occurred drawing output to outfile: '" + outputFilePath + "' Error message: " + ex.getMessage()), (Throwable)ex);
            throw ex;
        }
    }
}

