/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.vocab;

import au.org.ala.vocab.Vocabulary;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;

@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class Concept<T extends Concept<T>> {
    @JsonProperty
    private URI uri;
    @JsonProperty
    private String id;
    @JsonProperty
    private List<String> names;
    @JsonProperty
    private String description;
    @JsonManagedReference
    private Vocabulary<T> vocabulary;
    @JsonProperty
    private Concept<T> parent;

    public Concept() {
    }

    public Concept(Vocabulary<T> vocabulary, URI uri, String id, String description, Concept<T> parent, String ... names) {
        this.vocabulary = vocabulary;
        this.uri = uri;
        this.id = id;
        this.names = names == null ? null : Arrays.asList(names);
        this.description = description;
        this.parent = parent;
    }

    public Concept(Vocabulary<T> vocabulary, String id, String description, Concept<T> parent, String ... names) {
        this(vocabulary, null, id, description, parent, names);
        try {
            this.uri = new URI(this.vocabulary.getUri().getScheme(), this.vocabulary.getUri().getSchemeSpecificPart(), id);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Unable to construct concept " + id, ex);
        }
    }

    public Concept(Vocabulary<T> vocabulary, String id, String ... names) {
        this(vocabulary, id, (String)null, (Concept<T>)null, names);
    }

    public URI getUri() {
        return this.uri;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getNames() {
        return this.names;
    }

    public String getDescription() {
        return this.description;
    }

    public Vocabulary<T> getVocabulary() {
        return this.vocabulary;
    }

    public Concept<T> getParent() {
        return this.parent;
    }

    public void write(Writer writer) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.writeValue(writer, (Object)this);
    }
}

