/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index.provider;

import au.org.ala.names.index.NameKey;
import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.index.provider.ScoreAdjustment;
import au.org.ala.names.index.provider.TaxonCondition;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;

public class ScoreAdjuster {
    @JsonProperty
    private List<TaxonCondition> forbidden = new ArrayList<TaxonCondition>();
    @JsonProperty
    private List<ScoreAdjustment> adjustments = new ArrayList<ScoreAdjustment>();

    public void addForbidden(TaxonCondition condition) {
        this.forbidden.add(condition);
    }

    public void addAdjustment(ScoreAdjustment adjustment) {
        this.adjustments.add(adjustment);
    }

    public String forbid(TaxonConceptInstance instance, NameKey key) {
        for (TaxonCondition condition : this.forbidden) {
            if (!condition.match(instance, key)) continue;
            return condition.explain();
        }
        return null;
    }

    public int score(int base, TaxonConceptInstance instance, NameKey key) {
        return this.adjustments.stream().reduce(base, (score, adjuster) -> adjuster.adjust((int)score, instance, key), (a, b) -> a);
    }
}

