/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index.provider;

import au.org.ala.names.index.NameKey;
import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.index.provider.TaxonCondition;
import au.org.ala.names.model.RankType;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.gbif.api.vocabulary.NameType;
import org.gbif.api.vocabulary.NomenclaturalCode;

public class KeyAdjustment {
    @JsonProperty
    private TaxonCondition condition;
    @JsonProperty
    private NomenclaturalCode nomenclaturalCode;
    @JsonProperty
    private String scientificName;
    @JsonProperty
    private String scientificNameAuthorship;
    @JsonProperty
    private NameType nameType;
    @JsonProperty
    private RankType rank;

    public KeyAdjustment() {
    }

    public KeyAdjustment(TaxonCondition condition, @Nullable NomenclaturalCode nomenclaturalCode, @Nullable String scientificName, @Nullable String scientificNameAuthorship, @Nullable NameType nameType, @Nullable RankType rank) {
        this.condition = condition;
        this.nomenclaturalCode = nomenclaturalCode;
        this.scientificName = scientificName;
        this.scientificNameAuthorship = scientificNameAuthorship;
        this.nameType = nameType;
        this.rank = rank;
    }

    public NameKey adjust(NameKey key, TaxonConceptInstance instance) {
        String sna;
        if (!this.condition.match(instance, key)) {
            return key;
        }
        NomenclaturalCode nc = this.nomenclaturalCode != null ? this.nomenclaturalCode : key.getCode();
        String sn = this.scientificName != null ? this.scientificName : key.getScientificName();
        String string = sna = this.scientificNameAuthorship != null ? this.scientificNameAuthorship : key.getScientificNameAuthorship();
        if (sna != null && sna.isEmpty()) {
            sna = null;
        }
        NameType nt = this.nameType != null ? this.nameType : key.getType();
        RankType rt = this.rank != null ? this.rank : key.getRank();
        return new NameKey(key.getAnalyser(), nc, sn, sna, rt, nt);
    }
}

