/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.names.index.ALANameAnalyser;
import au.org.ala.names.index.ALATaxonResolver;
import au.org.ala.names.index.BareName;
import au.org.ala.names.index.IndexBuilderException;
import au.org.ala.names.index.IssueType;
import au.org.ala.names.index.NameAnalyser;
import au.org.ala.names.index.NameKey;
import au.org.ala.names.index.NameProvider;
import au.org.ala.names.index.NameSource;
import au.org.ala.names.index.Reporter;
import au.org.ala.names.index.ScientificName;
import au.org.ala.names.index.TaxonConcept;
import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.index.TaxonResolver;
import au.org.ala.names.index.TaxonomicElement;
import au.org.ala.names.index.TaxonomyConfiguration;
import au.org.ala.names.index.UnrankedScientificName;
import au.org.ala.names.model.LinnaeanRankClassification;
import au.org.ala.names.model.NameSearchResult;
import au.org.ala.names.model.RankType;
import au.org.ala.names.model.TaxonomicType;
import au.org.ala.names.search.ALANameSearcher;
import au.org.ala.names.search.DwcaNameIndexer;
import au.org.ala.names.util.DwcaWriter;
import au.org.ala.names.util.FileUtils;
import au.org.ala.vocab.ALATerm;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Version;
import org.gbif.api.model.registry.Citation;
import org.gbif.api.model.registry.Contact;
import org.gbif.api.model.registry.Dataset;
import org.gbif.api.model.registry.Identifier;
import org.gbif.api.vocabulary.ContactType;
import org.gbif.api.vocabulary.IdentifierType;
import org.gbif.api.vocabulary.NomenclaturalCode;
import org.gbif.api.vocabulary.NomenclaturalStatus;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.GbifTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Taxonomy
implements Reporter {
    private static Logger logger = LoggerFactory.getLogger(Taxonomy.class);
    private static DateTimeFormatter ISO8601 = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    public static int PROGRESS_INTERVAL = 10000;
    private static Map<org.gbif.dwc.terms.Term, String> fieldNames = new HashMap<org.gbif.dwc.terms.Term, String>();
    private static Map<String, org.gbif.dwc.terms.Term> fieldTerms = new HashMap<String, org.gbif.dwc.terms.Term>();
    public static Set<String> COUNT_PROGRESS = new HashSet<String>(Arrays.asList("count.homonym", "count.load.instance", "count.resolve.instance.links", "count.resolve.taxonConcept", "count.resolve.scientificName.principal", "count.resolve.uncodedScientificName.principal", "count.resolve.unrankedScientificName.principal", "count.write.taxonConcept"));
    protected static final List<String> UNPLACED_VERNACULAR_FORBIDDEN = Arrays.asList("type", "id", Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.taxonID), Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.scientificName), Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.scientificNameAuthorship), Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.nomenclaturalCode), Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.taxonRank), Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.kingdom), Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.phylum), Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.class_), Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.order), Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.family), Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.genus), Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.specificEpithet), Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.infraspecificEpithet));
    private static final List<org.gbif.dwc.terms.Term> DEFAULT_TERMS = Collections.unmodifiableList(Arrays.asList(DwcTerm.taxonID));
    private TaxonomyConfiguration configuration;
    private NameAnalyser analyser;
    private TaxonResolver resolver;
    private File work;
    private Analyzer indexAnalyzer;
    private File index;
    private Directory indexDir;
    private IndexWriter indexWriter;
    private SearcherManager searcherManager;
    private Map<NameKey, ScientificName> names;
    private Map<NameKey, UnrankedScientificName> unrankedNames;
    private Map<NameKey, BareName> bareNames;
    private Map<String, TaxonConceptInstance> instances;
    private Map<String, NameProvider> providers;
    private NameProvider defaultProvider;
    private NameProvider inferenceProvider;
    private Map<org.gbif.dwc.terms.Term, Set<org.gbif.dwc.terms.Term>> outputMap;
    private ResourceBundle resources;
    private ConcurrentMap<String, AtomicInteger> counts;
    private List<NameSource> sources;
    private ALANameSearcher workingIndex;

    public Taxonomy() throws IndexBuilderException {
        this(null, null);
    }

    public Taxonomy(TaxonomyConfiguration configuration, File work) throws IndexBuilderException {
        if (configuration == null) {
            configuration = new TaxonomyConfiguration();
            configuration.nameAnalyserClass = ALANameAnalyser.class;
            configuration.resolverClass = ALATaxonResolver.class;
            configuration.inferenceProvider = configuration.defaultProvider = new NameProvider("default", 100);
            configuration.providers = new ArrayList<NameProvider>();
            configuration.providers.add(configuration.defaultProvider);
        }
        this.configuration = configuration;
        this.configuration.validate();
        try {
            this.analyser = this.configuration.nameAnalyserClass.newInstance();
            this.analyser.setReporter(this);
        }
        catch (Exception ex) {
            throw new IndexBuilderException("Unable to create analyser", ex);
        }
        try {
            this.resolver = this.configuration.resolverClass.getConstructor(Taxonomy.class).newInstance(this);
        }
        catch (Exception ex) {
            throw new IndexBuilderException("Unable to create resolver", ex);
        }
        this.providers = new HashMap<String, NameProvider>((Map<String, NameProvider>)Maps.uniqueIndex(configuration.providers, p -> p.getId()));
        this.defaultProvider = this.configuration.defaultProvider;
        this.inferenceProvider = this.configuration.inferenceProvider != null ? configuration.inferenceProvider : this.defaultProvider;
        this.names = new HashMap<NameKey, ScientificName>();
        this.unrankedNames = new HashMap<NameKey, UnrankedScientificName>();
        this.bareNames = new HashMap<NameKey, BareName>();
        this.instances = new HashMap<String, TaxonConceptInstance>();
        this.makeBaseOutputMap();
        this.makeWorkArea(work);
        this.indexAnalyzer = new KeywordAnalyzer();
        this.resources = ResourceBundle.getBundle("taxonomy");
        this.counts = new ConcurrentHashMap<String, AtomicInteger>();
        this.sources = new ArrayList<NameSource>();
    }

    public Taxonomy(NameAnalyser analyser, TaxonResolver resolver, Map<String, NameProvider> providers, NameProvider defaultProvider) {
        this.configuration = new TaxonomyConfiguration();
        this.analyser = analyser;
        this.analyser.setReporter(this);
        this.resolver = resolver;
        this.providers = providers;
        this.defaultProvider = defaultProvider;
        this.names = new HashMap<NameKey, ScientificName>();
        this.unrankedNames = new HashMap<NameKey, UnrankedScientificName>();
        this.bareNames = new HashMap<NameKey, BareName>();
        this.instances = new HashMap<String, TaxonConceptInstance>();
        this.makeBaseOutputMap();
        this.makeWorkArea(null);
        this.indexAnalyzer = new KeywordAnalyzer();
        this.resources = ResourceBundle.getBundle("taxonomy");
        this.counts = new ConcurrentHashMap<String, AtomicInteger>();
        this.sources = new ArrayList<NameSource>();
    }

    public File getWork() {
        return this.work;
    }

    public Map<NameKey, ScientificName> getNames() {
        return this.names;
    }

    public TaxonResolver getResolver() {
        return this.resolver;
    }

    public ALANameSearcher getWorkingIndex() {
        return this.workingIndex;
    }

    public ResourceBundle getResources() {
        return this.resources;
    }

    public void setWorkingIndex(ALANameSearcher workingIndex) {
        this.workingIndex = workingIndex;
    }

    public TaxonConceptInstance getInstance(String taxonID) {
        return this.instances.get(taxonID);
    }

    public int getAcceptedCutoff() {
        return this.configuration.acceptedCutoff;
    }

    public void count(String type) {
        this.count(type, 1);
    }

    public void count(String type, int amount) {
        AtomicInteger count = this.counts.computeIfAbsent(type, k -> new AtomicInteger(0));
        int c = count.addAndGet(amount);
        if (COUNT_PROGRESS.contains(type) && c % PROGRESS_INTERVAL == 0) {
            String message = this.resources.getString(type);
            message = MessageFormat.format(message, c);
            logger.info(message);
        }
    }

    public void resetCount(String type) {
        AtomicInteger count = this.counts.computeIfAbsent(type, k -> new AtomicInteger(0));
        count.set(0);
    }

    public void begin() throws IndexBuilderException {
        try {
            IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_4_10_4, this.indexAnalyzer);
            this.indexWriter = new IndexWriter(this.indexDir, config);
            this.indexWriter.commit();
            this.searcherManager = new SearcherManager(this.indexWriter, true, null);
        }
        catch (IOException ex) {
            throw new IndexBuilderException("Error creating working index", ex);
        }
    }

    public void close() throws IndexBuilderException {
        try {
            if (this.indexWriter != null) {
                this.indexWriter.close();
                this.indexWriter = null;
            }
            if (this.searcherManager != null) {
                this.searcherManager.close();
                this.searcherManager = null;
            }
        }
        catch (IOException ex) {
            throw new IndexBuilderException("Error closing taxonomy", ex);
        }
    }

    public void load(List<NameSource> sources) throws IndexBuilderException {
        try {
            if (this.indexWriter == null) {
                throw new IllegalStateException("Index not opened");
            }
            for (NameSource source : sources) {
                logger.info("Loading " + source.getName());
                source.loadIntoTaxonomy(this);
                this.indexWriter.commit();
                this.searcherManager.maybeRefresh();
                this.sources.add(source);
            }
        }
        catch (IOException ex) {
            throw new IndexBuilderException("Error constructing source index", ex);
        }
    }

    public void resolve() throws IndexBuilderException, IOException {
        this.resolveLinks();
        if (!this.validate()) {
            throw new IndexBuilderException("Invalid source data");
        }
        this.validateNameCollisions();
        this.resolveTaxon();
        this.resolvePrincipal();
        this.resolveDiscards();
        if (!this.validate()) {
            throw new IndexBuilderException("Invalid resolution");
        }
    }

    public void resolveLinks() throws IndexBuilderException {
        logger.info("Resolving links");
        this.instances.values().parallelStream().forEach(instance -> instance.resolveLinks(this));
        logger.info("Finished resolving links");
    }

    public boolean validate() throws IndexBuilderException {
        logger.info("Starting validation");
        boolean valid = true;
        valid = this.instances.values().parallelStream().map(instance -> instance.validate(this)).reduce(valid, (a, b) -> a != false && b != false);
        valid = this.names.values().parallelStream().map(instance -> instance.validate(this)).reduce(valid, (a, b) -> a != false && b != false);
        logger.info("Finished validation");
        return valid;
    }

    protected void validateNameCollisions() throws IndexBuilderException {
        logger.info("Validating name collisions");
        HashMap<String, Integer> counts = new HashMap<String, Integer>(this.names.size());
        for (NameKey nameKey : this.names.keySet()) {
            String name = nameKey.getScientificName();
            counts.put(name, counts.getOrDefault(name, 0) + 1);
        }
        for (Map.Entry entry : counts.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            this.count("count.homonym");
            this.report(IssueType.NOTE, "name.homonym", null, (String)entry.getKey(), null, new String[0]);
        }
        logger.info("Finished validating name collisions");
    }

    public void resolveTaxon() throws IndexBuilderException {
        logger.info("Resolving taxa");
        Collection<TaxonConceptInstance> allInstances = this.instances.values();
        Set rs = allInstances.stream().map(TaxonConceptInstance::getRank).collect(Collectors.toSet());
        ArrayList ranks = new ArrayList(rs);
        Collections.sort(ranks, (r1, r2) -> r1.getSortOrder() - r2.getSortOrder());
        long prevResolved = 0L;
        long resolved = 0L;
        do {
            for (RankType rank : ranks) {
                Set concepts = allInstances.stream().filter(instance -> instance.getRank() == rank).map(TaxonomicElement::getContainer).collect(Collectors.toSet());
                concepts.parallelStream().forEach(tc -> tc.resolveTaxon(this));
            }
            prevResolved = resolved;
            resolved = allInstances.stream().filter(instance -> instance.isResolved()).count();
            logger.debug("Resolved " + prevResolved + " -> " + resolved);
        } while (resolved != prevResolved);
        Set unresolvedConcepts = allInstances.stream().map(TaxonomicElement::getContainer).filter(tc -> !tc.isResolved()).collect(Collectors.toSet());
        logger.info("Found " + unresolvedConcepts.size() + " un-resolved concepts");
        unresolvedConcepts.parallelStream().forEach(tc -> {
            tc.resolveTaxon(this);
            this.report(IssueType.PROBLEM, "taxonConcept.unresolved", (TaxonomicElement)tc, null);
        });
        logger.info("Finished resolving taxa");
    }

    public void resolvePrincipal() throws IndexBuilderException {
        logger.info("Resolving principals for scientific names");
        this.names.values().parallelStream().forEach(name -> name.resolvePrincipal(this));
        logger.info("Resolving principals for unranked names");
        this.unrankedNames.values().parallelStream().forEach(name -> name.resolvePrincipal(this));
        logger.info("Resolving principals for bare names");
        this.bareNames.values().parallelStream().forEach(name -> name.resolvePrincipal(this));
        logger.info("Finished resolving principals");
    }

    public void resolveDiscards() throws IndexBuilderException, IOException {
        logger.info("Resolving discarded/forbiiden concepts");
        Collection<TaxonConceptInstance> allInstances = this.instances.values();
        allInstances.stream().forEach(tci -> tci.resolveDiscarded(this));
        this.indexWriter.commit();
        this.searcherManager.maybeRefresh();
        logger.info("Finished resolving dicarded/forbidden concepts");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveUnplacedVernacular() throws IndexBuilderException {
        logger.info("Resolving unplaced vernacular names");
        if (this.workingIndex == null) {
            throw new IndexBuilderException("No working name index set");
        }
        try {
            BooleanQuery query = new BooleanQuery();
            query.add((Query)new TermQuery(new Term("type", ALATerm.UnplacedVernacularName.qualifiedName())), BooleanClause.Occur.MUST);
            IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
            try {
                ScoreDoc after = null;
                TopFieldDocs docs = searcher.search((Query)query, 100, Sort.INDEXORDER);
                while (docs.scoreDocs.length > 0) {
                    ScoreDoc[] scoreDocArray = docs.scoreDocs;
                    int n = scoreDocArray.length;
                    for (int i = 0; i < n; ++i) {
                        TaxonConcept concept;
                        ScoreDoc sd;
                        after = sd = scoreDocArray[i];
                        Document document = searcher.doc(sd.doc);
                        TaxonConceptInstance tci = null;
                        String taxonID = document.get(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.taxonID));
                        if (taxonID != null) {
                            tci = this.instances.get(taxonID);
                        }
                        if (tci == null) {
                            tci = this.search(document);
                        }
                        String vernacularName = document.get(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.vernacularName));
                        TaxonConcept taxonConcept = concept = tci == null ? null : (TaxonConcept)tci.getContainer();
                        if (concept == null) {
                            String scientificName = document.get(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.scientificName));
                            this.report(IssueType.PROBLEM, "vernacularName.unplaced", null, scientificName, null, vernacularName);
                            this.count("count.vernacularName.unplaced");
                            continue;
                        }
                        Document placed = new Document();
                        placed.add((IndexableField)new StringField("type", GbifTerm.VernacularName.qualifiedName(), Field.Store.YES));
                        placed.add((IndexableField)new StringField("id", UUID.randomUUID().toString(), Field.Store.YES));
                        placed.add((IndexableField)new StringField(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.taxonID), concept.getRepresentative().getTaxonID(), Field.Store.YES));
                        for (IndexableField field : document) {
                            if (UNPLACED_VERNACULAR_FORBIDDEN.contains(field.name())) continue;
                            placed.add(field);
                        }
                        this.indexWriter.addDocument((Iterable)placed);
                    }
                    this.indexWriter.commit();
                    docs = searcher.searchAfter(after, (Query)query, 100, Sort.INDEXORDER);
                }
            }
            finally {
                this.searcherManager.release((Object)searcher);
                this.searcherManager.maybeRefresh();
            }
            logger.info("Finished resolving unplaced vernacular names");
        }
        catch (IndexBuilderException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IndexBuilderException("Unable to search for unplaced vernacular names", ex);
        }
    }

    protected TaxonConceptInstance search(Document document) throws IndexBuilderException {
        if (this.workingIndex == null) {
            throw new IndexBuilderException("No working name index set");
        }
        LinnaeanRankClassification lc = new LinnaeanRankClassification();
        String scientificName = document.get(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.scientificName));
        lc.setScientificName(scientificName);
        lc.setAuthorship(document.get(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.scientificNameAuthorship)));
        lc.setRank(document.get(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.taxonRank)));
        lc.setKingdom(document.get(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.kingdom)));
        lc.setPhylum(document.get(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.phylum)));
        lc.setKlass(document.get(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.class_)));
        lc.setOrder(document.get(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.order)));
        lc.setFamily(document.get(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.family)));
        lc.setGenus(document.get(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.genus)));
        lc.setSpecificEpithet(document.get(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.specificEpithet)));
        lc.setInfraspecificEpithet(document.get(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.infraspecificEpithet)));
        NameSearchResult result = this.workingIndex.searchForAcceptedRecordDefaultHandling(lc, true, true);
        return result == null ? null : this.instances.get(result.getLsid());
    }

    public NameProvider resolveProvider(String datasetID, String datasetName) {
        if (datasetID == null && datasetName == null) {
            return this.defaultProvider;
        }
        NameProvider provider = this.providers.get(datasetID);
        if (provider != null) {
            return provider;
        }
        provider = this.providers.get(datasetName);
        if (provider != null) {
            return provider;
        }
        provider = new NameProvider(datasetID != null ? datasetID : datasetName, datasetName, this.defaultProvider, true);
        this.report(IssueType.NOTE, "taxonomy.load.provider", null, null, null, provider.getId());
        if (datasetID != null) {
            this.providers.put(datasetID, provider);
        }
        if (datasetName != null) {
            this.providers.put(datasetName, provider);
        }
        return provider;
    }

    public NomenclaturalCode resolveCode(String nomenclaturalCode) {
        return this.analyser.canonicaliseCode(nomenclaturalCode);
    }

    public TaxonomicType resolveTaxonomicType(String taxonomicStatus) {
        return this.analyser.canonicaliseTaxonomicType(taxonomicStatus);
    }

    public RankType resolveRank(String rank) {
        return this.analyser.canonicaliseRank(rank);
    }

    public Set<NomenclaturalStatus> resolveNomenclaturalStatus(String nomenclaturalStatus) {
        if (nomenclaturalStatus == null || nomenclaturalStatus.isEmpty()) {
            return null;
        }
        String[] values = nomenclaturalStatus.split("[,;|]");
        HashSet<NomenclaturalStatus> status = new HashSet<NomenclaturalStatus>(values.length);
        for (String v : values) {
            NomenclaturalStatus s = this.analyser.canonicaliseNomenclaturalStatus(v);
            if (s == null) continue;
            status.add(s);
        }
        return status.isEmpty() ? null : status;
    }

    protected void addInferredInstance(TaxonConceptInstance instance) {
        String taxonID = instance.getTaxonID();
        if (this.instances.containsKey(taxonID)) {
            throw new IndexBuilderException("Attempting to add " + instance + " but taxonID " + taxonID + " already in use");
        }
        this.instances.put(taxonID, instance);
    }

    public TaxonConceptInstance addInstance(TaxonConceptInstance instance) throws Exception {
        BareName bare;
        String explain;
        String remark;
        String taxonID = instance.getTaxonID();
        boolean loose = instance.getProvider().isLoose();
        NameKey taxonKey = this.analyser.analyse(instance.getCode(), instance.getScientificName(), instance.getScientificNameAuthorship(), instance.getRank(), loose);
        taxonKey = instance.getProvider().adjustKey(taxonKey, instance);
        switch (taxonKey.getType()) {
            case PLACEHOLDER: {
                this.report(IssueType.NOTE, "taxonomy.load.placeholder", instance, null);
                remark = this.getResources().getString("taxonomy.load.placeholder.provenance");
                instance.addTaxonRemark(remark);
                this.addRemarksToOutput();
                break;
            }
            case NO_NAME: {
                this.report(IssueType.VALIDATION, "taxonomy.load.no_name", instance, null);
                remark = this.getResources().getString("taxonomy.load.no_name.provenance");
                instance.addProvenance(remark);
                instance.setForbidden(true);
                this.count("count.load.forbidden");
                this.addProvenanceToOutput();
                break;
            }
            case INFORMAL: 
            case DOUBTFUL: 
            case CANDIDATUS: {
                this.report(IssueType.NOTE, "taxonomy.load.as_is", instance, null);
                break;
            }
        }
        this.count("count.load.name." + taxonKey.getType().name());
        if (!instance.isForbidden() && (explain = instance.getProvider().forbid(instance, taxonKey)) != null) {
            this.count("count.load.forbidden");
            this.report(IssueType.NOTE, "taxonomy.load.forbidden", instance.getTaxonID(), instance.getScientificName(), instance.getScientificNameAuthorship(), explain);
            remark = this.getResources().getString("taxonomy.load.forbidden.provenance");
            remark = MessageFormat.format(remark, explain);
            instance.addTaxonRemark(remark);
            this.addRemarksToOutput();
            instance.setForbidden(true);
        }
        NameKey nameKey = taxonKey.toNameKey();
        NameKey unrankedKey = taxonKey.toUnrankedNameKey();
        NameKey bareKey = taxonKey.toUncodedNameKey();
        if (this.instances.containsKey(taxonID)) {
            TaxonConceptInstance collision = this.instances.get(taxonID);
            taxonID = UUID.randomUUID().toString();
            this.report(IssueType.VALIDATION, "taxonomy.load.collision", instance, Arrays.asList(collision));
            remark = this.getResources().getString("taxonomy.load.collision.provenance");
            remark = MessageFormat.format(remark, instance.getTaxonID(), instance.getProvider().getId());
            instance = new TaxonConceptInstance(taxonID, instance.getCode(), instance.getVerbatimNomenclaturalCode(), instance.getProvider(), instance.getScientificName(), instance.getScientificNameAuthorship(), instance.getYear(), instance.getTaxonomicStatus(), instance.getVerbatimTaxonomicStatus(), instance.getRank(), instance.getVerbatimTaxonRank(), instance.getStatus(), instance.getVerbatimNomenclaturalStatus(), instance.getParentNameUsage(), instance.getParentNameUsageID(), instance.getAcceptedNameUsage(), instance.getAcceptedNameUsageID(), instance.getTaxonRemarks() == null ? null : new ArrayList<String>(instance.getTaxonRemarks()), instance.getVerbatimTaxonRemarks(), (List<String>)(instance.getProvenance() == null ? null : new ArrayList<String>(instance.getProvenance())), instance.getClassification());
            instance.addProvenance(remark);
            this.addProvenanceToOutput();
        }
        if ((bare = this.bareNames.get(bareKey)) == null) {
            bare = new BareName(bareKey);
            this.bareNames.put(bareKey, bare);
        }
        bare.addInstance(taxonKey, instance);
        ScientificName name = (ScientificName)((TaxonConcept)instance.getContainer()).getContainer();
        if (!this.names.containsKey(name.getKey())) {
            this.names.put(name.getKey(), name);
        }
        UnrankedScientificName unranked = (UnrankedScientificName)name.getContainer();
        if (!this.unrankedNames.containsKey(unrankedKey)) {
            this.unrankedNames.put(unrankedKey, unranked);
        }
        this.instances.put(taxonID, instance);
        this.count("count.load.instance");
        return instance;
    }

    public TaxonomicElement findElement(NomenclaturalCode code, String name, NameProvider provider, RankType rank) {
        NameKey nameKey = null;
        nameKey = this.analyser.analyse(code, name, null, rank, provider.isLoose()).toNameKey();
        if (nameKey.isUncoded()) {
            return this.bareNames.get(nameKey);
        }
        if (nameKey.isUnranked()) {
            return this.unrankedNames.get(nameKey);
        }
        ScientificName scientificName = this.names.get(nameKey);
        return scientificName == null ? null : scientificName.findElement(this, provider);
    }

    public void createDwCA(File directory) throws IndexBuilderException, IOException {
        logger.info("Creating DwCA");
        this.resetCount("count.write.scientificName");
        this.resetCount("count.write.taxonConcept");
        this.resetCount("count.write.taxonConceptInstance");
        this.addOutputTerms((org.gbif.dwc.terms.Term)GbifTerm.Identifier, Arrays.asList(new org.gbif.dwc.terms.Term[]{DcTerm.title, ALATerm.status, DcTerm.source}));
        DwcaWriter dwcaWriter = new DwcaWriter((org.gbif.dwc.terms.Term)DwcTerm.Taxon, (org.gbif.dwc.terms.Term)DwcTerm.taxonID, directory, true);
        dwcaWriter.setEml(this.buildEml());
        for (NameProvider provider : this.providers.values()) {
            if (!provider.isExternal()) continue;
            dwcaWriter.addDetatchedRecord((org.gbif.dwc.terms.Term)DcTerm.rightsHolder, provider.getProviderMap());
        }
        ArrayList<ScientificName> nameList = new ArrayList<ScientificName>(this.names.values());
        Collections.sort(nameList);
        for (ScientificName name : nameList) {
            name.write(this, dwcaWriter);
        }
        dwcaWriter.close();
        logger.info("Finished creating DwCA");
    }

    protected Dataset buildEml() throws IndexBuilderException {
        Dataset dataset = new Dataset();
        Date now = new Date();
        String altId = MessageFormat.format("{0}-{1,date,yyyyMMdd}", this.configuration.id, now);
        dataset.setAbbreviation(this.configuration.id);
        dataset.setAdditionalInfo(this.resources.getString("dwca.additionalInfo"));
        dataset.setAlias(altId);
        dataset.setCitation(new Citation(this.configuration.name, this.configuration.id));
        dataset.setCreatedBy(this.configuration.getContactName());
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        if (this.configuration.contact != null) {
            try {
                Contact primary = (Contact)BeanUtils.cloneBean((Object)this.configuration.contact);
                primary.setType(ContactType.ORIGINATOR);
                primary.setPrimary(true);
                contacts.add(primary);
                Contact metadata = (Contact)BeanUtils.cloneBean((Object)this.configuration.contact);
                metadata.setType(ContactType.METADATA_AUTHOR);
                metadata.setPrimary(true);
                contacts.add(metadata);
                Contact processor = (Contact)BeanUtils.cloneBean((Object)this.configuration.contact);
                metadata.setType(ContactType.PROCESSOR);
                metadata.setPrimary(false);
                contacts.add(metadata);
            }
            catch (Exception ex) {
                logger.error("Unable to clone contact", (Throwable)ex);
            }
        }
        contacts.addAll(this.sources.stream().flatMap(s -> s.getContacts().stream()).collect(Collectors.toSet()));
        dataset.setContacts(contacts);
        dataset.setCountryCoverage(this.sources.stream().flatMap(s -> s.getCountries().stream()).collect(Collectors.toSet()));
        dataset.setCreated(new Date());
        dataset.setDescription(this.configuration.description);
        ArrayList citations = new ArrayList();
        citations.addAll(this.sources.stream().map(s -> s.getCitation()).filter(c -> c != null).collect(Collectors.toList()));
        citations.addAll(this.providers.values().stream().filter(p -> p.isExternal()).map(p -> p.getCitation()).collect(Collectors.toList()));
        dataset.setBibliographicCitations(citations);
        ArrayList<Identifier> ids = new ArrayList<Identifier>();
        if (this.configuration.uri != null) {
            ids.add(new Identifier(IdentifierType.URI, this.configuration.uri.toString()));
        }
        if (this.configuration.id != null) {
            ids.add(new Identifier(IdentifierType.UNKNOWN, this.configuration.id));
        }
        dataset.setIdentifiers(ids);
        dataset.setPubDate(now);
        dataset.setTitle(this.configuration.name);
        return dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(IssueType type, String code, String taxonID, String scientificName, String scientificNameAuthorship, String ... args) {
        String message;
        try {
            Object[] av = new String[3 + args.length];
            av[0] = taxonID == null ? "" : taxonID;
            av[1] = scientificName == null ? "" : scientificName;
            av[2] = scientificNameAuthorship == null ? "" : scientificNameAuthorship;
            for (int i = 0; args != null && i < args.length; ++i) {
                av[3 + i] = args[i];
            }
            message = this.resources.getString(code);
            message = message == null ? code : message;
            message = MessageFormat.format(message, av);
        }
        catch (MissingResourceException ex) {
            logger.error("Can't find resource for " + code + " defaulting to code");
            message = code;
        }
        switch (type) {
            case ERROR: 
            case VALIDATION: {
                logger.error(message);
                break;
            }
            case PROBLEM: {
                logger.warn(message);
                break;
            }
            case COLLISION: {
                logger.info(message);
                break;
            }
            case NOTE: 
            case COUNT: {
                logger.debug(message);
                break;
            }
            default: {
                logger.warn("Unknown message type " + (Object)((Object)type) + ": " + message);
            }
        }
        Document doc = new Document();
        doc.add((IndexableField)new StringField("type", ALATerm.TaxonomicIssue.qualifiedName(), Field.Store.YES));
        doc.add((IndexableField)new StringField("id", UUID.randomUUID().toString(), Field.Store.YES));
        doc.add((IndexableField)new StringField(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DcTerm.type), type.name(), Field.Store.YES));
        doc.add((IndexableField)new StringField(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DcTerm.subject), code, Field.Store.YES));
        doc.add((IndexableField)new StringField(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DcTerm.description), message, Field.Store.YES));
        doc.add((IndexableField)new StringField(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DcTerm.date), ISO8601.format(OffsetDateTime.now()), Field.Store.YES));
        if (taxonID != null) {
            doc.add((IndexableField)new StringField(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.taxonID), taxonID, Field.Store.YES));
        }
        if (scientificName != null) {
            doc.add((IndexableField)new StringField(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.scientificName), scientificName, Field.Store.YES));
        }
        if (scientificNameAuthorship != null) {
            doc.add((IndexableField)new StringField(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.scientificNameAuthorship), scientificNameAuthorship, Field.Store.YES));
        }
        if (args != null && args.length > 0) {
            doc.add((IndexableField)new StringField(Taxonomy.fieldName(ALATerm.value), args[0], Field.Store.YES));
        }
        try {
            Taxonomy i = this;
            synchronized (i) {
                this.indexWriter.addDocument((Iterable)doc);
                this.indexWriter.commit();
                this.searcherManager.maybeRefresh();
            }
        }
        catch (IOException ex) {
            logger.error("Unable to write report to index", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(IssueType type, String code, TaxonomicElement main, List<? extends TaxonomicElement> associated) {
        String message;
        String taxonID = null;
        String associatedTaxa = "";
        String associatedDesc = "";
        String datasetID = "";
        String scientificName = "";
        String scientificNameAuthorship = "";
        String nomenclauturalCode = "";
        String taxonRank = "";
        String taxonomicStatus = "";
        if (main != null) {
            TaxonConceptInstance primary;
            taxonID = main.getTaxonID();
            if (main.getScientificName() != null) {
                scientificName = main.getScientificName();
            }
            if (main.getScientificNameAuthorship() != null) {
                scientificNameAuthorship = main.getScientificNameAuthorship();
            }
            if (main.getRank() != null) {
                taxonRank = main.getRank().getRank();
            }
            if ((primary = main instanceof TaxonConceptInstance ? (TaxonConceptInstance)main : main.getRepresentative()) != null) {
                datasetID = primary.getProvider().getId();
                if (primary.getCode() != null) {
                    nomenclauturalCode = primary.getCode().getAcronym();
                }
                if (primary.getTaxonomicStatus() != null) {
                    taxonomicStatus = primary.getTaxonomicStatus().getTerm();
                }
            }
        }
        if (taxonID == null) {
            taxonID = "";
        }
        if (associated != null && !associated.isEmpty()) {
            StringBuilder ab = new StringBuilder();
            StringBuilder as = new StringBuilder();
            for (TaxonomicElement taxonomicElement : associated) {
                if (ab.length() > 0) {
                    ab.append("|");
                    as.append(", ");
                }
                ab.append(taxonomicElement.getTaxonID());
                as.append(taxonomicElement.toString());
            }
            associatedTaxa = ab.toString();
            associatedDesc = as.toString();
        }
        Object[] args = new String[]{taxonID, scientificName, scientificNameAuthorship, associatedTaxa, main.toString(), associatedDesc};
        try {
            message = this.resources.getString(code);
            message = MessageFormat.format(message == null ? code : message, args);
        }
        catch (MissingResourceException ex) {
            logger.error("Can't find resource for " + code + " defaulting to code");
            message = code + " " + args;
        }
        switch (type) {
            case ERROR: 
            case VALIDATION: {
                logger.error(message);
                break;
            }
            case PROBLEM: {
                logger.warn(message);
                break;
            }
            case COLLISION: {
                logger.info(message);
                break;
            }
            case NOTE: 
            case COUNT: {
                logger.debug(message);
                break;
            }
            default: {
                logger.warn("Unknown message type " + (Object)((Object)type) + ": " + message);
            }
        }
        Document doc = new Document();
        doc.add((IndexableField)new StringField("type", ALATerm.TaxonomicIssue.qualifiedName(), Field.Store.YES));
        doc.add((IndexableField)new StringField("id", UUID.randomUUID().toString(), Field.Store.YES));
        doc.add((IndexableField)new StringField(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DcTerm.type), type.name(), Field.Store.YES));
        doc.add((IndexableField)new StringField(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DcTerm.subject), code, Field.Store.YES));
        doc.add((IndexableField)new StringField(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DcTerm.description), message, Field.Store.YES));
        doc.add((IndexableField)new StringField(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DcTerm.date), ISO8601.format(OffsetDateTime.now()), Field.Store.YES));
        doc.add((IndexableField)new StringField(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.taxonID), taxonID, Field.Store.YES));
        doc.add((IndexableField)new StringField(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.scientificName), scientificName, Field.Store.YES));
        doc.add((IndexableField)new StringField(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.scientificNameAuthorship), scientificNameAuthorship, Field.Store.YES));
        doc.add((IndexableField)new StringField(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.nomenclaturalCode), nomenclauturalCode, Field.Store.YES));
        doc.add((IndexableField)new StringField(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.taxonRank), taxonRank, Field.Store.YES));
        doc.add((IndexableField)new StringField(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.taxonomicStatus), taxonomicStatus, Field.Store.YES));
        doc.add((IndexableField)new StringField(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.associatedTaxa), associatedTaxa, Field.Store.YES));
        doc.add((IndexableField)new StringField(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.datasetID), datasetID, Field.Store.YES));
        try {
            Taxonomy taxonomy = this;
            synchronized (taxonomy) {
                this.indexWriter.addDocument((Iterable)doc);
                this.indexWriter.commit();
                this.searcherManager.maybeRefresh();
            }
        }
        catch (IOException iOException) {
            logger.error("Unable to write report to index", (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createReport(File report) throws IOException {
        logger.info("Writing report to " + report);
        int pageSize = 100;
        try (OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(report), "UTF-8");){
            CSVWriter writer = new CSVWriter((Writer)fw);
            List<org.gbif.dwc.terms.Term> output = this.outputTerms(ALATerm.TaxonomicIssue);
            String[] headers = output.stream().map(term -> term.toString()).collect(Collectors.toList()).toArray(new String[output.size()]);
            writer.writeNext(headers);
            this.counts.keySet().stream().sorted().forEach(type -> {
                String message = this.resources.getString((String)type);
                AtomicInteger count = this.counts.getOrDefault(type, new AtomicInteger(0));
                message = MessageFormat.format(message, count.intValue());
                logger.info(message);
                HashMap<Object, String> doc = new HashMap<Object, String>();
                doc.put(DcTerm.type, IssueType.COUNT.name());
                doc.put(DcTerm.subject, (String)type);
                doc.put(DcTerm.description, message);
                doc.put((Object)ALATerm.value, count.toString());
                String[] values = output.stream().map(term -> (String)doc.get(term)).collect(Collectors.toList()).toArray(new String[output.size()]);
                writer.writeNext(values);
            });
            IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
            try {
                TermQuery query = new TermQuery(new Term("type", ALATerm.TaxonomicIssue.qualifiedName()));
                TopFieldDocs docs = searcher.search((Query)query, pageSize, Sort.INDEXORDER);
                ScoreDoc last = null;
                while (docs.scoreDocs.length > 0) {
                    ScoreDoc[] scoreDocArray = docs.scoreDocs;
                    int n = scoreDocArray.length;
                    for (int i = 0; i < n; ++i) {
                        ScoreDoc sd;
                        last = sd = scoreDocArray[i];
                        Document doc = searcher.doc(sd.doc);
                        String[] values = output.stream().map(term -> doc.get(Taxonomy.fieldName(term))).collect(Collectors.toList()).toArray(new String[output.size()]);
                        writer.writeNext(values);
                        this.count("count.write.report");
                    }
                    docs = searcher.searchAfter(last, (Query)query, pageSize, Sort.INDEXORDER);
                }
            }
            finally {
                this.searcherManager.release((Object)searcher);
            }
        }
        logger.info("Finished creating report");
    }

    public void createWorkingIndex() throws IOException {
        logger.info("Creating working name index");
        File interim = File.createTempFile("interim", "combined", this.work);
        if (!interim.delete()) {
            throw new IndexBuilderException("Unable to delete interim file " + interim);
        }
        if (!interim.mkdirs()) {
            throw new IndexBuilderException("Unable to create interim directory " + interim);
        }
        File searchIndex = File.createTempFile("interim", "index", this.work);
        if (!searchIndex.delete()) {
            throw new IndexBuilderException("Unable to delete interim index file " + searchIndex);
        }
        if (!searchIndex.mkdirs()) {
            throw new IndexBuilderException("Unable to create interim index directory " + searchIndex);
        }
        File tmpIndex = File.createTempFile("interim", "tmp", this.work);
        if (!tmpIndex.delete()) {
            throw new IndexBuilderException("Unable to delete interim tmp file " + searchIndex);
        }
        if (!tmpIndex.mkdirs()) {
            throw new IndexBuilderException("Unable to create interim tmp directory " + searchIndex);
        }
        this.createDwCA(interim);
        try {
            DwcaNameIndexer indexer = new DwcaNameIndexer(searchIndex, tmpIndex, this.configuration.getPriorities(), true, true);
            indexer.begin();
            indexer.createLoadingIndex(interim);
            indexer.commitLoadingIndexes();
            indexer.generateIndex();
            indexer.create(interim);
            indexer.commit();
        }
        catch (Exception ex) {
            throw new IndexBuilderException("Unable to build working index");
        }
        finally {
            this.searcherManager.maybeRefresh();
        }
        this.workingIndex = new ALANameSearcher(searchIndex.getCanonicalPath());
        logger.info("Created working name index");
    }

    private void makeWorkArea(File work) throws IndexBuilderException {
        try {
            this.work = work == null ? File.createTempFile("name", "work") : File.createTempFile("name", ".work", work);
            this.work.delete();
            this.work.mkdirs();
            FileUtils.clear(this.work, false);
            this.index = new File(this.work, "index");
            this.index.mkdir();
            this.indexDir = new SimpleFSDirectory(this.index);
        }
        catch (IOException ex) {
            throw new IndexBuilderException("Unable to build work area", ex);
        }
    }

    private void makeBaseOutputMap() {
        this.outputMap = new HashMap<org.gbif.dwc.terms.Term, Set<org.gbif.dwc.terms.Term>>();
        for (Map.Entry<org.gbif.dwc.terms.Term, List<org.gbif.dwc.terms.Term>> entry : NameSource.REQUIRED_TERMS.entrySet()) {
            this.outputMap.put(entry.getKey(), new HashSet(entry.getValue()));
        }
    }

    public void addRecords(List<Document> documents) throws IOException {
        for (Document doc : documents) {
            this.indexWriter.addDocument((Iterable)doc);
        }
    }

    public void addOutputTerms(org.gbif.dwc.terms.Term type, Collection<org.gbif.dwc.terms.Term> terms) {
        Map<org.gbif.dwc.terms.Term, List<org.gbif.dwc.terms.Term>> implied;
        List<org.gbif.dwc.terms.Term> additional;
        Set<org.gbif.dwc.terms.Term> map = this.outputMap.get(type);
        if (map == null) {
            map = new HashSet<org.gbif.dwc.terms.Term>(terms.size());
            this.outputMap.put(type, map);
        }
        HashSet<org.gbif.dwc.terms.Term> seen = new HashSet<org.gbif.dwc.terms.Term>(map);
        List<org.gbif.dwc.terms.Term> remove = NameSource.FORBIDDEN_TERMS.get(type);
        boolean strict = NameSource.ONLY_INCLUDE_ALLOWED.getOrDefault(type, false);
        if (remove != null) {
            seen.addAll(remove);
        }
        if ((additional = NameSource.ADDITIONAL_TERMS.get(type)) != null) {
            for (org.gbif.dwc.terms.Term term : additional) {
                if (seen.contains(term) || !terms.contains(term)) continue;
                map.add(term);
                seen.add(term);
            }
        }
        if ((implied = NameSource.IMPLIED_TERMS.get(type)) != null) {
            for (Map.Entry<org.gbif.dwc.terms.Term, List<org.gbif.dwc.terms.Term>> entry : implied.entrySet()) {
                if (!terms.contains(entry.getKey())) continue;
                for (org.gbif.dwc.terms.Term term : entry.getValue()) {
                    if (seen.contains(term)) continue;
                    map.add(term);
                    seen.add(term);
                }
            }
        }
        if (!strict) {
            for (org.gbif.dwc.terms.Term term : terms) {
                if (seen.contains(term)) continue;
                map.add(term);
            }
        }
    }

    public void addProvenanceToOutput() {
        Set<org.gbif.dwc.terms.Term> map = this.outputMap.get(DwcTerm.Taxon);
        map.add((org.gbif.dwc.terms.Term)DcTerm.provenance);
        map = this.outputMap.get((Object)ALATerm.TaxonVariant);
        map.add((org.gbif.dwc.terms.Term)DcTerm.provenance);
        map = this.outputMap.get(GbifTerm.VernacularName);
        map.add((org.gbif.dwc.terms.Term)DcTerm.provenance);
        map = this.outputMap.get(GbifTerm.Identifier);
        map.add((org.gbif.dwc.terms.Term)DcTerm.provenance);
        map = this.outputMap.get(GbifTerm.Distribution);
        map.add((org.gbif.dwc.terms.Term)DcTerm.provenance);
    }

    public void addRemarksToOutput() {
        Set<org.gbif.dwc.terms.Term> map = this.outputMap.get(DwcTerm.Taxon);
        map.add((org.gbif.dwc.terms.Term)DwcTerm.taxonRemarks);
        map = this.outputMap.get((Object)ALATerm.TaxonVariant);
        map.add((org.gbif.dwc.terms.Term)DwcTerm.taxonRemarks);
        map.add(ALATerm.verbatimTaxonRemarks);
        map = this.outputMap.get(GbifTerm.VernacularName);
        map.add((org.gbif.dwc.terms.Term)DwcTerm.taxonRemarks);
        map = this.outputMap.get(GbifTerm.Identifier);
        map.add((org.gbif.dwc.terms.Term)DwcTerm.taxonRemarks);
        map = this.outputMap.get(GbifTerm.Distribution);
        map.add((org.gbif.dwc.terms.Term)DwcTerm.taxonRemarks);
    }

    public List<org.gbif.dwc.terms.Term> outputTerms(org.gbif.dwc.terms.Term type) {
        HashSet<org.gbif.dwc.terms.Term> used = new HashSet<org.gbif.dwc.terms.Term>(this.outputMap.getOrDefault(type, new HashSet()));
        used.addAll(DEFAULT_TERMS);
        ArrayList<org.gbif.dwc.terms.Term> order = new ArrayList<org.gbif.dwc.terms.Term>(used.size());
        for (org.gbif.dwc.terms.Term required : NameSource.REQUIRED_TERMS.getOrDefault(type, DEFAULT_TERMS)) {
            if (used.contains(required)) {
                order.add(required);
            }
            used.remove(required);
        }
        for (org.gbif.dwc.terms.Term additional : NameSource.ADDITIONAL_TERMS.getOrDefault(type, DEFAULT_TERMS)) {
            if (used.contains(additional)) {
                order.add(additional);
            }
            used.remove(additional);
        }
        order.addAll(used);
        return order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<org.gbif.dwc.terms.Term, String>> getIndexValues(org.gbif.dwc.terms.Term type, String taxonID) throws IOException {
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term("type", type.qualifiedName())), BooleanClause.Occur.MUST);
        query.add((Query)new TermQuery(new Term(Taxonomy.fieldName((org.gbif.dwc.terms.Term)DwcTerm.taxonID), taxonID)), BooleanClause.Occur.MUST);
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            TopFieldDocs docs = searcher.search((Query)query, 100, Sort.INDEXORDER);
            ArrayList<Map<org.gbif.dwc.terms.Term, String>> valueList = new ArrayList<Map<org.gbif.dwc.terms.Term, String>>(docs.totalHits);
            for (ScoreDoc sd : docs.scoreDocs) {
                Document document = searcher.doc(sd.doc);
                HashMap<org.gbif.dwc.terms.Term, String> values = new HashMap<org.gbif.dwc.terms.Term, String>();
                for (IndexableField field : document) {
                    if (field.name().equals("id") || field.name().equals("type")) continue;
                    org.gbif.dwc.terms.Term term = fieldTerms.get(field.name());
                    if (term == null) {
                        throw new IllegalStateException("Can't find term for " + field.name());
                    }
                    values.put(term, field.stringValue());
                }
                valueList.add(values);
            }
            ArrayList<Map<org.gbif.dwc.terms.Term, String>> arrayList = valueList;
            return arrayList;
        }
        finally {
            this.searcherManager.release((Object)searcher);
        }
    }

    public void clean() throws IOException {
        FileUtils.clear(this.work, true);
    }

    public NameProvider getInferenceProvider() {
        return this.inferenceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fieldName(org.gbif.dwc.terms.Term term) {
        String name = fieldNames.get(term);
        if (name == null) {
            name = term.toString().replace(':', '_');
            Map<org.gbif.dwc.terms.Term, String> map = fieldNames;
            synchronized (map) {
                fieldNames.put(term, name);
                fieldTerms.put(name, term);
            }
        }
        return name;
    }
}

