/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.NameKey;
import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.index.Taxonomy;
import au.org.ala.names.model.RankType;
import java.util.Comparator;

public abstract class TaxonomicElement<T extends TaxonomicElement, C extends TaxonomicElement> {
    public static final int MAX_SCORE = 1000000;
    public static final int MIN_SCORE = -1000000;
    public static final Comparator<TaxonomicElement> PROVIDER_SCORE_COMPARATOR = new Comparator<TaxonomicElement>(){

        @Override
        public int compare(TaxonomicElement e1, TaxonomicElement e2) {
            if (e1 == null && e2 == null) {
                return 0;
            }
            if (e1 == null && e2 != null) {
                return -1000000;
            }
            if (e1 != null && e2 == null) {
                return 1000000;
            }
            int o1 = e1.getProviderScore();
            int o2 = e2.getProviderScore();
            try {
                return Math.subtractExact(o1, o2);
            }
            catch (Exception ex) {
                if (o1 > o2) {
                    return 1000000;
                }
                if (o2 > o1) {
                    return -1000000;
                }
                return 0;
            }
        }
    };
    public static final Comparator<TaxonomicElement> REVERSE_PROVIDER_SCORE_COMPARATOR = PROVIDER_SCORE_COMPARATOR.reversed();
    public static final Comparator<TaxonomicElement> PRINCIPAL_SCORE_COMPARATOR = new Comparator<TaxonomicElement>(){

        @Override
        public int compare(TaxonomicElement e1, TaxonomicElement e2) {
            if (e1 == null && e2 == null) {
                return 0;
            }
            if (e1 == null && e2 != null) {
                return -1000000;
            }
            if (e1 != null && e2 == null) {
                return 1000000;
            }
            int o1 = e1.getPrincipalScore();
            int o2 = e2.getPrincipalScore();
            try {
                return Math.subtractExact(o1, o2);
            }
            catch (Exception ex) {
                if (o1 > o2) {
                    return 1000000;
                }
                if (o2 > o1) {
                    return -1000000;
                }
                return 0;
            }
        }
    };
    public static final Comparator<TaxonomicElement> REVERSE_PRINCIPAL_SCORE_COMPARATOR = PRINCIPAL_SCORE_COMPARATOR.reversed();
    private C container;

    public TaxonomicElement() {
        this.container = null;
    }

    public TaxonomicElement(C container) {
        this.container = container;
    }

    public C getContainer() {
        return this.container;
    }

    public void setContainer(C container) {
        this.container = container;
    }

    public abstract boolean validate(Taxonomy var1);

    public abstract String getTaxonID();

    public abstract String getId();

    public abstract String getScientificName();

    public abstract String getScientificNameAuthorship();

    public abstract RankType getRank();

    public abstract TaxonConceptInstance getRepresentative();

    public abstract int getPrincipalScore();

    public abstract int getProviderScore();

    public abstract <E extends TaxonomicElement> E addInstance(NameKey var1, TaxonConceptInstance var2);

    public abstract void reallocate(T var1, Taxonomy var2, String var3);
}

