/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.CSVNameSource;
import au.org.ala.names.index.DwcaNameSource;
import au.org.ala.names.index.IndexBuilderException;
import au.org.ala.names.index.Taxonomy;
import au.org.ala.vocab.ALATerm;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.gbif.api.model.registry.Citation;
import org.gbif.api.model.registry.Contact;
import org.gbif.api.vocabulary.Country;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.GbifTerm;
import org.gbif.dwc.terms.IucnTerm;
import org.gbif.dwc.terms.Term;

public abstract class NameSource {
    protected static final List<Term> TAXON_REQUIRED = Arrays.asList(DwcTerm.taxonID, DwcTerm.parentNameUsageID, DwcTerm.acceptedNameUsageID, DwcTerm.nomenclaturalCode, DwcTerm.scientificName, DwcTerm.scientificNameAuthorship, DwcTerm.taxonomicStatus, DwcTerm.taxonRank, DwcTerm.datasetID);
    protected static final List<Term> TAXON_ADDITIONAL = Arrays.asList(new Term[]{DwcTerm.acceptedNameUsage, DwcTerm.parentNameUsage, DwcTerm.taxonConceptID, DwcTerm.scientificNameID, DwcTerm.nomenclaturalStatus, DwcTerm.kingdom, DwcTerm.phylum, DwcTerm.class_, DwcTerm.order, DwcTerm.family, DwcTerm.genus, DwcTerm.specificEpithet, DwcTerm.infraspecificEpithet, ALATerm.nameComplete, ALATerm.nameFormatted, DwcTerm.nameAccordingToID, DwcTerm.nameAccordingTo, DwcTerm.namePublishedInID, DwcTerm.namePublishedIn, DwcTerm.namePublishedInYear, DcTerm.source, DwcTerm.taxonRemarks, DcTerm.provenance});
    protected static final List<Term> TAXON_FORBIDDEN = Arrays.asList(new Term[]{ALATerm.subphylum, ALATerm.subclass, ALATerm.suborder, ALATerm.infraorder, ALATerm.kingdomID, ALATerm.phylumID, ALATerm.classID, ALATerm.orderID, ALATerm.familyID, ALATerm.genusID, ALATerm.speciesID});
    protected static final List<Term> IDENTIFIER_REQUIRED = Arrays.asList(DcTerm.identifier, DwcTerm.datasetID);
    protected static final List<Term> IDENTIFIER_ADDITIONAL = Arrays.asList(new Term[]{DcTerm.title, DcTerm.subject, DcTerm.format, ALATerm.status, DcTerm.source, DwcTerm.taxonRemarks, DcTerm.provenance});
    protected static final List<Term> IDENTIFIER_FORBIDDEN = Arrays.asList(new Term[0]);
    protected static final List<Term> VERNACULAR_REQUIRED = Arrays.asList(DwcTerm.vernacularName, DwcTerm.datasetID);
    protected static final List<Term> VERNACULAR_ADDITIONAL = Arrays.asList(new Term[]{ALATerm.nameID, DcTerm.language, DcTerm.temporal, DwcTerm.locationID, DwcTerm.locality, DwcTerm.countryCode, DwcTerm.sex, DwcTerm.lifeStage, GbifTerm.isPlural, GbifTerm.isPreferredName, GbifTerm.organismPart, DwcTerm.taxonRemarks, ALATerm.status, DcTerm.source, DcTerm.provenance});
    protected static final List<Term> VERNACULAR_FORBIDDEN = Arrays.asList(DwcTerm.scientificName, DwcTerm.scientificNameAuthorship, DwcTerm.nomenclaturalCode, DwcTerm.taxonRank, DwcTerm.kingdom, DwcTerm.phylum, DwcTerm.class_, DwcTerm.order, DwcTerm.family, DwcTerm.genus, DwcTerm.specificEpithet, DwcTerm.infraspecificEpithet);
    protected static final List<Term> DISTRIBUTION_REQUIRED = Arrays.asList(DwcTerm.datasetID);
    protected static final List<Term> DISTRIBUTION_ADDITIONAL = Arrays.asList(DwcTerm.countryCode, DwcTerm.stateProvince, DwcTerm.locationID, DwcTerm.locality, DwcTerm.lifeStage, DwcTerm.occurrenceStatus, IucnTerm.threatStatus, DwcTerm.establishmentMeans, GbifTerm.appendixCITES, DwcTerm.eventDate, DwcTerm.startDayOfYear, DwcTerm.endDayOfYear, DwcTerm.occurrenceRemarks, DcTerm.source, DcTerm.provenance);
    protected static final List<Term> DISTRIBUTION_FORBIDDEN = Arrays.asList(new Term[0]);
    protected static final List<Term> TAXON_VARIANT_REQUIRED = Arrays.asList(new Term[]{DwcTerm.taxonID, DwcTerm.nomenclaturalCode, DwcTerm.scientificName, DwcTerm.scientificNameAuthorship, DwcTerm.taxonomicStatus, DwcTerm.taxonRank, DwcTerm.datasetID, ALATerm.priority});
    protected static final List<Term> TAXON_VARIANT_ADDITIONAL = Arrays.asList(new Term[]{DwcTerm.taxonConceptID, DwcTerm.scientificNameID, DwcTerm.nomenclaturalStatus, ALATerm.nameComplete, ALATerm.nameFormatted, DwcTerm.nameAccordingToID, DwcTerm.nameAccordingTo, DwcTerm.namePublishedInID, DwcTerm.namePublishedIn, DwcTerm.namePublishedInYear, DcTerm.source, DwcTerm.taxonRemarks, DcTerm.provenance, ALATerm.verbatimNomenclaturalCode, ALATerm.verbatimTaxonomicStatus, ALATerm.verbatimNomenclaturalStatus, DwcTerm.verbatimTaxonRank, ALATerm.verbatimTaxonRemarks});
    protected static final Map<Term, List<Term>> TAXON_VARIANT_IMPLIED_TERMS = MapUtils.putAll(new HashMap(), (Object[])new Object[][]{{DwcTerm.nomenclaturalCode, Arrays.asList(ALATerm.verbatimNomenclaturalCode)}, {DwcTerm.taxonomicStatus, Arrays.asList(ALATerm.verbatimTaxonomicStatus)}, {DwcTerm.nomenclaturalStatus, Arrays.asList(ALATerm.verbatimNomenclaturalStatus)}, {DwcTerm.taxonRemarks, Arrays.asList(ALATerm.verbatimTaxonRemarks)}});
    protected static final List<Term> TAXONOMIC_ISSUE_REQUIRED = Arrays.asList(new Term[]{DcTerm.type, DcTerm.subject, DcTerm.description, DcTerm.date, DwcTerm.taxonID, DwcTerm.scientificName, DwcTerm.scientificNameAuthorship, DwcTerm.nomenclaturalCode, DwcTerm.taxonRank, DwcTerm.taxonomicStatus, DwcTerm.associatedTaxa, DwcTerm.datasetID, ALATerm.value});
    protected static final List<Term> TAXONOMIC_ISSUE_ADDITIONAL = Arrays.asList(new Term[0]);
    protected static final List<Term> TAXONOMIC_ISSUE_FORBIDDEN = Arrays.asList(new Term[0]);
    protected static final Map<Term, List<Term>> REQUIRED_TERMS = MapUtils.putAll(new HashMap(), (Object[])new Object[][]{{DwcTerm.Taxon, TAXON_REQUIRED}, {GbifTerm.Identifier, IDENTIFIER_REQUIRED}, {GbifTerm.VernacularName, VERNACULAR_REQUIRED}, {GbifTerm.Distribution, DISTRIBUTION_REQUIRED}, {ALATerm.TaxonVariant, TAXON_VARIANT_REQUIRED}, {ALATerm.TaxonomicIssue, TAXONOMIC_ISSUE_REQUIRED}});
    protected static final Map<Term, List<Term>> ADDITIONAL_TERMS = MapUtils.putAll(new HashMap(), (Object[])new Object[][]{{DwcTerm.Taxon, TAXON_ADDITIONAL}, {GbifTerm.Identifier, IDENTIFIER_ADDITIONAL}, {GbifTerm.VernacularName, VERNACULAR_ADDITIONAL}, {GbifTerm.Distribution, DISTRIBUTION_ADDITIONAL}, {ALATerm.TaxonVariant, TAXON_VARIANT_ADDITIONAL}, {ALATerm.TaxonomicIssue, TAXONOMIC_ISSUE_ADDITIONAL}});
    protected static final Map<Term, List<Term>> FORBIDDEN_TERMS = MapUtils.putAll(new HashMap(), (Object[])new Object[][]{{DwcTerm.Taxon, TAXON_FORBIDDEN}, {GbifTerm.Identifier, IDENTIFIER_FORBIDDEN}, {GbifTerm.VernacularName, VERNACULAR_FORBIDDEN}, {GbifTerm.Distribution, DISTRIBUTION_FORBIDDEN}, {ALATerm.TaxonVariant, TAXON_FORBIDDEN}, {ALATerm.TaxonomicIssue, TAXONOMIC_ISSUE_FORBIDDEN}});
    protected static final Map<Term, Map<Term, List<Term>>> IMPLIED_TERMS = MapUtils.putAll(new HashMap(), (Object[])new Object[][]{{ALATerm.TaxonVariant, TAXON_VARIANT_IMPLIED_TERMS}});
    protected static final Map<Term, Boolean> ONLY_INCLUDE_ALLOWED = MapUtils.putAll(new HashMap(), (Object[])new Object[][]{{DwcTerm.Taxon, false}, {GbifTerm.Identifier, false}, {GbifTerm.VernacularName, false}, {GbifTerm.Distribution, false}, {ALATerm.TaxonVariant, true}, {ALATerm.TaxonomicIssue, true}});

    public abstract String getName();

    public abstract void validate() throws IndexBuilderException;

    public abstract void loadIntoTaxonomy(Taxonomy var1) throws IndexBuilderException;

    public abstract Citation getCitation() throws IndexBuilderException;

    public abstract Collection<Country> getCountries() throws IndexBuilderException;

    public abstract Collection<Contact> getContacts() throws IndexBuilderException;

    public static NameSource create(String f) throws IndexBuilderException {
        try {
            File nf = new File(f);
            if (!nf.exists()) {
                throw new IndexBuilderException("Name source " + nf + " does not exist");
            }
            NameSource ns = nf.isDirectory() ? new DwcaNameSource(nf) : new CSVNameSource(nf.toPath(), "UTF-8", (Term)DwcTerm.Taxon);
            ((NameSource)ns).validate();
            return ns;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

