/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.IssueType;
import au.org.ala.names.index.NameKey;
import au.org.ala.names.index.Reporter;
import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.index.TaxonomicElement;
import au.org.ala.names.model.RankType;
import au.org.ala.names.model.TaxonomicType;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.gbif.api.vocabulary.NomenclaturalCode;
import org.gbif.api.vocabulary.NomenclaturalStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NameAnalyser
implements Comparator<NameKey>,
Reporter {
    private static final Logger logger = LoggerFactory.getLogger(NameAnalyser.class);
    protected static final boolean REPORT_INFORMAL = true;
    private Reporter reporter;

    public NameKey analyse(TaxonConceptInstance instance) {
        return this.analyse(instance.getCode(), instance.getScientificName(), instance.getScientificNameAuthorship(), instance.getRank(), false);
    }

    public NameKey analyse(String code, String scientificName, String scientificNameAuthorship, String rank) {
        NomenclaturalCode canonicalCode = this.canonicaliseCode(code);
        RankType rankType = this.canonicaliseRank(rank);
        return this.analyse(canonicalCode, scientificName, scientificNameAuthorship, rankType, false);
    }

    public abstract NameKey analyse(@Nullable NomenclaturalCode var1, String var2, @Nullable String var3, @Nullable RankType var4, boolean var5);

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public abstract NomenclaturalCode canonicaliseCode(String var1);

    public abstract TaxonomicType canonicaliseTaxonomicType(String var1);

    public abstract RankType canonicaliseRank(String var1);

    public abstract NomenclaturalStatus canonicaliseNomenclaturalStatus(String var1);

    public abstract boolean isInformal(String var1);

    @Override
    public abstract int compare(NameKey var1, NameKey var2);

    public abstract int hashCode(NameKey var1);

    @Override
    public void report(IssueType type, String code, String taxonID, String scientificName, String scientificNameAuthorship, String ... args) {
        if (this.reporter != null) {
            this.reporter.report(type, code, taxonID, scientificName, scientificNameAuthorship, args);
        } else {
            logger.warn("Report " + type.name() + " code=" + code + " args=" + Arrays.toString(args));
        }
    }

    @Override
    public void report(IssueType type, String code, TaxonomicElement main, List<? extends TaxonomicElement> associated) {
        if (this.reporter != null) {
            this.reporter.report(type, code, main, associated);
        } else {
            logger.warn("Report " + type.name() + " code=" + code + " main=" + main.toString() + " associated=" + associated);
        }
    }

    public abstract int compareAuthor(String var1, String var2);
}

