/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.IndexBuilderException;
import au.org.ala.names.index.IssueType;
import au.org.ala.names.index.NameProvider;
import au.org.ala.names.index.NameSource;
import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.index.Taxonomy;
import au.org.ala.names.model.RankType;
import au.org.ala.names.model.TaxonomicType;
import au.org.ala.vocab.ALATerm;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.gbif.api.model.registry.Citation;
import org.gbif.api.model.registry.Contact;
import org.gbif.api.model.registry.Dataset;
import org.gbif.api.vocabulary.ContactType;
import org.gbif.api.vocabulary.Country;
import org.gbif.api.vocabulary.NomenclaturalCode;
import org.gbif.api.vocabulary.NomenclaturalStatus;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.GbifTerm;
import org.gbif.dwc.terms.Term;
import org.gbif.dwca.io.Archive;
import org.gbif.dwca.io.ArchiveFactory;
import org.gbif.dwca.io.ArchiveFile;
import org.gbif.dwca.io.MetadataException;
import org.gbif.dwca.record.Record;
import org.gbif.dwca.record.StarRecord;

public class DwcaNameSource
extends NameSource {
    private Archive archive;

    public DwcaNameSource(Archive archive) {
        this.archive = archive;
    }

    public DwcaNameSource(File archiveDir) throws IOException {
        this(ArchiveFactory.openArchive((File)archiveDir));
    }

    @Override
    public String getName() {
        try {
            return this.archive.getLocation().getCanonicalPath();
        }
        catch (IOException e) {
            return "Unreadable archive";
        }
    }

    @Override
    public Citation getCitation() {
        try {
            Dataset dataset = this.archive.getMetadata();
            if (dataset != null) {
                return dataset.getCitation();
            }
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        return new Citation(this.getName(), this.archive.toString());
    }

    @Override
    public Collection<Country> getCountries() {
        try {
            Dataset dataset = this.archive.getMetadata();
            if (dataset != null) {
                return dataset.getCountryCoverage();
            }
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        return Collections.emptySet();
    }

    @Override
    public Collection<Contact> getContacts() {
        try {
            Dataset dataset = this.archive.getMetadata();
            if (dataset != null) {
                ArrayList<Contact> contacts = new ArrayList<Contact>();
                for (Contact contact : dataset.getContacts()) {
                    if (!contact.isPrimary() && contact.getType() != ContactType.ORIGINATOR) continue;
                    contact = (Contact)BeanUtils.cloneBean((Object)contact);
                    contact.setPrimary(false);
                    contact.setType(ContactType.CONTENT_PROVIDER);
                    contacts.add(contact);
                }
                return contacts;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptySet();
    }

    @Override
    public void validate() throws IndexBuilderException {
        this.checkStructure(this.archive.getCore());
        for (ArchiveFile ext : this.archive.getExtensions()) {
            this.checkStructure(ext);
        }
    }

    protected void checkStructure(ArchiveFile af) throws IndexBuilderException {
        List required = (List)REQUIRED_TERMS.get(af.getRowType());
        if (required != null) {
            for (Term term : required) {
                if (af.hasTerm(term)) continue;
                throw new IndexBuilderException("File " + af.getTitle() + " from " + this.archive.getLocation() + " is of type " + af.getRowType() + " and is missing " + term);
            }
        }
    }

    @Override
    public void loadIntoTaxonomy(Taxonomy taxonomy) throws IndexBuilderException {
        if (this.archive.getCore().getRowType() == DwcTerm.Taxon) {
            this.loadTaxonDwCA(taxonomy);
        } else if (this.archive.getCore().getRowType() == GbifTerm.VernacularName) {
            this.loadVernacularDwCA(taxonomy);
        } else {
            throw new IndexBuilderException("Unable to load from archive of type " + this.archive.getCore().getRowType());
        }
    }

    public void loadVernacularDwCA(Taxonomy taxonomy) throws IndexBuilderException {
        taxonomy.addOutputTerms(this.archive.getCore().getRowType(), this.archive.getCore().getTerms());
        String taxonID = null;
        Term type = null;
        for (ArchiveFile ext : this.archive.getExtensions()) {
            taxonomy.addOutputTerms(ext.getRowType(), ext.getTerms());
        }
        try {
            for (StarRecord record : this.archive) {
                Record core = record.core();
                taxonID = core.value((Term)DwcTerm.taxonID);
                type = core.rowType();
                if (taxonID == null) {
                    taxonID = UUID.randomUUID().toString();
                    type = ALATerm.UnplacedVernacularName;
                }
                ArrayList<Document> docs = new ArrayList<Document>();
                docs.add(this.makeDocument(taxonomy, type, core, taxonID));
                for (List ext : record.extensions().values()) {
                    for (Record er : ext) {
                        docs.add(this.makeDocument(taxonomy, er.rowType(), er, taxonID));
                    }
                }
                taxonomy.addRecords(docs);
            }
        }
        catch (Exception ex) {
            throw new IndexBuilderException("Unable to load archive " + this.archive.getLocation() + " at taxon " + taxonID, ex);
        }
    }

    protected void loadTaxonDwCA(Taxonomy taxonomy) throws IndexBuilderException {
        if (this.archive.getCore().getRowType() != DwcTerm.Taxon) {
            throw new IndexBuilderException("Expecting a core row type of " + DwcTerm.Taxon);
        }
        List classifiers = TaxonConceptInstance.CLASSIFICATION_FIELDS.stream().filter(t -> this.archive.getCore().hasTerm(t)).collect(Collectors.toList());
        taxonomy.addOutputTerms(this.archive.getCore().getRowType(), this.archive.getCore().getTerms());
        taxonomy.addOutputTerms(ALATerm.TaxonVariant, this.archive.getCore().getTerms());
        String taxonID = null;
        for (ArchiveFile ext : this.archive.getExtensions()) {
            taxonomy.addOutputTerms(ext.getRowType(), ext.getTerms());
        }
        try {
            for (StarRecord record : this.archive) {
                Record core = record.core();
                taxonID = core.value((Term)DwcTerm.taxonID);
                String verbatimNomenclaturalCode = core.value((Term)DwcTerm.nomenclaturalCode);
                NameProvider provider = taxonomy.resolveProvider(core.value((Term)DwcTerm.datasetID), core.value((Term)DwcTerm.datasetName));
                NomenclaturalCode code = taxonomy.resolveCode(verbatimNomenclaturalCode);
                String scientificName = core.value((Term)DwcTerm.scientificName);
                String scientificNameAuthorship = core.value((Term)DwcTerm.scientificNameAuthorship);
                if (code == null) {
                    code = provider.getDefaultNomenclaturalCode();
                    if (code == null && !provider.isLoose()) {
                        throw new IllegalStateException("No nomenclatural code for " + taxonID + " and code " + verbatimNomenclaturalCode);
                    }
                    if (code != null) {
                        taxonomy.report(IssueType.PROBLEM, "taxonomy.load.nullCode", taxonID, scientificName, scientificNameAuthorship, verbatimNomenclaturalCode);
                        taxonomy.count("count.load.problem");
                    }
                }
                String year = core.value((Term)DwcTerm.namePublishedInYear);
                String verbatimTaxonomicStatus = core.value((Term)DwcTerm.taxonomicStatus);
                TaxonomicType taxonomicStatus = taxonomy.resolveTaxonomicType(verbatimTaxonomicStatus);
                String verbatimTaxonRank = core.value((Term)DwcTerm.taxonRank);
                RankType rank = taxonomy.resolveRank(verbatimTaxonRank);
                String verbatimNomenclaturalStatus = core.value((Term)DwcTerm.nomenclaturalStatus);
                Set<NomenclaturalStatus> nomenclaturalStatus = taxonomy.resolveNomenclaturalStatus(verbatimNomenclaturalStatus);
                String parentNameUsage = core.value((Term)DwcTerm.parentNameUsage);
                String parentNameUsageID = core.value((Term)DwcTerm.parentNameUsageID);
                String acceptedNameUsage = core.value((Term)DwcTerm.acceptedNameUsage);
                String acceptedNameUsageID = core.value((Term)DwcTerm.acceptedNameUsageID);
                String verbatimTaxonRemarks = core.value((Term)DwcTerm.taxonRemarks);
                String verbatimProvenance = core.value((Term)DcTerm.provenance);
                List<String> taxonRemarks = verbatimTaxonRemarks == null || verbatimTaxonRemarks.isEmpty() ? null : Arrays.stream(verbatimTaxonRemarks.split("\\|")).map(s -> s.trim()).collect(Collectors.toList());
                List<String> provenance = verbatimProvenance == null || verbatimProvenance.isEmpty() ? null : Arrays.stream(verbatimProvenance.split("\\|")).map(s -> s.trim()).collect(Collectors.toList());
                Map<Term, Optional<String>> classification = classifiers.stream().collect(Collectors.toMap(t -> t, t -> Optional.ofNullable(core.value(t))));
                TaxonConceptInstance instance = new TaxonConceptInstance(taxonID, code, verbatimNomenclaturalCode, provider, scientificName, scientificNameAuthorship, year, taxonomicStatus, verbatimTaxonomicStatus, rank, verbatimTaxonRank, nomenclaturalStatus, verbatimNomenclaturalStatus, parentNameUsage, parentNameUsageID, acceptedNameUsage, acceptedNameUsageID, taxonRemarks, verbatimTaxonRemarks, provenance, classification);
                instance = taxonomy.addInstance(instance);
                ArrayList<Document> docs = new ArrayList<Document>();
                docs.add(this.makeDocument(taxonomy, core.rowType(), core, instance.getTaxonID()));
                for (List ext : record.extensions().values()) {
                    for (Record er : ext) {
                        docs.add(this.makeDocument(taxonomy, er.rowType(), er, instance.getTaxonID()));
                    }
                }
                taxonomy.addRecords(docs);
            }
        }
        catch (Exception ex) {
            throw new IndexBuilderException("Unable to load archive " + this.archive.getLocation() + " at taxon " + taxonID, ex);
        }
    }

    private Document makeDocument(Taxonomy taxonomy, Term type, Record record, String taxonID) {
        Document doc = new Document();
        doc.add((IndexableField)new StringField("type", type.qualifiedName(), Field.Store.YES));
        doc.add((IndexableField)new StringField("id", UUID.randomUUID().toString(), Field.Store.YES));
        doc.add((IndexableField)new StringField(Taxonomy.fieldName((Term)DwcTerm.taxonID), taxonID, Field.Store.YES));
        for (Term term : record.terms()) {
            if (term == DwcTerm.taxonID) continue;
            String value = record.value(term);
            if (term == null || value == null || value.isEmpty()) continue;
            doc.add((IndexableField)new StringField(Taxonomy.fieldName(term), value, Field.Store.YES));
        }
        return doc;
    }
}

