/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.IndexBuilderException;
import au.org.ala.names.index.IssueType;
import au.org.ala.names.index.Name;
import au.org.ala.names.index.NameKey;
import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.index.Taxonomy;
import au.org.ala.names.index.UnrankedScientificName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class BareName
extends Name<BareName, BareName, UnrankedScientificName> {
    public BareName(NameKey key) {
        super(key);
    }

    @Override
    UnrankedScientificName createConcept(NameKey stageKey) {
        return new UnrankedScientificName(this, stageKey);
    }

    @Override
    NameKey buildStageKey(NameKey instanceKey) {
        return instanceKey.toUnrankedNameKey();
    }

    @Override
    protected void reallocateDanglingConcepts(Taxonomy taxonomy, UnrankedScientificName principal) {
        if (principal == null) {
            return;
        }
        ArrayList<UnrankedScientificName> reallocated = new ArrayList<UnrankedScientificName>();
        for (UnrankedScientificName name : this.getConcepts()) {
            if (name == principal || !name.getKey().isUncoded()) continue;
            principal.reallocate(name, taxonomy, "uncodedScientificName.reallocated.provenance");
            reallocated.add(name);
        }
        this.removeConcepts(reallocated);
        taxonomy.count("count.resolve.uncodedScientificName.principal");
    }

    @Override
    protected UnrankedScientificName findPrincipal(Taxonomy taxonomy) {
        List names = this.getConcepts();
        if (names.isEmpty()) {
            return null;
        }
        if (names.size() == 1) {
            return (UnrankedScientificName)names.get(0);
        }
        names.sort(REVERSE_PROVIDER_SCORE_COMPARATOR);
        int cutoff = taxonomy.getAcceptedCutoff();
        List coded = names.stream().filter(sn -> !sn.getKey().isUncoded() && sn.getPrincipal() != null && sn.getPrincipalScore() > cutoff).collect(Collectors.toList());
        if (coded.size() == 0) {
            return (UnrankedScientificName)names.get(0);
        }
        if (coded.size() == 1) {
            return (UnrankedScientificName)coded.get(0);
        }
        taxonomy.report(IssueType.COLLISION, "uncodedScientificName.collision", this, coded);
        int score = coded.stream().mapToInt(Name::getPrincipalScore).max().orElse(-1000000);
        List candidates = coded.stream().filter(sn -> sn.getPrincipalScore() == score).collect(Collectors.toList());
        if (candidates.size() > 1) {
            taxonomy.report(IssueType.PROBLEM, "uncodedScientificName.collision.warn", this, candidates);
        }
        return (UnrankedScientificName)candidates.get(0);
    }

    @Override
    public void reallocate(BareName element, Taxonomy taxonomy, String reason) {
        UnrankedScientificName principal = (UnrankedScientificName)this.getPrincipal();
        taxonomy.report(IssueType.NOTE, "uncodedScientificName.reallocated", element, Arrays.asList(this));
        taxonomy.count("count.reallocate.uncodedScientificName");
        if (principal == null) {
            throw new IndexBuilderException("Unable to reallocate " + element + " to " + this + " without principal");
        }
        for (UnrankedScientificName name : element.getConcepts()) {
            principal.reallocate(name, taxonomy, reason);
        }
        element.clear(principal);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(64);
        UnrankedScientificName principal = (UnrankedScientificName)this.getPrincipal();
        TaxonConceptInstance representative = this.getRepresentative();
        builder.append("BN[");
        builder.append(this.getKey().getScientificName());
        if (principal != null) {
            builder.append(" = ");
            builder.append(principal.getKey());
        }
        if (representative != null) {
            builder.append(" = ");
            builder.append(representative.getLocator());
        }
        builder.append("]");
        return builder.toString();
    }
}

