/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.nameparser;

import au.org.ala.names.model.ALAParsedName;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.gbif.api.exception.UnparsableException;
import org.gbif.api.model.checklistbank.ParsedName;
import org.gbif.api.vocabulary.NameType;
import org.gbif.api.vocabulary.Rank;
import org.gbif.nameparser.GBIFNameParser;
import org.gbif.nameparser.RankUtils;

public class PhraseNameParser
extends GBIFNameParser {
    public static final HashMap<String, Rank> VALID_PHRASE_RANKS;
    public static final String ALL_LETTERS_NUMBERS = "A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u01530-9";
    protected static final String LOCATION_OR_DESCR = "(?:[A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u01530-9 -'\"_\\.]+|\\.)";
    protected static final String VOUCHER = "(\\([A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u01530-9- \\./&,']+\\))";
    protected static final String SOURCE_AUTHORITY = "([A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u01530-9\\[\\]'\" -,\\.]+|\\.)";
    protected static final String PHRASE = "";
    protected static final String PHRASE_RANKS;
    private static final String RANK_MARKER_ALL;
    public static final Pattern RANK_MARKER;
    protected static final Pattern SPECIES_PATTERN;
    protected static final Pattern POTENTIAL_SPECIES_PATTERN;
    protected static final Pattern PHRASE_PATTERN;
    protected static final Pattern WRONG_CASE_INFRAGENERIC;
    protected static final Pattern IGNORE_MARKERS;

    public ParsedName parse(String scientificName, Rank rank) throws UnparsableException {
        ParsedName pn = super.parse(scientificName, rank);
        if (pn.getType() != NameType.SCIENTIFIC && this.isPhraseRank(pn.getRank()) && (!pn.isAuthorsParsed() || pn.getSpecificEpithet() == null || SPECIES_PATTERN.matcher(pn.getSpecificEpithet()).matches())) {
            String newName;
            Matcher m1;
            if (SPECIES_PATTERN.matcher(scientificName).find() && (m1 = POTENTIAL_SPECIES_PATTERN.matcher(scientificName)).find() && (pn = super.parse(newName = m1.group(1) + m1.group(3) + StringUtils.defaultString((String)m1.group(4), (String)PHRASE), rank)).getType() == NameType.SCIENTIFIC) {
                return pn;
            }
            Matcher m = PHRASE_PATTERN.matcher(scientificName);
            if (m.find()) {
                ALAParsedName alapn = new ALAParsedName(pn);
                alapn.setInfraGeneric(null);
                alapn.setSpecificEpithet(null);
                alapn.setInfraSpecificEpithet(null);
                alapn.setAuthorship(null);
                alapn.setAuthorsParsed(false);
                alapn.setLocationPhraseDescription(StringUtils.trimToNull((String)m.group(3)));
                alapn.setPhraseVoucher(StringUtils.trimToNull((String)m.group(4)));
                alapn.setPhraseNominatingParty(StringUtils.trimToNull((String)m.group(5)));
                return alapn;
            }
        } else {
            Matcher m = WRONG_CASE_INFRAGENERIC.matcher(scientificName);
            if (m.find()) {
                scientificName = WordUtils.capitalize((String)scientificName, (char[])new char[]{'('});
                pn = super.parse(scientificName, rank);
            }
        }
        return pn;
    }

    private boolean isPhraseRank(Rank rank) {
        if (rank == null) {
            return false;
        }
        return VALID_PHRASE_RANKS.containsValue(rank);
    }

    static {
        HashMap<String, Rank> ranks = new HashMap<String, Rank>();
        ranks.put("subsp", Rank.SUBSPECIES);
        ranks.put("ssp", Rank.SUBSPECIES);
        ranks.put("var", Rank.VARIETY);
        ranks.put("sp", Rank.SPECIES);
        ranks.put("cv", Rank.CULTIVAR);
        VALID_PHRASE_RANKS = ranks;
        PHRASE_RANKS = "(?:" + StringUtils.join(VALID_PHRASE_RANKS.keySet(), (String)"|") + ")\\.? ";
        RANK_MARKER_ALL = "(notho)? *(" + StringUtils.join(RankUtils.RANK_MARKER_MAP.keySet(), (String)"|") + ")\\.?";
        RANK_MARKER = Pattern.compile("^" + RANK_MARKER_ALL + "$");
        SPECIES_PATTERN = Pattern.compile("sp\\.?");
        POTENTIAL_SPECIES_PATTERN = Pattern.compile("^([\\x00-\\x7F\\s]*)(" + SPECIES_PATTERN.pattern() + " )" + "([" + "a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153" + "]{3,})(?: *)" + "([\\x00-\\x7F\\s]*)");
        PHRASE_PATTERN = Pattern.compile("^([\\x00-\\x7F\\s]*)(?: *)(" + PHRASE_RANKS + ")(?: *)" + "(" + LOCATION_OR_DESCR + ")" + VOUCHER + "?" + SOURCE_AUTHORITY + "?$");
        WRONG_CASE_INFRAGENERIC = Pattern.compile("(?:\\( ?([a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153-]+) ?\\)|(" + StringUtils.join(RankUtils.RANK_MARKER_MAP_INFRAGENERIC.keySet(), (String)"|") + ")\\.? ?([" + "A-Z\u00cf\u00cb\u00d6\u00dc\u00c4\u00c9\u00c8\u010c\u00c1\u00c0\u00c6\u0152" + "][" + "a-z\u00ef\u00eb\u00f6\u00fc\u00e4\u00e5\u00e9\u00e8\u010d\u00e1\u00e0\u00e6\u0153" + "-]+)" + ")");
        IGNORE_MARKERS = Pattern.compile("s[\\.| ]+str[\\. ]+");
    }
}

