/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.vocab;

import au.org.ala.vocab.Concept;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.util.StdConverter;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonDeserialize(converter=VocabularyConverter.class)
public class Vocabulary<T extends Concept<T>>
extends Concept<Vocabulary<?>> {
    @JsonBackReference
    private List<Concept<T>> concepts = new ArrayList<Concept<T>>();
    private Map<URI, Concept<T>> uriConceptMap = new HashMap<URI, Concept<T>>();
    private Map<String, Concept<T>> nameConceptMap = new HashMap<String, Concept<T>>();

    public Vocabulary() {
    }

    public Vocabulary(URI uri, String id, String description) {
        super(null, uri, id, description, null, null);
    }

    public void add(Concept<T> concept) {
        this.concepts.add(concept);
        this.resolve(concept);
    }

    protected void resolve() {
        this.uriConceptMap = new HashMap<URI, Concept<T>>(this.concepts.size());
        this.nameConceptMap = new HashMap<String, Concept<T>>(this.concepts.size());
        for (Concept<T> concept : this.concepts) {
            this.resolve(concept);
        }
    }

    protected void resolve(Concept<T> concept) {
        if (concept.getUri() != null) {
            if (this.uriConceptMap.containsKey(concept.getUri())) {
                throw new IllegalStateException("Duplicate uri " + concept.getUri() + " for " + concept.getId());
            }
            this.uriConceptMap.put(concept.getUri(), concept);
        }
        if (this.nameConceptMap.containsKey(concept.getId())) {
            throw new IllegalStateException("Duplicate id " + concept.getId());
        }
        this.nameConceptMap.put(concept.getId(), concept);
        if (concept.getNames() != null) {
            for (String name : concept.getNames()) {
                if (this.nameConceptMap.containsKey(concept.getId())) {
                    throw new IllegalStateException("Duplicate name " + name + " for " + concept.getId());
                }
                this.nameConceptMap.put(name, concept);
            }
        }
    }

    protected static class VocabularyConverter
    extends StdConverter<Vocabulary<?>, Vocabulary<?>> {
        protected VocabularyConverter() {
        }

        public Vocabulary<?> convert(Vocabulary<?> value) {
            value.resolve();
            return value;
        }
    }
}

