/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;

public class GbifModule
extends SimpleModule {
    private TermFactory factory = TermFactory.instance();

    public GbifModule() {
        super("GbifModule", new Version(1, 0, 0, null, null, null));
        StdSerializer<Term> ser = new StdSerializer<Term>(Term.class){

            public void serialize(Term value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeString(value.qualifiedName());
            }
        };
        StdDeserializer<Term> des = new StdDeserializer<Term>(Term.class){

            public Term deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                    return GbifModule.this.factory.findTerm(p.getText());
                }
                throw ctxt.mappingException("Expected JSON String");
            }
        };
        StdKeyDeserializer kdes = new StdKeyDeserializer(-1, Term.class){

            public Object deserializeKey(String key, DeserializationContext ctxt) throws IOException {
                return GbifModule.this.factory.findTerm(key);
            }
        };
        this.addSerializer(Term.class, (JsonSerializer)ser);
        this.addKeySerializer(Term.class, (JsonSerializer)ser);
        this.addDeserializer(Term.class, (JsonDeserializer)des);
        this.addKeyDeserializer(Term.class, (KeyDeserializer)kdes);
    }
}

