/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;

public class FileUtils {
    public static Set<String> streamToSet(InputStream source, Set<String> resultSet, boolean toLowerCase) throws IOException {
        LineIterator lines = FileUtils.getLineIterator(source, "UTF8");
        while (lines.hasNext()) {
            String line = lines.nextLine().trim();
            if (toLowerCase) {
                line = line.toLowerCase();
            }
            if (FileUtils.ignore(line)) continue;
            resultSet.add(line);
        }
        return resultSet;
    }

    private static boolean ignore(String line) {
        return StringUtils.trimToNull((String)line) == null || line.startsWith("#");
    }

    public static LineIterator getLineIterator(InputStream source, String encoding) {
        try {
            return new LineIterator((Reader)new BufferedReader(new InputStreamReader(source, encoding)));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported encoding" + encoding, e);
        }
    }

    public static void clear(File dir, boolean clearTop) throws IOException {
        if (dir.isDirectory()) {
            for (File f : dir.listFiles()) {
                FileUtils.clear(f, true);
            }
        }
        if (clearTop) {
            dir.delete();
        }
    }
}

