/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.NameSource;
import au.org.ala.names.index.Taxonomy;
import au.org.ala.names.index.TaxonomyConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaxonomyBuilder {
    private static Logger logger = LoggerFactory.getLogger(TaxonomyBuilder.class);

    public static void main(String[] args) {
        try {
            Options options = new Options();
            boolean cleanup = true;
            File work = new File(System.getProperty("user.dir"));
            File output = new File(work, "combined");
            TaxonomyConfiguration config = null;
            OptionBuilder.withLongOpt((String)"output");
            OptionBuilder.withDescription((String)"Output directory - defaults to 'combined' in the current directory");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"DIR");
            OptionBuilder.withType(File.class);
            Option o = OptionBuilder.create((char)'o');
            OptionBuilder.withLongOpt((String)"work");
            OptionBuilder.withDescription((String)"Working directory - defaults to the current directory");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"DIR");
            OptionBuilder.withType(File.class);
            Option w = OptionBuilder.create((char)'w');
            OptionBuilder.withLongOpt((String)"config");
            OptionBuilder.withDescription((String)"Configuration file");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"FILE");
            OptionBuilder.withType(File.class);
            Option c = OptionBuilder.create((char)'c');
            OptionBuilder.withLongOpt((String)"report");
            OptionBuilder.withDescription((String)"Report file");
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"FILE");
            OptionBuilder.withType(File.class);
            Option r = OptionBuilder.create((char)'r');
            OptionBuilder.withLongOpt((String)"noclean");
            OptionBuilder.withDescription((String)"Don't clean up work area");
            Option ncl = OptionBuilder.create();
            OptionBuilder.withLongOpt((String)"nocreate");
            OptionBuilder.withDescription((String)"Don't create an output taxonomy");
            Option nc = OptionBuilder.create();
            options.addOption(o);
            options.addOption(w);
            options.addOption(c);
            options.addOption(r);
            options.addOption(ncl);
            options.addOption(nc);
            BasicParser parser = new BasicParser();
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("noclean")) {
                cleanup = false;
            }
            if (cmd.hasOption('o')) {
                output = (File)cmd.getOptionObject('o');
            }
            if (cmd.hasOption('w')) {
                work = (File)cmd.getOptionObject('w');
            }
            if (cmd.hasOption('c')) {
                File cf = (File)cmd.getOptionObject('c');
                if (!cf.exists()) {
                    throw new IllegalArgumentException("Configuration file " + cf + " does not exist");
                }
                config = TaxonomyConfiguration.read(new FileInputStream(cf));
            }
            File report = cmd.hasOption('r') ? (File)cmd.getOptionObject('r') : new File(work, "taxonomy_report.csv");
            if (cmd.hasOption("nocreate")) {
                output = null;
            }
            List<NameSource> sources = Arrays.asList(cmd.getArgs()).stream().map(f -> NameSource.create(f)).collect(Collectors.toList());
            Taxonomy taxonomy = new Taxonomy(config, work);
            taxonomy.begin();
            taxonomy.load(sources);
            taxonomy.resolve();
            if (output != null) {
                taxonomy.createDwCA(output);
            }
            if (report != null) {
                taxonomy.createReport(report);
            }
            taxonomy.close();
            if (cleanup) {
                taxonomy.clean();
            }
        }
        catch (Exception ex) {
            logger.error("Unable to combine taxa", (Throwable)ex);
            System.out.println(ex.getMessage());
            System.exit(1);
        }
    }
}

