/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.names.index.ALANameAnalyser;
import au.org.ala.names.index.ALATaxonResolver;
import au.org.ala.names.index.BareName;
import au.org.ala.names.index.IndexBuilderException;
import au.org.ala.names.index.IssueType;
import au.org.ala.names.index.NameAnalyser;
import au.org.ala.names.index.NameKey;
import au.org.ala.names.index.NameProvider;
import au.org.ala.names.index.NameSource;
import au.org.ala.names.index.Reporter;
import au.org.ala.names.index.ScientificName;
import au.org.ala.names.index.TaxonConcept;
import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.index.TaxonResolver;
import au.org.ala.names.index.TaxonomicElement;
import au.org.ala.names.index.TaxonomyConfiguration;
import au.org.ala.names.index.UnrankedScientificName;
import au.org.ala.names.model.RankType;
import au.org.ala.names.model.TaxonomicType;
import au.org.ala.names.util.DwcaWriter;
import au.org.ala.names.util.FileUtils;
import au.org.ala.vocab.ALATerm;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Version;
import org.gbif.api.model.registry.Citation;
import org.gbif.api.model.registry.Contact;
import org.gbif.api.model.registry.Dataset;
import org.gbif.api.model.registry.Identifier;
import org.gbif.api.vocabulary.ContactType;
import org.gbif.api.vocabulary.IdentifierType;
import org.gbif.api.vocabulary.NomenclaturalCode;
import org.gbif.api.vocabulary.NomenclaturalStatus;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.GbifTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Taxonomy
implements Reporter {
    private static Logger logger = LoggerFactory.getLogger(Taxonomy.class);
    private static DateTimeFormatter ISO8601 = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    public static int PROGRESS_INTERVAL = 10000;
    public Set<String> COUNT_PROGRESS = new HashSet<String>(Arrays.asList("count.homonym", "count.load.instance", "count.resolve.instance.links", "count.resolve.taxonConcept", "count.resolve.scientificName.principal", "count.resolve.uncodedScientificName.principal", "count.resolve.unrankedScientificName.principal", "count.write.taxonConcept"));
    private static final List<org.gbif.dwc.terms.Term> DEFAULT_TERMS = Collections.unmodifiableList(Arrays.asList(DwcTerm.taxonID));
    private TaxonomyConfiguration configuration;
    private NameAnalyser analyser;
    private TaxonResolver resolver;
    private File work;
    private Analyzer indexAnalyzer;
    private File index;
    private Directory indexDir;
    private IndexWriter indexWriter;
    private SearcherManager searcherManager;
    private Map<NameKey, ScientificName> names;
    private Map<NameKey, UnrankedScientificName> unrankedNames;
    private Map<NameKey, BareName> bareNames;
    private Map<String, TaxonConceptInstance> instances;
    private Map<String, NameProvider> providers;
    private NameProvider defaultProvider;
    private NameProvider inferenceProvider;
    private Map<org.gbif.dwc.terms.Term, List<org.gbif.dwc.terms.Term>> outputMap;
    private ResourceBundle resources;
    private ConcurrentMap<String, AtomicInteger> counts;
    private Map<org.gbif.dwc.terms.Term, String> fieldNames;
    private Map<String, org.gbif.dwc.terms.Term> fieldTerms;
    private List<NameSource> sources;

    public Taxonomy() throws IndexBuilderException {
        this(null, null);
    }

    public Taxonomy(TaxonomyConfiguration configuration, File work) throws IndexBuilderException {
        if (configuration == null) {
            configuration = new TaxonomyConfiguration();
            configuration.nameAnalyserClass = ALANameAnalyser.class;
            configuration.resolverClass = ALATaxonResolver.class;
            configuration.inferenceProvider = configuration.defaultProvider = new NameProvider("default", 100);
            configuration.providers = new ArrayList<NameProvider>();
            configuration.providers.add(configuration.defaultProvider);
        }
        this.configuration = configuration;
        this.configuration.validate();
        try {
            this.analyser = this.configuration.nameAnalyserClass.newInstance();
            this.analyser.setReporter(this);
        }
        catch (Exception ex) {
            throw new IndexBuilderException("Unable to create analyser", ex);
        }
        try {
            this.resolver = this.configuration.resolverClass.getConstructor(Taxonomy.class).newInstance(this);
        }
        catch (Exception ex) {
            throw new IndexBuilderException("Unable to create resolver", ex);
        }
        this.providers = new HashMap<String, NameProvider>((Map<String, NameProvider>)Maps.uniqueIndex(configuration.providers, p -> p.getId()));
        this.defaultProvider = this.configuration.defaultProvider;
        this.inferenceProvider = this.configuration.inferenceProvider != null ? configuration.inferenceProvider : this.defaultProvider;
        this.names = new HashMap<NameKey, ScientificName>();
        this.unrankedNames = new HashMap<NameKey, UnrankedScientificName>();
        this.bareNames = new HashMap<NameKey, BareName>();
        this.instances = new HashMap<String, TaxonConceptInstance>();
        this.makeBaseOutputMap();
        this.makeWorkArea(work);
        this.indexAnalyzer = new KeywordAnalyzer();
        this.resources = ResourceBundle.getBundle("taxonomy");
        this.counts = new ConcurrentHashMap<String, AtomicInteger>();
        this.fieldNames = new HashMap<org.gbif.dwc.terms.Term, String>();
        this.fieldTerms = new HashMap<String, org.gbif.dwc.terms.Term>();
        this.sources = new ArrayList<NameSource>();
    }

    public Taxonomy(NameAnalyser analyser, TaxonResolver resolver, Map<String, NameProvider> providers, NameProvider defaultProvider) {
        this.configuration = new TaxonomyConfiguration();
        this.analyser = analyser;
        this.analyser.setReporter(this);
        this.resolver = resolver;
        this.providers = providers;
        this.defaultProvider = defaultProvider;
        this.names = new HashMap<NameKey, ScientificName>();
        this.unrankedNames = new HashMap<NameKey, UnrankedScientificName>();
        this.bareNames = new HashMap<NameKey, BareName>();
        this.instances = new HashMap<String, TaxonConceptInstance>();
        this.makeBaseOutputMap();
        this.makeWorkArea(null);
        this.indexAnalyzer = new KeywordAnalyzer();
        this.resources = ResourceBundle.getBundle("taxonomy");
        this.counts = new ConcurrentHashMap<String, AtomicInteger>();
        this.fieldNames = new HashMap<org.gbif.dwc.terms.Term, String>();
        this.fieldTerms = new HashMap<String, org.gbif.dwc.terms.Term>();
        this.sources = new ArrayList<NameSource>();
    }

    public File getWork() {
        return this.work;
    }

    public Map<NameKey, ScientificName> getNames() {
        return this.names;
    }

    public TaxonResolver getResolver() {
        return this.resolver;
    }

    public TaxonConceptInstance getInstance(String taxonID) {
        return this.instances.get(taxonID);
    }

    public int getAcceptedCutoff() {
        return this.configuration.acceptedCutoff;
    }

    public void count(String type) {
        AtomicInteger count = this.counts.computeIfAbsent(type, k -> new AtomicInteger(0));
        int c = count.incrementAndGet();
        if (this.COUNT_PROGRESS.contains(type) && c % PROGRESS_INTERVAL == 0) {
            String message = this.resources.getString(type);
            message = MessageFormat.format(message, c);
            logger.info(message);
        }
    }

    public void begin() throws IndexBuilderException {
        try {
            IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_4_10_4, this.indexAnalyzer);
            this.indexWriter = new IndexWriter(this.indexDir, config);
            this.indexWriter.commit();
            this.searcherManager = new SearcherManager(this.indexWriter, true, null);
        }
        catch (IOException ex) {
            throw new IndexBuilderException("Error creating working index", ex);
        }
    }

    public void close() throws IndexBuilderException {
        try {
            if (this.indexWriter != null) {
                this.indexWriter.close();
                this.indexWriter = null;
            }
            if (this.searcherManager != null) {
                this.searcherManager.close();
                this.searcherManager = null;
            }
        }
        catch (IOException ex) {
            throw new IndexBuilderException("Error closing taxonomy", ex);
        }
    }

    public void load(List<NameSource> sources) throws IndexBuilderException {
        try {
            if (this.indexWriter == null) {
                throw new IllegalStateException("Index not opened");
            }
            for (NameSource source : sources) {
                logger.info("Loading " + source.getName());
                source.loadIntoTaxonomy(this);
                this.indexWriter.commit();
                this.searcherManager.maybeRefresh();
                this.sources.add(source);
            }
        }
        catch (IOException ex) {
            throw new IndexBuilderException("Error constructing source index", ex);
        }
    }

    public void resolve() throws IndexBuilderException {
        this.resolveLinks();
        if (!this.validate()) {
            throw new IndexBuilderException("Invalid source data");
        }
        this.validateNameCollisions();
        this.resolveTaxon();
        this.resolvePrincipal();
        if (!this.validate()) {
            throw new IndexBuilderException("Invalid resolution");
        }
    }

    public void resolveLinks() throws IndexBuilderException {
        logger.info("Resolving links");
        this.instances.values().parallelStream().forEach(instance -> instance.resolveLinks(this));
        logger.info("Finished resolving links");
    }

    public boolean validate() throws IndexBuilderException {
        logger.info("Starting validation");
        boolean valid = true;
        valid = this.instances.values().parallelStream().map(instance -> instance.validate(this)).reduce(valid, (a, b) -> a != false && b != false);
        valid = this.names.values().parallelStream().map(instance -> instance.validate(this)).reduce(valid, (a, b) -> a != false && b != false);
        logger.info("Finished validation");
        return valid;
    }

    protected void validateNameCollisions() throws IndexBuilderException {
        logger.info("Validating name collisions");
        HashMap<String, Integer> counts = new HashMap<String, Integer>(this.names.size());
        for (NameKey nameKey : this.names.keySet()) {
            String name = nameKey.getScientificName();
            counts.put(name, counts.getOrDefault(name, 0) + 1);
        }
        for (Map.Entry entry : counts.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            this.count("count.homonym");
            this.report(IssueType.NOTE, "name.homonym", (String)entry.getKey());
        }
        logger.info("Finished validating name collisions");
    }

    public void resolveTaxon() throws IndexBuilderException {
        logger.info("Resolving taxa");
        Collection<TaxonConceptInstance> allInstances = this.instances.values();
        Set rs = allInstances.stream().map(TaxonConceptInstance::getRank).collect(Collectors.toSet());
        ArrayList ranks = new ArrayList(rs);
        Collections.sort(ranks, (r1, r2) -> r1.getSortOrder() - r2.getSortOrder());
        long prevResolved = 0L;
        long resolved = 0L;
        do {
            for (RankType rank : ranks) {
                Set concepts = allInstances.stream().filter(instance -> instance.getRank() == rank).map(TaxonomicElement::getContainer).collect(Collectors.toSet());
                concepts.parallelStream().forEach(tc -> tc.resolveTaxon(this));
            }
            prevResolved = resolved;
            resolved = allInstances.stream().filter(instance -> instance.isResolved()).count();
            logger.debug("Resolved " + prevResolved + " -> " + resolved);
        } while (resolved != prevResolved);
        Set unresolvedConcepts = allInstances.stream().map(TaxonomicElement::getContainer).filter(tc -> !tc.isResolved()).collect(Collectors.toSet());
        logger.info("Found " + unresolvedConcepts.size() + " un-resolved concepts");
        unresolvedConcepts.parallelStream().forEach(tc -> {
            tc.resolveTaxon(this);
            this.report(IssueType.PROBLEM, "taxonConcept.unresolved", (TaxonomicElement)tc);
        });
        logger.info("Finished resolving taxa");
    }

    public void resolvePrincipal() throws IndexBuilderException {
        logger.info("Resolving principals for scientific names");
        this.names.values().parallelStream().forEach(name -> name.resolvePrincipal(this));
        logger.info("Resolving principals for unranked names");
        this.unrankedNames.values().parallelStream().forEach(name -> name.resolvePrincipal(this));
        logger.info("Resolving principals for bare names");
        this.bareNames.values().parallelStream().forEach(name -> name.resolvePrincipal(this));
    }

    public NameProvider resolveProvider(String datasetID, String datasetName) {
        if (datasetID == null && datasetName == null) {
            return this.defaultProvider;
        }
        NameProvider provider = this.providers.get(datasetID);
        if (provider != null) {
            return provider;
        }
        provider = this.providers.get(datasetName);
        if (provider != null) {
            return provider;
        }
        provider = new NameProvider(datasetID != null ? datasetID : datasetName, datasetName, this.defaultProvider, true);
        this.report(IssueType.NOTE, "taxonomy.load.provider", provider.getId());
        if (datasetID != null) {
            this.providers.put(datasetID, provider);
        }
        if (datasetName != null) {
            this.providers.put(datasetName, provider);
        }
        return provider;
    }

    public NomenclaturalCode resolveCode(String nomenclaturalCode) {
        return this.analyser.canonicaliseCode(nomenclaturalCode);
    }

    public TaxonomicType resolveTaxonomicType(String taxonomicStatus) {
        return this.analyser.canonicaliseTaxonomicType(taxonomicStatus);
    }

    public RankType resolveRank(String rank) {
        return this.analyser.canonicaliseRank(rank);
    }

    public Set<NomenclaturalStatus> resolveNomenclaturalStatus(String nomenclaturalStatus) {
        if (nomenclaturalStatus == null || nomenclaturalStatus.isEmpty()) {
            return null;
        }
        String[] values = nomenclaturalStatus.split("[,;|]");
        HashSet<NomenclaturalStatus> status = new HashSet<NomenclaturalStatus>(values.length);
        for (String v : values) {
            NomenclaturalStatus s = this.analyser.canonicaliseNomenclaturalStatus(v);
            if (s == null) continue;
            status.add(s);
        }
        return status.isEmpty() ? null : status;
    }

    protected void addInferredInstance(TaxonConceptInstance instance) {
        String taxonID = instance.getTaxonID();
        if (this.instances.containsKey(taxonID)) {
            throw new IndexBuilderException("Attempting to add " + instance + " but taxonID " + taxonID + " already in use");
        }
        this.instances.put(taxonID, instance);
    }

    public TaxonConceptInstance addInstance(TaxonConceptInstance instance) throws Exception {
        BareName bare;
        String taxonID = instance.getTaxonID();
        boolean loose = instance.getProvider().isLoose();
        NameKey taxonKey = this.analyser.analyse(instance.getCode(), instance.getScientificName(), instance.getScientificNameAuthorship(), instance.getRank(), loose);
        taxonKey = instance.getProvider().adjustKey(taxonKey, instance);
        switch (taxonKey.getType()) {
            case PLACEHOLDER: {
                this.report(IssueType.NOTE, "taxonomy.load.placeholder", instance);
                instance.setForbidden(true);
                break;
            }
            case NO_NAME: {
                this.report(IssueType.VALIDATION, "taxonomy.load.no_name", instance);
                instance.setForbidden(true);
                break;
            }
            case INFORMAL: 
            case DOUBTFUL: 
            case CANDIDATUS: {
                this.report(IssueType.NOTE, "taxonomy.load.as_is", instance);
                break;
            }
        }
        this.count("count.load." + taxonKey.getType().name());
        if (!instance.isForbidden() && instance.getProvider().forbid(instance)) {
            this.report(IssueType.NOTE, "taxonomy.load.forbidden", instance);
            instance.setForbidden(true);
        }
        NameKey nameKey = taxonKey.toNameKey();
        NameKey unrankedKey = taxonKey.toUnrankedNameKey();
        NameKey bareKey = taxonKey.toUncodedNameKey();
        if (this.instances.containsKey(taxonID)) {
            TaxonConceptInstance collision = this.instances.get(taxonID);
            taxonID = UUID.randomUUID().toString();
            this.report(IssueType.VALIDATION, "taxonomy.load.collision", instance.toString(), collision.toString(), taxonID);
            instance = new TaxonConceptInstance(taxonID, instance.getCode(), instance.getVerbatimNomenclaturalCode(), instance.getProvider(), instance.getScientificName(), instance.getScientificNameAuthorship(), instance.getYear(), instance.getTaxonomicStatus(), instance.getVerbatimTaxonomicStatus(), instance.getRank(), instance.getVerbatimTaxonRank(), instance.getStatus(), instance.getVerbatimNomenclaturalStatus(), instance.getParentNameUsage(), instance.getParentNameUsageID(), instance.getAcceptedNameUsage(), instance.getAcceptedNameUsageID(), instance.getClassification());
        }
        if ((bare = this.bareNames.get(bareKey)) == null) {
            bare = new BareName(bareKey);
            this.bareNames.put(bareKey, bare);
        }
        bare.addInstance(taxonKey, instance);
        ScientificName name = (ScientificName)((TaxonConcept)instance.getContainer()).getContainer();
        if (!this.names.containsKey(name.getKey())) {
            this.names.put(name.getKey(), name);
        }
        UnrankedScientificName unranked = (UnrankedScientificName)name.getContainer();
        if (!this.unrankedNames.containsKey(unrankedKey)) {
            this.unrankedNames.put(unrankedKey, unranked);
        }
        this.instances.put(taxonID, instance);
        this.count("count.load.instance");
        return instance;
    }

    public TaxonomicElement findElement(NomenclaturalCode code, String name, NameProvider provider, RankType rank) {
        NameKey nameKey = null;
        nameKey = this.analyser.analyse(code, name, null, rank, provider.isLoose()).toNameKey();
        if (nameKey.isUncoded()) {
            return this.bareNames.get(nameKey);
        }
        if (nameKey.isUnranked()) {
            return this.unrankedNames.get(nameKey);
        }
        ScientificName scientificName = this.names.get(nameKey);
        return scientificName == null ? null : scientificName.findElement(this, provider);
    }

    public void createDwCA(File directory) throws IndexBuilderException, IOException {
        logger.info("Creating DwCA");
        this.addOutputTerms((org.gbif.dwc.terms.Term)GbifTerm.Identifier, Arrays.asList(new org.gbif.dwc.terms.Term[]{DcTerm.title, ALATerm.status, DcTerm.source}));
        DwcaWriter dwcaWriter = new DwcaWriter((org.gbif.dwc.terms.Term)DwcTerm.Taxon, (org.gbif.dwc.terms.Term)DwcTerm.taxonID, directory, true);
        dwcaWriter.setEml(this.buildEml());
        for (NameProvider provider : this.providers.values()) {
            if (!provider.isExternal()) continue;
            dwcaWriter.addDetatchedRecord((org.gbif.dwc.terms.Term)DcTerm.rightsHolder, provider.getProviderMap());
        }
        ArrayList<ScientificName> nameList = new ArrayList<ScientificName>(this.names.values());
        Collections.sort(nameList);
        for (ScientificName name : nameList) {
            name.write(this, dwcaWriter);
        }
        dwcaWriter.close();
        logger.info("Finished creating DwCA");
    }

    protected Dataset buildEml() throws IndexBuilderException {
        Dataset dataset = new Dataset();
        Date now = new Date();
        String altId = MessageFormat.format("{0}-{1,date,yyyyMMdd}", this.configuration.id, now);
        dataset.setAbbreviation(this.configuration.id);
        dataset.setAdditionalInfo(this.resources.getString("dwca.additionalInfo"));
        dataset.setAlias(altId);
        dataset.setCitation(new Citation(this.configuration.name, this.configuration.id));
        dataset.setCreatedBy(this.configuration.getContactName());
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        if (this.configuration.contact != null) {
            try {
                Contact primary = (Contact)BeanUtils.cloneBean((Object)this.configuration.contact);
                primary.setType(ContactType.ORIGINATOR);
                primary.setPrimary(true);
                contacts.add(primary);
                Contact metadata = (Contact)BeanUtils.cloneBean((Object)this.configuration.contact);
                metadata.setType(ContactType.METADATA_AUTHOR);
                metadata.setPrimary(true);
                contacts.add(metadata);
                Contact processor = (Contact)BeanUtils.cloneBean((Object)this.configuration.contact);
                metadata.setType(ContactType.PROCESSOR);
                metadata.setPrimary(false);
                contacts.add(metadata);
            }
            catch (Exception ex) {
                logger.error("Unable to clone contact", (Throwable)ex);
            }
        }
        contacts.addAll(this.sources.stream().flatMap(s -> s.getContacts().stream()).collect(Collectors.toSet()));
        dataset.setContacts(contacts);
        dataset.setCountryCoverage(this.sources.stream().flatMap(s -> s.getCountries().stream()).collect(Collectors.toSet()));
        dataset.setCreated(new Date());
        dataset.setDescription(this.configuration.description);
        ArrayList citations = new ArrayList();
        citations.addAll(this.sources.stream().map(s -> s.getCitation()).filter(c -> c != null).collect(Collectors.toList()));
        citations.addAll(this.providers.values().stream().filter(p -> p.isExternal()).map(p -> p.getCitation()).collect(Collectors.toList()));
        dataset.setBibliographicCitations(citations);
        ArrayList<Identifier> ids = new ArrayList<Identifier>();
        if (this.configuration.uri != null) {
            ids.add(new Identifier(IdentifierType.URI, this.configuration.uri.toString()));
        }
        if (this.configuration.id != null) {
            ids.add(new Identifier(IdentifierType.UNKNOWN, this.configuration.id));
        }
        dataset.setIdentifiers(ids);
        dataset.setPubDate(now);
        dataset.setTitle(this.configuration.name);
        return dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(IssueType type, String code, String ... args) {
        String message;
        try {
            message = this.resources.getString(code);
            message = message == null ? code : message;
            message = MessageFormat.format(message, args);
        }
        catch (MissingResourceException ex) {
            logger.error("Can't find resource for " + code + " defaulting to code");
            message = code;
        }
        switch (type) {
            case ERROR: 
            case VALIDATION: {
                logger.error(message);
                break;
            }
            case PROBLEM: {
                logger.warn(message);
                break;
            }
            case COLLISION: {
                logger.info(message);
                break;
            }
            case NOTE: 
            case COUNT: {
                logger.debug(message);
                break;
            }
            default: {
                logger.warn("Unknown message type " + (Object)((Object)type) + ": " + message);
            }
        }
        Document doc = new Document();
        doc.add((IndexableField)new StringField("type", ALATerm.TaxonomicIssue.qualifiedName(), Field.Store.YES));
        doc.add((IndexableField)new StringField("id", UUID.randomUUID().toString(), Field.Store.YES));
        doc.add((IndexableField)new StringField(this.fieldName((org.gbif.dwc.terms.Term)DcTerm.type), type.name(), Field.Store.YES));
        doc.add((IndexableField)new StringField(this.fieldName((org.gbif.dwc.terms.Term)DcTerm.subject), code, Field.Store.YES));
        doc.add((IndexableField)new StringField(this.fieldName((org.gbif.dwc.terms.Term)DcTerm.description), message, Field.Store.YES));
        doc.add((IndexableField)new StringField(this.fieldName((org.gbif.dwc.terms.Term)DcTerm.date), ISO8601.format(OffsetDateTime.now()), Field.Store.YES));
        try {
            Taxonomy taxonomy = this;
            synchronized (taxonomy) {
                this.indexWriter.addDocument((Iterable)doc);
                this.indexWriter.commit();
                this.searcherManager.maybeRefresh();
            }
        }
        catch (IOException ex) {
            logger.error("Unable to write report to index", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(IssueType type, String code, TaxonomicElement ... elements) {
        String message;
        TaxonomicElement main;
        String taxonID = "";
        String scientificName = "";
        String scientificNameAuthorship = "";
        String associatedTaxa = "";
        String datasetID = "";
        TaxonomicElement taxonomicElement = main = elements.length > 0 ? elements[0] : null;
        if (main != null) {
            taxonID = main.getId();
            scientificName = main.getScientificName();
            scientificNameAuthorship = main.getScientificNameAuthorship();
            if (scientificNameAuthorship == null) {
                scientificNameAuthorship = "";
            }
            if (main instanceof TaxonConceptInstance) {
                datasetID = ((TaxonConceptInstance)main).getProvider().getId();
            }
        }
        if (elements.length > 1) {
            StringBuilder associated = new StringBuilder();
            for (int i = 1; i < elements.length; ++i) {
                if (associated.length() > 0) {
                    associated.append("|");
                }
                associated.append(elements[i].getId());
            }
            associatedTaxa = associated.toString();
        }
        try {
            message = this.resources.getString(code);
            message = MessageFormat.format(message == null ? code : message, taxonID, scientificName, scientificNameAuthorship, associatedTaxa);
        }
        catch (MissingResourceException ex) {
            logger.error("Can't find resource for " + code + " defaulting to code");
            message = code;
        }
        switch (type) {
            case ERROR: 
            case VALIDATION: {
                logger.error(message);
                break;
            }
            case PROBLEM: {
                logger.warn(message);
                break;
            }
            case COLLISION: {
                logger.info(message);
                break;
            }
            case NOTE: 
            case COUNT: {
                logger.debug(message);
                break;
            }
            default: {
                logger.warn("Unknown message type " + (Object)((Object)type) + ": " + message);
            }
        }
        Document doc = new Document();
        doc.add((IndexableField)new StringField("type", ALATerm.TaxonomicIssue.qualifiedName(), Field.Store.YES));
        doc.add((IndexableField)new StringField("id", UUID.randomUUID().toString(), Field.Store.YES));
        doc.add((IndexableField)new StringField(this.fieldName((org.gbif.dwc.terms.Term)DcTerm.type), type.name(), Field.Store.YES));
        doc.add((IndexableField)new StringField(this.fieldName((org.gbif.dwc.terms.Term)DcTerm.subject), code, Field.Store.YES));
        doc.add((IndexableField)new StringField(this.fieldName((org.gbif.dwc.terms.Term)DcTerm.description), message, Field.Store.YES));
        doc.add((IndexableField)new StringField(this.fieldName((org.gbif.dwc.terms.Term)DcTerm.date), ISO8601.format(OffsetDateTime.now()), Field.Store.YES));
        doc.add((IndexableField)new StringField(this.fieldName((org.gbif.dwc.terms.Term)DwcTerm.taxonID), taxonID, Field.Store.YES));
        doc.add((IndexableField)new StringField(this.fieldName((org.gbif.dwc.terms.Term)DwcTerm.scientificName), scientificName, Field.Store.YES));
        doc.add((IndexableField)new StringField(this.fieldName((org.gbif.dwc.terms.Term)DwcTerm.scientificNameAuthorship), scientificNameAuthorship, Field.Store.YES));
        doc.add((IndexableField)new StringField(this.fieldName((org.gbif.dwc.terms.Term)DwcTerm.associatedTaxa), associatedTaxa, Field.Store.YES));
        doc.add((IndexableField)new StringField(this.fieldName((org.gbif.dwc.terms.Term)DwcTerm.datasetID), datasetID, Field.Store.YES));
        try {
            Taxonomy taxonomy = this;
            synchronized (taxonomy) {
                this.indexWriter.addDocument((Iterable)doc);
                this.indexWriter.commit();
                this.searcherManager.maybeRefresh();
            }
        }
        catch (IOException ex) {
            logger.error("Unable to write report to index", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createReport(File report) throws IOException {
        logger.info("Writing report to " + report);
        int pageSize = 100;
        try (OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(report), "UTF-8");){
            CSVWriter writer = new CSVWriter((Writer)fw);
            List<org.gbif.dwc.terms.Term> output = this.outputTerms(ALATerm.TaxonomicIssue);
            String[] headers = output.stream().map(term -> term.toString()).collect(Collectors.toList()).toArray(new String[output.size()]);
            writer.writeNext(headers);
            for (String type : this.counts.keySet()) {
                String message = this.resources.getString(type);
                AtomicInteger count = this.counts.getOrDefault(type, new AtomicInteger(0));
                message = MessageFormat.format(message, count.intValue());
                logger.info(message);
                String[] values = new String[]{IssueType.COUNT.name(), type, message, count.toString()};
                writer.writeNext(values);
            }
            IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
            try {
                TermQuery query = new TermQuery(new Term("type", ALATerm.TaxonomicIssue.qualifiedName()));
                TopDocs docs = searcher.search((Query)query, pageSize);
                ScoreDoc last = null;
                while (docs.scoreDocs.length > 0) {
                    ScoreDoc[] scoreDocArray = docs.scoreDocs;
                    int n = scoreDocArray.length;
                    for (int i = 0; i < n; ++i) {
                        ScoreDoc sd;
                        last = sd = scoreDocArray[i];
                        Document doc = searcher.doc(sd.doc);
                        String[] values = output.stream().map(term -> doc.get(this.fieldName((org.gbif.dwc.terms.Term)term))).collect(Collectors.toList()).toArray(new String[output.size()]);
                        writer.writeNext(values);
                        this.count("count.write.report");
                    }
                    docs = searcher.searchAfter(last, (Query)query, pageSize);
                }
            }
            finally {
                this.searcherManager.release((Object)searcher);
            }
        }
        logger.info("Finished creating report");
    }

    private void makeWorkArea(File work) throws IndexBuilderException {
        try {
            this.work = work == null ? File.createTempFile("name", "work") : File.createTempFile("name", ".work", work);
            this.work.delete();
            this.work.mkdirs();
            FileUtils.clear(this.work, false);
            this.index = new File(this.work, "index");
            this.index.mkdir();
            this.indexDir = new SimpleFSDirectory(this.index);
        }
        catch (IOException ex) {
            throw new IndexBuilderException("Unable to build work area", ex);
        }
    }

    private void makeBaseOutputMap() {
        this.outputMap = new HashMap<org.gbif.dwc.terms.Term, List<org.gbif.dwc.terms.Term>>();
        for (Map.Entry<org.gbif.dwc.terms.Term, List<org.gbif.dwc.terms.Term>> entry : NameSource.REQUIRED_TERMS.entrySet()) {
            this.outputMap.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
    }

    public void addRecords(List<Document> documents) throws IOException {
        for (Document doc : documents) {
            this.indexWriter.addDocument((Iterable)doc);
        }
    }

    public void addOutputTerms(org.gbif.dwc.terms.Term type, Collection<org.gbif.dwc.terms.Term> terms) {
        Map<org.gbif.dwc.terms.Term, List<org.gbif.dwc.terms.Term>> implied;
        List<org.gbif.dwc.terms.Term> additional;
        List<org.gbif.dwc.terms.Term> map = this.outputMap.get(type);
        if (map == null) {
            map = new ArrayList<org.gbif.dwc.terms.Term>(terms.size());
            this.outputMap.put(type, map);
        }
        HashSet<org.gbif.dwc.terms.Term> seen = new HashSet<org.gbif.dwc.terms.Term>(map);
        List<org.gbif.dwc.terms.Term> remove = NameSource.FORBIDDEN_TERMS.get(type);
        boolean strict = NameSource.ONLY_INCLUDE_ALLOWED.getOrDefault(type, false);
        if (remove != null) {
            seen.addAll(remove);
        }
        if ((additional = NameSource.ADDITIONAL_TERMS.get(type)) != null) {
            for (org.gbif.dwc.terms.Term term : additional) {
                if (seen.contains(term) || !terms.contains(term)) continue;
                map.add(term);
                seen.add(term);
            }
        }
        if ((implied = NameSource.IMPLIED_TERMS.get(type)) != null) {
            for (Map.Entry<org.gbif.dwc.terms.Term, List<org.gbif.dwc.terms.Term>> entry : implied.entrySet()) {
                if (!terms.contains(entry.getKey())) continue;
                for (org.gbif.dwc.terms.Term term : entry.getValue()) {
                    if (seen.contains(term)) continue;
                    map.add(term);
                    seen.add(term);
                }
            }
        }
        if (!strict) {
            for (org.gbif.dwc.terms.Term term : terms) {
                if (seen.contains(term)) continue;
                map.add(term);
            }
        }
    }

    public List<org.gbif.dwc.terms.Term> outputTerms(org.gbif.dwc.terms.Term type) {
        return this.outputMap.getOrDefault(type, DEFAULT_TERMS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<org.gbif.dwc.terms.Term, String>> getIndexValues(org.gbif.dwc.terms.Term type, String taxonID) throws IOException {
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(new Term("type", type.qualifiedName())), BooleanClause.Occur.MUST);
        query.add((Query)new TermQuery(new Term(this.fieldName((org.gbif.dwc.terms.Term)DwcTerm.taxonID), taxonID)), BooleanClause.Occur.MUST);
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            TopFieldDocs docs = searcher.search((Query)query, 100, Sort.INDEXORDER);
            ArrayList<Map<org.gbif.dwc.terms.Term, String>> valueList = new ArrayList<Map<org.gbif.dwc.terms.Term, String>>(docs.totalHits);
            for (ScoreDoc sd : docs.scoreDocs) {
                Document document = searcher.doc(sd.doc);
                HashMap<org.gbif.dwc.terms.Term, String> values = new HashMap<org.gbif.dwc.terms.Term, String>();
                for (IndexableField field : document) {
                    if (field.name().equals("id") || field.name().equals("type")) continue;
                    org.gbif.dwc.terms.Term term = this.fieldTerms.get(field.name());
                    if (term == null) {
                        throw new IllegalStateException("Can't find term for " + field.name());
                    }
                    values.put(term, field.stringValue());
                }
                valueList.add(values);
            }
            ArrayList<Map<org.gbif.dwc.terms.Term, String>> arrayList = valueList;
            return arrayList;
        }
        finally {
            this.searcherManager.release((Object)searcher);
        }
    }

    public void clean() throws IOException {
        FileUtils.clear(this.work, true);
    }

    public NameProvider getInferenceProvider() {
        return this.inferenceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fieldName(org.gbif.dwc.terms.Term term) {
        String name = this.fieldNames.get(term);
        if (name == null) {
            name = term.toString().replace(':', '_');
            Map<org.gbif.dwc.terms.Term, String> map = this.fieldNames;
            synchronized (map) {
                this.fieldNames.put(term, name);
                this.fieldTerms.put(name, term);
            }
        }
        return name;
    }
}

