/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.IndexBuilderException;
import au.org.ala.names.index.IssueType;
import au.org.ala.names.index.NameKey;
import au.org.ala.names.index.NameProvider;
import au.org.ala.names.index.ResolutionException;
import au.org.ala.names.index.TaxonConcept;
import au.org.ala.names.index.TaxonomicElement;
import au.org.ala.names.index.Taxonomy;
import au.org.ala.names.model.RankType;
import au.org.ala.names.model.TaxonomicType;
import au.org.ala.vocab.ALATerm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gbif.api.vocabulary.NomenclaturalCode;
import org.gbif.api.vocabulary.NomenclaturalStatus;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.GbifTerm;
import org.gbif.dwc.terms.Term;

public class TaxonConceptInstance
extends TaxonomicElement<TaxonConceptInstance, TaxonConcept> {
    public static Comparator<TaxonConceptInstance> PROVIDER_SCORE_COMPARATOR = new Comparator<TaxonConceptInstance>(){

        @Override
        public int compare(TaxonConceptInstance e1, TaxonConceptInstance e2) {
            if (e1 == null && e2 == null) {
                return 0;
            }
            if (e1 == null && e2 != null) {
                return -1000000;
            }
            if (e1 != null && e2 == null) {
                return 1000000;
            }
            int o1 = e1.getProviderScore();
            int o2 = e2.getProviderScore();
            try {
                return Math.subtractExact(o1, o2);
            }
            catch (Exception ex) {
                if (o1 > o2) {
                    return 1000000;
                }
                if (o2 > o1) {
                    return -1000000;
                }
                return 0;
            }
        }
    };
    public static Comparator<TaxonConceptInstance> SCORE_COMPARATOR = new Comparator<TaxonConceptInstance>(){

        @Override
        public int compare(TaxonConceptInstance e1, TaxonConceptInstance e2) {
            if (e1 == null && e2 == null) {
                return 0;
            }
            if (e1 == null && e2 != null) {
                return -1000000;
            }
            if (e1 != null && e2 == null) {
                return 1000000;
            }
            int o1 = e1.getScore();
            int o2 = e2.getScore();
            try {
                return Math.subtractExact(o1, o2);
            }
            catch (Exception ex) {
                if (o1 > o2) {
                    return 1000000;
                }
                if (o2 > o1) {
                    return -1000000;
                }
                return 0;
            }
        }
    };
    public static Comparator<TaxonConceptInstance> INVERSE_SCORE_COMPARATOR = SCORE_COMPARATOR.reversed();
    public static final int MAX_RESOLUTION_STEPS = 20;
    protected static final List<Term> CLASSIFICATION_FIELDS = Arrays.asList(DwcTerm.kingdom, DwcTerm.phylum, DwcTerm.class_, DwcTerm.order, DwcTerm.family, DwcTerm.genus, DwcTerm.specificEpithet, DwcTerm.infraspecificEpithet);
    protected static final List<RankType> CLASSIFICATION_RANKS = Arrays.asList(RankType.KINGDOM, RankType.PHYLUM, RankType.CLASS, RankType.ORDER, RankType.FAMILY, RankType.GENUS, RankType.SPECIES, RankType.SUBSPECIES);
    private String taxonID;
    private NomenclaturalCode code;
    private String verbatimNomenclaturalCode;
    private NameProvider provider;
    private String scientificName;
    private String scientificNameAuthorship;
    private String year;
    private TaxonomicType taxonomicStatus;
    private String verbatimTaxonomicStatus;
    private RankType rank;
    private String verbatimTaxonRank;
    private Set<NomenclaturalStatus> status;
    private String verbatimNomenclaturalStatus;
    private String parentNameUsage;
    private String parentNameUsageID;
    private TaxonomicElement parent;
    private String acceptedNameUsage;
    private String acceptedNameUsageID;
    private TaxonomicElement accepted;
    private Map<Term, Optional<String>> classification;
    private Integer baseScore;
    private Integer score;
    private boolean forbidden;

    public TaxonConceptInstance(String taxonID, NomenclaturalCode code, String verbatimNomenclaturalCode, NameProvider provider, String scientificName, String scientificNameAuthorship, String year, TaxonomicType taxonomicStatus, String verbatimTaxonomicStatus, RankType rank, String verbatimTaxonRank, Set<NomenclaturalStatus> status, String verbatimNomenclaturalStatus, String parentNameUsage, String parentNameUsageID, String acceptedNameUsage, String acceptedNameUsageID, @Nullable Map<Term, Optional<String>> classification) {
        this.taxonID = taxonID;
        this.code = code;
        this.verbatimNomenclaturalCode = verbatimNomenclaturalCode;
        this.provider = Objects.requireNonNull(provider);
        this.scientificName = scientificName;
        this.scientificNameAuthorship = scientificNameAuthorship;
        this.year = year;
        this.taxonomicStatus = taxonomicStatus;
        this.verbatimTaxonomicStatus = verbatimTaxonomicStatus;
        this.rank = rank;
        this.verbatimTaxonRank = verbatimTaxonRank;
        this.status = status;
        this.verbatimNomenclaturalStatus = verbatimNomenclaturalStatus;
        this.parentNameUsage = parentNameUsage;
        this.parentNameUsageID = parentNameUsageID;
        this.acceptedNameUsage = acceptedNameUsage;
        this.acceptedNameUsageID = acceptedNameUsageID;
        this.classification = classification;
    }

    public NomenclaturalCode getCode() {
        return this.code;
    }

    public String getTaxonID() {
        return this.taxonID;
    }

    @Override
    public String getId() {
        return this.taxonID;
    }

    public NameProvider getProvider() {
        return this.provider;
    }

    @Override
    public String getScientificName() {
        return this.scientificName;
    }

    @Override
    public String getScientificNameAuthorship() {
        return this.scientificNameAuthorship;
    }

    @Override
    public TaxonConceptInstance getRepresentative() {
        return this;
    }

    @Override
    public int getPrincipalScore() {
        return this.getScore();
    }

    @Override
    public int getProviderScore() {
        return this.provider.getDefaultScore();
    }

    @Override
    public TaxonConceptInstance addInstance(NameKey instanceKey, TaxonConceptInstance instance) {
        throw new UnsupportedOperationException("Unable to add taxon concept instance " + instance + " to taxon concept instance " + this);
    }

    @Override
    public void reallocate(TaxonConceptInstance element, Taxonomy taxonomy) {
        throw new UnsupportedOperationException("Unable to reallocate taxon concept instance " + element + " to taxon concept instance " + this);
    }

    public String getYear() {
        return this.year;
    }

    public TaxonomicType getTaxonomicStatus() {
        return this.taxonomicStatus;
    }

    @Override
    public RankType getRank() {
        return this.rank;
    }

    public Set<NomenclaturalStatus> getStatus() {
        return this.status;
    }

    public String getParentNameUsage() {
        return this.parentNameUsage;
    }

    public String getParentNameUsageID() {
        return this.parentNameUsageID;
    }

    public TaxonomicElement getParent() {
        return this.parent;
    }

    public String getAcceptedNameUsage() {
        return this.acceptedNameUsage;
    }

    public String getAcceptedNameUsageID() {
        return this.acceptedNameUsageID;
    }

    public TaxonomicElement getAccepted() {
        return this.accepted;
    }

    public String getVerbatimNomenclaturalCode() {
        return this.verbatimNomenclaturalCode;
    }

    public String getVerbatimTaxonomicStatus() {
        return this.verbatimTaxonomicStatus;
    }

    public String getVerbatimTaxonRank() {
        return this.verbatimTaxonRank;
    }

    public String getVerbatimNomenclaturalStatus() {
        return this.verbatimNomenclaturalStatus;
    }

    public int getBaseScore() {
        if (this.baseScore == null) {
            this.baseScore = this.provider.computeBaseScore(this, this);
        }
        return this.baseScore;
    }

    public int getBaseScore(TaxonConceptInstance original) {
        if (original == this) {
            throw new IllegalStateException("Loop in score computation from " + original);
        }
        if (this.baseScore == null) {
            this.baseScore = this.provider.computeBaseScore(original, this);
        }
        return this.baseScore;
    }

    public int getScore() {
        if (this.score == null) {
            this.score = this.provider.computeScore(this);
        }
        return this.score;
    }

    public boolean isForbidden() {
        return this.forbidden;
    }

    public void setForbidden(boolean forbidden) {
        this.forbidden = forbidden;
    }

    public Map<Term, Optional<String>> getClassification() {
        return this.classification;
    }

    public TaxonConceptInstance getResolved() {
        if (this.getContainer() == null) {
            throw new IllegalStateException("Not taxon concept. Unable to resolve " + this);
        }
        return ((TaxonConcept)this.getContainer()).getResolved(this);
    }

    public TaxonConceptInstance getResolvedParent() {
        return this.getResolvedParent(this, 20, null, true);
    }

    private List<TaxonomicElement> traceParent() {
        ArrayList<TaxonomicElement> trace = new ArrayList<TaxonomicElement>();
        trace.add(this);
        this.getResolvedParent(this, 20, trace, false);
        return trace;
    }

    private boolean validateParent(Taxonomy taxonomy) {
        if (this.parent == null) {
            return true;
        }
        TaxonomicElement elt = this;
        ArrayList<TaxonConceptInstance> parents = new ArrayList<TaxonConceptInstance>(20);
        parents.add(this);
        while (elt != null) {
            if (elt instanceof TaxonConceptInstance) {
                elt = elt.parent;
                if (elt == null) continue;
                if (parents.contains(elt)) {
                    parents.add((TaxonConceptInstance)elt);
                    taxonomy.report(IssueType.VALIDATION, "instance.validation.parent.loop", parents.toArray(new TaxonConceptInstance[0]));
                    return false;
                }
                parents.add((TaxonConceptInstance)elt);
                continue;
            }
            elt = null;
        }
        return true;
    }

    private TaxonConceptInstance getResolvedParent(TaxonConceptInstance original, int steps, @Nullable List<TaxonomicElement> trace, boolean exception) {
        if (steps <= 0) {
            if (exception) {
                throw new ResolutionException("Detected possible loop resolving parent " + original, trace);
            }
            return null;
        }
        TaxonConceptInstance resolved = this.getResolvedAccepted(original, steps - 1, trace, exception);
        if (resolved == null) {
            return null;
        }
        TaxonomicElement pe = resolved.getParent();
        if (pe == null) {
            return null;
        }
        TaxonConceptInstance parent = pe.getRepresentative();
        parent = parent.getResolvedAccepted(original, steps - 1, trace, exception);
        if (trace != null && trace.contains(parent)) {
            trace.add(parent);
            if (exception) {
                throw new ResolutionException("Detected possible loop resolving parent " + original, trace);
            }
            return null;
        }
        if (trace != null) {
            trace.add(parent);
        }
        if (parent == null || !parent.isForbidden()) {
            return parent;
        }
        return parent.getResolvedParent(original, steps - 1, trace, exception);
    }

    public TaxonConceptInstance getResolvedAccepted() {
        return this.getResolvedAccepted(this, 20, null, true);
    }

    private List<TaxonomicElement> traceAccepted() {
        ArrayList<TaxonomicElement> trace = new ArrayList<TaxonomicElement>();
        trace.add(this);
        this.getResolvedAccepted(this, 20, trace, false);
        return trace;
    }

    private TaxonConceptInstance getResolvedAccepted(TaxonConceptInstance original, int steps, @Nullable List<TaxonomicElement> trace, boolean exception) {
        if (steps <= 0) {
            if (exception) {
                throw new ResolutionException("Detected possible loop resolving accepted " + original, trace);
            }
            return original;
        }
        TaxonConceptInstance resolved = this.getResolved(original, steps - 1);
        if (resolved == null) {
            if (exception) {
                throw new ResolutionException("Detected dangling resolution resolving accepted " + original, trace);
            }
            return original;
        }
        TaxonomicElement ae = resolved.getAccepted();
        if (ae == null || ae == resolved) {
            return resolved;
        }
        if (trace != null && trace.contains(ae)) {
            trace.add(ae);
            if (exception) {
                throw new ResolutionException("Detected possible loop resolving accepted " + original, trace);
            }
            return original;
        }
        if (trace != null) {
            trace.add(ae);
        }
        TaxonConceptInstance accepted = ae.getRepresentative();
        if (!(accepted = accepted.getResolvedAccepted(original, steps - 1, trace, exception)).isForbidden()) {
            return accepted;
        }
        return accepted.getResolvedParent(original, steps - 1, trace, exception);
    }

    private TaxonConceptInstance getResolved(TaxonConceptInstance original, int steps) {
        if (steps <= 0) {
            throw new ResolutionException("Detected possible loop resolving " + original);
        }
        TaxonConceptInstance resolved = this.getResolved();
        if (resolved != null && this != resolved) {
            return resolved.getResolved(original, steps - 1);
        }
        return resolved;
    }

    public boolean isResolved() {
        return this.getResolved() != null;
    }

    public boolean isPrimary() {
        return this.taxonomicStatus != null && this.taxonomicStatus.isPrimary();
    }

    public void normalise() throws IndexBuilderException {
        int pos;
        if (this.acceptedNameUsageID != null && this.acceptedNameUsageID.equals(this.taxonID)) {
            this.acceptedNameUsageID = null;
        }
        if (this.scientificNameAuthorship != null && (pos = this.scientificName.indexOf(this.scientificNameAuthorship)) >= 0) {
            this.scientificName = this.scientificName.substring(0, pos) + this.scientificName.substring(pos + this.scientificNameAuthorship.length());
            this.scientificName = this.scientificName.trim();
        }
    }

    public void resolveLinks(Taxonomy taxonomy) throws IndexBuilderException {
        if (this.parentNameUsageID != null) {
            this.parent = taxonomy.getInstance(this.parentNameUsageID);
        }
        if (this.parentNameUsage != null && this.parent == null) {
            this.parent = taxonomy.findElement(this.code, this.parentNameUsage, this.provider, null);
        }
        if (this.parent == null && this.taxonomicStatus.isAccepted() && this.classification != null) {
            for (int i = 0; i < CLASSIFICATION_FIELDS.size(); ++i) {
                RankType pr;
                Term cls = CLASSIFICATION_FIELDS.get(i);
                RankType clr = CLASSIFICATION_RANKS.get(i);
                Optional<String> name = this.classification.get(cls);
                if (name == null || !name.isPresent() || name.get().equals(this.scientificName)) continue;
                TaxonomicElement p = taxonomy.findElement(this.code, name.get(), this.provider, clr);
                RankType rankType = pr = p != null ? p.getRank() : null;
                if (p == null || p == this || pr != null && !pr.isHigherThan(this.rank)) continue;
                this.parent = p;
            }
        }
        if (this.parent == null && (this.parentNameUsage != null || this.parentNameUsageID != null)) {
            throw new IndexBuilderException("Unable to find parent taxon for " + this + " from " + this.parentNameUsageID + " - " + this.parentNameUsage);
        }
        if (this.acceptedNameUsageID != null) {
            this.accepted = taxonomy.getInstance(this.acceptedNameUsageID);
        }
        if (this.acceptedNameUsage != null && this.accepted == null) {
            this.accepted = taxonomy.findElement(this.code, this.acceptedNameUsage, this.provider, null);
        }
        if (this.accepted == null && (this.acceptedNameUsage != null || this.acceptedNameUsageID != null)) {
            throw new IndexBuilderException("Unable to find accepted taxon for " + this + " from " + this.acceptedNameUsageID + " - " + this.acceptedNameUsage);
        }
        taxonomy.count("count.resolve.instance.links");
    }

    public boolean isAccepted() {
        return this.taxonomicStatus.isAccepted();
    }

    public boolean isSynonym() {
        return this.taxonomicStatus.isSynonym();
    }

    public boolean isInferredSynonym() {
        return this.taxonomicStatus == TaxonomicType.INFERRED_SYNONYM;
    }

    public Map<Term, String> getTaxonMap(Taxonomy taxonomy) throws IOException {
        Map<Object, Object> values;
        List<Map<Term, String>> valuesList = taxonomy.getIndexValues((Term)DwcTerm.Taxon, this.taxonID);
        if (valuesList.isEmpty()) {
            if (this.provider != taxonomy.getInferenceProvider()) {
                taxonomy.report(IssueType.NOTE, "instance.noIndex", this);
            }
            values = new HashMap();
        } else {
            if (valuesList.size() > 1) {
                taxonomy.report(IssueType.ERROR, "instance.multiIndex", this);
            }
            values = valuesList.get(0);
        }
        values.put(DwcTerm.taxonID, this.taxonID);
        values.put(DwcTerm.nomenclaturalCode, this.code == null ? null : this.code.getAcronym());
        values.put((Object)ALATerm.verbatimNomenclaturalCode, this.verbatimNomenclaturalCode);
        values.put(DwcTerm.datasetID, this.provider.getId());
        values.put(DwcTerm.scientificName, this.scientificName);
        values.put(DwcTerm.scientificNameAuthorship, this.scientificNameAuthorship);
        values.put(DwcTerm.namePublishedInYear, this.year);
        values.put(DwcTerm.taxonomicStatus, this.taxonomicStatus.getTerm());
        values.put((Object)ALATerm.verbatimTaxonomicStatus, this.verbatimTaxonomicStatus);
        values.put(DwcTerm.nomenclaturalStatus, this.status == null ? null : this.status.stream().map(NomenclaturalStatus::getAbbreviatedLabel).collect(Collectors.joining(", ")));
        values.put((Object)ALATerm.verbatimNomenclaturalStatus, this.verbatimNomenclaturalStatus);
        values.put(DwcTerm.taxonRank, this.rank.getRank());
        values.put(DwcTerm.verbatimTaxonRank, this.verbatimTaxonRank);
        values.put((Object)ALATerm.priority, Integer.toString(this.getScore()));
        if (this.parentNameUsageID != null) {
            String pid = null;
            try {
                TaxonConceptInstance rp = this.getResolvedParent();
                String string = pid = rp == null ? null : rp.getTaxonID();
                if (pid == null) {
                    taxonomy.report(IssueType.ERROR, "instance.parent.resolve", this);
                }
            }
            catch (ResolutionException ex) {
                taxonomy.report(IssueType.ERROR, "instance.parent.resolve.loop", this.traceParent().toArray(new TaxonConceptInstance[0]));
            }
            values.put(DwcTerm.parentNameUsageID, pid);
        }
        if (this.acceptedNameUsageID != null) {
            String aid = null;
            try {
                TaxonConceptInstance ra = this.getResolvedAccepted();
                String string = aid = ra == null ? null : ra.getTaxonID();
                if (aid == null) {
                    taxonomy.report(IssueType.ERROR, "instance.accepted.resolve", this);
                }
            }
            catch (ResolutionException ex) {
                taxonomy.report(IssueType.ERROR, "instance.accepted.resolve.loop", this.traceAccepted().toArray(new TaxonConceptInstance[0]));
            }
            values.put(DwcTerm.acceptedNameUsageID, aid);
        }
        return values;
    }

    public List<Map<Term, String>> getIdentifierMaps(Taxonomy taxonomy) throws IOException {
        HashMap<Object, String> values2;
        Map<Term, String> taxon = this.getTaxonMap(taxonomy);
        String scientificNameID = taxon.get(DwcTerm.scientificNameID);
        String taxonConceptID = taxon.get(DwcTerm.taxonConceptID);
        String source = taxon.get(DcTerm.source);
        List<Map<Term, String>> valuesList = taxonomy.getIndexValues((Term)GbifTerm.Identifier, this.taxonID);
        Set identifiers = valuesList.stream().map(values -> (String)values.get(DcTerm.identifier)).collect(Collectors.toSet());
        if (!identifiers.contains(this.taxonID)) {
            values2 = new HashMap<Object, String>();
            values2.put(DcTerm.identifier, this.taxonID);
            values2.put(DwcTerm.datasetID, this.provider.getId());
            values2.put(DcTerm.title, "Taxon");
            values2.put((Object)ALATerm.status, "current");
            if (source != null) {
                values2.put(DcTerm.source, source);
            }
            valuesList.add(values2);
        }
        if (scientificNameID != null && !identifiers.contains(scientificNameID)) {
            values2 = new HashMap();
            values2.put(DcTerm.identifier, scientificNameID);
            values2.put(DwcTerm.datasetID, this.provider.getId());
            values2.put(DcTerm.title, "Scientific Name");
            values2.put((Object)ALATerm.status, "current");
            if (source != null) {
                values2.put(DcTerm.source, source);
            }
            valuesList.add(values2);
        }
        if (taxonConceptID != null && !identifiers.contains(taxonConceptID)) {
            values2 = new HashMap();
            values2.put(DcTerm.identifier, taxonConceptID);
            values2.put(DwcTerm.datasetID, this.provider.getId());
            values2.put(DcTerm.title, "Taxon Concept");
            values2.put((Object)ALATerm.status, "current");
            if (source != null) {
                values2.put(DcTerm.source, source);
            }
            valuesList.add(values2);
        }
        return valuesList;
    }

    public List<Map<Term, String>> getVernacularMaps(Taxonomy taxonomy) throws IOException {
        List<Map<Term, String>> valuesList = taxonomy.getIndexValues((Term)GbifTerm.VernacularName, this.taxonID);
        return valuesList;
    }

    public List<Map<Term, String>> getDistributionMaps(Taxonomy taxonomy) throws IOException {
        List<Map<Term, String>> valuesList = taxonomy.getIndexValues((Term)GbifTerm.Distribution, this.taxonID);
        return valuesList;
    }

    public String toString() {
        return "TCI[" + this.taxonID + ", " + this.scientificName + ", " + this.scientificNameAuthorship + "]";
    }

    public boolean isOwned() {
        return this.provider.owns(this.scientificName);
    }

    public TaxonConceptInstance createInferredSynonym(TaxonConcept concept, String scientificName, String scientificNameAuthorship, String year, Taxonomy taxonomy) {
        TaxonConceptInstance synonym = new TaxonConceptInstance(UUID.randomUUID().toString(), this.code, this.verbatimNomenclaturalCode, taxonomy.getInferenceProvider(), scientificName, scientificNameAuthorship, year, TaxonomicType.INFERRED_SYNONYM, this.verbatimTaxonomicStatus, this.rank, this.verbatimTaxonRank, this.status, this.verbatimNomenclaturalStatus, null, null, null, this.getTaxonID(), this.classification);
        synonym.setContainer(concept);
        synonym.accepted = this;
        synonym.baseScore = null;
        synonym.score = null;
        synonym.forbidden = false;
        taxonomy.addInferredInstance(synonym);
        return synonym;
    }

    @Override
    public boolean validate(Taxonomy taxonomy) {
        boolean valid = true;
        if ((this.parentNameUsageID != null || this.parentNameUsage != null || this.isAccepted() && this.classification != null && !this.classification.isEmpty()) && this.parent == null) {
            if (this.provider.isLoose()) {
                taxonomy.report(IssueType.NOTE, "instance.validation.noParent.loose", this);
            } else {
                taxonomy.report(IssueType.VALIDATION, "instance.validation.noParent", this);
                valid = false;
            }
        }
        if ((this.acceptedNameUsageID != null || this.acceptedNameUsage != null) && this.accepted == null) {
            if (this.provider.isLoose()) {
                taxonomy.report(IssueType.NOTE, "instance.validation.noAccepted.loose", this);
            } else {
                taxonomy.report(IssueType.VALIDATION, "instance.validation.noAccepted", this);
                valid = false;
            }
        }
        if (this.getContainer() == null) {
            taxonomy.report(IssueType.VALIDATION, "instance.validation.noTaxonConcept", this);
            valid = false;
        } else if (((TaxonConcept)this.getContainer()).getContainer() == null) {
            taxonomy.report(IssueType.VALIDATION, "instance.validation.noScientificName", this);
            valid = false;
        }
        valid = valid && this.validateParent(taxonomy);
        return valid;
    }
}

