/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.org.ala.names.index.IssueType;
import au.org.ala.names.index.NameKey;
import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.index.TaxonomicElement;
import au.org.ala.names.index.Taxonomy;
import au.org.ala.names.model.RankType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class Name<T extends TaxonomicElement, C extends TaxonomicElement, E extends TaxonomicElement>
extends TaxonomicElement<T, C> {
    private NameKey key;
    private List<E> concepts;
    private Map<NameKey, E> conceptMap;
    private E principal;
    private boolean cleared;

    public Name(NameKey key) {
        this(null, key);
    }

    public Name(C container, NameKey key) {
        super(container);
        this.key = key;
        this.concepts = new ArrayList();
        this.conceptMap = new HashMap<NameKey, E>();
        this.principal = null;
        this.cleared = false;
    }

    public NameKey getKey() {
        return this.key;
    }

    public List<E> getConcepts() {
        return this.concepts;
    }

    public E getPrincipal() {
        return this.principal;
    }

    public boolean isCleared() {
        return this.cleared;
    }

    @Override
    public RankType getRank() {
        return this.key.getRank();
    }

    @Override
    public int getPrincipalScore() {
        return this.principal != null ? ((TaxonomicElement)this.principal).getPrincipalScore() : -1000000;
    }

    @Override
    public int getProviderScore() {
        return this.principal != null ? ((TaxonomicElement)this.principal).getProviderScore() : -1000000;
    }

    abstract E createConcept(NameKey var1);

    public void removeConcepts(Collection<E> remove) {
        if (remove.isEmpty()) {
            return;
        }
        this.concepts.removeAll(remove);
        Set<NameKey> keys = this.conceptMap.entrySet().stream().filter(e -> remove.contains(e.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
        keys.forEach(k -> {
            TaxonomicElement cfr_ignored_0 = (TaxonomicElement)this.conceptMap.remove(k);
        });
        if (remove.contains(this.principal)) {
            this.principal = null;
        }
    }

    public void clear(E principal) {
        this.concepts.clear();
        this.conceptMap.clear();
        this.principal = principal;
        this.cleared = true;
    }

    abstract NameKey buildStageKey(NameKey var1);

    @Override
    public E addInstance(NameKey instanceKey, TaxonConceptInstance instance) {
        NameKey stageKey = this.buildStageKey(instanceKey);
        TaxonomicElement concept = (TaxonomicElement)this.conceptMap.get(stageKey);
        if (concept == null) {
            concept = this.createConcept(stageKey);
            this.concepts.add(concept);
            this.conceptMap.put(stageKey, concept);
        }
        concept.addInstance(instanceKey, instance);
        return (E)concept;
    }

    @Override
    public boolean validate(Taxonomy taxonomy) {
        boolean valid = true;
        if (!this.cleared && this.concepts.isEmpty()) {
            taxonomy.report(IssueType.VALIDATION, "scientificName.validation.noConcepts", this);
            valid = false;
        }
        for (TaxonomicElement concept : this.concepts) {
            if (concept.getContainer() != this) {
                taxonomy.report(IssueType.VALIDATION, "scientificName.validation.conceptParent", concept, this);
                valid = false;
            }
            valid = concept.validate(taxonomy) && valid;
        }
        return valid;
    }

    public void resolvePrincipal(Taxonomy taxonomy) {
        this.principal = this.findPrincipal(taxonomy);
        if (this.principal == null) {
            taxonomy.report(IssueType.PROBLEM, "name.noPrincipal", this);
        } else if (this.concepts.size() > 1) {
            taxonomy.report(IssueType.NOTE, "name.principal", new TaxonomicElement[]{this, this.principal});
        }
        this.reallocateDanglingConcepts(taxonomy, this.principal);
    }

    protected abstract void reallocateDanglingConcepts(Taxonomy var1, E var2);

    protected abstract E findPrincipal(Taxonomy var1);

    @Override
    public String getId() {
        if (this.getScientificNameAuthorship() == null) {
            return this.key.getScientificName();
        }
        return this.key.getScientificName() + " " + this.key.getScientificNameAuthorship();
    }

    @Override
    public String getScientificName() {
        return this.key.getScientificName();
    }

    @Override
    public String getScientificNameAuthorship() {
        return this.key.getScientificNameAuthorship();
    }

    @Override
    public TaxonConceptInstance getRepresentative() {
        return this.principal != null ? ((TaxonomicElement)this.principal).getRepresentative() : null;
    }
}

