/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.index;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.names.index.IndexBuilderException;
import au.org.ala.names.index.NameProvider;
import au.org.ala.names.index.NameSource;
import au.org.ala.names.index.TaxonConceptInstance;
import au.org.ala.names.index.Taxonomy;
import au.org.ala.names.model.RankType;
import au.org.ala.names.model.TaxonomicType;
import au.org.ala.vocab.ALATerm;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.gbif.api.model.registry.Citation;
import org.gbif.api.model.registry.Contact;
import org.gbif.api.vocabulary.Country;
import org.gbif.api.vocabulary.NomenclaturalCode;
import org.gbif.api.vocabulary.NomenclaturalStatus;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.terms.TermFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVNameSource
extends NameSource {
    private static final Logger logger = LoggerFactory.getLogger(CSVNameSource.class);
    private String name;
    private CSVReader reader;
    private List<Term> terms;
    private Map<Term, Integer> termLocations;

    public CSVNameSource(Reader reader) throws IOException {
        this.name = "Reader " + System.identityHashCode(reader);
        this.reader = new CSVReader(reader);
        this.collectColumns();
    }

    public CSVNameSource(Path path, String encoding) throws IOException {
        this(Files.newBufferedReader(path, Charset.forName(encoding)));
        this.name = path.toUri().toASCIIString();
    }

    protected void collectColumns() throws IOException {
        TermFactory factory = TermFactory.instance();
        int index = 0;
        String[] header = this.reader.readNext();
        if (header == null || header.length == 0) {
            throw new IndexBuilderException("No header in CSV file");
        }
        this.termLocations = new LinkedHashMap<Term, Integer>(header.length);
        this.terms = new ArrayList<Term>(header.length);
        for (String heading : header) {
            Term term = factory.findTerm(heading = heading.trim());
            if (term == null) {
                term = ALATerm.valueOf(heading);
            }
            if (term != null) {
                this.termLocations.put(term, index);
            } else {
                logger.warn("Unable to map " + heading + " onto a term");
            }
            this.terms.add(term);
            ++index;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Citation getCitation() throws IndexBuilderException {
        return new Citation(this.getName(), null);
    }

    @Override
    public Collection<Country> getCountries() {
        return Collections.emptySet();
    }

    @Override
    public Collection<Contact> getContacts() {
        return Collections.emptySet();
    }

    @Override
    public void validate() throws IndexBuilderException {
        for (Term term : TAXON_REQUIRED) {
            if (this.termLocations.containsKey(term)) continue;
            throw new IndexBuilderException("CSV file does not contain required term " + term);
        }
    }

    @Override
    public void loadIntoTaxonomy(Taxonomy taxonomy) throws IndexBuilderException {
        Map<Term, Integer> termLocations = this.termLocations;
        taxonomy.addOutputTerms((Term)DwcTerm.Taxon, this.terms);
        taxonomy.addOutputTerms(ALATerm.TaxonVariant, this.terms);
        Integer taxonIDIndex = termLocations.get(DwcTerm.taxonID);
        Integer nomenclaturalCodeIndex = termLocations.get(DwcTerm.nomenclaturalCode);
        Integer datasetIDIndex = termLocations.get(DwcTerm.datasetID);
        Integer datasetNameIndex = termLocations.get(DwcTerm.datasetName);
        Integer scientificNameIndex = termLocations.get(DwcTerm.scientificName);
        Integer scientificNameAuthorshipIndex = termLocations.get(DwcTerm.scientificNameAuthorship);
        Integer namePublishedInYearIndex = termLocations.get(DwcTerm.namePublishedInYear);
        Integer taxonomicStatusIndex = termLocations.get(DwcTerm.taxonomicStatus);
        Integer taxonRankIndex = termLocations.get(DwcTerm.taxonRank);
        Integer nomenclaturalStatusIndex = termLocations.get(DwcTerm.nomenclaturalStatus);
        Integer parentNameUsageIndex = termLocations.get(DwcTerm.parentNameUsage);
        Integer parentNameUsageIDIndex = termLocations.get(DwcTerm.parentNameUsageID);
        Integer acceptedNameUsageIndex = termLocations.get(DwcTerm.acceptedNameUsage);
        Integer acceptedNameUsageIDIndex = termLocations.get(DwcTerm.acceptedNameUsageID);
        Set classifications = TaxonConceptInstance.CLASSIFICATION_FIELDS.stream().filter(t -> termLocations.containsKey(t)).collect(Collectors.toSet());
        try {
            String[] r;
            while ((r = this.reader.readNext()) != null) {
                String[] record = r;
                String taxonID = this.get(record, taxonIDIndex);
                String verbatimNomenclautralCode = this.get(record, nomenclaturalCodeIndex);
                NomenclaturalCode code = taxonomy.resolveCode(verbatimNomenclautralCode);
                NameProvider provider = taxonomy.resolveProvider(this.get(record, datasetIDIndex), this.get(record, datasetNameIndex));
                String scientificName = this.get(record, scientificNameIndex);
                String scientificNameAuthorship = this.get(record, scientificNameAuthorshipIndex);
                String year = this.get(record, namePublishedInYearIndex);
                String verbatimTaxonomicStatus = this.get(record, taxonomicStatusIndex);
                TaxonomicType taxonomicStatus = taxonomy.resolveTaxonomicType(verbatimTaxonomicStatus);
                String verbatimTaxonRank = this.get(record, taxonRankIndex);
                RankType rank = taxonomy.resolveRank(verbatimTaxonRank);
                String verbatimNomenclaturalStatus = this.get(record, nomenclaturalStatusIndex);
                Set<NomenclaturalStatus> nomenclaturalStatus = taxonomy.resolveNomenclaturalStatus(verbatimNomenclaturalStatus);
                String parentNameUsage = this.get(record, parentNameUsageIndex);
                String parentNameUsageID = this.get(record, parentNameUsageIDIndex);
                String acceptedNameUsage = this.get(record, acceptedNameUsageIndex);
                String acceptedNameUsageID = this.get(record, acceptedNameUsageIDIndex);
                Map<Term, Optional<String>> classification = null;
                if (!classifications.isEmpty()) {
                    classification = classifications.stream().collect(Collectors.toMap(t -> t, t -> Optional.ofNullable(this.get(record, (Integer)termLocations.get(t)))));
                }
                TaxonConceptInstance instance = new TaxonConceptInstance(taxonID, code, verbatimNomenclautralCode, provider, scientificName, scientificNameAuthorship, year, taxonomicStatus, verbatimTaxonomicStatus, rank, verbatimTaxonRank, nomenclaturalStatus, verbatimNomenclaturalStatus, parentNameUsage, parentNameUsageID, acceptedNameUsage, acceptedNameUsageID, classification);
                instance.normalise();
                instance = taxonomy.addInstance(instance);
                Document doc = new Document();
                doc.add((IndexableField)new StringField("type", DwcTerm.Taxon.qualifiedName(), Field.Store.YES));
                doc.add((IndexableField)new StringField("id", UUID.randomUUID().toString(), Field.Store.YES));
                for (int i = 0; i < record.length; ++i) {
                    String value;
                    Term term = this.terms.get(i);
                    String string = value = term == DwcTerm.taxonID ? instance.getTaxonID() : record[i];
                    if (term == null || value == null || value.isEmpty()) continue;
                    doc.add((IndexableField)new StringField(taxonomy.fieldName(term), value, Field.Store.YES));
                }
                taxonomy.addRecords(Collections.singletonList(doc));
            }
        }
        catch (IndexBuilderException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IndexBuilderException("Unable to load CSV file", ex);
        }
    }

    private String get(String[] record, Integer index) {
        if (index == null || index < 0 || index >= record.length) {
            return null;
        }
        String s = record[index];
        if (s == null) {
            return null;
        }
        return (s = s.trim()).isEmpty() ? null : s;
    }
}

